> * 原文地址：[Deep Learning Is Going to Teach Us All the Lesson of Our Lives: Jobs Are for Machines](https://medium.com/basic-income/deep-learning-is-going-to-teach-us-all-the-lesson-of-our-lives-jobs-are-for-machines-7c6442e37a49)
> * 原文作者：[Scott Santens](https://medium.com/@2noame?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/deep-learning-is-going-to-teach-us-all-the-lesson-of-our-lives-jobs-are-for-machines.md](https://github.com/xitu/gold-miner/blob/master/TODO1/deep-learning-is-going-to-teach-us-all-the-lesson-of-our-lives-jobs-are-for-machines.md)
> * 译者：[yuwhuawang](https://github.com/yuwhuawang)
> * 校对者：[Justin-Wong](https://github.com/Justin-Wong), [7Ethan](https://github.com/7Ethan)

# 深度学习将会给我们所有人的生活一个教训：工作是为了机器准备的

**(本文的另一个版本最初发表在**[**波士顿环球报)**](http://www.bostonglobe.com/ideas/2016/02/24/robots-will-take-your-job/5lXtKomQ7uQBEzTJOXT7YO/story.html)。

![](https://cdn-images-1.medium.com/max/2000/1*WtLgKg59v-CT1Jw6KCdclw.jpeg)

18 次围棋世界冠军李世乭从 AlphaGo 那里学到了一些新的东西 —— 失败

1942 年 12 月 2 日，一组由 Enrico Fermi 带领的科学家小组吃完午饭回来，他们在芝加哥大学操场地下的一个由砖石和木头搭成的反应堆里观察到了第一个由人类创建的自持核反应。这就是著名的[芝加哥 1 号堆](https://www.youtube.com/watch?v=0tKf7R2XncM)。尽管这些科学家非常明白这对人类来说意味着什么，但是他们只是简单地用一瓶基安蒂酒来庆祝，并不需要任何言辞。

如今，一个永远改变世界的新东西又一次悄悄出现了。就像用外语轻轻说出的词汇，你很有可能听过，但是却不能完全理解它的意义。但是非常必要的是，我们要理解这个语言，以及它持续告诉我们的事情，因为这些影响将改变我们对全球化经济运作方式理所当然的一切，和我们作为人类存在于此的方式。

这门语言就是机器学习的一个新的类别[**深度学习**](http://deeplearning.net/)，“低声的词汇”就是计算机不知从哪里莫名出现，并且使用它[击败三次欧洲围棋冠军樊麾](https://www.youtube.com/watch?v=SUbqykXVx0A)，不是一次，而是一连五次击败。很多看过这个新闻的人都觉得印象深刻。可是这和与李世乭的比赛没办法比。李世乭即使不是有史以来围棋水平最高的，也是在世的人中水平最高之一。想象一下这个伟大的人机大战，[中国顶尖的围棋选手认为李世乭一局都不会输，李世乭自己也很有信心的认为自己最多输一局](http://news.xinhuanet.com/english/sports/2016-02/23/c_135121693.htm)。

对峙的最终结果是什么？李世乭输了[**五局中的四局**](http://www.theverge.com/2016/3/15/11213518/alphago-deepmind-go-match-5-result)。一个叫做 AlphaGo 的 AI 现在是比任何人类更好的围棋选手，并且[被授予了荣誉围棋九段](http://phys.org/news/2016-03-google-alphago-divine.html)。换句话说，它的水平就像神一样。 围棋正式被机器打败，就像综艺节目危险边缘被沃森打败，国际象棋被深蓝打败。

> “AlphaGo 的历史性胜利是一个非常清晰的信号：我们从线性走到了抛物线的发展。”

那么，什么是围棋？非常简单，就把围棋想象成超级大型国际象棋。听起来还是像一个小成就，机器在我们玩的有趣游戏中不断证明它们（机器）所具备的优越性，并且这还没有完全展示机器的实力。但是这并不是小成就，所发生的也不是游戏。

AlphaGo 的历史性胜利是一个非常清晰地信号，我们从[线性走到了抛物线的发展](http://about.bankofamerica.com/assets/davos-2016/PDFs/robotic-revolution.pdf)。技术的进步已指数级别增长，我们可以期待看到跨越非常多的，之前不可想象的里程碑。这些指数级的进步，大多都是用人工智能解决特定的任务，只要我们继续坚持把就业作为主要的收入来源， 那我们就完全还没准备好。

听起来有些夸张，那我们回顾这几十年，看一下计算机科技目前为止对人类就业的影响：

![](https://cdn-images-1.medium.com/max/800/1*yPLHq5HEBTIs0VCdpe7KYA.jpeg)

来源：[St. Louis Fed](https://www.stlouisfed.org/on-the-economy/2016/january/jobs-involving-routine-tasks-arent-growing)

领会下上面的图表。不要被骗认为劳动自动化的对话发生在未来。这已经发生了。**计算机技术从 1990 年开始就已经蚕食工作岗位了。**

#### 日常工作

所有的工作分为四类：日常工作和非常规工作，认知型工作和体力工作。日常工作就是每天都做同样的事情，而非常规工作则各种各样。在这两种类型中，又包括需要我们大脑（认知）的工作和需要我们身体（体力）的工作。随着四种类型的工作都在增长，日常工作在 1990 年就停止的增长。这是因为日常的劳动对于科技来说是最容易承担的。对于不变的工作来说，可以写出规则，这种工作更加适合机器来做。

让人忧虑的是，日常工作就是组成美国中产阶级的基础。亨利福特通过付给人们中产阶级的薪资，来实行的日常手工工作的变革，常规的脑力工作也曾经填满的美国的办公室。[像这样的工作现如今已经越来越少了](http://www.huffingtonpost.com/scott-santens/future-of-jobs_b_8011296.html)，只剩下两种工作看起来还不错：只需要一点思考的工作，我们只会付给做这些工作的人很少的钱，以及需要大量思考的工作，做这些工作的人收入会很好。

让我们把经济想象成一架有四个引擎的飞机，现在只有依靠还在保持轰鸣的两个引擎飞行，我们暂时可以不用担心飞机会坠毁。但是如果最后两个引擎也挂了呢？机器人和 AI 技术在两个领域不断进步，因为人类第一次教会了机器如何去**学习**。

#### 神经网络

我本质上是个作家，但是我的教育背景碰巧是心理学和物理。我沉迷于这两个学科，所以我的本科关注点就是人类大脑的物理学，也就是[认知神经科学](http://www.sciencedaily.com/terms/cognitive_neuroscience.htm)。我认为，一旦你开始研究人类的大脑是如何工作的，神经元是如何相互连接并且形成我们说的心智，你会发现一切都变了。至少对我来说一切都变了。

简短说明大脑的功能，他们是由相互连接的细胞组成的巨大的网络。其中一些连接很短，另一些则很长。有些细胞只会和一个细胞相连，而另一些则会和很多细胞连接。电信号以不同的速度，通过这些连接传递，最终依次点燃这些神经元。这就像倒下的多米诺骨牌，但是更快，更大和更复杂。结果令人惊讶的是我们，以及我们学到的如何工作，我们现在会把这些应用到机器上面去。

下面的应用中有一个是由[**深度神经网络**](http://www.wired.com/2016/01/microsoft-neural-net-shows-deep-learning-can-get-way-deeper/)创建 —— 有点像简装版的虚拟大脑。它提供了一个通向机器学习的大道，并且超越了之前所有可能的想象，有了巨大的飞跃。这是如何做到的？不只是计算机能力的明显增长和神经科学认知的深入，还包括我们收集的极速增加的数据，也叫做**大数据**。

#### 大数据

大数据不只是流行词那么简单而已。大数据是信息，而且是我们每天都在创造的信息。事实上我们创造了太多的数据，根据 SINTEF 2013 年的报告预计[世界上 90% 的信息都是两年内创造的](http://www.sciencedaily.com/releases/2013/05/130522085217.htm)。数据的正在以不可思议的速度增加[每 1.5 年翻一倍](http://www.datamation.com/applications/big-data-analytics-overview.html)。在因特网上，2015 年[我们**每分钟**在 Facebook 上点 420 万个赞，在 Youtube 上传 300 个小时的视频，并且发 350000 个推文](https://www.domo.com/blog/2015/08/data-never-sleeps-3-0/)。我们做的所有事情都创造了之前没有的数据，并且其中很多数据正是机器**学习**所需要的。为什么？

想象一下写一个识别椅子的程序，你需要输入大量的指令，但是这个程序仍然会把不是椅子的东西识别成椅子，对于真正的椅子，也会识别**失败**。那么，**我们**是怎么学会识别椅子的？我们的父母指着一把椅子说，“这是椅子。” 然后我们就觉得我们已经学会什么是椅子了，所以我们指着一张桌子说，“这是椅子。”这时候我们的父母就会告诉我们说，“这是桌子。”这就是强化学习。“椅子”这个标签就和我们见到的每一把椅子关联了起来，这样一种确定的神经通路就建立了，与此同时，其他的却没有。要想定位到我们大脑里的“椅子”，我们观察到的东西必须和之前遇到的椅子非常接近才可以。本质上来说，我们的生活就是大脑过滤的大数据。

#### 深度学习

深度学习的魔力就是提供了方法，让机器可以像我们一样使用大量数据，而不需给它们太多指令。不用描述“椅子的特性”，我们只需要把机器连上网，给它灌输数以百万计的椅子照片。机器就可以得到一个整体的“椅子的特性”。接着我们用更多椅子的照片来测试它。如果它错了，我们就纠正它，那么它识别“椅子特性”的能力就会增强。重复这些过程，计算机就能在看到一把椅子的时候认出来，[基本上和我们做的一样好](https://research.facebook.com/publications/deepface-closing-the-gap-to-human-level-performance-in-face-verification/)。这中间最重要的不同就是[不像我们，他们可以**在几秒钟内**就识别**几百万**图像](https://www.youtube.com/watch?v=t4kyRyKyOpo)。

深度学习和大数据的结合在过去短短几年取得了令人震惊的成就。除了不可思议的 AlphaGo 之外，通过成千上万的标注过的新闻，[谷歌的 DeepMind AI 学会了如何去阅读，并且理解它所读到的](https://www.technologyreview.com/s/538616/google-deepmind-teaches-artificial-intelligence-machines-to-read/)。[DeepMind 同时_自学_了几十个 Atari 2600 的电子游戏，而且玩儿的比人类还好](http://www.nature.com/nature/journal/v518/n7540/full/nature14236.html)，也仅仅是观察屏幕和分数，然后不停的玩儿而已。一个叫 Griraffe 的 AI 通过 1 亿 7 千 5 百万棋谱学会了国际象棋，[在不断和自己下了 72 个小时的棋之后，达到了国际大师的水平](https://www.technologyreview.com/s/541276/deep-learning-machine-teaches-itself-chess-in-72-hours-plays-at-international-master/)。2015 年，[一个 AI 经过学习甚至通过了一个视觉图灵测试](http://news.mit.edu/2015/computer-system-passes-visual-turing-test-1210)，测试的方式就是给机器看一个不认识的科幻字母表的字符，然后立刻用和人类一样的方式复述这个字母。这些就是 AI 领域**主要的**里程碑。

尽管跨越了这些里程碑，当专家们在 [Google 宣布 AlphaGo](http://googleresearch.blogspot.com/2016/01/alphago-mastering-ancient-game-of-go.html) 胜利几个月之前，被问到什么时候计算机可以击败一个卓越的围棋选手，“[也许还需要十年](http://www.wired.com/2014/05/the-world-of-computer-go/)。”十年听起来是个正常的猜测，因为围棋十分复杂，我就用危险边缘节目的 Ken Jennings [另一个被 AI 打扮的冠军](http://www.slate.com/articles/technology/technology/2016/03/google_s_alphago_defeated_go_champion_lee_sedol_ken_jennings_explains_what.html)，来描述它:

> 围棋的有名的难，比国际象棋难得多，有更大的棋盘，更长时间的对弈，棋子也多得多。Google 的 DeepMinde 人工智能小组喜欢说围棋的变化比已知宇宙里的原子还多，但这也极大地**低估了**计算问题。围棋棋盘上有 10¹⁷⁰ 位置可能，可宇宙里只有 10⁸⁰ 个原子。这也就意味着，如果平行宇宙的数量和我们宇宙里原子的数量一样多的话（！），**所有**宇宙里**所有**原子加起来也就和一个围棋棋盘上的所有可能性接近。

如此混乱复杂，让任何暴力扫描所有可能行来确定最好的那一个的方法变得不可能。但是深度神经网络绕过了这个障碍，用了和我们大脑一样的方式，去学着评估什么**感觉**是最佳的一招。我们通过观察和联系来学习，AlphaGo 也是一样的，通过分析几百万的专业对局，并且[自我对弈了几百万次](http://www.wired.com/2016/03/googles-ai-viewed-move-no-human-understand/)。因此什么时候围棋会被机器打败，很有可能不是十年，正确的答案是“**在目前的任何时候**。”

#### 非常规的自动化

在目前的任何时候。在 21 世纪对于机器能够比人做的更好的问题，有了新的回答，我们应该时刻记住这一点。

![](https://cdn-images-1.medium.com/max/600/1*4hNt7iSp_JtWjxoFgllSkg.png)

我们需要认识到，技术指数级的增长,对于有史以来第一次改变整个非常规工作的劳动力市场，意味着什么。机器能够学习，就意味着再也没有任何人类的工作是安全的了。从[汉堡包](http://singularityhub.com/2013/01/22/robot-serves-up-340-hamburgers-per-hour/)到[健康护理](https://deepmind.com/health)，能够胜任这些**任务**的机器都可以很轻松的被创造出来，而且比人类便宜的多。

[Amelia](http://www.entrepreneur.com/article/245827) 就是一个**正在**很多公司进行测试的 AI。由 IPsoft 公司经过 16 年的研发，她已经胜任呼叫中心员工的角色。她能够在几秒钟之内，用 20 种不同的语言,学到我们要花几个月学会的东西。因为她可以学习，所以随着时间的推进，她能够做的更多。在一个部署了 Amelia 的公司里，第一周她就成功地负责了十分之一的呼叫，而到了第二个月底，她已经可以解决十分之六的呼叫了。就因为这样，有预测她会在**全球范围**内让超过 2.5 亿人失去工作。

[Viv](http://www.esquire.com/lifestyle/a34630/viv-artificial-intelligence-0515/) 是一个由 Siri 的创造者,即将给我们带来的 AI 私人助理。她可以为我们执行各种在线的任务，她甚至还能够是更强大版本的 Facebook 新闻流，她推荐给我们的信息一定都是我们最喜欢看的。通过 Viv，我们将会看到更少的广告。这也就意味着，广告业 —— 整个互联网建立的基础 —— 即将被摧毁。

一个充满了 Amelia 和 Viv —— 以及数不清的即将上线的 AI 同行者的世界 —— 再加上像 [Boston Dynamics’ next generation Atlas](https://www.youtube.com/watch?v=rVlhMGQgDkY) 这样的机器人，预示着一个机器能够做**所有类型**工作的世界，带来了严重的社会考虑。如果机器能够代替人工作，[人类是否就被迫受到缺乏工作的威胁](https://www.youtube.com/watch?v=N8n5ZL5PwiA)？收入是否还应该是雇佣有关联，也就是说工作是获取收入的唯一途径，那么当[大多数工作都被机器取代](http://www.huffingtonpost.com/scott-santens/the-job-market-a-game-of-_b_7581704.html)了呢？如果机器可以持续替代我们的工作，并且一分钱收入都不要，[那么这些钱又会去哪儿呢?](http://mic.com/articles/119896/after-robots-take-our-jobs-basic-income-is-the-best-solution)[如果没人买东西了会怎么样？](http://www.cabot.net/issues/cwa/archives/2015/11/guaranteed-basic-income)[我们创造的很多工作是不是根本不需要存在？](http://strikemag.org/bullshit-jobs/)，而只是因为这些工作能带来收入？我们需要开始赶快提出这些问题。

#### 收入和工作解耦

幸运的是，人们**正在**[开始](http://www.brookings.edu/blogs/techtank/posts/2015/10/26-emerging-tech-employment-public-policy-west)[提出](http://futurism.com/interview-chris-eliasmith-talks-reverse-engineering-the-brain-dangerous-ai-and-universal-basic-income/)[这些](http://www.businessinsider.com/ai-expert-jeremy-howard-on-universal-basic-income-2015-12)[问题](http://www.forbes.com/sites/roberthof/2016/01/28/ai-guru-andrew-ng-government-must-play-big-role-in-rollout-of-self-driving-cars/2/#5ca975ed6971)，一个很有势头的答案也出现了。这个答案就是让机器给我们工作，为了我们人类提供能量，去寻找剩下的最有价值的适合人类的工作，只要简单的给每个人按月提供与工作无关的薪水。这个薪水应该无条件的授予所有的公民，这个薪水就叫[**统一基本收入**](https://medium.com/working-life/why-should-we-support-the-idea-of-an-unconditional-basic-income-8a2680c73dd3)。通过实施统一基本收入（UBI）方案，除了对自动化的副作用[免疫](https://medium.com/basic-income/universal-basic-income-as-the-social-vaccine-of-the-21st-century-d66dff39073)之外，我们也面临着[企业家精神](http://www.geektime.com/2015/12/17/how-a-universal-basic-income-could-fuel-entrepreneurship/)以及为了提高收入所必需的[政府机构数量](http://www.usbig.net/papers/144-Sheahen-RefundableTaxCredit.pdf)减少的风险。正因为如此，统一基本收入（UBI）获得了[跨党派的支持](http://www.fastcoexist.com/3040832/world-changing-ideas/a-universal-basic-income-is-the-bipartisan-solution-to-poverty-weve-bee)，甚至在[瑞士](http://www.basicincome2016.org/blog/universal-basic-income-first-representative-survey-in-switzerla)、[芬兰](http://www.vox.com/2015/12/8/9872554/finland-basic-income-experiment)、[挪威](http://www.basicincome.org/news/2015/07/dutch-municipalities-experiments/)和[加拿大](http://www.cbc.ca/news/politics/guaranteed-minimum-income-merits-further-study-pre-budget-report-says-1.3490157)，这个方案已经开始实施。

未来充满了快速变化。用过去的老眼光看待未来是不明智的，新的工作总是会出现。[2016 年 WEF 预测到 2020 年，有 200 万新的工作会出现，同时 700 万旧的工作会消失](http://www.weforum.org/reports/the-future-of-jobs)。这是净亏损，而不是净收益 500 万工作。在一份经常被引用的论文里，[牛津的研究表明到 2033 年一半的工作都会被自动化取代](https://www.technologyreview.com/s/519241/report-suggests-nearly-half-of-us-jobs-are-vulnerable-to-computerization/)。与此同时，自动驾驶，同样是机器学习的功劳，将会极大的冲击所有的经济体 —— [尤其是美国经济，我去年写的关于卡车自动驾驶有提及](https://medium.com/basic-income/self-driving-trucks-are-going-to-hit-us-like-a-human-driven-truck-b8507d9c5961) —— 会在很短的时间内替代几百万个工作。

![](https://cdn-images-1.medium.com/max/600/1*DmAswJfSRjbimEAA82s2eg.gif)

甚至在白宫，[一个惊人的国会报告中](https://www.whitehouse.gov/sites/default/files/docs/ERP_2016_Book_Complete%20JA.pdf "www.whitehouse.gov")指出，一个时薪低于 20 美金的人，他的工作有 83% 的可能性最终被机器取代。甚至那些时薪 40 美金的人也有 31% 的可能。忽略这种可能性就像在冷战时期我们用“[躲避和掩护](https://www.youtube.com/watch?v=C0K_LZDXp0I)”策略来避免核爆炸一样可笑。

这就是为什么在 AI 领域知识渊博的人都在为积极地为基本收入敲响了警钟。在 2015 年末奇点大学的一次小组会议上，杰出的数据科学家 [Jeremy Howard](http://www.businessinsider.com/ai-expert-jeremy-howard-on-universal-basic-income-2015-12) 问道：“你们会让一半的人因为他们不能增加经济价值就让他们挨饿吗？”在给出建议之前，“如果答案是不，最聪明的办法就是通过实施**统一基本收入**来分配财富。”

AI 先锋 [Chris Eliasmith](http://futurism.com/interview-chris-eliasmith-talks-reverse-engineering-the-brain-dangerous-ai-and-universal-basic-income/)，理论神经科学中心的主任，在一次未来主义的采访中警告大家 AI 直接带来的冲击，“AI 已经给我们的经济带来了很大的冲击……我怀疑会有更多的国家追随芬兰的脚步实施基本收入保障。”	

Moshe Vardi 在美国先进科学协会的年会上的演讲，也对出现的智能机器[表达过同样的感受](http://www.huffingtonpost.com/entry/the-moral-imperative-thats-driving-the-robot-revolution_us_56c22168e4b0c3c550521f64)，“我们要重新思考我们经济系统的基本结构……我们需要考虑建立基本收入保障机制。”

就连百度的首席科学家，也是 Google 的 “Google 大脑” 的创始人[吴恩达](http://www.forbes.com/sites/roberthof/2016/01/28/ai-guru-andrew-ng-government-must-play-big-role-in-rollout-of-self-driving-cars/#46bb8e8a6b12)，也在今年的深度学习峰会上的一次台上采访中表述，政府必须要“严肃的考虑”**基本收入机制**，他说，“AI 有很大的机会取代很多人力工作。”

当创造这些工具的人开始警告大家使用这些工具带来的冲击时，我们难道不应该希望尽可能注意地去使用这些工具吗？尤其是它会让数百万人的生活危如累卵。如果不是这样，为什么[诺贝尔经济学奖获得者们](http://www.basicincome.org/news/2016/02/international-christopher-pissarides-a-nobel-economist-argues-for-ubi-at-a-debate-in-davos/)也开始支持基本收入保障？

没有一个国家对于即将到来的变化做好的准备。大量劳动力游离在社会之外，社会会变得更加动荡，而在消费经济中，缺少消费者也会让经济动荡。让我们扪心自问，我们创造科技的目的是什么？能替我们自动驾驶的车，能减轻我们 60% 的工作量的人工智能的目的是什么？会不会让我们工作更长的时间却获得更少的报酬？或能让我们选择我们工作的方式，并且减少工作时间，因为我们已经赚取了机器不会拿的收入？

在机器都可以学习的世纪，我们学到的最重要的一课是什么？

**我的建议是工作交给机器，生活留给人类。**

* * *

![](https://cdn-images-1.medium.com/max/600/1*A5T3a8K4JR2TlT4G6x9Z4A.png)

**这篇文章是我众筹月度基本收入的一部分。如果你觉得本文有价值，你可以用[每月承诺](http://www.patreon.com/scottsantens)一美元以上来支持我。**

> [你是一位创作者吗？成为 Patreon 的一员吧。](https://patreon.com/invite/xxgw). 加入我[大 Patreon 创作者承诺基本收入](http://www.patreon.com/scottsantens)

* * *

**特别鸣谢 Arjun Banker, Steven Grimm, Larry Cohen, Topher Hunt, Aaron Marcus-Kubitza, Andrew Stern, Keith Davis, Albert Wenger, Richard Just, Chris Smothers, Mark Witham, David Ihnen, Danielle Texeira, Katie Doemland, Paul Wicks, Jan Smole, Joe Esposito, Jack Wagner, Joe Ballou, Stuart Matthews, Natalie Foster, Chris McCoy, Michael Honey, Gary Aranovich, Kai Wong, John David Hodge, Louise Whitmore, Dan O’Sullivan, Harish Venkatesan, Michiel Dral, Gerald Huff, Susanne Berg, Cameron Ottens, Kian Alavi, Gray Scott, Kirk Israel, Robert Solovay, Jeff Schulman, Andrew Henderson, Robert F. Greene, Martin Jordo, Victor Lau, Shane Gordon, Paolo Narciso, Johan Grahn, Tony DeStefano, Erhan Altay, Bryan Herdliska, Stephane Boisvert, Dave Shelton, Rise & Shine PAC, Luke Sampson, Lee Irving, Kris Roadruck, Amy Shaffer, Thomas Welsh, Olli Niinimäki, Casey Young, Elizabeth Balcar, Masud Shah, Allen Bauer, all my other funders for their support, and my amazing partner, Katie Smith.**

> [**你想在这里看到你的名字吗？**](http://www.patreon.com/bePatron?rid=120769&u=296170&patAmt=7.00#/r120769)

* * *

#### → [参加统一收入计划基本收入调查](https://docs.google.com/forms/d/13nhbJokjZQayv_ndZHHzcB3bX9kq-Ieq6a84bASgLoA/viewform?c=0&w=1) ←

* * *

**Scott Santens 在他的[博客](http://scottsantens.com)上写过基本收入的文章。你可以在[**Medium**](https://medium.com/@2noame)、[**Twitter**](https://twitter.com/2noame)、[**Facebook**](https://www.facebook.com/scottsantens) 或者 [Reddit](http://www.reddit.com/user/2noame/) 上的[/r/BasicIncome](http://www.reddit.com/r/basicincome/wiki)关注他，他是这个有着 30000 多订阅的社区的主持人。

**如果你认为别人也会欣赏这篇文章，请点击绿色的心。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
