> * 原文地址：[3 Levels of Deep Learning Competence](https://machinelearningmastery.com/deep-learning-competence/)
> * 原文作者：[Jason Brownlee](https://machinelearningmastery.com/author/jasonb) 
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/deep-learning-competence.md](https://github.com/xitu/gold-miner/blob/master/TODO1/deep-learning-competence.md)
> * 译者：[Hearfishle](https://github.com/Hearfishle)
> * 校对者：[portandbridge](https://github.com/portandbridge), [ezioyuan](https://github.com/ezioyuan)

# 深度学习能力的三个等级

[深度学习](https://machinelearningmastery.com/what-is-deep-learning/)不是一颗灵丹妙药，但是在许多非常具有挑战性的领域里它已经证明了自己的高效。

这意味着企业对高效的深度学习从业者的需求量巨大。

问题是，一般的企业如何去鉴别这些从业者的好坏？

作为一名深度学习的从业者，你如何用最好的方式去证明你可以提供熟练的深度学习模型？

在这篇文章中，你将了解胜任深度学习的三级能力，并且作为一个从业者你需要在每一层次具有怎样的表现。

在阅读本文之后你将了解：

*   评估深度学习能力水平的问题，最好是通过项目作品集去解决。
*   三个能力级别的层次结构可被使用去给从业者分类，并且提供一个框架去明确从业者所应具备的技能。
*   初学者最常犯的错误是认为刚开始学就想达到等级 3，他们想一次学会所有的能力，从而导致了困惑和挫败感。

让我们开始吧。

![深度学习能力的三个等级](https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2019/03/The-Three-Levels-of-Deep-Learning-Competence.jpg)

深度学习能力的三个等级
照片由 [Bernd Thaller] 拍摄，所属权归拍摄者

## 概述

本文分为三个部分，分别是：

1.  如何评估（深度学习）能力
2.  建立深度学习作品集
3.  深度学习能力的等级

## 如何评估（深度学习）能力

你如何知道一个从业者有能力做深度学习？

这是个艰难的问题。

*   一个科研人员也许可以把一个技术的数学性讲述的很好并且提供一系列的论文。
*   一个开发人员使用直观的解释和一系列的 API 也能把技术讲明白。 

他们都看似非常懂。

但是，一个真正的商业项目是不需要解释的。

我们需要使用模型去做有效的预测，我们需要的是结果。

结果胜过一切。

就是这样，结果胜过那些传统的能够代表能力的东西，诸如教育背景，工作履历和经验水平。

大部分开发者和招聘开发者的经理已经明白了这个道理。

但一些人还没有。

## 建立一个深度学习作品集

回答从业者是否胜任这一问题，最好的方法是去展示（能力）而不是告知（招聘者）。

从业者必须提供证据去证明他们理解如何去应用深度学习的技术，并且使用他们去开发高效的模型。

这意味着要使用开源仓库和可用的公共数据集去开发一个[公开作品集](https://machinelearningmastery.com/build-a-machine-learning-portfolio/)。

这样做有很多的好处，因为：

*   展示你倾注技巧搭建的模型。
*   让别人审阅代码。
*   捍卫你的设计决定。

（在作品集中）如实地讨论真实项目，就能让人很快弄清，从业者是不是真的理解这些项目。

*   为了评估这个能力，雇主必须要求从业者提交包含已完成工作的作品集，然后着重进行查阅。
*   为了证明这个能力，深度学习的从业者必须建立和维护一个已完成的项目的作品集。

作为一个从业者，问题变成了：有哪几个能力等级，每个等级又有什么样的能力期望？

## 深度学习能力的等级

从业者应该认真的选择要开发的项目，因为它还可以用来去证明你的技术能力。

在本节中，我们将概述深度学习能力的等级以及作为一名从业者，您可以开发和实施的项目类型，以便从中学习、获取和展示每一级能力水平。

深度学习能力分为三个等级，分别是：

*   **等级 1**：建立模型
*   **等级 2**：调试
*   **等级 3**：应用

这可能不完整，但是为商业开发中的从业者提供了一个良好的出发点。

对等级划分的一些解释：

*   假设你早已是一个机器学习从业者，并不是从零开始。
*   并不是所有的商业开发都要或者可以完美使用等级 3 的从业者。
*   许多从业者想一开始就进入第 3 级，并且想很快搞清楚 1 级和 2 级的事情。
*   等级 2 常常被忽视，但是我认为它是关键，（因为可以）证明有更深入的理解。

其他没有被讨论到的可能和能力相关的话题还有从零开始写代码、处理大数据和数据流、GPU 编程、开发新的方法，等等。

如果你有关于能力等级或者项目的想法。请在下面的评论里展示出来让我知道。

现在让我们把目光放回到每个等级上。

## 等级 1：建模

能达到这一深度学习能力的等级意味着你早已是一个机器学习从业者了。

这是最低的等级并且意味着你可以在传统的机器学习项目中高效地使用工具和方法。

但这并不意味着要你去有个更高级的证书或者你是什么项目大牛。相反，这意味着你熟悉应用机器学习的基础知识和能够从头到尾的建立预测性建模项目端到端工作的过程。

这并不是一个严格的先决条件。因为如果需要的话，这些元素可以被快速的学会。

这一等级的能力，会有以下表现：

*   **库能力**：你（应该）知道如何去使用一个开源的深度学习库去开发一个模型。
*   **建模能力**：你知道如何去应用使用神经网络去开发机器学习的过程。

### 库能力

库能力意味着你知道如何去搭建一个开发环境并且使用最普遍的 API 层去定义，加载，并且使用神经网络模型去预测。

这也意味着你知道每种神经网络模型最基本的差异，以及使用它的最佳时机。

这并不意味着你知道每种函数过程和每种参数。这也不意味着你知道具体技术的数学描述。

### 建模能力

建模能力意味着你知道如何使用神经网络模型从头到尾地去完成一个机器学习项目。

具体而言，这意味着你有能力完成如下事情：

*   判断监督学习问题并且收集相关数据。
*   准备数据，包括特征选择，输入损失值，缩放和其他转换。
*   使用目标测试工具评估一套模型和模型架构。
*   选择和准备一个最终的模型并且使用它去对新数据进行预测。

这些能力意味着你可以高效的驾驭神经网络使之用于新项目的开发和建立有效模型上。

这一能力并不表示，你是应用所有或者一些神经网络技术的专家，或者你可以获得最好的结果。这也不意味着你熟悉所有数据类型。

### 项目

展示这种能力水平的项目应该是使用开源的深度学习库（比如 Keras），并在公开的机器学习数据集上显示应用机器学习过程的每一步。

这并不意味着要去实现对数据集的最佳预测结果，甚至不意味着使用神经网络是数据集的最佳可能模型。相反，你的目标应该是展示自己使用神经网络的能力，而最有可能用到的是比较简单的模型，比如多层感知机。

一个不错的数据集资源是在 1990 年到 2000 年被广泛使用的小型内存数据集。可以用它去证明机器学习甚至是神经网络的表现。例如在 [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/index.php)列表中的一些。

数据集很小，很容易在内存中容纳，这意味着项目的范围也很小，允许使用健壮的模型评估方案。如 k-折叠交叉验证，并且可能需要仔细的模型设计，以避免过拟合。

我希望有一系列项目能够处理标准预测建模项目的普遍问题，例如：

改变输入数据，从而展现出适用于神经网络的数据预处理技能：

*   输入具有相同范围的变量。
*   输入不同比例的变量。
*   混合了数字类型和分类类型的变量。
*   变量失去部分值。
*   具有冗余输入功能的数据。

处理多种目标变量，从而展现出合适的模型架构技能：

*   二分类任务。
*   多类分类任务。
*   回归任务。

## 等级 2：调试

假设具有的能力等级为 1，然后展示你可以使用传统和现代的技术从深度学习神经网络模型中发挥最大的功效。

它演示了下列事情：

*   **学习能力**。你可以改进神经网络模型的训练过程。
*   **泛化能力**。你可以减少训练数据的过度拟合还有减少样本外数据的泛化误差。
*    **预测能力**。你可以降低最终预测模型的方差和提升模型的技能。

### 学习能力

学习能力就是说，你知道如何去配置和调整学习算法的超参数来让程序达到更好的表现。

这意味着在调整随机梯度下降超参数方面的技能，例如：

*   批量大小
*   学习速率
*   学习速率计划
*   适应学习速率

这意味着调整影响模型能力方面的技能，例如：

*   模型选择
*   激活函数的选择
*   节点的数量
*   层的数量

化解（机器）学习过程中的相关问题的技能，例如：

*   梯度消失
*   梯度爆炸

它也意味着用技术去加速学习的技能，例如：

*   批处理规范化
*   分层培训
*   迁移学习

### 泛化能力

泛化能力意味着，你知道如何去配置和调整一个模型去减少过拟合，去提升模型在样本外数据的表现。

这包括经典的技术例如：

*   权重正则化
*   增加噪声
*   提前停止

这也包括一些现代的技术例如：

*   权重约束
*   活动规范化
*   随机失活

### 预测能力

预测能力意味着你知道如何使用技术去减少预测时所选模型的方差，并结合模型以提高性能。

这意味着要使用集成技术，例如：

*   模型均衡
*   堆栈集成
*   权重均衡

### 项目

证明这一能力水平的项目可能不太关注应用机器学习过程中的所有步骤，而是关注特定的问题，还有以缓解问题为设计目标的一个或多个技术。

与这三方面的能力相称的问题，可能包括：

*   模型训练太慢的问题
*   对训练数据集过拟合的问题
*   方差过高的问题

再说一次，这并不意味着在一个具体的问题里实现最佳的表现，仅仅是显示技术的正确使用方法和它处理已确定问题的能力。

清楚展示项目中研究的问题，比选择数据集甚至问题类型都更重要。

一些数据集自然会带来一些问题，例如，小的训练集和不平衡的数据集会带来过拟合的结果。

可以使用标准机器学习数据集。也可以人为设计问题然后再去证明它，或者还可以使用数据集生成器。

## 等级 3：应用

这个能力等级高于能力等级 1 和 2，并且展示你可以在具体问题里使用深度学习神经网络技术。

这就是说，要在 simple tabular datasets 以外的场合展现深度学习的技术。

这也是对问题领域里不同类型和特定问题实例的深入学习的演示。在这些领域中，这些技术可能表现良好，甚至是最先进的。

它演示如下事情：

*   **数据处理能力**。你可以为神经网络加载和准备具体问题的数据。
*   **技术能力**。你可以为具体问题比较和选择合适的神经网络模型。

### 数据处理能力

数据处理能力意味着你可以获得，加载，使用和准备模型所使用的数据。

这很可能证明运用标准库处理数据，以及运用标准技术准备数据的能力。

问题域和对数据的处理可能包括：

*   **时间序列预测**。将时间序列问题处理为监督学习问题的代码。
*   **计算机视觉**。用于加载图像和转换以调整像素大小（可能是标准化）的API。
*   **自然语言处理**。用于加载文本数据和转换译码字符或者单词的 API。

### 技术能力

技术能力意味着你可以准确识别适合特定领域建模问题的技术、模型和模型体系结构。

这将很可能需要你熟悉学术文献和/或行业中针对该领域一般类问题使用的常用方法。

问题域和针对具体问题的方法可能包括：

*   **预测时间序列**。使用序列预测模型。比如卷积神经网络模型和循环神经网络模型。
*   **计算机视觉**。使用深度卷积神经网络和使用特殊体系结构。
*   **自然语言处理**。使用深度循环神经网络模型和使用特殊体系结构。

### 项目

能表现出这一能力水平的项目，必须涵盖应用机器学习过程，用上细致的模型调整方法（等级 1 和 2 的能力），还必须将重点放在特定领域的数据集上。

数据集来源于这里：

*   被使用在学术领域去验证方法的标准数据集
*   机器学习竞赛网站的数据集
*   由你收集和定义的独特数据集。

可能存在大量属于给定问题域的问题。尽管会有一个更常见或更突出的子集，这些可能是示范项目的重点。

域和突出的子问题的一些示例可能包括：

*   **时间序列预测**。单一变量，多元变量，多步和分类。
*   **计算机视觉**。物体分类，物体定位和物体描述。
*   **自然语言处理**。文本分类，文本翻译和文本概括。

可取的做法或许是，在跨领域的高水平层面上展示能力，这样就能让数据处理手法、建模技术和技能很好地表现出来。

在解决了最突出的问题和技术之后，也可能需要专门研究某个领域，并缩小对细微子问题的演示项目的范围。

因为这种类型的项目可能表现出深度学习的更广泛吸引力（例如，超越经典方法的能力），直接跳到这一水平是有危险的。

有经验的从业者，要是在其他机器学习方法或者该专门领域具备更深入的知识和经验，或许能做到这一点。

然而，这是非常困难的，因为你可能不得不学习并且必须一次驾驭和证明所有三个等级的能力。

这是迄今为止初学者犯的最大的错误。他们钻研特定领域的项目并遇到一个又一个的障碍。因为他们对库的用法、从头到尾完成一个项目的流程以及提高模型表现的过程这几个方面还掌握得不好，更别说所涉领域中运用的特定数据处理技术和建模技术了。

再说一次，可以从这一个等级开始，但给你带来的可能仅仅是三倍的工作量和挫败感。

你对能力框架产生共鸣了吗？你认为这很空洞吗？
请在评论区让我知道。

## 扩展阅读

如果你想研究的更深入，这一节为你提供此课题下更多的资源。

### 帖子

*   [建立一个机器学习文件夹](https://machinelearningmastery.com/build-a-machine-learning-portfolio/)
*   [深度学习是什么](https://machinelearningmastery.com/what-is-deep-learning/)
*   [8 启发性的深度学习应用](https://machinelearningmastery.com/inspirational-applications-deep-learning/)
*   [7 自然语言处理服务的深度学习应用](https://machinelearningmastery.com/applications-of-deep-learning-for-natural-language-processing/)

### 文章

*   [UC Irvine 深度学习仓库](https://archive.ics.uci.edu/ml/index.php)
*   [研究机器学习的一些数据集, 维基百科](https://en.wikipedia.org/wiki/List_of_datasets_for_machine_learning_research)
*   [深度学习数据集](http://deeplearning.net/datasets/)
*   [25 开放式数据集，供每个数据科学家深入学习, Analytics Vidhya](https://www.analyticsvidhya.com/blog/2018/03/comprehensive-collection-deep-learning-datasets/).

## 总结

在这篇文章中，你发现了深度学习能力的三个等级，作为一个从业者，你必须在每一个等级上证明什么

具体而言，你学习了：

*   深度学习的能力最好是通过项目组合去评估。
*   三个能力级别的层次结构可用于对从业者进行分类，并提供一个识别预期技能的框架。
*   最普通的错误是新手从 3 级就开始，意味着他们试图一下就学到所有的等级，导致困惑和挫折感。

你有问题吗？
在下方评论区提问，我将尽我所能去回答。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。 
