> * 原文地址：[Data Streaming](http://tutorials.jenkov.com/data-streaming/index.html)
> * 原文作者：[Jakob Jenkov](https://twitter.com/#!/jjenkov)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/data-streaming.md](https://github.com/xitu/gold-miner/blob/master/TODO1/data-streaming.md)
> * 译者：[steinliber](https://github.com/steinliber)
> * 校对者：[Endone](https://github.com/Endone)，[xionglong58](https://github.com/xionglong58)

# 数据流简介

**数据流**是一种数据分发技术，通过这种技术数据生产者可以把数据记录写入到一个有序的数据流中，数据消费者可以从该数据流中以同样的顺序读取数据。这里有一个简单的数据流图解释数据生产者、数据流和数据消费者：

![](http://tutorials.jenkov.com/images/data-streaming/data-streaming-introduction-1.png)

## 数据流有很多变体

从表面上看，数据流作为一个概念看起来很简单。数据生产者把记录储存到数据流中，稍后消费者会读取这些数据。但是，在这个表面下还存在着很多细节，这些细节会影响到整个数据流系统的表现、行为方式以及功能。

每个数据流产品都会对其支持的使用场景和支持的处理技术做出一系列假设。这些假设决定了数据流的设计方式，从而影响你可以实现的流处理行为类型。这个数据流教程研究了许多这些设计中的选择，并且根据这些设计选择讨论它们作为产品对于使用用户的影响。

## 数据流解耦生产者和消费者

数据流使数据生产者和数据消费者相互解耦。数据生产者只是简单地把数据写到数据流中，并不需要知道读取数据的消费者。消费者可以独立于生产者添加或删除。消费者也可以启动和停止，或者暂停和恢复它们的消费，而生产者并不需要知道这些。这种解耦简化了数据生产者和消费者的实现。

## 数据流作为数据共享的机制

在更大的分布式系统中，数据流是一种储存和共享数据十分有效的机制。正像之前提到的那样，数据生产者只需要把数据发送到数据流系统。生产者不需要了解消费者的任何情况。消费者可以在不影响生产者的情况下被添加和删除。

像 LinkedIn 这样的大公司在内部广泛使用了数据流。Uber 内部也使用了数据流。许多企业级公司内部正在采用或已经采用了数据流。许多初创公司也是如此。

## 持久化数据流

数据流是可以是持久化的，在这种情况下，它有时候被称为**日志**或者**日报**。持久化数据流的优点在于当数据流服务被关闭时里面的数据还可以保存下来，因此不会丢失任何数据记录。

和只将记录保存在内存中的数据流服务相比，持久化数据流服务通常可以保存更多的历史数据。一些数据流服务甚至可以把保存的历史数据一直追溯到写入数据流的第一条记录。其它数据流保存的历史数据通常不会很久，例如几天。

在持久化数据流保存了完整历史记录的情况下，消费者就可以重放所有这些记录，并基于这些历史记录重建其内部的状态。如果在消费者的代码中发现了错误，则可以更正错误代码并重放数据流以重新创建其内部的数据库。

## 数据流用例

数据流是一个非常通用的概念，可以用来支持许多不同的用例。在本节中，我将会介绍一些常用数据流用例。

### 数据流用于事件驱动架构

数据流通常可以用来实现[事件驱动架构](http://tutorials.jenkov.com/software-architecture/event-driven-architecture.html)。事件生产者将事件作为记录写到某些数据流系统，事件的消费者可以从中读取事件。

### 数据流用于智能城市和物联网

对于安装在**智慧城市**的传感器，**智能工厂**内的传感器或者其它**物联网**设备，数据流可以被用来从这些设备传输数据。温度、污染水平等这些数值可以定期从设备中取样并写入数据流中。数据消费者可以在需要时从数据流中读取样本。

### 数据流用于定期采样数据

智能城市中的传感器和物联网设备只是作为数据源的两个例子，这些数据流可以被定期采样并且通过数据流得到。但是还有很多其它类型的数据可以被定期采样和流式处理。比如说，货币汇率或股票价格也可以被采样和流式处理。投票数也能定期被采样和流式处理。

### 数据流用于数据点

在投票数的例子中，你可以决定将每个单独的回答流式传输到投票所中，而不是流式传输定期抽样的总数。在一些总数是由单个数据点组成的（就像民意调查）的情况下，使用流式传输单个数据点比计算得到的总数更有意义。它取决于具体的用例以及其它一些因素，比如其中的单个点数据是匿名的或者包含了不应该共享的私人信息。

## 记录，消息，事件，样本等

数据流中的记录有时候被称为消息、事件、样本，对象或其它术语。使用什么术语取决于数据流的具体用例，以及生产者和消费者如何处理和响应数据。通常情况下这都是合理的，在用例中通过使用的术语来映射数据流中的数据是有意义的。

值得注意的是，用例也会影响给定记录所表示的内容。并非所有的数据记录都是相同的。事件和采样值是不同的，所以它们不能通过同样的方式使用。稍后我会在本（或其它）教程中更详细的介绍这点。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
