> * 原文地址：[Composing Software: The Book](https://medium.com/javascript-scene/composing-software-the-book-f31c77fc3ddc)
> * 原文作者：[Eric Elliott](https://medium.com/@_ericelliott)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/composing-software-the-book.md](https://github.com/xitu/gold-miner/blob/master/TODO1/composing-software-the-book.md)
> * 译者：[zoomdong](https://github.com/fireairforce)
> * 校对者：[Roc](https://github.com/QinRoc), [niayyy](https://github.com/niayyy-S)

# 组合软件：书

![Smoke Art Cubes to Smoke — MattysFlicks — (CC BY 2.0)](https://cdn-images-1.medium.com/max/10302/1*uVpU7iruzXafhU2VLeH4lw.jpeg)

> **注意：** 这是[**“组合软件”系列丛书**](https://leanpub.com/composingsoftware)的一部分，它最初以一个博客文章系列的形式出现在这里。它从头到尾地包含了 JavaScript（ES6+）中的函数式编程和组合软件技术。[“组合软件”同样也有印刷版本](https://www.amazon.com/Composing-Software-Exploration-Programming-Composition/dp/1661212565/ref=as_li_ss_tl?ie=UTF8&linkCode=ll1&tag=eejs-20&linkId=eee1371063c82dea4c2fc72c097868c6&language=en_US)。

“组合软件”是一个热门的博客文章系列，介绍了 JavaScript 中的函数式编程和软件组合，现在是 [Leanpub 上最畅销的书](https://leanpub.com/composingsoftware)。也有[印刷版本](https://www.amazon.com/Composing-Software-Exploration-Programming-Composition/dp/1661212565/ref=as_li_ss_tl?ie=UTF8&linkCode=ll1&tag=eejs-20&linkId=eee1371063c82dea4c2fc72c097868c6&language=en_US)。

2017 年 2 月 8 日，我开始写一篇关于函数式编程的博客文章。[“跌宕起伏的函数式编程”](https://medium.com/javascript-scene/the-rise-and-fall-and-rise-of-functional-programming-composable-software-c2d91b424c8c) 作为《软件组合》系列的介绍文章。当我开始写作的时候，我并不知道它会吸引超过 10 万的读者，也不知道接下来的文章会有超过 100 万的总阅读量，更不知道它能够[出版](https://leanpub.com/composingsoftware)，并在发布的一周内跃升到 Leanpub 畅销书排行榜。

我衷心感谢 JS Cheerleader，她使这本书在很多方面变得更好。如果你觉得这些文章是易于阅读的，那是因为她仔细地校验了每一页，并在每一步都提供了深刻的反馈和鼓励。没有她的帮助，你现在就不会读到这些文章。

感谢博客的读者，他们的热情支持帮助我们把这个小小的博客文章系列变成了一个吸引了数百万读者的现象级文章系列，并为我们提供了把它变成一本书的动力。

感谢计算机科学领域中为我们铺平了道路的传奇人物们。

> “如果说我看得更远，那是因为我站在巨人的肩膀上。” —— 艾萨克·牛顿爵士

组合是所有的软件开发方式：将复杂的问题分解成更小的部分，然后将这些更小的解决方案组合在一起，组成了应用程序。

但是我在面试软件开发工作的面试者时注意到，几乎没有人能描述软件上下文中的组合。当我在面试的时候问 “什么是函数组合？” 或者 “什么是对象组合？”，得到的却是支支吾吾的或者没有任何实质的内容的回答。

怎么会这样呢？99% 的专业开发人员 —— 有些拥有 10 年以上的软件开发经验 —— 怎么可能不知道软件工程中组合的两种最基础形式的定义或例子呢？每个人每天都在构建软件的过程中组合函数和对象，那么怎么会有那么多人不理解这些技术的基本原理呢？

事实上，组合根本不是一门人们关注、教得好、学得好的学科。我突然想到，也许这就是为什么[过度复杂化是软件开发人员每天犯的最大错误](https://medium.com/javascript-scene/the-single-biggest-mistake-programmers-make-every-day-62366b432308)。当你不知道如何把乐高积木拼在一起时，你可能会弄坏胶带和胶水，然后变得烦躁......对于软件开发来说，你也会损害软件、你的队友和用户。

你无法摆脱组合软件 —— 软件就是这样组合在一起的。但如果你不认真组合软件的话，你会做得很差，浪费大量的时间和金钱，造成漏洞，甚至导致严重的人类安全问题。我写了这个系列和这本书来改变这一点。

博客文章的麻烦在于它们从来没有官方索引。欢迎使用“组合软件：博客文章”的官方博客文章索引。

* [简介](https://medium.com/javascript-scene/composing-software-an-introduction-27b72500d6ea)
* [不变性之道](https://medium.com/javascript-scene/the-dao-of-immutability-9f91a70c88cd)
* [跌宕起伏的函数式编程](https://medium.com/javascript-scene/the-rise-and-fall-and-rise-of-functional-programming-composable-software-c2d91b424c8c)
* [为什么用 JavaScript 学习函数式编程？](https://medium.com/javascript-scene/why-learn-functional-programming-in-javascript-composing-software-ea13afc7a257)
* [纯函数](https://medium.com/javascript-scene/master-the-javascript-interview-what-is-a-pure-function-d1c076bec976)
* [什么是函数式编程？](https://medium.com/javascript-scene/master-the-javascript-interview-what-is-functional-programming-7f218c68b3a0)
* [函数式程序员的 JavaScript 简介](https://medium.com/javascript-scene/a-functional-programmers-introduction-to-javascript-composing-software-d670d14ede30)
* [高阶函数](https://medium.com/javascript-scene/higher-order-functions-composing-software-5365cf2cbe99)
* [柯里化与函数组合](https://medium.com/javascript-scene/curry-and-function-composition-2c208d774983)
* [抽象与组合](https://medium.com/javascript-scene/abstraction-composition-cb2849d5bdd6)
* [Functor 与 Category](https://medium.com/javascript-scene/functors-categories-61e031bac53f)
* [JavaScript 让 Monad 更简单](https://medium.com/javascript-scene/javascript-monads-made-simple-7856be57bfe8)
* [被遗忘的面向对象编程史](https://medium.com/javascript-scene/the-forgotten-history-of-oop-88d71b9b2d9f)
* [对象组合中的宝藏](https://medium.com/javascript-scene/the-hidden-treasures-of-object-composition-60cd89480381)
* [ES6+ 中的 JavaScript 工厂函数](https://medium.com/javascript-scene/javascript-factory-functions-with-es6-4d224591a8b1)
* [函数式 Mixin](https://medium.com/javascript-scene/functional-mixins-composing-software-ffb66d5e731c)
* [为什么类中使用组合很难](https://medium.com/javascript-scene/why-composition-is-harder-with-classes-c3e627dcd0aa)
* [可自定义数据类型](https://medium.com/javascript-scene/composable-datatypes-with-functions-aec72db3b093)
* [Lenses：可组合函数式编程的 Getter 和 Setter](https://medium.com/javascript-scene/lenses-b85976cb0534)
* [Transducers：JavaScript 中高效的数据处理 Pipeline](https://medium.com/javascript-scene/transducers-efficient-data-processing-pipelines-in-javascript-7985330fe73d)
* [JavaScript 样式元素](https://medium.com/javascript-scene/elements-of-javascript-style-caa8821cb99f)
* [模拟是一种代码异味](https://medium.com/javascript-scene/mocking-is-a-code-smell-944a70c90a6a)

---

**Eric Elliott** 是一名分布式系统专家，并且是 [《组合软件》](https://leanpub.com/composingsoftware)和[《编写 JavaScript 程序》](https://ericelliottjs.com/product/programming-javascript-applications-ebook/)这两本书的作者。作为 [EricElliottJS.com](https://ericelliottjs.com) 和 [DevAnywhere.io](https://devanywhere.io/) 的联合创始人，他教开发人员远程工作和实现工作以及生活平衡所需的技能。他创建了加密项目的开发团队，并为他们提供建议。他还在软件体验上为 **Adobe 系统、Zumba Fitness、华尔街日报、ESPN、BBC** 以及包括 **Usher、Frank Ocean、Metallica** 等在内的顶级唱片艺术家做出了贡献。

**他和世界上最漂亮的女人一起享受着远程（工作）的生活方式。**

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
