> * 原文地址：[Building the Design Ecosystem of the Future](https://medium.com/@pablostanley/building-the-design-ecosystem-of-the-future-d22b663fed1f)
> * 原文作者：[Pablo Stanley](https://medium.com/@pablostanley?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/building-the-design-ecosystem-of-the-future.md](https://github.com/xitu/gold-miner/blob/master/TODO1/building-the-design-ecosystem-of-the-future.md)
> * 译者：[MeFelixWang](https://github.com/MeFelixWang)
> * 校对者：[StellaBauhinia](https://github.com/StellaBauhinia)

# 构建未来的设计生态系统

## 我为什么要加入 InVision

很高兴告诉大家我加入了 InVision 团队，在 [Studio](https://www.invisionapp.com/studio) 平台工作。我们的目标是建立起连接最紧密的设计生态系统，使团队能够安然度过设计过程中从构思到开发的每个阶段。

* * *

![](https://cdn-images-1.medium.com/max/800/1*YueL6vogJTWvNi-03_h2Vw.gif)

### 设计工具的演变

在过去几年中，现代设计师的角色以惊人的速度演变着。对此我深有体会。曾经被认为是创造了漂亮像素的人已经转变为应用研究成果、创造浏览体验、增加交互设计以及通过为公司用户发声而加入领导者行列的人。

由于这种快速转变，一系列新的责任转移到了设计师身上。技术的进步要求设计人员针对各种内容、设备和语言进行设计。曾经的一个静态像素，现在变成了一个集接收、增长、缩小和动画于一体的动态单元。我们现在将想法转化为概念、草图、线框、屏幕、流程、原型、动画、代码，最后转化为产品。

在这种演变的同时，设计工具已经发展到能够支持这些特定需求了。这包括从专门为创建屏幕设计和交互式原型而构建的工具到实现文档响应式布局，实现设计传递以及支持实时协作的插件。

令人兴奋的是看到如此多样化的工具集出现，但这也最终导致设计师的不确定性，并且在许多情况下，设计工作流程被破坏了。💔

* * *

![](https://cdn-images-1.medium.com/max/800/1*MkogGsVeqrb3HpzbF4u0Dg.gif)

### 学习成为一名设计师

四年前，我从平面设计师转变为“产品设计师”。老实说，当时我并不知道产品设计师究竟是什么。但它似乎很简单。就是绘制大量的盒子，添加文本，并将所有内容对齐到左边，对吧？

哦，我错了。产品设计涉及的东西不止于此。有要遵循的流程，有实施的方法，有合作伙伴以及使用的工具。那时候，没有太多的学习资源，我们把设计领导者写的稀缺的 Medium 文章视为福音。🙏🏽

在此演变的过程中，越来越多的资源开始出现，使得成为产品设计师的道路变得容易了一些。[Meng To](https://medium.com/@mengto) 的 [Design+Code](https://designcode.io/) 教会了我们如何使用必要的工具，[uxdesign.cc](https://medium.com/@uxdesigncc) 让我们深入了解了什么是用户体验。我决定加入他们并与其他设计师分享我在学习过程中学到的东西。我开始在湾区举办[设计研讨会]((https://www.meetup.com/))，并创建了一个由教程组成的[ YouTube 频道]((https://www.youtube.com/c/sketchtogethertv))。

为了学习如何成为更好的产品设计师，我决定教授别人如何成为一名产品设计师。听起来违反直觉，对吧？但这有点道理。当你试图展示某些东西时会迫使自己去深刻理解它，这样你就可以将其分解然后加以解释。

分享我所学到的东西让我置身于一个梦幻般的创造者社区。人们渴望知识，由一种令人难以置信的创造力所驱动，他们会公开分享他们学到的东西。我很幸运能成为这个令人难以置信的团队的一员。

我的下一步计划是从教导人们如何使用设计工具转变为加入一个为他们创建设计工具的团队。

* * *

![](https://cdn-images-1.medium.com/max/800/1*SenVAHnqgG4uTWEm971hXQ.gif)

### 为什么选择 InVision

根据 [Jim Collins](https://www.jimcollins.com/article_topics/articles/good-to-great.html) 的说法，伟大公司的发展征程并不始于他们的目标或是他们的途径，而是开始于他们的团队。他们从让那些愿意付出几倍努力的人上车开始发迹。没有比 InVision 更好的例子了。

在过去的几年里，我一直与 InVision 的人保持着联系，在插件、资源方面进行合作，只是对设计和工具感到不安。虽然他们的专业性和沟通能力一直很优秀，但我注意到的最震撼的是他们的人。我觉得遇到的每个人都与他们目前的岗位完美适配，而事实也的确如此。

该团队让 InVision 快速成长并保持稳定。他们创造了一些最受欢迎的设计工具，如 [Craft](https://www.invisionapp.com/craft)、[Design System Manager](https://www.invisionapp.com/blog/announcing-invision-design-system-manager/)，[Design Better](https://www.designbetter.co/)、[Freehand](https://www.invisionapp.com/feature/freehand)、[Inspect](https://www.invisionapp.com/feature/inspect)，以及现在的 [Studio](https://www.invisionapp.com/studio) —— 一个面向现代设计师的屏幕设计工具。加入这样一支优秀的团队将是一次学习经历。我迫不及待地想与一些我最钦佩的最有才华的设计师和聪明的产品人并肩工作。🙌🏽

* * *

![](https://cdn-images-1.medium.com/max/800/1*8Z9ciGXuvpoAPDv_N8zNew.gif)

### 适合所有人的设计工具

如果你用来创建令人惊叹的体验所需的一切都在同一个设计生态系中会怎样？听起来像圣杯，对吧？随着 Studio 平台的推出，这很快就会实现。我正在加入一个与第三方合作的团队，帮助他们提供高质量的体验。我们将帮助为顶级应用程序提供设计资产和资源。我们将与社区联系，了解他们的需求并帮助他们加入我们的平台。

我们正在为该平台建立一个由工程师、设计师和营销人员组成的支持团队。此外，我们正在为信仰充值 —— [Design Forward Fund](https://www.invisionapp.com/design-forward-fund) 正在向为 InVision Studio 创建世界级应用和附加组件的人和公司提供 500 万美元的赠款和股权投资。我想像着一个由创造者社区建立和推动的健康生态系统。如果你对可以改进 Studio 内设计工作流程的应用程序有好的想法，我们很希望听到！📣

我很高兴能加入 InVision 成为平台的设计主管。我们邀请你、创造者、开发者和企业家加入我们，让梦想成真 —— 构建未来的设计生态系统。

* * *

顺便说一句，此文章中的所有动画都是使用 [Studio](https://www.invisionapp.com/studio) 制作的。你可以[在这里下载](https://www.dropbox.com/sh/nsq4kd2w9v7801h/AAAbNsPy5vLbKOiPIQgFDTDoa?dl=0)。

* * *

感谢 [Courtney M. Sawyer](https://medium.com/@courtneymsawyer)、[Edgar Chaparro](https://medium.com/@Echaparro) 和 [Lindsey Scott](https://medium.com/@lindseylinds) 帮助我解决语法上的恐怖问题。

感谢 [Courtney Sawyer](https://medium.com/@csawyer?source=post_page)、[Lindsey Scott](https://medium.com/@lindseylinds?source=post_page) 和 [Edgar Chaparro](https://medium.com/@Echaparro?source=post_page). [No rights reserved](http://creativecommons.org/publicdomain/zero/1.0/)。作者没有[保留任何权利]（[No rights reserved](http://creativecommons.org/publicdomain/zero/1.0/)）。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
