> * 原文地址：[How to grow your app business in Southeast Asia](https://medium.com/googleplaydev/building-a-successful-app-or-game-business-in-southeast-asia-29e6eea0defb)
> * 原文作者：[Guy Charusadhirakul](https://medium.com/@guycharusa?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/building-a-successful-app-or-game-business-in-southeast-asia.md](https://github.com/xitu/gold-miner/blob/master/TODO1/building-a-successful-app-or-game-business-in-southeast-asia.md)
> * 译者：[jianboy](https://github.com/jianboy)

# 如何在东南亚拓展您的应用业务

## 使用 Android（Go 版）进行本地化和向新市场拓展的四个关键策略

![](https://cdn-images-1.medium.com/max/1600/1*mNb91X17FSyOL7CKXh6E-A.png)

东南亚是一个跨越 10 个国家的大型多样化地区，[人口超过 6.3 亿](https://aseanup.com/asean-infographics-population-market-economy/)。超过 [3.3 亿互联网用户](https://www.thinkwithgoogle.com/intl/en-apac/trends-and-insights/e-conomy-sea-unlocking-200b-digital-opportunity/) —— 已经超过了美国的互联网用户 —— 该地区已经成熟，可以进行爆炸性的数字和移动革命。[Google and Temasek 的研究](https://www.thinkwithgoogle.com/intl/en-apac/trends-and-insights/e-conomy-sea-unlocking-200b-digital-opportunity/)指出东南亚（SEA）到 2025 年，数字经济将价值超过 2000 亿美元。

与具有更发达的互联网基础设施的地区不同，东南亚人们依靠智能手机来访问信息，在社交媒体上共享内容以及消费娱乐。事实上，东南亚人[每天在移动互联网上花费 3.6 小时](https://www.blog.google/around-the-globe/google-asia/sea-internet-economy/)，时间多于世界上任何其他地方。

随着可支配收入的快速增长和智能手机拥有量的快速增长，东南亚为应用和游戏开发商提供了扩大用户群和业务的机会。

然而，东南亚为全球应用和游戏开发商带来了独特的挑战。虽然该地区的国家有许多文化和经济特征，但他们说不同的语言，并有独特的消费者偏好。该地区的许多消费者仍然习惯于在智能手机上购物，同时熟悉新的支付方式。

根据我的经验，作为一名东南亚本地人以及我在该地区的工作，我为应用和游戏开发者提供下面 4 个关键策略，以帮助他们在东南亚拓展业务。

![](https://cdn-images-1.medium.com/max/1600/0*SP1YjLo_uniUb49G)

### 策略 1：内容本地化

本地化是关键。我建议将应用和游戏内容以及 Google Play 商店列表翻译成本地语言。这对于没有广泛使用英语的泰国、印度尼西亚和越南等市场至关重要。已翻译的开发人员已经看到应用安装、用户和支出的增长。

> **例如，基于比较本地化前后 3 个月的应用内支出，GTarcade 的 Discacy of Discord-FuriousWings 报告称，当游戏本地化为泰国时，有 150％ 的增长，而本地化为印度尼西亚时，有 40％ 的增长。同样，Supercell 数据显示 [Hay Day](https://play.google.com/store/apps/details?id=com.supercell.hayday) 本地化为泰国后的支出增加了 40％。**

如果您不熟悉新市场，请使用 [store listing experiments](https://developer.android.com/distribute/best-practices/grow/store-listing-experiments) 以您的目标语言来测试商店列表的版本。

除了翻译内容以外，您还应考虑本地化应用内或游戏内容以符合当地文化规范。创建文化契合使应用和游戏与人们相关。

> **例如，[Smule](https://play.google.com/store/apps/developer?id=Smule) 与艺术家合作，为印度尼西亚和马来西亚的听众提供相关歌曲。Smule 一直是这些国家/地区 Google Play 商店中收入最高的应用之一。**

![](https://cdn-images-1.medium.com/max/1600/0*2BmnPD79f2EoGRII)

### 策略 2：本地化价格并考虑本地支付

与发达市场相比，东南亚的消费者可支配收入较低。2016 年人均国内生产总值估计为 [4,034 美元](https://www.aseanstats.org/wp-content/uploads/2018/01/ASYB_2017-rev.pdf)。因此，请考虑应用内购买的定价或订阅方式来匹配消费者收入。

> **Smule 在印度尼西亚的每月订阅价格为 12,000 印尼盾，即 0.83 美元。相比之下，美国每月 4.99 美元。通过将游戏内货币的价格设定为比北亚版本低 30-40％，[Dragon Nest M](https://play.google.com/store/apps/details?id=com.playfungame.ggplay.lzgsea)，东南亚中的热门动作游戏，报告了净收益。**

除了新加坡，Google Play 为东南亚所有市场提供的应用内购买价格低于 0.99 美元。

除了将定价项目本地化为本地用户的支付能力之外，直接运营商计费和礼品卡是该地区流行的支付方式。这些是很好的选择，因为信用卡使用在东南亚并不普遍。Google Play 与东南亚的 24 家运营商建立了合作伙伴关系，让消费者可以轻松地在您的应用中购物。

![](https://cdn-images-1.medium.com/max/1600/0*cBlieEiL3XU7Gu3b)

### 策略 3：为新兴市场（如东南亚）的用户优化应用和游戏

东南亚消费者使用各种设备 —— 从高端智能手机到入门级 Android 手机。为了确保入门级设备的最佳用户体验，许多开发人员通过减少 APK 大小和优化内存使用来优化他们的应用程序。这与 [Google 对 Android 用户的调查](https://medium.com/googleplaydev/shrinking-apks-growing-installs-5d3fcba23ce2)的结果一致：新兴市场中约有 70％ 的人认为是应用程序之前下载它出于对数据成本和手机存储空间的担忧。

> **[Garena Free Fire](https://play.google.com/store/apps/details?id=com.dts.freefireth) 的开发者通过音频，图像和视频缩小 APK 尺寸，为新兴市场优化了这款游戏数据压缩。开发人员还根据图形质量使用不同的纹理分辨率优化了内存使用。因此，Free Fire一直是东南亚最受欢迎的游戏之一。**

您可以针对 [Android Oreo（Go 版）](https://www.android.com/versions/oreo-8-0/go-edition/)。进一步优化您的应用。通过减少 APK 大小，优化内存使用和减少应用启动时间来做到这一点。[Viki](https://play.google.com/store/apps/details?id=com.viki.android)、[Shopback](https://play.google.com/store/apps/details?id=com.shopback.app)、[Tokopedia](https://play.google.com/store/search?q=Tokopedia&c=apps&sticky_source_country=ID) 和 [Picmix](https://play.google.com/store/apps/details?id=com.picmix.mobile) 是东南亚流行的应用程序的示例，这些应用程序已针对 Android Oreo（Go版）进行了优化，以更好地为该地区的人们提供服务。

您还应该了解 [Android vitals](https://developer.android.com/topic/performance/vitals/)，它可以测量应用程序运行状况信号，例如崩溃率，应用程序无响应和电池耗尽唤醒锁。这些与新兴市场的用户和设备非常相关，例如东南亚。您可以在 Google Play 控制台中监控 Android 生命周期。

但是，如果您的应用或游戏需要更高规格的设备来提供良好体验，请使用 [device catalog](https://support.google.com/googleplay/android-developer/answer/7353455?hl=en)。此 Google Play 控制台功能可让您过滤设备，以确保只有拥有合适手机的消费者才能安装您的应用或游戏。

![](https://cdn-images-1.medium.com/max/1600/0*_D796bdhi6hvwiNy)

### 策略 4：建立本地社区并与当地用户互动

东南亚用户具有高度社交性：在线和离线。成功的开发人员利用社区的力量来获取用户，教育人们他们的应用和游戏，并让用户保持参与和停留。以下是一些有助于在东南亚建立强大社区的提示：

*   **用他们的语言与人沟通：** 要建立一个强大的社区，您需要用他们的语言与人沟通。这意味着让母语使用者响应 Play 商店中的用户评论并通过其他渠道提供通信。当 Netmarble 在印度尼西亚推出他们的热门游戏 [Lineage2 Revolution](https://play.google.com/store/apps/details?id=com.netmarble.revolutionthm) 时，他们通过当地语言回复了印度尼西亚语版 Google Play 上的用户评论。自推出以来，Lineage2 Revolution 一直是印度尼西亚在 Google Play 上排名前三的游戏。
*   **建立当地社交媒体：** 成功的开发者使用当地市场的流行社交媒体定期向社区传达相关新闻和内容。这些社交渠道也是人们向您传达客户服务问题的热门方式。例如，[IGG.COM](https://play.google.com/store/apps/dev?id=8895734616362643252) 估计，东南亚超过 50% 的客户服务问题来自社交渠道。
*   **考虑与内容创作者合作：** YouTube 在东南亚非常受欢迎。事实上，泰国和印度尼西亚[在移动设备上观看 YouTube 的比例最高](https://www.thinkwithgoogle.com/intl/en-apac/trends-and-insights/beyond-numbers-youtube-shapes-lives-thailand-indonesia/)。因此，许多游戏开发人员与创作者一起制作游戏玩法，以帮助教育和重新吸引玩家。
*   **不要低估线下：** 线下活动是在东南亚建立社区的重要元素。开发人员，如 [Com2uS](https://play.google.com/store/apps/dev?id=6850516909323484758) 和 [Siamgame](https://play.google.com/store/apps/dev?id=6476992165808510390) 定期为最狂热的粉丝举办线下活动，培养强烈的社区意识，增加重新参与度。电子竞技在东南亚越来越受欢迎，它甚至被列入今年的亚洲运动会，在雅加达和印度尼西亚的巨港举办。[Hero Games](https://play.google.com/store/apps/dev?id=9060101706093336387) 和 [Garena](https://play.google.com/store/apps/details?id=com.dts.freefireth) 将电子竞技视为推动与东南亚游戏玩家社区互动的主要因素。

### 后记

随着这个充满活力的地区的经济继续增长，东南亚市场为寻找新用户和增加收入提供了巨大的机会。成功的关键是根据您的目标市场定制您的业务 —— 本地化您的内容，将定价设置为当地收入，优化 Android Oreo（Go 版）应用以及构建社区。如果您需要更多指导，请查看 Android 开发人员的 [Build for billions](https://developer.android.com/docs/quality-guidelines/building-for-billions/) 页面。

* * *

###  你怎么看？

您是否有关于在东南亚中构建应用和游戏业务的想法？请在下面的评论中告诉我们，或使用 **#AskPlayDev** 发送推文，我们会从 [@GooglePlayDev](http://twitter.com/googleplaydev) 中进行回复，我们会在 Google Play 上定期分享有关如何取得成功的新闻和提示。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
