> * 原文地址：[Blockchain Platforms & Tech to Watch in 2019](https://medium.com/the-challenge/blockchain-platforms-tech-to-watch-in-2019-f2bfefc5c23)
> * 原文作者：[Eric Elliott](https://medium.com/@_ericelliott?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/blockchain-platforms-tech-to-watch-in-2019.md](https://github.com/xitu/gold-miner/blob/master/TODO1/blockchain-platforms-tech-to-watch-in-2019.md)
> * 译者：[Rickon](https://github.com/gs666)
> * 校对者：[shixi-li](https://github.com/shixi-li), [kasheemlew](https://github.com/kasheemlew)

# 2019 区块链平台与技术展望

![](https://cdn-images-1.medium.com/max/2000/1*k2FyIN5xEkNzAGyflWPhUg.jpeg)

no.thisispatrick — “Electric Water” (CC BY-NC-ND 2.0)

自 2015 年以来，**以太坊** 一直是智能合约平台的主导者，但是在 2018，谷歌、亚马逊和苹果公司打造智能合约平台的竞赛逐渐升温，且赌注很大。主导新兴价值互联网的平台可能轻易地达到万亿美元的市值。

> **太长，不看**？请在底部参阅 2019 年值得关注的加密技术的完整列表。

2018 年底，开发人员厌倦了等待 EVM 的扩展成为现实。像 [**Raiden Network’s**](https://raiden.network/) 这样的新兴技术登陆以太坊主网给以太坊开发者来了期待已久的希望，但这可能太晚了并且还远远不够。今年，具有更快第 1 层共识的替代区块链开始吸引开发人员的注意力，开发人员去哪里，应用程序和用户也会随之而去。

![](https://i.loli.net/2019/01/02/5c2c256055b28.png)

但是，要追赶上来很难。以太坊有成千上万的开发者课程、教程、文章和 Stack Overflow 问答，这是一个很好的开始。他们还拥有致力于改进提案和核心协议开发的最大、最活跃的社区。

开发人员可能会对缓慢的交易和糟糕的用户界面感到不满，但以太坊仍然在占据着开发人员的心。超过 3000 个 ICO 已经在以太坊发行，其最接近的竞争对手仍然有数百计。以太坊在 2018 年遭受了一些重大打击，但本周的一次大反弹可以作为给挑战者的回应：**不要将以太坊排除在外**。

![](https://cdn-images-1.medium.com/max/800/1*BDxlV5cQEhxEcWBAnKSWyA.png)

以太坊反弹：这还没有结束！

![](https://cdn-images-1.medium.com/max/800/1*aO99I_W_x4ckn_kgFlYYlg.png)

2018 年 12 月 28 号 24 小时内涨幅排行

### 主导主题

2017 年主要的加密主题是 ICO 大爆炸：初次发行代币产品（ICOs）的曙光。这种爆炸式增长一直持续到 2018 年上半年，直到监管问题对加密行业产生寒蝉效应。

![](https://cdn-images-1.medium.com/max/800/1*FUZjNmtKuVNSAK-DnoGtoQ.png)

每月 ICO 募资：2014-2018 来源：CoinDesk

2018年有两个主要主题：

**BUIDL 跑道** - 我们可以在资金耗尽之前将我们的加密项目推向市场吗？子主题：**加密行业的浪费**。许多公司在打造可行的产品之前，花费了大量资金飞到世界各地举行会议。在你建立 MVP 之前就在营销上花钱，这与精益创业的理念背道而驰，自 2001 年互联网泡沫破裂以来，精益创业理念一直主导着明智的科技领导者。

**加密“寒冬”** - 在 2017 年底，加密市场又跨越了另一个 10 倍的增长。每次发生这种情况，市场都会回落，然后再攀升至上次的 10 倍。2018 年是 10 倍峰值之后的第一年，所以很自然地，我们再次下跌。不幸的是，许多加密项目在价格暴跌 80％-90％ 期间保留了他们在市场上筹集的资金，现在钱即将耗尽。这已经导致了很多裁员。（另见：[“BUIDL 圣诞节：区块链圣诞节裁员的故事](https://medium.com/the-challenge/buidl-christmas-58a0c9d7377b)）

这意味着什么？加密市场有可预测的起伏。根据过去的表现，我们知道在我们达到下一个 10 倍标记后，价格很可能会在接下来的几个月中下降 80％-90％。这对于财务部门来说意味着他们应该计划项目跑道—传统上至少 18 个月的运营费用，并用法定货币存入资金以保护它免受市场下行周期的影响。这样，无论加密市场如何，他们都可以继续运营。如果在将该跑道投入保管之后还有额外的资金，当然是将这些资金留在市场中并期望在买入时获得长期收益。

大多数项目都做不到这点。那些公司被迫进行裁员，而在我看来应该从财务主管开始。

![](https://cdn-images-1.medium.com/max/800/1*2nlit12SUIYN93RdmBNoHQ.png)

比特币价格（记录）：每个红色的箭头都比上次高十倍

精明的加密行业投资者意识到了市场周期，并计划他们期望保持 7 到 10 多年的长期投资策略。对于这些投资者来说，加密行业投资的前景再次开始变得好看起来。

**关于“加密业寒冬”的提示**：加密行业从未经历人工智能行业在 1987 年至 2009 年间经历过的寒冬，这可能强化了“加密寒冬”的名称。在非常真实的人工智能寒冬，研究人员使用诸如“机器学习”和“分析”之类的委婉语来确保资金以避免“AI”的耻辱，许多人已经开始将其视为永远不会实现的科幻乌托邦。今天，AI 的进步带给我们一些最令人振奋的技术，包括自动驾驶汽车，自动飞行无人机以及机器人技术的重大突破。

### 2019 年的主题是什么?

如果 2017 年是关于 ICO，2018 年是关于“生存”，那么 2019 年的加密相关的主题会是什么？

#### 吸引用户

去中心化应用程序在 2018 年只有很少的受众，但 2019 年可能是我们第一次看到有着数百万用户的去中心化应用程序的年份，而拒绝加密的极客最终将开始以加密货币进行交易。

据 [DappRadar](https://dappradar.com/) 称，2018 年最受欢迎的以太坊 dApp 目前每日活跃用户**不足一千**。但是，一种新的加密应用程序正在显现。

支持加密的 [**Brave Browser**](https://brave.com/) （由Mozilla的联合创始人兼web 平台编程语言 JavaScript 的创建者 Brendan Eich 领导）已经在 Google Play 商店中有着超过 1000 万的安装量。Brave 使用户可以轻松获得并使用 [**BAT**](https://basicattentiontoken.org/) 加密货币。您可以通过浏览自己喜欢的网站获得加密币。如果您选择加入，Brave 将使用不会跟踪您的行为的广告替换广告网络商投放的具有潜在危险的跟踪型广告。作为交换，你将自动获得 BAT，只是为了做你以前总做的事情。

![](https://cdn-images-1.medium.com/max/800/1*kbd-a9fDJdFenZ8couEOFw.png)

截图：Brave 浏览器集成了 BAT 钱包

[**Sliver.tv**](https://www.sliver.tv/) 是一个让游戏玩家直播游戏视频给其他游戏爱好者观看的视频游戏流媒体网站。它最近集成了 [**Theta**](https://www.thetatoken.org/) 加密货币，它允许观众通过观看视频流和与其他观众共享网络带宽来获得加密货币。

![](https://cdn-images-1.medium.com/max/800/1*81S6bI6fP7ca59GzR_qyMw.png)

截屏 左边：腾讯游戏的无限法则在 Sliver 上直播。右：Sliver.tv 集成了 Theta 钱包。

观众也可以赢得 Theta，捐给主播或者使用它来在 Sliver 商店购买虚拟或真实的商品。Sliver.tv [每月活跃用户超过两万](https://www.alexa.com/siteinfo/sliver.tv)，可能是迄今为止最受欢迎的加密应用程序，供一般受众使用（即不是投资/交换/钱包应用）。

Sliver.tv 是一个非常有前途的开端，但它使用中心化的托管钱包，用户无法提取资金。

[**Cent.co**](https://beta.cent.co/) 着眼于基于内容的社交网络的未来。想象一下 Twitter 和 Medium 的最大优势:长格式内容以咬入式内容流的形式呈现，你可以将其扩展到更大的图片。你可以给创建内容的用户小费，当其他人给你小费时，你也会得到奖励。给小费被称为“播种”。当你对内容播种时，一部分钱会给内容原始创建者，一部分钱会给在你之前播种内容的每个人。它为发布高质量的内容以及你认为会在平台上流行的种子内容创造了经济激励。

![](https://cdn-images-1.medium.com/max/800/1*OuairG9NVQBNbsuhZ5gXaQ.png)

Cent 截图

Cent 用提供奖励来获得工作的方式 - 任何类型的工作 - 由 Cent 生态系统的用户完成。您可以提出问题并提供回答的悬赏。您可以要求提供 logo 设计帮助，或者请求帮助编辑您的最新帖子。任何对您来说物有所值的东西。您可以控制您悬赏的金额以及将获得这笔钱的人数，因此就算您的提议病毒式传播，您也不会意外地超出预算。Cent背后的想法是创造一种经济形式，允许其用户日常工作之外只使用他们的才能和 Cent 平台在线挣钱。我不确定人们每小时在 Cent 上赚多少钱，但我确信它看起来非常有前途。

它也是我迄今为止看到的最用户友好的 dApp 之一，到目前为止，我没有看到任何迹象表明它被以太坊扩展问题所困扰。要使用 Cent,你需要一个 Web3 浏览器比如  [**Trust**](https://trustwallet.com/) 或者 [**Coinbase Wallet**](https://wallet.coinbase.com/)。

我仍然渴望看到一个带有用户控制钱包的 dApp 达到 1000 多万用户量。它会在 2019 年发生吗？

### 以太坊挑战者

以太坊挑战者将于 2019 年进入研发和社区建设阶段。以太坊有一个很好的开端，但是 2019 年可能是竞争压力真正开始压迫以太坊的一年。以太坊的挑战者们主要有两种势力：**ICO 平台**和 **dAPP 平台**。

许多潜在的挑战者将同时充当这两个角色，但还是尽可能的去独立看待这两个角色会比较好。

**ICO 平台** — 几乎是从有了 ICO 平台这个概念产生开始，以太坊就一直是 ICO 发行最合适的选择。智能合约应用程序还没有真正开始吸引客户，但是 ICO 在 2017 年和 2018 年就已经取得了极大的成功。

2019 年，以太坊不再是推出 ICO 唯一的选择，也可能不再是最好的选择。竞争者正在加快步伐。在 2018 年，数百个加密资产在竞争者平台推出。尤其是[**Waves**](https://wavesplatform.com/) 认识到推出加密资产是以太坊的杀手级应用程序，并着手让它变得简单。他们这样做了。您可以在 Waves 上发布新代币，而不需要任何编码。

![](https://cdn-images-1.medium.com/max/800/1*_P3kFffm36qxoUWWRggCSQ.png)

截屏：Waves 代币生成工具

它们还具有传递特质，可让您轻松地将代币分发给许多人 - 例如，从您的 ICO 进行 airdrop 传递或分发代币。进行 ICO 的难点在于交易所上市。[**Waves wallet**](https://wavesplatform.com/product) 包括一个集成的分散交换（DEX），以便用户可以立即开始交易新代币。Waves DEX 功能优于集中式交换，在任何用户体验竞争中可以轻松击败基于以太坊的 DEX。与集中式交换不同，DEX 资金由用户控制的密钥管理，因此他们不必信任被监管的集中交换，或担心如果交易被黑客攻击会发生什么。Android Waves 钱包已被下载超过 100,000 次。

以太坊仍然是最受欢迎的代币发布平台，但 Waves 已成功吸引了[数百个项目](https://icobench.com/icos?filterPlatform=Waves)。[**Stellar**](https://www.stellar.org/) 是另一个可选的流行 ICO 平台，它也 [紧随其后](https://icobench.com/icos?filterPlatform=Stellar)。一些项目已经在其他替代平台上推出，包括 [NEO](https://icobench.com/icos?filterPlatform=NEO)、[EOS](https://icobench.com/icos?filterPlatform=EOS)等，但看起来 Waves 和 Stellar 可能会在 2019 年从新的代币发布平台中脱颖而出。

他们很有可能会吸引到更多原本将在 2019 年在以太坊上推出的项目。

### dApps（去中心化应用程序）

加密行业的愿景是建立有价值的互联网，你可能会说[去中心化应用程序](https://www.stateofthedapps.com/rankings)起着关键作用 但究竟什么是 dApp？为什么它们很重要，哪些 dApp 平台将在 2019 年重塑秩序？

**什么是 dApp**？dApp 是去中心化应用的缩写，它本质上是中心化应用程序的对立面。中心化应用程序掌握着用户的数据。举了例子，您的银行应用程序可以帮助您管理银行帐户余额，但从技术上讲，您无法控制这笔钱 — 银行在控制。

如果他们想[未经你的允许借钱给别人](https://en.wikipedia.org/wiki/Fractional-reserve_banking)，他们可以也会做！如果他们想要[冻结您的帐户](https://www.sacbee.com/news/business/article217567300.html)，他们可以。如果他们想[延迟你的提现](https://www.sacbee.com/news/business/article217567300.html)，他们可以。

Facebook 也是一个非常好的例子。如果 Facebook 想[分享你的好友列表](https://www.fool.com/investing/2018/12/22/this-spotlight-is-plaguing-facebook-and-it-wont-se.aspx)给第三方开发者，他们未经你的允许就能做到。如果他们想[分享你的私人消息](https://www.newsweek.com/facebook-stock-price-fb-messenger-sharing-private-messages-netflix-spotify-1265319)，他们也可以。如果他们想[关闭某个功能或杀掉你的应用](https://medium.com/javascript-scene/a-new-hope-e2021fce7c7b)，他们还是可以做到。

另一方面，去中心化应用程序不会将所有用户数据存储在集中式数据库中。取而代之的是他们依赖去中心化技术，如区块链和其他 DLT（分布式账本技术），[去中心化数据库](https://github.com/orbitdb/orbit-db) 和 [去中心化文件存储系统](https://ipfs.io/)。dApps 可以让您控制自己的身份，货币和数据。（他们还没有全部做到这些，但我怀疑那些做到的将颠覆 Web 3.0。）

dApp 经常需要通过网络进行交易。为此，他们通常依赖区块链，例如比特币，以太坊，Waves 等。他们通常需要与钱包接口才能授权交易。

我当前最喜欢的 dApps 内置了钱包，并且要么是监管（意味着他们管理诸如私人密钥之类的硬件，例如 [Sliver.tv](https://www.sliver.tv/)），要么直接与钱包集成（例如 [Brave](https://brave.com/)）。

#### dApp 用户体验

dApp 用户体验正在变得越来越好。现在有两个流行的浏览器集成了 dApp 支持功能，因此不需要考虑浏览器扩展：[**Trust**](https://play.google.com/store/apps/details?id=com.wallet.crypto.trustapp)（最近被 [Binance](https://www.binance.com/) 收购）和 [**Coinbase Wallet**](https://www.coinbase.com)（直到 [Coinbase](https://www.coinbase.com) 在收购Trust后不久收购了它的 Toshi）。两者都比  [Metamask](https://metamask.io/) 等替代品具有更好的用户体验，并提供与 [**Web3 API**](https://github.com/ethereum/wiki/wiki/JavaScript-API) 的集成，这有助于 dApp 与以太坊区块链集成。

我最喜欢的 dApp 使用区块链来达成一致，但它们也连接到快速数据库并且加载非常迅速。我最喜欢的 dApp 也不需要用户批准可能在区块链上发生的每一笔事务。良好的 dApp 用户体验的关键是选择你所遇到的区块链。例如，可以拥有一个由数据库支持的虚拟帐户，该数据库只需要定期同步到区块链，用于结算或安全，或两者兼而有之。

在 2018 年初，[**Lightning Network**](https://lightning.network/) 作为比特币区块链的第二层协议发布。2019 年 12 月，[**Raiden Network**](https://raiden.network/) 在以太坊区块链上发布了 alpha 版本。两个网络都使用由 [Hashed Timelock Contracts](https://en.bitcoin.it/wiki/Hashed_Timelock_Contracts) (HTLCs) 连接的支付渠道提供点对点的离线支付。这对最终用户意味着现在几乎可以立即用您的 dApp 进行交易，而不是等待可能需要长达 10 分钟的区块链确认。

#### 智能合约平台

[Solidity](https://en.wikipedia.org/wiki/Solidity) 自从其可用以来已经统治了智能合约编程语言生态系统。它在以太坊虚拟机（EVM）上的智能合约编程中无处不在。但Solidity有一些严重的问题，包括[算术溢出和下溢](https://blog.sigmaprime.io/solidity-security.html)，[类型错误](https://blog.sigmaprime.io/solidity-security.html#short-vuln)，以及[冻结 3 亿美元](https://medium.com/chain-cloud-company-blog/parity-multisig-hack-again-b46771eaa838)的 [delegatecall 漏洞](https://blog.sigmaprime.io/solidity-security.html#dc-example)。所有这些漏洞都是编程语言级别存在的问题的例子。换句话说，更好的编程语言可以创建更加安全的智能合约。

挑战者来了。

*   [**Waves RIDE**](https://docs.wavesplatform.com/en/technical-details/ride-language.html)：一种图灵不完整（无循环或递归）的类 Haskell 式函数式程序语言，用于 Waves 区块链。它具有静态类型、延迟评估、模式匹配和用于确定是否允许事务完成的谓词表达式。图灵完整版本也在开发中。Waves 的智能合约支持目前正在主网上运行。我们应该能在 2019 年看到第一批 Waves dApp 出现。
*  [**Plutus**](https://cardanodocs.com/technical/plutus/introduction/) ([**Cardano**](https://www.cardano.org/en/home/)) 是另一种受 Haskell 启发的函数式编程语言，它是为了 Cardano 区块链而生。Cardano 计划在 2019 年推出两个重要版本：Shelley，它提供完全的去中心化和赌注，以及 Cardano-CL，它是支持可编程智能合约的虚拟机。
*  [**Scilla**](https://scilla-lang.org/) ([**Zilliqa**](https://zilliqa.com/)) 是一种经过正式验证的智能合约语言，其设计考虑了计算和效果的分离。这意味着状态转换的计算和通信是严格隔离的，这使得 Scilla 智能合约更容易测试和静态验证以最大限度地减少出错的可能性。Zilliqa 的主网计划于 2019 年 1 月底推出。
*  [**ewasm**](https://github.com/ewasm/design) (Ethereum) 并不是一个智能合约语言，而是一个编译器目标，它将允许以太坊程序员用其他语言编程（如Rust，C ++，也许某一天是智能合约特定语言，如 [Simplicity](http://chrome-extension://oemmndcbldboiebfnladdacbdfmadadm/https://blockstream.com/simplicity.pdf)），并编译成以太坊风格的 WebAssembly。ewasm 是 WebAssembly 的一个更安全的子集，它是 Web 平台相对较新的低级编译目标。方便的是，wasm（以及 ewasm）模块可以在任何 JavaScript 项目中使用。对于大多数区块链代码，通常超过 75％ 的代码根本不在智能合约中 — 它在 JavaScript 中必须与智能合约进行通信。ewasm 和 JavaScript 共享绑定和模块支持的共同基础。

*   **JavaScript** ([**Lisk**](https://lisk.io/)) Lisk 是一个区块链开发平台，允许开发人员使用 JavaScript 编写代码并为特定应用程序创建自定义区块链，从而避免以太网的大规模扩展问题。Lisk 允许开发人员创建自己的支链来管理所有特定应用程序的区块链操作，因此它不必与其他任何应用程序竞争主链的计算资源。目前，Lisk 没有开发智能合约编程语言或 虚拟机，区块链交易功能与比特币相似。

*  [**Rust**](https://www.rust-lang.org/) (via ewasm, Cardano client) 是一种低级语言（就像 C 语言），具有 Haskell 等语言的一些安全功能。Rust 具有保证常量引用以避免意外突变，静态防止空指针异常（必须显式声明选项），只提供对当前状态有意义的操作的状态类型，分析模式匹配以保证函数完整性（无法匹配的模式将导致编译时错误）等。基本上，它就像 C++ 和 Haskell 生的一个婴儿，没有继承任何不好的东西。Rust 可以编译为 ewasm，或者用于构建像 Cardano 这样的区块链的客户端代码。用于 Lisk 的模块可以在 Rust 中构建并编译为 wasm 以在 Lisk 项目中导入。

### 你可能不需要智能合约

在 2019 年，你可能不需要智能合约编程语言来开发一个 dApp 产品。

大部分去中心化应用开发者创建从区块链中提取数据并将其拉入可以有效查询的数据库中的节点。这个过程并不是很好玩，并且给加密应用程序增加了很多维护负担。使用 [**GraphQL**](https://graphql.org/) 可以轻松地查询区块链数据。去中心化节点汇集区块链数据，由 [**IPFS**](https://ipfs.io/) 提供支持。

您可以将计算工作发送到 [**iExec**](https://iex.ec/)，甚至可以使用 [**Render Token**](https://www.rendertoken.com/) 处理强烈的图形渲染。随着所有这些加密代币飞来飞去，我们可能需要做一些[交叉链原子交换](https://arxiv.org/abs/1801.09515)来跨多个区块链交易代币。

您可以使用[**可验证的声明**](https://w3c.github.io/vc-use-cases/)，分批并锚定到您选择的区块链（建议：比特币）来记录任何类型的数据，包括房地产，汽车和 NFT 等资产的所有权和转移。您可以在 [**IPFS**](https://ipfs.io/) 或 [**Storj**](https://storj.io/) 上存储这些声明，支持文件和各种数据库记录（请参阅 OrbitDB）。

### 清单

好吧，这有点多。让我们回顾一下你应该在 2019 年密切关注的技术：

#### 加密数字货币

*   [**BAT**](https://basicattentiontoken.org/)
*   [**Theta**](https://www.thetatoken.org/)
*   [**Waves**](https://wavesplatform.com/)
*   [**Stellar Lumens**](https://www.stellar.org/)
*   [**Zilliqa**](https://zilliqa.com/)

#### 加密应用程序

*   [**Brave Browser**](https://brave.com/)
*   [**Sliver.tv**](https://www.sliver.tv/)
*   [**Cent**](https://beta.cent.co/)

#### 钱包 & dApp 浏览器

*   [**Trust**](https://play.google.com/store/apps/details?id=com.wallet.crypto.trustapp)
*   [**Coinbase Wallet**](https://play.google.com/store/apps/details?id=org.toshi)
*   [**Waves Wallet**](https://wavesplatform.com/product)

#### dApp 平台

*   [**Ethereum**](https://www.ethereum.org/)
*   [**Waves**](https://wavesplatform.com/)
*   [**Stellar**](https://www.stellar.org/)
*   [**Cardano**](https://www.cardano.org/en/home/)
*   [**Zilliqa**](https://zilliqa.com/)
*   [**Lisk**](https://lisk.io/)

#### 智能合约语言

*   [**Waves RIDE**](https://docs.wavesplatform.com/en/technical-details/ride-language.html)
*   [**Plutus**](https://cardanodocs.com/technical/plutus/introduction/) (Cardano)
*   [**Scilla**](https://scilla-lang.org/) (Zilliqa)
*   [**Ewasm**](https://github.com/ewasm/design) (Ethereum, others)
*   [**Rust**](https://www.rust-lang.org/) (via ewasm, Cardano client)

#### 去中心化计算服务 (AWS for dApps)

*   [**IPFS**](https://ipfs.io/)
*   [**iExec**](https://iex.ec/)
*   [**Storj**](https://storj.io/)
*   [**OrbitDB**](https://github.com/orbitdb/orbit-db)
*   [**The Graph**](https://thegraph.com/)
*   [**Render Token**](https://www.rendertoken.com/)

#### 相关技术

*   [**Web3 API**](https://github.com/ethereum/wiki/wiki/JavaScript-API)
*   [**Lightning Network**](https://lightning.network/)
*   [**GraphQL**](https://graphql.org/)
*   [**Cross Chain Atomic Swaps**](https://arxiv.org/abs/1801.09515)
*   [**Verifiable Claims**](https://w3c.github.io/vc-use-cases/)

* * *

> 我们正在打造数字化收藏品的名声：[加密](https://docs.google.com/forms/d/e/1FAIpQLScrRX9bHdIYbQFI5L3hEgwQaDEdjo8t8glqlyObZexWjssxNQ/viewform)。

* * *

**Eric Elliott** 是一位分布式系统专家，也是 [Composing Software](https://leanpub.com/composingsoftware) 和  [Programming JavaScript Applications”](https://ericelliottjs.com/product/programming-javascript-applications-ebook/) 这两本书的作者。作为 [_DevAnywhere.io_](https://devanywhere.io/) 的联合创始人，他教开发人员远程工作所需的技能，并让他们拥抱工作与生活的平衡。他建立开发团队并提供建议给加密项目，并为 **_Adobe Systems,_**  **_Zumba Fitness,_** **_The Wall Street Journal,_**  **_ESPN,_**  **_BBC,_**  和包括 **_Usher, Frank Ocean, Metallica,_** 在内的顶尖艺术家贡献软件相关的经验。

**他和世界上最漂亮的女人一起享受着孤傲的生活。**

感谢 [JS_Cheerleader](https://medium.com/@JS_Cheerleader?source=post_page)。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
