> * 原文地址：[A New Hope: The Future of Application Platforms](https://medium.com/javascript-scene/a-new-hope-e2021fce7c7b)
> * 原文作者：[Eric Elliott](https://medium.com/@_ericelliott?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/a-new-hope-the-future-of-application-platforms.md](https://github.com/xitu/gold-miner/blob/master/TODO1/a-new-hope-the-future-of-application-platforms.md)
> * 译者：[skychenbo](https://github.com/skychenbo)
> * 校对者：[Eternaldeath](https://github.com/Eternaldeath), [HydeSong](https://github.com/HydeSong)

# 新愿景：未来的程序应用平台

![](https://user-gold-cdn.xitu.io/2019/1/16/1685717c82f2a645?w=2000&h=1125&f=jpeg&s=413061)

Image: Mr Hasgaha (CC BY-NC 2.0)

目前我们生活在集中控制的牢笼中。监狱中以牺牲其他人为代价让少部分人拥有特权。但是科技有潜力改变这些。

如果你是一个生活在当今世界下软件工程师，那么你就有潜力参与到这个以前从未发生的最大的全球变革中。这个变革将会影响到上亿的人的生活，会创造新的经济机遇，拯救生命，让数十亿人参与数字经济。

#### 集中化平台

在 2011 年，我是 facebook 上最受欢迎的音乐 app 创始团队的一员，这款 app 月活超过 3 千万。我们飞速的发展，将其他优秀的音乐服务整合到一起，例如 Spotify、Bands in Town、Google Search 和 Billboard Magazine。50 万个乐队使用这个平台来管理他们的个人资料，演出日期，音乐流媒体和商品。

然后有一天，Facebook 关闭了艺术家档案默认着陆页面的设置。一夜之间，网络瘫痪。在那天大量的公司被这单一的技术选择搞砸了。脸书更改了一个功能造成了大量的工程师丢失了他们的工作。数百个有用的有趣的 app 将不复存在，一个充满创造力的令人兴奋的生态系统被扼杀了。

但是 FaceBook 不是唯一一家具有这么大破坏力的公司。Google Searc 因为依赖搜索流量的公司创造大业务而臭名昭著，通过通过搜索算法来更新淘汰这些公司。

这个问题不是指 Facebook、Google 和 Apple 是魔鬼。问题在于这么多的权利一开始就集中控制在少数大公司手中。未来的你的 app 运行状况可能超出了你的控制，决定你命运的可能掌握在别人手中。

如果可以在由社区控制和管理的架构上构建应用程序，而不受限于自私的大公司的想法。试想一下，一个全球的计算机网络，所有计算机连接在一起，开发人员合作构建一个更具包容性、更分散的应用程序平台。

出于能让任何人在任何地放发布自由链接在一起的文档的想法，web 诞生了。它建立在没有集中控制的网络基础上。在 20 世纪 90 年代，出现了几个互相竞争的私有服务。为了与万维网直接竞争，类似 AOL 和 CompuServe 的公司推出了自己的内容网络：但是万维网赢了。

同时微软和苹果也在手机设备平台上竞争。如果我们把时间停留在 2010 年，你可能觉得苹果赢得了市场。但今天，开源的 Linux 操作系统主导了市场 [Android 设备占据了全球移动智能手机市场的 86%](https://www.statista.com/statistics/236027/global-smartphone-os-market-share-of-android/)。

在 20 世纪 90 年代，主导市场的是收取证书费用（或版税）的商业软件。今天，如果有人创建了一个闭源GUI工具包并试图收取许可费用，很少有人会愿意放弃开源的 React 生态系统。

但是为了应用程序能存活，我们开发的应用程序仍依赖于像 Facebook、Google 或 Twitter 的集中式公司。一场即将改变一切的“海啸”就要到来。

20 世纪 90 年代末，人们开始在互联网上共享 MP3 文件，最初是通过位于中央服务器上的文件传输协议（FTP）来实现的。但很快，中央服务器就受到了唱片公司的攻击。社区与第一个流行的去中心化音乐共享服务 Napster 抗争，但唱片公司辩称，尽管 Napster 没有直接托管音乐，但它使人们违法。

Napster 是一家由中心化的公司拥有和运营的公司，在 2000 年，[Metallica 起诉 Napster，致使其停摆。](https://en.wikipedia.org/wiki/Metallica_v._Napster,_Inc.)。

但是如果你认为 p2p 的故事到此结束，那你就大错特错了。从 Napster 的失败中崛起了 [gnutella](https://en.wikipedia.org/wiki/Gnutella)、[bittorrent](https://en.wikipedia.org/wiki/BitTorrent) 和 [ipfs](https://en.wikipedia.org/wiki/InterPlanetary_File_System)。所有附加源码的开源协议施行。所有未控制的去中心化的公司都提起诉讼，目前为止，没有人能使其停摆。

#### 集中资金

2008 年，房地产市场崩溃。太多无担保的抵押贷款债务集中在少数非常大的银行。当贷款违约率开始赶上他们时，多米诺骨牌开始倒塌，导致多家银行倒闭和救助，[仅在美国就有超过 7.7 万亿美元的救助](https://en.wikipedia.org/wiki/Emergency_Economic_Stabilization_Act_of_2008)。类似的崩溃和救援在整个欧洲发生，威胁到整个全球经济，并使世界陷入自大萧条以来最严重的衰退。

2009 年 1 月 9 日，[ Genesis 区块](https://en.bitcoin.it/wiki/Genesis_block)在比特币区块链上开采。嵌入在块中的消息如下：

> “《泰晤士报》2009 年 1 月 3 日财政大臣即将对银行实施第二轮救助。”

全球对银行业机构的信任度达到了危机引发的低点，公众因两年的金融危机、失业和房屋止赎而崩溃，聚集在一起，形成了 2011 年遍布全球的占领[华尔街示威活动](https://en.wikipedia.org/wiki/Occupy_Wall_Street)。导致危机的银行家们在中产阶级蒸发的时候却安稳着陆，公众因此被激怒了。

从那以后，银行再次开始玩相同的把戏，Facebook、Google 和 Apple 拥有更多的权力，全世界对自由的攻击不断升级。

#### 我们唯一的期望

分散式架构已经爆炸增长。比特币是点燃投资者想象力的火花，随着资金大力向加密货币注入，开发社区开始形成、发展、增长并进一步扩大。 

自 2011 年以来，比特币网络散列功率增长了 8 个数量级，价格也随之增长。

![](https://user-gold-cdn.xitu.io/2019/1/16/16857171e13c9a26?w=700&h=450&f=png&s=17744)

比特币哈希幂图（Hans Hodl）：2011-2018

比特币交易之所以起作用，是因为比特币区块链：第一次大规模展示数字稀缺性和分散共识。到 2013 年，大量的开发人员都在想，数字稀缺性和分散式账本技术（DLT）还能做些什么。

事实证明，答案是“很多”。一个名叫维塔利克·布特林的开发者因为他花了 3 年时间玩的魔兽世界游戏改变了游戏规则而感到沮丧。Buterin 参与了比特币，并想探索区块链还能做什么。在他的头脑中开始形成一个去中心化的世界计算机的想法。

2015 年，Vitalik Buterin、Gavin Wood 和 Joseph Lubin 推出了以太坊，一个大型开发社区聚集在以太坊周围。到 2017 年，ICO Big Bang 推出了数千种可供选择的加密资产，大部分位于以太坊之上，提供了传统风险投资的替代方案，并在此过程中创造了几个新的亿万富翁。

![](https://user-gold-cdn.xitu.io/2019/1/16/16857171e6420e1a?w=672&h=433&f=png&s=117517)

到 2017 年底，投资热潮达到顶峰，2018 年大部分时间，价格都已回落至现实水平。2018 年的价格下跌是一个历史性的现象，每次比特币价格达到另一个数量级的增长时都会出现这种现象。相信我，相对以前以后会有更大的增长。

与此同时，第一代可扩展的 dApps 也开始出现，包括 [Sliver.tv](https://www.sliver.tv/) 和[合作伙伴腾讯游戏](https://www.ccn.com/tencent-games-forms-partnership-with-blockchain-esports-platform/)，该公司通过加密货币奖励电视观众和流媒体，可以在Sliver平台上花费并用于游戏内购买。

同时，[Waves Platform](https://wavesplatform.com/)使任何人都可以轻松创建加密货币。它基于 Leased Proof of Stake（LPoS）共识运行自己的区块链 — 比比特币和以太坊使用的工作证明（PoW）模型更快的基层扩展解决方案。钱包软件具有内置的 Decentralized EXchange（DEX），用户可以在其中交易令牌。Waves 钱包在 Android 商店中下载量超过 100,000。

如果你对加入革命感到好奇，大多数加密应用程序都是在前端使用 JavaScript 构建的。块链节点实现（与块链本身通信的软件）是建立在广泛的技术之上的，包括 C++（Bitcoin Core）、GO（EthUM）和 JavaScript（[Lisk](https://lisk.io/)）。

区块链应用程序通常依赖于智能合约，这不仅为分类账中记录的数据提供了共识，而且还为处理该数据的算法提供了共识。 

大多数以太坊开发目前都是在 **Solidity** 中完成的，它是迄今为止最常用的智能合约编程语言。

比特币有**比特币脚本**。Waves 有一种故意不完整的图灵函数式编程语言，叫做 **Ride**，而 [Casdano ](https://www.cardano.org/en/home/) 有 [**Plutus**](https://cardanodocs.com/technical/plutus/introduction/)，这是一种由 [Philip Wadler](https://en.wikipedia.org/wiki/Philip_Wadler) 设计的，他把 Monads 带到了 Haskell，并在所有现代编程语言中激发了一代新的函数式编程语言。 

但是，尽管有所有这些区块链编程语言，世界上大部分的加密和区块链编程都是用 JavaScript 进行的。JavaScript 是推动加密革命的用户界面的默认标准。

> “世界上大量的加密和区块链编程都是用 JavaScript 进行的。”

#### 新博客

在我写第一篇关于 javascript 的文章之前，我已经在 javascript 专业编程 10 多年了。

在我写第一篇关于加密的博客文章之前，我一直在使用，构建和遵循分散式架构超过 10 年。

我一直在观察、学习、建设、领导团队，并等待合适的时机。技术通常不会在人们第一次听到时就爆炸。它开始时构建得很慢，然后到达了一个拐点，并开始真正地扩展到主流采用。

加密即将爆炸性增长。2019 年将是第一个数百万用户的 dApp 进入市场的一年，而非区块链的极客们开始首次以加密货币进行交易。

有一段时间，我可能会在 JavaScript 场景中发表关于分散式架构的博客，如果 JavaScript 开发者们对他有浓烈的兴趣。但是，我的大部分加密写作都会在一个名为 The Challenge 的新博客。

关于 The Challenge 的第一篇博客文章是由有影响力的密码资产分析师 [Hans HODL](https://goo.gl/forms/cC5hJmo4h21NlqPE3) 撰写。我很荣幸地把你介绍给他。

如果你想了解更多关于为什么加密是如此重要的事情，请深吸一口气，吃点零食，然后继续阅读战歌 ["The Challenge"](https://medium.com/the-challenge/the-challenge-7d502f0dfc3c)。

* * *

**_Eric Elliott_ 是 [“编写 JavaScript 应用”](http://pjabook.com)（O’Reilly）以及[“跟着 Eric Elliott 学 Javascript”](http://ericelliottjs.com/product/lifetime-access-pass/) 两书的作者。他为许多公司和组织作过贡献，例如 *Adobe Systems*、*Zumba Fitness*、*The Wall Street Journal*、*ESPN* 和 *BBC* 等，也是很多机构的顶级艺术家，包括但不限于 *Usher*、*Frank Ocean* 以及 *Metallica*。**

大多数时间，他都在 San Francisco Bay Area，同这世上最美丽的女子在一起。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
