> * 原文地址：[A new era of launching mobile games: How mobile game developers are evolving their go-to-market strategies.](https://medium.com/googleplaydev/a-new-era-of-launching-mobile-games-ef2453686f73)
> * 原文作者：[Emily Putze](https://medium.com/@putze?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/a-new-era-of-launching-mobile-games.md](https://github.com/xitu/gold-miner/blob/master/TODO1/a-new-era-of-launching-mobile-games.md)
> * 译者：[IllllllIIl](https://github.com/IllllllIIl)
> * 校对者：[sisibeloved](https://github.com/sisibeloved)，[whuzxq](https://github.com/whuzxq)

# 移动游戏发行的新时代

## 移动游戏开发者是如何改进他们打入市场的策略

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b416e18bd6?w=800&h=428&f=png&s=41593)

发行一个新的成功的移动游戏风险日益增大并且很烧钱。然而，除去近几年游戏产业的重大变化，大多数开发者，还是用和三四年前一样的发行流程，继续测试和发布新游戏。

在 Google Play，我和移动开发者一起工作过，经历过几百次游戏发行。我亲眼见过开发者为了在新发行上“降低风险”（如果他们没这么做的话，那很应该要去做），是怎么逐渐转变他们的开发过程和游戏上市策略。我希望通过分享其中一些见解，可以帮助你找到适应自己的发行策略，并改进上市的 playbook，下一次能更成功地发布。

### **传统发布的playbook**

首先，当我说到大多开发者像他们之前几年那样继续测试和发布新游戏，我是指什么呢？现在很多开发者遵循我所说的“传统发布的 playbook”。

一个更传统化的发布 playbook 通常包括在早期开发阶段的大量内部测试，接着便是各样的外部测试直到完全发布出来（例如，技术性的，用户留存度和能否变现的测试）。更常见的是，外部测试包含了在特定地区和不同阶段发布一个新游戏的产品版本（相对与测试版来说）。例如，许多遵循更传统化 playbook 的开发者在菲律宾进行技术性测试，在北欧地区进行用户存留度测试，在澳大利亚或加拿大进行变现能力测试。即使不同国家之间得出的结果可能有差异，新游戏通常还是会在不超过五到七个国家之中测试，并且出于稳定性和评价的考虑，测试一般只会在较高端的机型上部署。一般而言，留存和盈利模式测试会持续 2-3 个月的时间。在这段时间里，开发团队会不断调整游戏以达到公司期望的 KPI，也让团队对游戏全球性发布时可能的表现有一些预见。

这听起来熟悉吗？如果是的话，这不一定就是坏事，正如现在这个过程对很多开发者还是适用的。然而在 Google Play，游戏领域发展也尤为迅速的时候，我们认为使用**对过程进行持续评估**这种方法，并且在**必要的地方重复**，是至关重要的。

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b4083d0566?w=796&h=125&f=png&s=16999)

### **一个新时代**

几年前，移动游戏产业开始萌芽，并因为重视盈利性而开始腾飞。2010 到 2014 间，游戏产业的低门槛以及其市场的潜在安装规模促使了数千开发者进入移动游戏领域。在这段黄金爆发时期，游戏开发周期短，开发成本低，营销预算合理，能快速开发并上市发行。开发者可以先推出游戏，看看是否赚钱，再决定未来是否值得进一步投资下去。  

而到了今天，市场已经变得很不一样了，发行一个顶尖的新游戏也是如此。让我们快速回顾下近几年市场都发生了什么变化：

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b4dbad8d23?w=644&h=149&f=png&s=21123)

1.  **更多竞争。** 在当今愈发成熟和拥挤的游戏生态系统中发布一个爆款游戏可以说是很难的。在 Google play 上面就有超过 100 万款游戏，消费者比以往有更多的选择。与此同时，想让玩家换游戏变得更难了。由于玩家很深地沉迷在一款游戏上，就很难放下积累的游戏进度，游戏人物，装饰，联盟，资源等等 —— 即使不谈投入的时间和金钱，他们也不太可能转去玩别的游戏，放弃他们在已有游戏上的投入付出。所以，新游戏能进入到老玩家的眼是越来越难了，排行榜上最赚钱的游戏的营业额也在下降（至少在西方国家市场是这样的，包括美国）。 

2.  **更高的开发成本。** 合理进行测试所需的资源和发布一个新游戏在当今市场很重要。不单是开发周期变长了，而且用户的期望和移动产品的需求也从未如此之高，当用户的需求未能满足时，他们会很善变（换句话讲就是最简可行产品发布得更少了）。把这个因素算到长开发周期，还有就是对先进技术需求的日益增长 —— 保持游戏体积小，玩家匹配能迅速，又要有各种主流的特性如实时的 PvP（玩家对战玩家 Player versus player，即玩家互相利用游戏资源攻击而形成的互动竞技）和实时的聊天翻译机制 —— 结果就是研发一个新游戏的成本大大提高。 

3.  **更多的营销花费。** 如今顶级移动游戏发布的营销预算越来越接近主机游戏的预算了。在一个高度饱和的市场里面，不只是逐步演进的探索变得更加困难，而且用户获取成本依旧极其昂贵，还有就是高质量工具的花费，技术，还有在游戏开发周期中更早需要用到的各类分析，种种成本都叠加在了开发者身上。

这些变化带来的一个结果就是过去的几年很少有新的移动游戏发行，以及业内开发者对不确定性风险的愈发厌恶（这是在瞻前顾后和孤注一掷中的选择）。

### **业务过程只是作为“达到目的的手段”**

移动游戏市场中发生这么多变化，很多开发者继续像以前的方式一样测试和发布新游戏，有点意思，但不是出人意料的。

当业务中的其它部分变动的时候，业务过程是一个不用怎么变化的部分。即使如此，在一个快速变化的市场里面，过度依赖业务过程可以说是危险的，因为它给了你一个错误的安全感（例如，你甚至可能没有察觉到你落后于进度或者你开发中已经有一些盲区）。总体上，我看过只把业务过程看作是“达到目的的手段”的团队 —— 他们更关注于**什么**是他们正在尝试实现的而不是具体**怎么**实现它 —— 这些团队通常更具适应能力，最终也取得了成功。 

### **改进你的 playbook**

当很多开发者继续更多依赖“传统的 playbook”，越来越多人在两个方面上思考如何转变，即新游戏的发布和测试及发行方式上的革新。我最近组建了一个小组，旨在“降低新游戏发行的风险”，该平台是在我们一个 Google 活动中，这个活动中有其他来自 Electronic Arts、Wooga、Miniclip、Playrix、King 和 Big Fish Games 的开发者一起参与，我们切身参与到业务过程改进这个话题中来，并且分享了一些最实际可行的东西。 

下面是顶尖开发者为了降低新游戏在当今市场发布的风险，改进他们的测试和发布过程的五个方式。

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b505e58b79?w=800&h=400&f=png&s=53002)

#### 1. 持续性评估新游戏（并且不要怕终止业务）

为降低发布新游戏的固有风险，许多开发者和厂商把理念塑造为，开发“少而精”的游戏。要实现这点，他们改进了关于批准新游戏的内部流程，并且**对开发过程的多个阶段实现了更细致的评估**。例如，几年前常见的做法是在游戏团队在被允许把游戏推向市场之前，内部要有一个批准通过（批准那个时刻之后才会发行）。然而现在，许多开发者采用的是“有罪推定原则”的方式去批准新游戏，这就需要很多关键的评估，并且也会带来更多的失败和反馈（发布不再是在哪个时刻之后才被允许）。我见过有团队在游戏进入市场之前，要讨论审核直到有五个内部批准，才会通过。我也见过有的开发者放弃掉一些已经开发了一年的游戏 —— 或者在最后用户留存度和变现测试的阶段 —— 因为新游戏当时的指标表现没有达到期望。

这种过程的改进看起来似乎挺直接的，但成功实行起来是有难度的。它需要形成一种内部文化和气氛 —— 从上头的决策者到下属游戏团队 —— 失败是没有关系的（越快失败越好），在开发的任意阶段，没有达到预期所制定标准的游戏，终止它。虽然实践中很难做到，违背市场主流做法，许多开发者相信这起码好过在未来几年，一个平庸的游戏，只会烧了游戏发布（还有运营）的钱。

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b5de6bd5aa?w=800&h=400&f=png&s=42849)

#### 2. 在开发中借助公开或非公开的测试版，更早获得外界的反馈

鉴于发布新游戏会带来的风险逐步增加，尽早发现错误的想法对开发者来说也变得很重要（换句话说，如果要失败，那失败得早一点）。如此，许多顶尖开发者转变他们的 策略，在开发周期中，相比过去，提早了很长一段时间去测试新作品 —— 有时甚至在完整原型之前。不但是因为他们相信这样做对于发现错误的认知很重要（允许他们收集反馈意见，衡量 KPI 并且决定是否要长远投资或终止项目），而且很多人也认为早期市场的反馈对打造一个有长久生命力的游戏也至关重要。

为了能更早地从外部测试新游戏，许多开发者正改进他们在测试上面的技术手段 —— 从只测试游戏的产品版本到先对测试版进行测试，特别是从技术层面和用户留存度进行测试。这个变化的一个主要原因是测试版（公测或内测）的测试考虑到了更多分布式控制，而不是有地域性限制的产品软发布。例如，有了公开的测试版，你可以对这个测试版进行限制，让开发者去收集到早期市场对一个新游戏的反馈，在早期同时也能限制公众对它的接触了解。还有就是，不像一个产品的软发布，**对公测版的测试意味着没有公开评价 —— 用户反馈是非公开的 —— 这对解决游戏早期阶段出现的问题，或者做 A/B 测试从而了解哪些因素影响 KPI 有很大好处**。利用公测版进行外部测试的开发者数目大幅上升，同时也有需要处理大量 IP（知识产权）问题的开发者或大牌厂家，愈发依靠内测版进行早期外部测试（由于许可等问题）。如今，进行更多传统的，有区域限制的软发布测试之前，这些开发者会设立外部网站，吸引用户来申请使用内测版。

> 在了解使用公测版的好处之后 [Cooking Craze](https://play.google.com/store/apps/details?id=com.bigfishgames.cookingcrazegooglef2p)，Big Fish Games 现在要求所有新作品在发布前都要运行 Android 的公测版。这不仅让他们能直接收集到玩家的反馈，相比产品软发布，还能让他们更早，更大胆，更广泛地测试游戏。这意味着在艺术风格，游戏机制，奖励机制等方面上冒更大的风险，在更多地区和在更多的型号设备上测试新游戏。这样带来的好处是既能在各样的市场中体现强大的性能表现，又能暴露出更多未知的技术性问题（并更准确地估计已知问题的影响），并且减少发布时会出现的一星评论。对 Big Fish Games 来说，通过公测版测试意味着最小化风险和新游戏发布时的不确定性因素 —— 让他们对 QA 资源有更好地优先级处理，优化全球化 UA 渠道和发布前的预算，并且发布时更有自信（少了不确定的突发情况！）

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b60db0ed9c?w=800&h=409&f=png&s=342252)

[YouTube 视频：Big Fish Games 案例的学习](https://www.youtube.com/watch?v=qRXkEQOtQ98&t=51s).

不管你的预算多少或游戏大小如何，借助公测版测试新游戏是你在改进中一定要考虑的一个环节。况且，现在 Google Play 有新功能，可指定国家发布测试版，这允许开发者同时在不同的市场里发布测试版和产品版 APK（例如，你可以在大多数国家地区测试游戏的测试版，并且在精选的市场里进行产品的软发布，进而确认 KPI 的情况，借此也能收获到很全面的用户评价）。考虑一下这么做吧！

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b6770c07d7?w=800&h=400&f=png&s=45886)

#### 3. 专注于长期的指标，是成功的开端（并且测试更长时间）

近几年游戏开发中有一个转变，就是从只想着吸引用户下载和变现，到注重实现可持续成功商业的真实 KPI（特别是长期留存度和 LTV）。所以，许多开发者改变了流程，及时地构建应用，并且给比以往更长周期的测试做好预算。

当谈及测试周期时，很明显没有一劳永逸的模型 ——　取决于你测试的东西，你有多少需要优化等等　——　但开发者的测试周期至少要超过 30 天。虽然月留存率是长期留存率的关键指标，但为了更好理解真正的用户价值，你还要弄明白长期性的玩家关注度和留存度模型（LTV就是个周期长的东西）。所以即使你的游戏很完美，你也要测试至少两到三个月。平均来说，我共事过的大多数开发者选择花六个月时间测试新游戏，但对于更出名的游戏来说是十或十二个月（如果没有更多的话）。而那些具有大型 IP（知识产权）的游戏，开发者更要了解到，在经历月留存之后，用户的感受如何，因为 IP 能在短期内遮盖掉表现不好的指标（意思就是说人们早期很喜欢这个游戏，只是因为喜欢里面的人物，这些人物出自某些电影电视，但不是说你已经能够很好地留住用户了）。

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b714100bfe?w=800&h=400&f=png&s=24772)

#### 4. 转变观念，把游戏当作长期投资

五年前，很少有开发者认为一款移动游戏可以火五年。相反地，他们会发行一款游戏，然后就开始想下一个火的游戏要怎么弄了。现在，像 [Candy Crush](https://play.google.com/store/apps/details?id=com.king.candycrushsaga) 和 [8 Ball Pool](https://play.google.com/store/apps/details?id=com.miniclip.eightballpool) 游戏都证明了移动游戏可以有如平台游戏一样五或十年的寿命周期，甚至更久。所以，许多开发者逐渐地把游戏看作长期投资，并从原本只看重开发新游戏的模式，转变为注重把更多精力也投放到已流行的成功游戏上面。这不仅意味着机械化地维持这些游戏的运作，对它们重复投资的力度还要加大，来确保它们有输出新的内容，投资 Live Operation 服务，更新 UI，紧跟当前的潮流趋势。这不仅能吸收和留住他们现有的玩家，而且也能吸引到新的玩家进来。**对当前的许多开发者来说，大更新就是游戏的新“发布”**。

考虑到目前市场的竞争性 —— 还有获得用户的成本 —— 许多开发者现在专注于发展现有的已形成用户群的游戏就不足为奇了（比冒着发布新游戏好多了）。因为相似的原因，我们目睹着大牌的开发者和发布商放弃了知名游戏每年发布一个新系列的惯例，取而代之的是让一些常青游戏有一些重大的季度更新。[Electronic Arts](https://play.google.com/store/apps/dev?id=6605125519975771237)，以这个厂商为例，它已经在很多体育类游戏上面，如 Madden，NBA Live 和最近的 FIFA 都实行了这一模式。在 2016 年秋季发布的 [FIFA Mobile](https://play.google.com/store/apps/details?id=com.ea.gp.fifamobile) 之前（而现在已经进入到该游戏所说的第二“季”），FIFA 这系列之前每年都有发布移动端的游戏，看到这一现象，这对 EA 来说其实是一个很重大的改变。现在，对 EA 和其他许多开发者来说，是否在已有的作品系列发行一个新游戏，基本取决于是否需要在根本上提升这个游戏的技术/引擎（相对与只是想发布一些新游戏的欲望）。

如果你已经有一个很稳固用户群的游戏，那它**值得你去思考如何能再对它进行投入，使它更成功**，而不只是想如何打造你的下一个爆款游戏。

![](https://user-gold-cdn.xitu.io/2018/5/14/1635f4b71b6a59bb?w=800&h=400&f=png&s=38937)

#### 5. 发布前，为最佳留存率做优化

**发布游戏不再只是发布出来这么简单，它还事关如何从发布那一天起就留住用户**。所以，许多开发者改进了他们的开发 playbook，在游戏早期要发行时，要专注于如何最大化地留住用户。许多人认为当今要做一个第一名的游戏真的很有竞争性 —— 对付市场上同样热门的游戏 —— 意味着内容要多，足够让玩家消费，社交特性和各类游戏活动计划这些从一开始就要规划预备好（相对于最简可行产品发布只展示了 25% 的特色）。即使如此，在发布前对这些特性的预先投资对预算，人数统计和资源有很重要的作用。

当说到用户最佳留存度优化这方面时，这是我看到很多人在改进过程中会重视的地方：

1.  **发布前，专注质量和性能表现。** 有一个健壮的 app 和性能指标（例如崩溃率）是防止早期玩家流失的关键，并且能最大化减少发布时的差评（一星的评论里面一半都提及到了稳定性和bug的问题）。所以，在发布前，许多开发者会在更多机型设备上测试新游戏的性能。在 Google Play 上，这尤其重要，正如去年宣布的，Play Store 的推荐算法正在调整为看重质量和玩家的参与度，而这些又从游戏的 Android vitals，用户留存度，评价里体现出来。 

2.  **确保发布时，游戏内容足够丰富，吸引玩家，并且避免玩家流失。** 相比把游戏难度弄高从而拖慢玩家的进度，冒着玩家流失的风险，许多开发者会在测试版的时候，就主动测试他们的玩家能多快通过一个游戏关卡，并且通往下一个等级难度，确保每关的内容足够丰富，留住玩家。记住，你可以通过举办活动来重复利用游戏内容！ 

3.  **在游戏上线前，就加入社交功能。** 社交特性在任何游戏里对凝聚和留住玩家都是至关重要的，尤其是新游戏。当玩家用户更能被吸引连结在一起时，他们转去玩别的游戏的可能性就越低。联盟和团战这种玩法在应该发布的第一天就有了，同样也还应该有实时性服务和游戏活动。在发布前，要专注于运用 LiveOps。

4.  **在测试版期间，不要怕“浪费”好活动。** 开发者需要知道他们的 LiveOps 服务对 KPI 造成的变化，它们是怎么影响玩家行为，以及以及他们的团队如何处理麻烦的 LiveOps 波动。通常这说明他们在发布前对 LiveOps 进行仿真测试（还有团队的承受能力）。例如，Wooga 出的 [June’s Journey](https://play.google.com/store/apps/details?id=net.wooga.junes_journey_hidden_object_mystery_game) 是一个很需要有内容产出的游戏。在发布前的一个月 —— 此时距离解决了稳定性和 KPI 的软发布已经过去 7 个月 —— Wooga 对正式发布已经做了一个完整的“彩排”，把游戏当作已经上线的状态（每周更新，营销报告，社交媒体等等）。他们毫无保留地投入到这个“彩排”中，有一个很好的机会让团队实战并且理解整个 LiveOps 计划的需求，并且最终为新游戏的正式发布做到了更充分的准备。

如果你还没有重新审视你过去几年进入市场的 playbook，现在就去重新评估下吧，并且看看当下的新趋势和可利用的工具。我希望你能尝试下我分享给你们的一些例子，看看你能否找到一些领域，是可以改善业务过程或者避开盲区的。

* * *

### 你是怎么想的呢？

你对运行公开测试版以及降低发布风险的建议有什么想法吗？ 让我们在下方或推特上通过 **#AskPlayDev** 知道你的意见，我们会由 [@GooglePlayDev](http://twitter.com/googleplaydev) 账号回复，这个推特账号上面，我们平时会发布新闻还有一些在 Google Play 上如何成功推广的建议。 


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
