> * 原文地址：[A Complete Guide to Getting Hired as an iOS Developer in 2018](https://blog.usejournal.com/a-complete-guide-to-getting-hired-as-an-ios-developer-in-2018-d7dcf50dc25)
> * 原文作者：[Rob Caraway](https://blog.usejournal.com/@robcaraway?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/a-complete-guide-to-getting-hired-as-an-ios-developer-in-2018.md](https://github.com/xitu/gold-miner/blob/master/TODO1/a-complete-guide-to-getting-hired-as-an-ios-developer-in-2018.md)
> * 译者：[melon8](https://github.com/melon8)
> * 校对者：[Park-ma](https://github.com/Park-ma)

# 2018 年 iOS 开发找工作完全指南

## 或如何避免浪费你人生的两千个小时

![](https://cdn-images-1.medium.com/max/1600/1*CSEtc6xuG1-Va_JWQC7naQ.jpeg)

我被一份耗费了我三个半月精力的工作拒绝了。

我做了所有的准备。那个公司的一切就是我的一切。我几乎可以告诉你所有关于那家公司创始人在网上发表的东西。

我大概十分天真了。

想象一下，我写了一篇很长的博客，里面全是实际的代码和如何改进他们应用程序的例子。因为我就是这么做的。

尽管我投入了所有的精力，我还是得**大声**说，得到这份工作是不可能的。我不想相信，但说出来还让我感到了一点安慰。

几个月后，我终于吸引了他们的注意。我和他们的 CTO 通了电话，聊得很愉快，他们邀请我参加编程挑战。

我花了一周的时间来做到完美，他们的团队也表示对我的代码印象深刻。我自信心高涨，感到自己很安全。

然后，我参加了他们的结对编程测试。

> 两天后，我收到一封拒绝邮件。他们告诉我，我不是很合适。超过 2000 个小时来学习换来了一小时的教训。

我瘫倒在沙发上。他们是对的。我并没有真的符合他们的需求 —— 我只是花了几个月的时间说服自己我做到了。

回想起来，很容易看出我的行为是多么荒唐和危险。我猜原来的我太害怕被拒绝，想要尽自己所能来减少被拒绝的可能性。

> 也许我们大多数人需要处理这种负能量 —— 把简历群发给每个可能的公司，然后石沉大海没有回应。

在遭到可怕的拒绝后，我醒悟过来了(好像我别无选择)。于是我重新制定了一个实际可行的策略，并最终被一家我认为非常合适的公司应聘为 iOS 开发人员。

### 本篇指南旨在实现的目标：

我概述的这些策略**不需要先前的人际关系网络**，并且是那些希望获得**全职工作**的 iOS 开发者。虽然你不需要认识任何人，但知道如何沟通和推销自己还是有帮助的。

**你需要做大量的工作** —— 意思是以下任一条或全部：

*   你发布的可以下载的应用程序
*   你启动或参与的开源项目
*   你作为该领域的意见领袖创造的内容
*   或其他相关工作经验

**如果你没有任何可以推销的东西，那我也帮不了你。**

到本指南的结尾，你就会知道在 2018 年，在一家开发面向消费者的应用的公司获得一份 iOS 开发工作需要做出什么准备工作。

#### 关于我的背景：

我从 iOS4 开始就开始开发 app。我没有大学学位。我从未有过全职工作，也从未在“敏捷”开发环境或大的团队中工作过。

许多公司因为我没有大团队工作经验和没有大学文凭的简历拒绝了我。

但我也不是空手而去。我自己开发上架的应用被[下载了 100 万次](https://medium.com/@thecaraway/how-i-lean-startupd-my-way-to-240k-on-the-saturated-app-store-92862ba3c6fc)。我与人合作创办了一家（低成本的）初创公司，并以自由职业者的身份与一些很酷的客户合作。我有很好的公共项目来展示我的技能。

我在一个主要的科技市场(德克萨斯州奥斯丁)找到了工作，也得到了一些远程工作机会。我被聘为高级职位。我想我的经历对初级和中级程序员也有帮助。

**在我们跳进沉重的东西之前：**

> **我最终被录用的第一条规则是：把所有的事情都记录下来！**

对公司做笔记，跟踪哪些简历和求职信有用，每次面试后做笔记，这些会帮助你变得更快更好。

### 搞定你的 iOS 简历

不想重复造轮子，所以如果你有时间，请[阅读这篇编写开发人员简历指南](https://medium.freecodecamp.org/how-to-write-a-good-resume-in-2017-b8ea9dfdd3b9)。

如果你没有时间：

#### 我曾经被应聘时的简历的一个稍微修改过的版本：

![](https://cdn-images-1.medium.com/max/800/1*4xXwKJBUGdKxfn9Rrs1mVg.png)

> 你的简历应该简单易读。以一种易于阅读的格式列出你的成就，优先列出让你看起来最好的事情。

**你的简历应该有：**

*   教育背景（如获得学位或选修重要课程）
*   工作经验
*   开源项目（提供链接）
*   你的个人应用程序（如果可能的话提供链接）
*   最相关的技术技能（保持最小篇幅）
*   其他值得注意的事情（你参加的俱乐部，你举办的开发者见面会，你赢的黑客马拉松）

**不**要提及你是高级还是初级开发。让你的简历说明一切。

**对你的简历维护几个版本**。每个版本都应该尽量根据不同公司的个性调整描述细节。

不是让你去撒谎，而是以不同公司最看重的方面来推销自己。

### 获得成功的其他方法

#### 建立一个很棒的个人网站。

你的网站可以表达出简历无法表达的东西。[看看我的个人网站](http://robcaraway.com/about/)。当我走进 [InMotion Software](http://www.inmotionsoftware.com/) 的办公室时，他们打开了我的个人网站的 about me 页面。几天后他们给了我 offer。

[这是另一个很好的个人网站的例子](https://peterlyons.com/)。保持网站的整洁，用**你潜在雇主希望看到的方式**准确地表达你做了什么。

如果你不得不撒谎，你可能是在努力争取一个并不适合你的职位。没关系。调整你的期望，重新准备。

如果你不擅长 web 开发，请坚持在 Squarespace 或者 Wordpress 上建立你的网站。

**如果了解网页开发，建立你自己的网站**。我使用了 Node.js 和 Hexo。这表明，如果需要的话，我很乐意跳到其他的代码领域，这不会损害雇主的利益。

#### 建立强大的 LinkedIn 页面。

如果你认为 LinkedIn “很挫”，那你就是在和自己过不去。我就通过 LinkedIn 得到了了一些工作机会。

![](https://cdn-images-1.medium.com/max/600/1*cQ2mbHxy07bYePiL7I4O4Q.png)

截至 2018 年中

[看看我的 LinkedIn 页面](https://www.linkedin.com/in/rob-caraway/)。你没必要成为 LinkedIn 方面的专家：我去年才开始真正地研究它。

要保持更新并且**有一个自己的好看的照片**。我拍了一张我满意的自拍上去。用编辑照片的 app，修修图。多练习可以让你拍出更好的照片。

添加特定的关键字到你的个人资料中，以助你出现在你期待的某些搜索关键词下面。

想象一下，如果你生活在一个不是奥斯丁这样竞争激烈的地区，你可能很快就会脱颖而出。

### 以聪明的方式申请工作

这里有一些找到 iOS 开发工作的好方法：

*   查看 [Angel.co](https://angel.co/) 上面的工作（搜索在你的工作地和“支持远程工作”的工作）
*   Google 搜索 “iOS 开发人员的工作 [首选城市]”。谷歌，Glassdoor，ZipRecruiter 和 Indeed 会弹出相关结果。
*   Google 搜索 “远程 iOS 开发”
*   检查你的 Stack Overflow 板块，做出漂亮的个人页面
*   Github 同上
*   在 LinkedIn 上 搜索 iOS 开发者职位
*   参加相关的技术活动

最后一个好地方 —— 通常城市会有一个本地的技术网站。奥斯丁有 [BuiltInAustin](https://www.builtinaustin.com/jobs)。实际上我就是通过这个板块找到了我现在工作的公司的职位。

> 在你的搜索中使用的关键词：移动，应用，iOS, Swift，开发者，工程师，程序员，远程，架构师，iPhone

在你喜欢的文档应用(我用的是苹果备忘录)中记录工作列表。

> 记录他们的网站、他们的应用程序、他们的 glassdoor 评论以及其他的你喜欢（或不喜欢）每家公司的哪些方面。

找到一种你感觉可持续的申请速度。你需要足够的时间去做一些基本的准备工作。

我发现每周申请两到三家公司对我来说最合适，但如果你已经有了全职工作，你可能每两周甚至更慢地申请一次 —— 如果你坚持下去，那也没什么问题。

想想是什么让你为每个公司感到兴奋。你可能不是对他们的产品充满热情，但你喜欢他们公司的技术、文化、你可能学到的东西，或者他们帮助的人。

#### 写求职信

在做了充分研究之后，你可能会注意到一些让你喜欢上这家公司的地方。也许他们在招聘广告中特别提到的一些事情引起了你的共鸣。

用这些来表达为什么你是一个非常合适的人选，以及你想从他们那里得到怎样的反馈。

稍微放松随意一些。没有面试官愿意听让人发困的企业行话和 500 字毫无意义的独白。

把你对公司做笔记的时候提到的积极的方面拿出来，并提出一两件引起你注意的事。简单地用你自己的方式说一下为什么你认为自己可以胜任。

#### 这里有一封我用过的求职信，让我得到了一个电话面试机会：

![](https://cdn-images-1.medium.com/max/800/1*vjgAq86vcjnwb3Wx3OkKZg.png)

注意到它甚至有一个错字 😂 （尽管我不建议这样做）

请注意我是如何把自己缺乏团队经验说成是一件我急于克服的事情（这是真的）。

像你的简历一样，记录你用过的求职信的几个版本，注意哪些有用，哪些没有用电子表格。

### 为编程挑战做准备

编程挑战是一个测试你知识和编码技能的小练习，你可以在自己的时间内（通常是在一个宽松的期限内）做。

编程挑战通常由一个或两个视图控制器组成，并要用到一个或两个相关技术（如网络和 core data）。

我不打算透露所有公司的准确的题目，但我想，即使是我申请的公司，如果有更多的应聘者做好准备，并且对公司想让应聘者知道的东西有足够的了解，公司也会很感激的。

#### 不说的太具体，下面是一些我遇到的几个编程挑战中所做的关键工作：

*   [AutoLayout](https://www.raywenderlich.com/125718/coding-auto-layout) 和 [Autoresizing](https://stackoverflow.com/questions/12986130/proper-autoresizingmask) 视图
*   调整文本大小以适应不同的屏幕（[Dynamic Text](https://www.raywenderlich.com/77092/text-kit-tutorial-swift)）
*   使用基本 API 进行网络请求
*   使用 TableViews 和 CollectionViews
*   用 Core Data，UserDefaults 或存档来持久化数据
*   知道如何使用 storyboards，也要准备好以纯代码方式编写视图和控制器
*   [Size classing](https://www.raywenderlich.com/162311/adaptive-layout-tutorial-ios-11-getting-started)
*   异步加载图片并在主线程上显示
*   向 tableview 或 collection view 添加无限滚动
*   将代码模块化。不要把所有东西都塞进视图控制器。了解如何构建不可变的模型和服务层对象。

以上这些内容也可能会出现在面试中。

你不可能写出完美的代码。这是可以接受的：

> 当你写代码的时候，如果你知道代码不完美，你可以用 //TODO 或 //FIXME 来说明你将如何改进它，以向团队展示你知道你必须做的权衡。

别人也会看你是否有能力做出人们喜欢的产品。如果你知道如何让它超快、平滑、漂亮，即使他们没有要求（如果你也有时间），你也要去做，除非他们明确说不需要做。

### 如何处理结对编程挑战

**不是每个公司都会做这一部分，但是值得注意。**

对于结对编程，你可能要处理你在编码挑战中创建的代码，或者处理与公司希望你编写的代码类型类似的任务。

不幸的是，你不能真的“伪造”这一部分。你必须相信你的直觉，因为在你不认识的人面前，你无法立即改变自己的行为。

> 不要紧张，在任务中要玩得开心。如果事后你觉得不太顺利，记下你能做得更好的事情。

如果你想练习，那就坐在你朋友旁边一起做一些项目。越多越好。

### 搞定面试

你需要准备好谈论的话题：

*   大 O 符号。Swift/Obj-C 中的时间复杂度的例子
*   数据结构
*   用 Swift 创建一个 LinkedList（以防万一）
*   Struct vs. Swift 的类
*   了解 Swift 标准库数据结构是如何工作的（基本程度）
*   MVC, [MVVM](https://www.raywenderlich.com/192471/design-patterns-by-tutorials-mvvm)
*   你在编程挑战中写的代码或：
*   为解决类似公司面临的问题你可能会编写的代码
*   你的兴趣和目标与公司的目标是如何一致的
*   “你认为5年后你的职业生涯会怎样”之类的问题很可能会出现

对一家公司产生兴趣往往是一种“假装直到你成功”的情况。你越是研究并找出对公司有意义的贡献的方式，你的兴趣就越会“神奇地”与他们保持一致。

不过，不要太强迫自己 —— 那些有着糟糕的 Glassdoor 评论和零星任务的公司几乎总是你需要避开的坑。

我所注意到的（虽然不是绝对的规则）：公司越大，面试就显得越学术。准备好应对来自大公司问题中的“陷阱”吧。

小公司通常会有更少的形式，因为他们不需要它。

#### 其他重要的准备方法：

*   读 [Advanced Swift](https://www.objc.io/books/advanced-swift/)
*   在你的业余时间参加 [swift 在线测验](https://www.hackingwithswift.com/test)
*   阅读 [Cracking the Coding Interview](https://www.amazon.com/Cracking-Coding-Interview-Programming-Questions/dp/0984782850/ref=pd_lpo_sbs_14_t_0?_encoding=UTF8&psc=1&refRID=DC92Y76B7Z8DXK6VWH9T)，特别是关于数据结构和时间复杂度的部分。

### 最后的想法

找到渴望得到工作和完全不关心你得到的工作之间的平衡。

如果你坚持上述的过程，你会变得更好 —— 我得到的这份工作使用的简历和我刚开始找工作时投递的简历看起来完全不同。我学会了用一种更淡定的态度来处理面试。

让这个过程给你翅膀。每次被拒绝都会让你变得更好，所以要奖励自己的进步，而仅仅是关心你是否得到了这份工作。

最后，如果你住在奥斯汀地区：[InMotion Software 正在招聘](https://www.builtinaustin.com/company/inmotion-software/jobs)！:) 我和他们一起工作很开心。

### 学习如何制作令人惊叹的应用程序等等

如果你从这篇文章中有所收获，Rob Caraway 写了关于**应用程序开发、创业和建立一个伟大的开发者职业生涯的详细指南**。[在这里注册就会得到通知](http://robcaraway.com) **是他自己的想法。**

* * *

#### 这篇文章从哪来的

这个文章发表在 [Noteworthy](http://blog.usejournal.com) 上，每天都有成千上万的人来这里了解塑造我们喜爱的产品的人们和想法。

跟随我们的出版物去看更多的产品和设计的故事，由 [Journal](https://usejournal.com/?utm_source=usejournal.com&utm_medium=blog&utm_campaign=guest_post) 团队提供。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
