> * 原文地址：[A Brief Totally Accurate History Of Programming Languages](https://medium.com/@caspervonb/a-brief-totally-accurate-history-of-programming-languages-cd93ec806124)
> * 原文作者：[Casper Beyer](https://medium.com/@caspervonb?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/a-brief-totally-accurate-history-of-programming-languages.md](https://github.com/xitu/gold-miner/blob/master/TODO1/a-brief-totally-accurate-history-of-programming-languages.md)
> * 译者：[Starrier](https://github.com/Starriers)
> * 校对者：[L9m](https://github.com/L9m)、[allenlongbaobao](https://github.com/allenlongbaobao)

# 简短而又完全精确的编程语言历史

## 完美的灵感源于事实

![](https://cdn-images-1.medium.com/max/1600/1*ROH0byc_N5d96ggEk2A8nA.jpeg)

#### 1800

[Joseph Marie Jacquard](https://en.wikipedia.org/wiki/Joseph_Marie_Jacquard) 教会.一个纺织机读穿孔卡片，创建了第一个重量级多线程处理单元。他的发明遭到预见天网（Skynet）诞生的丝织工的强烈反对。

#### 1842

[Ada Lovelace](https://en.wikipedia.org/wiki/Ada_Lovelace) 厌倦了贵族，后在一个笔记本上无心地写下被后世所称的首个计算机程序，只是当时并没有计算机，事实上稍微有点不方便。

#### 1936

[Alan Turing](https://en.wikipedia.org/wiki/Alan_Turing) 发明的所有东西都被英国法院否决，而且对他采取化学阉割。

尽管女王后来赦免了他，但不幸的是距他逝世已经过去了几个世纪。

#### 1936

[Alonzo Church](https://en.wikipedia.org/wiki/Alonzo_Church) 和图灵一样也发明了很多东西，但和他不一样的是，女王没有对他进行阉割。

#### 1957

[John Backus](https://en.wikipedia.org/wiki/John_Backus) 开发了 FORTRAN ，这是第一种被 **程序员真正使用的**语言。

#### 1959

[Grace Hopper](https://en.wikipedia.org/wiki/Grace_Hopper) 开发了第一种企业可用的面向业务编程语言，叫做“**面向商业的通用语言**”或者简称 **COBOL**。

#### 1964

[John Kemeny](https://en.wikipedia.org/wiki/John_G._Kemeny) 和 [Thomas Kurtz](https://en.wikipedia.org/wiki/Thomas_E._Kurtz) 认为编程太难了，而他们想要回归基础，因此称它们发明的语言为 BASIC。

#### 1970

[Niklaus Wirth](https://en.wikipedia.org/wiki/Niklaus_Wirth) 让 Pascal 成为了众多语言中的一种，他喜欢发明语言。

他还发明了[沃思定律](https://en.wikipedia.org/wiki/Wirth%27s_law) ，这使得摩尔定律变得过时，因为软件开发者编写的软件过于臃肿，即使是大型机也跟不上。这一定律被之后的 Electron.js 证明是正确的。

#### 1972

[Dennis Ritchie](https://en.wikipedia.org/wiki/Dennis_Ritchie) 在贝尔实验室工作时间感觉无聊，所以决定开发 C，因为 C 有花括号，所以它最终获得了巨大的成功。之后他还添加了分段错误和其他对开发者友好的特性来提高生产效率。

还有几个小时，他和贝尔实验室的朋友们决定制作一个演示 C 的示例程序，于是他们制作了一个名为 Unix 的操作系统。

#### 1980

[Alan Kay](https://en.wikipedia.org/wiki/Alan_Kay)  发明了面向对象编程语言并称其为 Smalltalk，在 Smalltalk 中，一切都是对象，对象本身也是一个对象。但没有人真正有时间去理解闲聊（small talk ）的意义。

#### 1987

[Larry Wall](https://en.wikipedia.org/wiki/Larry_Wall) 有宗教经验，成为了传教士，并使 Perl 成为教义。

#### 1983

[Jean Ichbiah](https://en.wikipedia.org/wiki/Jean_Ichbiah) 注意到 Ada Lovelace 的程序从没有真正运行过，所以决定用她的名字开发一种语言，但是语言仍然没有运行。

#### 1986

[Brac Box](https://en.wikipedia.org/wiki/Brad_Cox) 和 [Tol Move](https://en.wikipedia.org/wiki/Tom_Love) 决定基于 Smalltalk 开发一个不可读的 C 版本，他们称之为 Object-C，但没有人可以理解语法。

#### 1983

[Bjarne Stroustrup](https://en.wikipedia.org/wiki/Bjarne_Stroustrup) 回到未来，注意到 C 没有花足够的时间编译，所以他在语言中添加了他想得到的所有特性，并将它命名为 C++。

它得到了广泛使用，所以程序员们在工作时看视频、看新闻有了真正的借口。

#### 1991

[Guido van Rossum](https://en.wikipedia.org/wiki/Guido_van_Rossum) 不喜欢花括号，于是发明了 Python，语法选择的灵感来源于 Monty Python 和 Flying Circus。

#### 1993

[Roberto Ierusalimschy](https://en.wikipedia.org/wiki/Roberto_Ierusalimschy "Roberto Ierusalimschy") 和朋友们认为他们需要的是一种巴西本地化脚本语言，在本地化过程中出现了一个错误，导致索引不是从 0 而是从 1 开始计算，他们将其命名为 Lua。

#### 1994

[Rasmus Lerdorf](https://en.wikipedia.org/wiki/Rasmus_Lerdorf) 为自己的个人主页 CGI 脚本制作了一个模版引擎，并在网上发布了他的 dotfiles。

时代导致这些文件可以用于任何事物，疯狂的 Rasmus 还在其中引入额外的数据库绑定，并将其称为--PHP。

#### 1995

[Yukihiro Matsumoto](https://en.wikipedia.org/wiki/Yukihiro_Matsumoto) 并不开心，他注意到其他程序员也不开心。他发明 Ruby 是为了让程序员开心。在发明出 Ruby 后「Matz」很开心，Ruby 社区也很开心，每个人都是快乐的。

#### 1995

[Brendan Eich](https://en.wikipedia.org/wiki/Brendan_Eich) 利用周末设计了一种语言，用于为世界上的每一个浏览器提供支持，并最终为天网提供服务。起初，他去了网景（Netscape），称它为 LiveScript，但在代码审查期间，Java 变得流行起来，所以他们决定最好使用花括号，并将其重新命名为 JavaScript。

Java 被证明将是一个给他们带来麻烦的商标，JavaScript 后来被重命名为 ECMAScript，但大家仍称之为 JavaScript。

#### 1996

[James Gosling](https://en.wikipedia.org/wiki/James_Gosling) 发明了 Java，这是第一种真正过于冗长的面向对象编程语言，其设计模式的规则凌驾于实际需要之上。

其高效的管理器提供容器提供服务管理单例管理提供商模式就诞生了。

#### 2001

[Anders Hejlsberg](https://en.wikipedia.org/wiki/Anders_Hejlsberg) 重新开发 Java 并将其命名为 C#，因为 C 编程感觉比 Java 更酷。每个人都喜欢这个完全不像 Java 的新版 Java。

#### 2005

[David Hanselmeyer Hansen](https://en.wikipedia.org/wiki/David_Heinemeier_Hansson)   编写了一个叫做 Ruby on Rails 的 Web 框架，人们从此再也记不得它们曾经是分开的。

#### 2006

[John Resig](https://en.wikipedia.org/wiki/John_Resig) 为 JavaScript 编写了一个助手库，每个人都认这是一种语言，并从事从互联网复制粘贴 jQuery 代码的职业。

#### 2009

[Ken Thompson](https://en.wikipedia.org/wiki/Ken_Thompson) 和 [Rob Pike](https://en.wikipedia.org/wiki/Rob_Pike) 决定发明一种类似 C 的语言， 但要有更安全的「装备」并更有市场前景，还要以 Gophers 作为吉祥物。

他们称它为 Go，还开源了它，而且还不捆绑地售卖地鼠牌的护膝和头盔。

#### 2010

Graydon Hoare 也想编写一种类似 C 的语言-- Rust。大家都要求可以立即用 Rust 重写每一个软件。Graydon 想要更炫的事情，于是开始为 Apple 开发 Swift。

#### 2012

[Anders Hjelsberg](http://Anders%20Hejlsberg) 想在 Web 浏览器中编写 C#，于是就设计了一种 JavaScript 语言--TypeScript，而实际上它却包含了很多 Java 内容。

#### 2013

[Jeremy Ashkenas](https://en.wikipedia.org/wiki/Jeremy_Ashkenas "Jeremy Ashkenas") 希望像 Ruby 开发者那样幸福，所以他创建了最后可以编译成 JavaScript 的 CoffeeScript，但它看起来更像 Ruby。Jeremy 从来没有像 Matz 和 Ruby 开发者那样真正快乐过。

#### 2014

[Chris Lattner](https://en.wikipedia.org/wiki/Chris_Lattner) 使 Swift 成为了主要的设计语言，而不是 Object-C，最后让 Swift 看起来很像 Java。

* * *

[James Iry, 我只能假设他是计算机科学史学者，他曾在 2009 年做过一些类似的观察。](http://james-iry.blogspot.com/2009/05/brief-incomplete-and-mostly-wrong.html?m=1)


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
