> * 原文地址：[A Beginner’s Guide to Rapid Prototyping](https://medium.freecodecamp.org/a-beginners-guide-to-rapid-prototyping-71e8722c17df)
> * 原文作者：[Anant Jain](https://medium.freecodecamp.org/@anant90?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/a-beginners-guide-to-rapid-prototyping.md](https://github.com/xitu/gold-miner/blob/master/TODO1/a-beginners-guide-to-rapid-prototyping.md)
> * 译者：[Ryden Sun](https://juejin.im/user/585b9407da2f6000657a5c0c)
> * 校对者：[Ivocin](https://github.com/Ivocin)

# 快速原型设计的新手指南

## 7分钟（甚至不到）内了解快速原型设计的一切

![](https://cdn-images-1.medium.com/max/800/1*HX9NJx68T86OwbXaqVkvFQ.jpeg)

照片由 [Denise Jans](https://unsplash.com/photos/ZEtE38ybfao?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText) 提供于 [Unsplash](https://unsplash.com/search/photos/sketch?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText)

从一个想法到完整的产品，过程是复杂的。每一个想打造自己产品的人都应该具备**原型设计**的能力，通过原型获得**反馈**，然后不断进行**迭代**。这也是 UX 设计师工作中的重要一环。

原型设计有很多种形式，从纸上简单的草稿到看起来像最终产品的交互模拟，都属于原型范畴。这篇指南是写给那些想理解原型所有相关方面知识的初学者的。

我们除了会讲到一些快速原型设计相关术语的含义之外，还会有以下这些方面：

![](https://cdn-images-1.medium.com/max/800/1*EycA2hPdjY4EtPLiw6uwcg.jpeg)

1. 什么是快速原型设计？
2. 你需要为哪些部分设计原型？
3. 快速原型设计的流程
4. 原型需要包含哪些部分？
5. 原型的保真度是什么意思？
6. 应该如何为原型挑选合适的保真度？
7. 如何选择原型设计工具？
8. 原型设计最佳实践：做什么和不做什么

### 什么是快速原型设计？

**快速原型设计**是一个不断迭代的过程，将网页或者应用可视化，以此来获得用户，利益相关者，开发者和设计师的反馈和认可。

当使用的好时，快速原型设计可以通过加强多方沟通，避免制作出一个用户不喜欢的产品，以此来提高设计的质量。

![](https://cdn-images-1.medium.com/max/800/1*Rhy673frJz2NZdXxwk5DMg.png)

### 你需要为哪些部分设计原型？

原型设计并不是一个系统的完整功能性版本，它只是被用来帮助可视化最终产品的用户体验。就像谷歌 Ventures design（风险投资设计，一种用设计入股创业公司的方式）合伙人 Daniel Burka 说的：

> 一个理想的原型应该是 “Goldilocks”（金发姑娘，用来形容完美平衡，刚刚好）般的质量。如果原型的质量太差，人们不会相信这个原型是一个真正的产品。如果质量太高，会导致你没日没夜的工作，并且你完不成。你需要一个 “Goldilocks” 的质量，不需要太高，也不要太差，刚刚好就行。

你不仅可以为屏幕，移动应用或者网页进行原型设计，甚至说是任何东西都可以进行原型设计。原型设计可以极好的测试以下方面（提供了案例）：

*   **新功能**：在 Instagram app 中进行 Instagram Stories 模块的原型设计（在正式发布之前）。
*   **流程上的改动**：在 Medium 引入付费会员之后，对其新的发布流程进行原型设计
*   **新兴技术**：为自动驾驶汽车的旅程进行原型设计！
*   **新的交互界面**：为 Apple Watch 交互界面进行原型设计（当它首次发布时）

![](https://cdn-images-1.medium.com/max/800/1*GY6wSGyvDaBsOcNVL79aOQ.png)

所以，你现在知道快速原型设计是干什么的了。但是你怎么来做呢？我们后续会讲到。

### 快速原型设计流程

快速原型设计包含了一个 3 步走的流程，根据需求多次迭代：

1.  **原型**：为你的解决方案或交互界面创建一个可视化的模型。
2.  **评审**：跟用户分享原型，探索它是否满足用户需求和期望。
3.  **改进**：根据用户反馈，找出需要改善或进一步明确的地方。

![](https://cdn-images-1.medium.com/max/800/1*vg-vKo3Z7SHIR-tD2C9brw.png)

原型，评审，改进，迭代。

一个原型通常是从一个简单的模型开始，只涵盖关键点，随着用户反馈的数据收集，通过每一次迭代变得更加完善，复杂。

### 你的原型需要包含哪些部分？

集中精力在那些关键的功能，这些功能是用户最常使用的。快速原型设计的意义是，在不需要规划整个产品细节之前，展示一个功能是怎么工作的，亦或是它看起来是什么样的。谨记，我们的目标是 **“Goldilocks”** 般的质量！

**一次性对整个 [用户流程](https://www.commonlounge.com/discussion/a916ed5af1354c8eb26ce23b3fcc9076) 进行原型设计**。比起一个界面一个界面的设计，原型设计应基于一个用户使用场景，这个场景包含所有你想进行原型设计的区域。通过这种方法，你会得到更精准的用户反馈，因为你的原型会切实的反应用户真实生活中的场景。比如，将“注册/登陆/重置密码”一套流程进行整体原型设计。

除此之外，要记住，心中要有一个**迭代计划**。按经验来说，制作迭代计划时要从全局入手，然后超更细节的解决方案版本入力。随着你不断迭代，原型的**保真度**和所包含的内容，都会不断增长。

但是稍等，什么是保真度？

![](https://cdn-images-1.medium.com/max/800/1*u5tCByoIo7t-S4mVHoUW3w.png)

### 什么是原型的保真度？

保真度是指原型与最终产品或解决方案的相似度。你可以从不同等级的准确度中选择，根据目前流程的阶段和原型的目标来选择。

#### 视觉（草图 vs. 设计稿）

布局和设计是原型保真度中最显眼的部分。如果一个原型从开始就保持高视觉保真度的产出，用户会倾向集中于视觉，而不是功能细节，这会偏离早期阶段原型的主要目标。

![](https://cdn-images-1.medium.com/max/800/1*xphKRum4oHgEDVFOgKKSkQ.png)

静态原型有两种保真度 — 草图（低保真）和设计稿（高保真）

#### 功能性（静态 vs. 可交互）

原型是静态还是必须要看起来支持所有功能（可交互）？两个版本都有好处和坏处：静态原型可以更简单快捷的实现，然而可交互版本后续可被用来做可用性测试和用户培训。

![](https://cdn-images-1.medium.com/max/800/1*31Dmfuel1WCPS4R9JIYLnw.gif)

一个高保真的可交互的原型。（[来源](https://framer.com/getstarted/examples/)）

#### 内容（固定文本 vs. 实际内容）

原型的早期阶段，使用统一的固定文本内容可以有效的避免用户从提供功能性反馈中偏离，而不是对文本内容进行评论。

然而，随着原型设计的流程递进，用实际内容来替代冗余的文本，这样用户可以感觉到整体设计的影响。

使用实际的标签也是一个很好的机会来测试你“复制的内容”的工作效果。**复制**对于文本空间和屏幕中信息是一个美妙的术语，就像我们把“发布”按钮叫做“发布”，“发表”，“发送”，“完成”或者其他的叫法。

#### 都存在哪些保真度？

*   **低保真**：低保真度就像“笔和纸”，草图会生成静态的原型图，包含较低的视觉和内容保真度，以此来支持快捷的改动。这会强制用户**集中于功能**以及他们如何使用这个系统，而不是系统看起来怎么样。
*   **中保真**：电脑端的工具比如 Visio 所产出的原型我们叫做中度保真原型，由**界面框架和工作流组成**。这个程度的保真是用来展示系统的表现行为，来判断用户的需求是否被满足，以及来评估用户体验。
*   **高保真**：高保真原型有时候会**太真实**，以至于经常与实际产品搞混。它们的产出也更**耗费时间**。一些工具像 nVision, Sketch, Figma, Adobe XD, Framer 等允许非技术用户来创造高保真原型。虽然它们不能被转换成可用的代码，但是可以很顺手的被用来做可用性测试和用户培训。

![](https://cdn-images-1.medium.com/max/800/1*NJ8zAAsl3WdZ3Nm1Tb9Jmg.jpeg)

从低保真，到中保真再到高保真（[Source](http://murdochcarpenter.com/portfolio/wireframes/)）

### 如何选择合适的原型保真度级别？

大多数时间，设计方案的最佳探索方式是从粗略的草图开始，然后根据系统的复杂度和需求，迁移到更高的保真度。

有些时候，你的选择可能是由客户需求或所关注的领域所指引。比如，如果你想评估一个界面改动所造成的视觉影像，相对于粗略的草图，你可能会选择一个视觉设计稿。或者如果你的解决方案时关注于消息的，你可能会决定使用真实的内容而不是统一的固定文本。

### 如何选择原型设计工具？

根据你的需求和方式有很多可用的原型设计工具。选择工具之前，你要问清楚这些问题：

*   学习使用这个工具要耗费多长**时间**？
*   工具**是否支持**产品原型的需求（网页，应用程序，手机 apps，新科技等等）？
*   工具是否支持**分享**原型给其他人并且收集反馈？
*   对原型进行改动是否**方便**？
*   工具是否支持预定义的**模板**？

![](https://cdn-images-1.medium.com/max/800/1*qFU_eCjrbaQNvQnac0odqg.png)

纸笔、Sketch、Figma、Framer、Photoshop、Illustrator、XD 和 Origami 等等

### 原型设计最佳实践：做什么和不做什么

#### 做什么：

*   和用户与利益相关者交流工作，获得最多的**反馈**，并且培养他们对于最终产品的主人翁意识。
*   尽早**设立期望目标**，以确保用户和利益相关者知道原型设计是一种寻找问题解决方案的方式，而且并不代表最终的产品。
*   让高保真尽量**真实**（包含相应延迟），这样用户和利益相关者将原型和最终产品比较时不会失望。
*  **保存好模板**，可以在以后的项目中复用。

![](https://cdn-images-1.medium.com/max/800/1*JREHbIuPyyni2AHqk0O6tg.png)

#### 不做什么：

*   不要给那些不会出现在最终产品的功能做原型设计。
*   不要做完美主义者，足够好就可以了。快速原型设计的目的是给每个人达成一致。
*   不要任何事情都做原型设计！

如果你好奇应该如何测试你的原型，可以阅读我的另一篇**可用性测试**的文章：

[**极致 UX 体验背后的秘密：可用性测试**：无论是一个原型还是一个完全成熟的产品，进行几个月的长时间可用性测试都是很好的选择](https://medium.freecodecamp.org/the-well-kept-secret-behind-great-ux-usability-testing-b788178a64c3 "https://medium.freecodecamp.org/the-well-kept-secret-behind-great-ux-usability-testing-b788178a64c3")

![](https://cdn-images-1.medium.com/max/800/1*UrU4lEMyukeMZnKO5LbMQw.png)

感谢阅读这篇指南。这篇文章最初是作为 [Commonlounge](https://www.commonlounge.com/) 上的 [UX 设计课程](https://www.commonlounge.com/discussion/d8c1c96e92024adf9f496fe41dcaad1a)其中一部分发布的，这个平台有很多小型课程，话题从 [Django](https://www.commonlounge.com/discussion/8053bde657804a6b9135c0d781c9d2c7) 涵盖到 [Machine Learning](https://www.commonlounge.com/discussion/35ccdb70826e434a876d612504297232)，可以让付出的时间得到最大的回报。

通过在真实世界的项目上工作进行学习，并且从产业导师身上获得反馈，尽在 [commonlounge](https://www.commonlounge.com/)！

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
