> * 原文地址：[A beginner’s guide to Ethereum](https://blog.coinbase.com/a-beginners-guide-to-ethereum-46dd486ceecf)
> * 原文作者：[Linda Xie](https://blog.coinbase.com/@linda.xie?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/a-beginners-guide-to-ethereum.md](https://github.com/xitu/gold-miner/blob/master/TODO1/a-beginners-guide-to-ethereum.md)
> * 译者：[Rickon](https://github.com/gs666)
> * 校对者：[Qiuk17](https://github.com/Qiuk17), [ZyGan1999](https://github.com/ZyGan1999)

# 以太坊入门指南

## 什么是以太坊？

按照[以太坊官网](https://www.ethereum.org/)的说法，“以太坊是一个运行智能合约的去中心化平台。”这是一个准确的总结，但是根据我的经验，当我首次向我的亲朋好友或者陌生人解释以太坊的时候把以太坊和比特币作比较会让人更容易理解，因为很多人之前至少听说过比特币。这份入门指南应该有助于刚接触以太坊的人们理解两者之间的高层差异。

![](https://user-gold-cdn.xitu.io/2018/12/12/167a289c995aea29?w=800&h=478&f=png&s=128690)

## 比较

 简而言之，比特币可以被描述为数字货币。比特币已经存在 8 年了，它被人用来向另一个人转账。它通常被用作一种价值储存手段，同时也成为了公众理解去中心化数字货币概念的重要途径。

以太坊与比特币的不同之处在于它允许智能合约，可以称之为高度可编程的数字货币。想象一下，只要满足一系列条件，货币就能从一个人自动发送给另一个人。举个例子，一个人想要从另一个人手里买房子。传统上，交易会涉及多个第三方机构，包括律师和托管代理，这会让过程变得不必要地缓慢且昂贵。有了以太坊，一段代码就可以在交易达成后自动将房屋所属权转给买家，而卖家会在交易完成后收到卖房资金，无需第三方代表他们运作。

这种潜力是不可思议的！想想众多基于某种逻辑集合作为第三方组织连接你和其他人的应用（例如 Uber，Airbnb，eBay）。我们今天使用的许多集中式系统都可以在以太坊上用去中心化的方式构建。有了以太坊，您可以使这些交易变得无法信任，从而打开了去中心化应用的整个世界。[去中心化是重要的](https://medium.com/@VitalikButerin/the-meaning-of-decentralization-a0c92b76a274#.4hl67650f)因为它消除了单点故障或控制。这使得内部勾结和外部攻击变得不切实际。去中心化的平台去除了中间商，最终为用户降低了成本。有一些应用让我尤其为之振奋。

## 身份识别

一个人可以在许多网站上创建数字身份（例如 Facebook，Twitter，LinkedIn）。这样管理起来很麻烦，并且在一天结束时，你无法完全掌控你的信息，因为它仍然被一个中心实体拥有。使用以太坊，你可以拥有像 [uPort](https://www.uport.me/) 这样的去中心化身份管理系统，让你可以完全掌控数据。没有任何集中式服务器可以访问、编辑或关闭你的私人数据，或者使你的数据被黑客攻击。

现在在美国，我们有信用机构（例如Experian，TransUnion，Equifax），银行等其他机构依赖它来获取你的信用评价。信用机构会使外国人和年轻人等特定群体处于不利地位。[Lending Club](https://www.lendingclub.com/)，一个 P2P 借贷平台，解决传统金融服务的问题完全依赖 FICO 分数提供额外的数据点，如住房所有权、收入和工作时间。像 uPort 这样的以太坊应用程序可以更进一步地允许你掌控自己的数据，身份和声誉。

## 计算能力 / 存储空间

考虑到一个普通人在电脑上可能拥有多余的计算能力和存储空间。如果它没有被使用，那么为什么不把它提供给其他人呢？这与在 Airbnb 出租一间空着的卧室的概念类似。使用去中心化应用的另一个好处是没有了容易受到审查的集中式服务器。

有几个正在开发中的项目允许人们从别人那里获得多余的计算能力和存储空间。[Filecoin](http://filecoin.io/)允许人们出租他们的电脑存储空间给别人并获得报酬。类似的还有 [Golem](https://golem.network/)允许人们出租他们的计算能力。像这样的点子并不新鲜了。自从 2000 年起，[Folding@home](https://folding.stanford.edu/) 就已经允许志愿者为斯坦福大学的科学研究贡献多余的计算能力。现在，这个概念可以货币化并应用于其他行业，可能会降低成本。

## 社交媒体

[Akasha](http://akasha.world/) 是一个去中心化的社交媒体平台。没有集中式服务器，因此没有任何一方可以完全控制内容。这意味着该平台可以抵御审查。在以太坊上构建去中心化的社交媒体应用的另一个好处是，人们可以创建一个在财务上奖励高质量内容的系统。这就像 [Reddit](https://www.reddit.com/) 一样，但是你可以向帖子打赏少量的钱，而不是点赞。

## 权利管理

去中心化的应用程序可被用来为多个行业带来透明度。例如 [SingularDTV](https://singulardtv.com/) 提供娱乐圈权利管理平台，它允许向创作者、投资者、工作人员、演员和项目中涉及的其他人透明地分配资金。没有集中方可以阻止某个组获取他们的资金，因为这些条款是由代码强制执行的。每个人都会按照前面提到的条款获得报酬，并且不需要第三方介入。

## 管理公司

创建新公司的一个耗时且通常代价昂贵的问题是分配和管理股票。随着公司的发展和更多的融资，他们最终需要发行和转移股票。[Aragon](https://aragon.one/) 就是一个有前景项目的例子，它有一个易于使用的界面来管理公司的上限表和融资。

## 融资

最后，以太坊的一个主要使用案例是来自全球网络的投资者的去中心化融资。众筹降低了从事高风险项目的开发人员的准入门槛。自从以太坊于 2015 年 7 月推出以来，我们已经看到去中心化式应用通过众筹融资到前所未有的资金。以太坊本身是通过一个筹集了价值1800万美元比特币的众筹来创建的，一个名为 The DAO 的项目筹集了 1.6 亿美元。其他一些著名的众筹如下所示：

![](https://user-gold-cdn.xitu.io/2018/12/12/167a077c6dde9978?w=800&h=429&f=png&s=28880)

在众筹时筹集的金额（非隐含估值）

想获取有关这些代币如何运行的更多信息，请参阅[ 如何使用代币在区块链上融资](https://blog.gdax.com/how-to-raise-money-on-a-blockchain-with-a-token-510562c9cdfa#.rw9pz8i7p)，[ 区块链代币证券法律框架](https://blog.coinbase.com/2016-12-07-blockchain-token-securities-law-a66ef03c383f#.lowvjw5i8)，和 [App Coins 和协议代币之间的区别](https://medium.com/@willwarren89/the-difference-between-app-coins-and-protocol-tokens-7281a428348c#.pzk5vjfxd)。

## 资料

这篇文章仅涉及到无数以太坊使用案例中的几个。这个领域正在不断地发展和创新。以下是一些链接，可以帮助你进一步了解以太坊并及时了解最新的消息。

**了解以太坊**

*   [以太坊是数字货币的最前沿](https://blog.coinbase.com/ethereum-is-the-forefront-of-digital-currency-5300298f6c75#.kz1pj8bfv)
*   [App Coins 和去中心化商业模式的曙光](https://medium.com/the-coinbase-blog/app-coins-and-the-dawn-of-the-decentralized-business-model-8b8c951e734f#.hboxfmq6d)
*   [以太坊白皮书](https://github.com/ethereum/wiki/wiki/White-Paper)
*   [Bits on Block 的简单介绍](https://bitsonblocks.net/)
*   [权益证明常见问题解答](https://github.com/ethereum/wiki/wiki/Proof-of-Stake-FAQ)

**跟上以太坊的步伐**

*   [Ethereum Subreddit](https://www.reddit.com/r/ethereum/)
*   [Week in Ethereum News](http://www.weekinethereum.com/)
*   [The Control](https://thecontrol.co/)
*   [Smith + Crown](https://www.smithandcrown.com/)
*   [The Dapp Daily](https://dappdaily.com/)
*   [Silicon Valley Ethereum Meetup](https://www.meetup.com/EthereumSiliconValley/)（查看你当地的聚会）

感谢 [Will Warren](https://medium.com/@willwarren89)、[Fred Ehrsam](https://medium.com/@FEhrsam) 和很多 [Coinbase](https://www.coinbase.com/) 员工，尤其是 [Jordan Clifford](https://medium.com/@jcliff)、[Reuben Bramanathan](https://medium.com/@bramanathan)、[Ankur Nandwani](https://medium.com/u/62401673b186)、[Dan Romero](https://medium.com/@dwr) 和 [Jeremy Henrickson](https://medium.com/@jeremyhenrickson)。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
