> * 原文地址：[8 UI design trends for 2020](https://uxdesign.cc/8-ui-ux-design-trends-for-2020-68e37b0278f6)
> * 原文作者：[Dawid Tomczyk](https://medium.com/@dawidtomczyk)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/8-ui-ux-design-trends-for-2020.md](https://github.com/xitu/gold-miner/blob/master/TODO1/8-ui-ux-design-trends-for-2020.md)
> * 译者：
> * 校对者：

# 8 UI design trends for 2020

![](https://cdn-images-1.medium.com/max/2860/1*QpftgHDWJVL2zwM4KgIBjg.png)

The rapid growth of technology influences design trends every year. As designers we need be aware of the existing and upcoming design trends, constantly learning, improving and expanding our design toolkit in order to be up to date on the current market. Based on my research, experience and observations I’ve selected very carefully 8 UI/UX design trends that you should watch in 2020. Let’s get started then! :)

---

![](https://cdn-images-1.medium.com/max/2000/1*jAIfwF5TkGN8cvx5tXd4Pw.png)

Illustrations have been in digital product design for a long time. Their evolution in the last years is very impressive. Illustrations as very popular design elements add natural feel and “human touch” to overall UX of our products. Illustrations are also very strong attention grabbers: at the top of that by applying motion to these illustrations we might bring our products to the life and make them stand out— adding extra details and personality.

![Welcome to Swiggy by [Saptarshi Prakash](https://dribbble.com/saptarshipr)](https://cdn-images-1.medium.com/max/2000/1*NIpVGu31MRBN5ZOoh2dAjw.gif)

![Onboarding animations — [Virgil Pana](https://dribbble.com/virgilpana)](https://cdn-images-1.medium.com/max/2000/1*nO8JMEHRAeUbhZ5uH1UzBg.gif)

Another benefit of applying motion is capturing users attention and making users engage with your product. Animations are also one of the most effective ways to **tell the story** about your brand, product or services.

---

![](https://cdn-images-1.medium.com/max/2260/1*Fb8-rQdPrEp38ofgYc1t7g.png)

Microinteractions exist pretty much in every single app or website. You see them every time when you’re opening your favourite app —for instance Facebook has tons of different microinteractions and I assume that the “Like” feature is just the perfect example. Sometimes we are not even aware of existence, because they are so so obvious, natural and “blended” into user interfaces. Altough, If you remove them from your product you will notice very quickly that something really important is missing.

![Menu toggle close animation — [Aaron Iker](https://dribbble.com/aaroniker)](https://cdn-images-1.medium.com/max/2000/1*euDrScfMNdCN25w6NVyC-g.gif)

![Tab bar active animation — [Aaron Iker](https://dribbble.com/aaroniker)](https://cdn-images-1.medium.com/max/2000/1*W0fsXNGi5V6WYCSb-MqEyA.gif)

Generally speaking, in UI/UX design sometimes even really small and subtle change might make huge impact. Microinteractions are the perfect proof that details and attention to them might greatly improve the overall user experience of your digital products and place them on the next/higher level. Every year, every new device brings new oppurtinitues for creating brand new and innovative microinteractions. 2020 wouldn’t be exception for sure.

---

![](https://cdn-images-1.medium.com/max/2000/1*DX5e1V7y0LE83gcNCgCzJw.png)

3D graphic exist pretty much everywhere — in movies, video games, adverts on the streets. 3D graphic has been introduced few decades ago and since then has improved and evolved dramatically. Mobile and web technology is also growing rapidly fast. New web browser capabilities have opened the door for 3D graphic allowing us as designers to create and implement amazing 3D graphics into modern web and mobile interfaces.

![[3D flip menu by Minh Pham](https://dribbble.com/phamduyminh)](https://cdn-images-1.medium.com/max/2000/1*qDlbltTzKja0Hx0dCupTCA.gif)

![Car health report UI by [Gleb Kuznetsov](https://dribbble.com/glebich)](https://cdn-images-1.medium.com/max/2000/1*zFmiJUB1Z_C3VuwINPycaA.gif)

Creating and then integration of 3D graphic into web and mobile interfaces requires some specific skills and tons of work, but very often the results are very rewarding.

![[Apple AirPods Pro landing page](https://www.apple.com/airpods-pro/)](https://cdn-images-1.medium.com/max/4492/1*4uhVHjD9d6pfYOb2K4TRog.png)

3D graphic renders allows to present the product or services in the a lot more interactive and engaging way: for instance 3D graphic renders could be viewed in 360 degree presentation improving the overall UX of the product.

In 2020 even more brands will use 3D render models to present the product or services in order to emulate the real world (in-store) shopping experience.

---

![](https://cdn-images-1.medium.com/max/2000/1*bPpluRGwRmcKIfd9Iuh7Cw.png)

2019 has been a big year for VR. In the last years we have seen a lot of progress and excitement in VR headsets — mostly in gaming industry. We need to keep in mind that gaming industry very often brings innovation and new technologies into digital product design. Research proves that VR is no exception as after Oculus Quest in 2019 launch many opportunities have opened for other industries. Facebook CEO Mark Zuckerberg has already tested exciting hand interaction feature and officially announced hand-tracking update for Quest, coming early 2020!

![Oculus Quest — hand interaction feature](https://cdn-images-1.medium.com/max/2560/1*WiOh5b7wTs4phPctqQ-vdg.jpeg)

![PlayStation Virtual Reality Website Design by [Kazi Mohammed Erfan](https://dribbble.com/kazierfan)](https://cdn-images-1.medium.com/max/2000/1*e_CbRfbzCAar13yq8e1YWg.png)

Sony and Microsoft will release their new generation consoles in 2020 holiday season. These would bring a lot opportunities and room to growth for VR technology.

---

![](https://cdn-images-1.medium.com/max/2000/1*Qmmrrxor4LVdpG5RqpleEA.png)

In the last years we have seen a lot of progress, excitement and improvement of AR. The world’s leading tech companies are investing millions into AR development , so we should expect to expand and grow this technology in 2020. Even Apple has introduced their own AR toolkit called [ARKIT 3](https://developer.apple.com/augmented-reality/arkit/) to help designers and developers build AR based products.

![Apple ARKit 3 by [Apple](https://developer.apple.com/augmented-reality/arkit/)](https://cdn-images-1.medium.com/max/5780/1*RRHUec5C2Q0aEdTv-t2aGQ.png)

![Public transit app by [Yi Li](https://dribbble.com/coreyliyi)](https://cdn-images-1.medium.com/max/3200/1*EQ1UOOlsA7ZuXQdkWNMRwA.png)

![House of Plants AR Concept by [Nathan Riley](https://dribbble.com/nathanriley)](https://cdn-images-1.medium.com/max/2000/1*rkl7gOWUrAMWPBvcAMeatQ.gif)

There are endless ****opportunities to innovate and create brand new and exciting experiences in AR space. UI design for AR will be one of the major trends in 2020, so as designers we should be prepared and eager to learn new tools, principles when creating AR experiences.

---

![](https://cdn-images-1.medium.com/max/2260/1*GIrEmNXeJKCjo4imwkk1Cg.png)

Generally speaking Skeuomorphic design refers to the design elements that are created in a realistic style/way to match the real life objects. The growth of VR/AR technology and latest design trends shown on the most popular design platforms (Dribbble, Behance etc.) might make skeuomorphic design comeback in 2020 — but this time with a lot modern fashion and slightly modified name: “New skeuomorphism” (also called **Neumorphism**).

![[Skeuomorph Mobile Banking | Dark Mode](https://dribbble.com/shots/8557373-Skeuomorph-Mobile-Banking-Dark-Mode) by [Alexander Plyuto](https://dribbble.com/alexplyuto)](https://cdn-images-1.medium.com/max/6400/1*jHc54zFmPjfdCFji2TB3-Q.png)

![Simple Music Player by [Filip Legierski](https://dribbble.com/kedavra)](https://cdn-images-1.medium.com/max/3200/1*BDEjVxl7yWdb7E5AU9nucQ.png)

![Sleep Cycle App — Neumorphism Redesign by [Devanta Ebison](https://dribbble.com/devantaebison)](https://cdn-images-1.medium.com/max/3200/1*isXyzOKNJYT66tsQDX3OLA.png)

As you’ve probably noticed: ****Neumorphism represents very detailed and precise design style. Highlight, shadows, glows — attention to details is very impressive and definitely on spot. Neumorphism has already inspired a lot of designers from all over the world and there is big chance that Neumorphism will be the biggest UI design trend in 2020.

---

![](https://cdn-images-1.medium.com/max/2000/1*pSfNETPuUqJsh8OR-0_r8Q.png)

In the last years we have noticed huge grown of asymmetrical layouts in digital product design. Traditional / “template” based layouts are definitely going away. 2020 will not be any different as this trend will continue. Proper usage of asymmetrical layouts add a lot of character, dynamic and personality to our designs, so they do not template based anymore.

![Limnia Fine Jewelry Grid — [Zhenya Rynzhuk](https://dribbble.com/Zhenya_Artem)](https://cdn-images-1.medium.com/max/3200/1*HNXaVNj-XfoIfZjCligjCw.png)

![[Carine fashion store — selection screen concept](https://dribbble.com/shots/5886207-Carine-fashion-store-selection-screen-concept) — [Dawid Tomczyk](https://dribbble.com/shots/5886207-Carine-fashion-store-selection-screen-concept)](https://cdn-images-1.medium.com/max/3200/1*Rnp7xmSbuhHhwvkWxt2H9w.png)

There is a lot of room for creativity as the number of options and opportunities when creating asymmetrical layouts are endless. Although, creating successful asymmetrical layouts requires some practice and time — placing elements randomly on the grid wouldn’t work :) also they should be used and implemented with care — always keeping in mind users needs : we do not want to get them lost when using our digital products — do we? :)

---

![](https://cdn-images-1.medium.com/max/2260/1*Eu_GNedAoQ_Dzl-tKBv9mg.png)

Stories play an very important role in overall UX in the digital product design. You might see them very often on the landing pages as introduction to the brand, product or new service. Storytelling is all about transferring data to the users in the best possible informative and creative way. This could be achieved by copyrighting mixed with strong and balanced visual hierarchy (typography, illustrations, high-quality photos, bold colours, animations and interactive elements).

![A+WQ / Young Lab Page Story of The Week Animation by [Zhenya Rynzhuk](https://dribbble.com/Zhenya_Artem)](https://cdn-images-1.medium.com/max/2712/1*sk8s9LyLmPUWeFMNccWX1A.png)

![Free Sketch Template :: Mimini by [Tran Mau Tri Tam](https://dribbble.com/tranmautritam)](https://cdn-images-1.medium.com/max/2000/1*cDpCrm_uTX7jEho18kFQIA.gif)

**Storytelling really helps to create positive emotions and relationships between your brand and users**. Storytelling might also make your brand a lot more memorable and making users feel like they are part of our products or services, so they would like to associate with them. Having said that, storytelling is also great and efficient marketing tool that might greatly increase the sales of your products/services. Storytelling as the very successful tool will continue and expand in 2020.

---

## Summary: 8 UI/UX design trends for 2020

#### #1 Animated Illustrations

By applying motion to illustrations we might really make our designs stand out and bring them to the life — adding extra details and personality.

#### #2 Microinteractions

Microinteractions are the perfect proof that details and attention to them might greatly improve the overall user experience of your digital products and place them on the next/higher level.

#### #3 3D Graphics in web and mobile interfaces

New web browser capabilities have opened the door for 3D graphic allowing us as designers to create and implement amazing 3D graphics into modern web and mobile interfaces.

#### #4 Virtual Reality

Gaming industry very often brings innovation and new technologies into digital product design.

#### #5 Augmented Reality

There are endless ****opportunities to innovate and create brand new and exciting experiences in AR space. UI design for AR will be one of the major trends in 2020, so as designers we should be prepared and eager to learn new tools, principles when creating AR experiences.

#### #6 Neumorphism

The grow of VR/AR technology and latest design trends shown on the most popular design platforms might make skeuomorphic design comeback in 2020 — but this time with a lot modern fashion.

#### #7 Asymmetrical Layouts

There is a lot of room for creativity as the number of options and opportunities when creating asymmetrical layouts are endless. Although, creating successful asymmetrical layouts requires some practice and time.

#### #8 Storytelling

Storytelling is all about transferring data to the users in the best possible informative and creative way. Storytelling is also great and efficient marketing tool that might greatly increase the sales of your products/services.

---

Which of the trends I’ve mentioned has got you the most excited? Is there any other trend that should have been included in the list? Please let me know In the comments section below! :) You might also check my previous articles:

* [**Master the basics of visual: how to become a self-taught UI/UX designer**](https://uxdesign.cc/how-to-become-a-ui-ux-designer-self-taught-8a511170fd7c)
* [**7 simple & effective methods to get better at Visual/UI Design**](https://uxdesign.cc/7-simple-methods-to-get-better-at-visual-ui-design-21fec0f417b5)
* [**Top 8 soft skills in UI/UX design**](https://uxdesign.cc/top-8-soft-skills-in-ui-ux-design-e1aedc783ac9)

If you have any questions please feel free to [email me](mailto:dawidtomczykgrafik@gmail.com) — always happy to help. You can also find me at: [Dribbble](https://dribbble.com/dawidtomczyk), [Behance](https://www.behance.net/dawidtomczyk), [Instagram](https://www.instagram.com/daviduxdesigner/), [Uplabs](https://www.uplabs.com/dawidtomczyk), [Facebook](https://www.facebook.com/dawidtomczykuxdesigner), [LinkedIn](https://www.linkedin.com/in/dawid-tomczyk-464b2b91/) or by visiting personal [**portfolio website.**](https://davidux.design/)

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
