> * 原文地址：[7 Rules for Creating Gorgeous UI (Part 2)](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96)
> * 原文作者：[Erik D. Kennedy](https://medium.com/@erikdkennedy?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-2.md](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-2.md)
> * 译者：[xujunjiejack](https://github.com/xujunjiejack)
> * 校对者：[maoqyhz](https://github.com/maoqyhz)

# 创造华丽 UI 的 7 个规则（Part 2）

## 一部出自于技术宅的通往视觉审美的指南

这是这个指南的第二部分，在此之前，你需要阅读[第一部分](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md)。

我们正在讨论可以让你不需要去上美术学院就可以设计**简洁 UI** 的规则。

下面是这些规则：

1. 光线来自天空。（查看[第 1 部分](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md)
2. 首选白色和黑色。（查看[第 1 部分](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md)
3. 添加更多的空白。（查看[第 1 部分](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md)
4. **学习如何在图片上添加文字**。
5. **令文本层次分明**。
6. **仅使用好看的字体**。 
7. **像艺术家一样借鉴**。

* * *

### 规则 4：学习如何在图片上添加文字

现在只有几种能够可靠得将文字精美得添加在图片上的办法。以下描述了 5 种常规和 1 种额外的方法。

如果你想成为一个很好的 UI 设计师，你需要学习如何用吸引人的办法把文字覆盖在图片上。每个优秀的UI设计师都会在这个方面处理得很好，但平庸的设计师往往处理得很糟糕，甚至不会处理。无论你是哪一种平庸的设计师，在读了这个章节后，你会有巨大的提升。

#### 方法 0：直接在图片上添加文字
我一直在犹豫是否要在这篇文章里包含这个方法，但是**严格来说**，直接在图片上添加文字并且让设计好看是**可行**的。

![](https://cdn-images-1.medium.com/max/800/1*cZFET5UcuL6rjVWkwqoK_A.png)

[Otter Surfboards](http://www.ottersurfboards.co.uk/) 看着像精致的 Instagram 配图，但是就是有点难读图片上面的字。

以下是这个方法的缺陷和注意事项：

1. **图片必须是黑色的**，并且没有很多高对比度。
2. **字体必须是白的** —— 我敢打赌你找不到一个又简单又干净的反例。**真的**，只有白色这一个。
3. 你需要**在每种显示尺寸下测试**文本是否清晰。

你的设计都符合这些条件了？棒。只要你之后别再改字或着这个图片，你应该就可以用你的设计了。

我不认为我在任何一个正规专业的项目里直接把文字覆盖到图片上。这个方法是一个需要很高技巧的方法，就是说这种方法虽然可能可以产生**非常酷炫**的效果，但使用的时候需要小心。

![](https://cdn-images-1.medium.com/max/800/1*aGKzy_8di06W8u1kmKcS4Q.png)

这是 Aquatilis 的网站，非常值得一看。

#### 方法 1：文本覆盖整个图片

在整个图片上覆盖一个图层可能是最简单的办法了。如果原始的图片不够黑，那你就可以在整个图片上加一个半透光的黑色图层。

这是一个非常流行的带有黑色图层的网站主页。

![](https://cdn-images-1.medium.com/max/800/1*-9qT-d3DcjmXV4vZkyBE8g.png)

这个 Upstart 的网站有 35% 透光度的黑色滤镜。

如果你打开 Firebug(译者注：Firefox 的 debug 工具)，你会发现原图因为亮度和对比度都比较高，所以字体看不清楚。但是当有了一个黑色的滤镜后，这些都不是问题！

这个方法用在缩略图和小的图片上同样好用。

![](https://cdn-images-1.medium.com/max/800/1*xvsvxW00oE9NuhbRUAUK2Q.png)

[Charity:water](http://www.charitywater.org/) 网站的缩略图。

黑色的图层尽管是最简单，并且用处最广泛的，你当然也可以用别的颜色的图层。

![](https://cdn-images-1.medium.com/max/800/1*0LUET8aQnpFvVB4yNhQj1Q.png)

#### 方法 2：把文本放框里

这实在是再简单不过了，但同时又很可靠。试试把一个微微透光的黑色长方形框覆盖在一些白色的文字上。如果这个图层足够透光，你依旧可以保证即使文字底下是任何图片，文字依旧清晰可见。

![](https://cdn-images-1.medium.com/max/800/1*J_7pHmSn6NvTuC3xFNIlqA.png)

Modern Honolulu 的 iPhone 设计稿 [Miguel Oliva Márquez](http://miguelolivamarquez.com/)。

你也可以往文本框里塞不同的颜色，但是当然要保持谨慎。

![](https://cdn-images-1.medium.com/max/800/1*6218qUE-AoaikksiQziL7Q.png)

现在这些是粉色的例子。作者是 [Mark Conlan](http://markconlan.com/)。

#### 方法 3：把图片模糊化

这个把底部图片模糊化来让人看得清楚上面的文本是出人意料得好用

![](https://cdn-images-1.medium.com/max/800/1*mC1oHWTKlRqOZ-ra3sLh-Q.png)

Snapguide 里用了大量的背景模糊化。注意看，这些模糊的区域同时也被加深过。

iOS 7 的设计真的让背景模糊化变得流行起来，虽然 Windows Vista 也用模糊化达到了非常好的效果。

![](https://cdn-images-1.medium.com/max/600/1*FkH2ZkCQ0wmT5FxmaAMzaA.jpeg)

![](https://cdn-images-1.medium.com/max/600/1*FyZBDM_gMoJ8bCK3zVr_Fg.png)

你也可以用照片里虚化的背景作为模糊化的区域。但是请注意 —— 这个办法并不好使。如果你的图片做了一点改变，你就得确保这些文字一直都是在模糊化的区域里。

![](https://cdn-images-1.medium.com/max/800/1*mZ22i_UB57qdFBZwOqUFFA.png)

[Teehan + Lax](http://www.teehanlax.com/)

我的点是，**试着**读清楚下面的小标题。

![](https://cdn-images-1.medium.com/max/1000/1*pMpduiy5C4LGu7abzj_a6g.png)

这[网站](https://www.google.com/wallet/send-money/)到底是怎么被通过的？

####　方法 4：底部逐渐变深

底部逐渐变深这个方法指的是你把图片里**靠近底部的地方逐渐变黑，然后接着把白字填在上面**。这是个非常巧妙的办法。我在看到 Medium 之前都没想到过。

![](https://cdn-images-1.medium.com/max/1000/1*_uPTqFCygpKPJoC5q0y1mg.png)

对于一个普通人，这些 Medium 上的收集的设计仅仅是图片上覆盖了些白色的文字-但是这种想法我说是很**错误**滴！从中部（0% 透光度的黑色）到底部（20% 透光度）有个小小的渐变。

这个渐变很难看出来，但是一定在那，而且绝对提高了字体的辨识度。

> 同时你可以注意一下这些 Medium 的收集缩略图用了一点点的文字阴影来更加提高识别度。这些人真的非常棒！

> 这个技巧的效果是 Medium 即使把任何文字放在任何图上，也可以得到能读的结果。

哦，还有一件事 — 为什么图片是往下变深？原因见我的[第一条规则](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md)-灯光一直是从上面照下来的。为了让眼睛看起来更舒服，图片必须要是在底下慢慢变深，就像我们看见的所有东西一样。

更高级的做法：如果把模糊化和底部渐变混起来...这就是底部模糊化了！

![](https://cdn-images-1.medium.com/max/800/1*vjezz0sSxlioqbEHbov_uw.png)

用在 SnapGuide 上的“底部模糊”。妈妈再也不用担心我在上面使用图层了！

#### 额外的办法：纱幕化

这个 [Elastica blog](http://www.elastica.net/category/blog/) 是怎么可以在任何的照片下有一个可以读得出的标题？而且这些图片是：

*   并不是特别黑的
*   有一点高对比度

我们很难解释为什么这些文字可以看得这么清晰。你看一下下面这些：

![](https://cdn-images-1.medium.com/max/600/1*UFnAScSM_SyiqI7g8e8Ajw.png)

![](https://cdn-images-1.medium.com/max/600/1*i1T-LV5JQMk95st51J8zDA.png)

答案是：纱幕化。

纱幕是一种让光变得更柔和的摄影装备。现在这也是种视觉设计的技术。这个技术通过让图片变得更柔和来让覆盖在上面的文字更加可以辨认。

如果我们用浏览器放大 Elastica blog 的网页，我们可以很清楚得看到发生了什么。

![](https://cdn-images-1.medium.com/max/800/1*BwU3s9dGxeUSpA-cIFuaHg.png)

在这句标题“145,000 Salesforce Users Come out to Celebrate…”有一个让透光度渐变的框。你应该可以很简单的注意到高对比度的照片下这个深蓝色的背景。

这可能是最**微妙**的把文字可靠得覆盖在图片上的办法，并且我在别的地方并没法看到（但是这个方法**真的是**很隐蔽）。但是把这个标记下来，你可能不知道你什么时候会用到。

* * *

### 规则 5：令文本层次分明

使得文字变好看并且符合背景的好办法经常是把文字往相反的方向 —— 比如说，变大但是更轻。

在我看来，创建漂亮的 UI 的最难的部分是调整文字 —— 并且这并不是因为缺少选项。如果你读过书，你大概用过所有的能让别人注意过文字的办法，或者让人不想看这些文字的办法：

*   **尺寸**（更大 或者更小）
*   **颜色**（更多或者更少对比度；明亮的颜色会吸引眼球）
*   **字重**（加深或者变轻）
*   **大小写**（小写，大写，或者用标题的格式）（译者注：中文并没办法做到）
*   **斜体**
*   **字符间距**（或者 —— 用 更 高 大 上 的 术 语 —— **字距!**)
*   **边距**（讲道理这并不是一个字体**本身的**性质，但是可以用来吸引别人的注意，所以它可以出现在表上）

![](https://cdn-images-1.medium.com/max/800/1*D7QBHz4TqdxzXphdioU_gg.png)

颜色，大小写，和字据用得不错。这是[@workjon](http://twitter.com/workjon)的孩子做的。当然，也关注下[@workjon](http://twitter.com/workjon) —— 他的文字设计很棒！

这里有几个别的可以吸引别人注意的选项，但是并不常用同时也不是很推荐。

*   **下划线**下划线现在基本意味着是超链接，并且要我说，下划线并不值得我们去给它负于任何意义。
*   **字体的背景颜色**并不常见，但是这个 37signals 网站把它用做超链接。
*   **删除线**你个 90 年代的 CSS 魔术师给我滚开，没错，就是指你！

在我个人的经验里，当我发现一个我没办法找到合适的文本样式的时候，并不是因为我忘记了如何用大写或者更深的颜色 — **一般是因为最好的解决办法经常需要把一些互相冲突的性质组合在一起**。


#### Up-pop 和 Down-pop

你可以把所有的调整文字的方法分成以下两个组：

*   **那些提高可见度的样式**大，粗，大写等等。
*   **那些降低可见度的样式**小，少对比度，小边距等等。 

我们会分别把这些叫做 "up-pop" 和 "down-pop" 的样式，以纪念 [favorite adjective](http://theoatmeal.com/comics/design_hell)。

![](https://cdn-images-1.medium.com/max/800/1*cT-Y5jcbdrUdO2JiBf8fZg.png)

从 [hugeinc.com](http://hugeinc.com/case-study/material-design) 来的案例分析。

“材料设计”（Material Design）里有很多 up-pop 的内容。它是**大**的；它是**高对比度**的；它是**非常****粗**的。

![](https://cdn-images-1.medium.com/max/800/1*yVbtuu-qvhFRXNwWKBvL-A.png)

这些底下的东西，但是，是 "down-pop" 的。他们是**小**的，**低对比度**，并且很**细**的。

现在是非常重要的内容。

> **这个页的标题是仅有的用上了所有 up-pop 方法的文本**。
> 对于所有别的东西，你需要 **up-pop 并且 down-pop**。
 
如果需要强调一个网站的内容元素，需要同时用上 up-pop 和 down-pop 的办法。这么做可以允许不同的内容元素看上去有不同的样子，防止你的东西被淹没。

![](https://cdn-images-1.medium.com/max/800/1*8YceqPbM08OB2kjJPEWzow.png)

这是一个视觉要素的平衡。

这个完美设计的 Blu Homes 网站有很多大标题，但是**需要强调的字都是小写** —— 太多的强调会看上去用力过猛。

![](https://cdn-images-1.medium.com/max/800/1*C0snGn4IAUg_KEjwwPQN3w.png)

Blue Homes 网站用了字的尺寸，颜色赫尔排列来吸引你眼球的数字 — 但是注意，他们并没选择用深灰色，**反而同时用了很轻的字重，低对比度的颜色**。

这些**在文字底下小小的标签**，然而，是灰色的，并且是即**大写**又**非常粗重**的。

这些都和平衡有关。

![](https://cdn-images-1.medium.com/max/800/1*phgw7PCxtkr78p0Td9yHcA.png)

contentsmagazine.com

Contents Magazine 是一个 up-pop 和 down-pop 很不错的案例分析。

*   这些**文章标题**基本上是**仅有的非斜体的网页要素**。在这种情况下，**缺少**斜体更加得吸引眼球（尤其是当和加粗的字重组合的时候）。
*   在 by 的这一行里的**作者名字**是被加粗的 — 让它和平常字重的 "by" 分别了开来。
*   这个小的，低对比度“**已经跳出来的**”字体给其他的要素让出了位置 —— 但是因为大写，很宽的字间距，和很大的边距，你可以在想看这些字的时候清楚得看到这些字。

#### 选取和悬浮的样式

调整被选择的元素和漂浮的效果是同一种文字游戏的另一个可能 —— 但是会更难。

变化字体的尺寸，大小写，或者字重经常会**改变文字占据多少空间**。这种变化可以限制住悬浮效果。

所以你还剩下哪些选项呢？

*   字的颜色
*   背景颜色
*   阴影
*   下划线
*   轻微的动画 — 提高，降低，等等。

一个很可靠的选择是：尝试把白色的元素放上颜色，或者把有颜色的元素变白，但同时加深后面的背景

![](https://cdn-images-1.medium.com/max/800/1*_9M8qJFXvB7cEabkV-8qrw.png)

这个选择的按钮从有颜色变成白色，但是依旧相对于背景保持高对比度。

我会送给你这个段话：**调整文本的样式是很难的**。

但是每次我在想“这个文本大概就是**不可能**看上去好看的”，我都是错的。我只需要逐渐变得更擅长。同时，去变得更擅长，我只要不断进行尝试就行了。

所以我提供给你个慰藉：如果这个文字看上去不好看，不要担心 —— **只要**你能变得更擅长。但是，嘿，让我们不断尝试，使自己**变得很强**!

**嘿，顺便说一句：如果你想学更多和调整文字样式有关的东西，看看这个** [Learn UI Design](http://learnui.design/?utm_source=medium&utm_medium=content&utm_campaign=7-rules-part-2)**，我在这里讲了更多细节**。

* * *

### 规则 6：仅使用好看的字体

**有些字体很好看。就用他们。**

**注意：在这个部分里，没有什么需要学习的策略或别的什么。我只会列出一些好看的字体然后供你去下载，接着运用。**

**注意 #2：由于前几年字体的选项得到了扩展，**并且**有些字体都快用烂了，今天我会特别推荐一些特别的字体组。如果你想看更多的字体，可以阅读** [Learn UI Design](http://learnui.design/?utm_source=medium&utm_medium=content&utm_campaign=7-rules-part-2)，这里面有一套可以交互的完整版的字体。（译者注：这篇文章只推荐了英文字体，不一定适用于汉字）

**特殊格调**的网站能用非常**特殊的字体**但是对于大部分的 UI 设计，你只希望一些**简单和干净**的字体。所以兄弟，没错，别用 [Wisdom Script](http://www.losttype.com/font/?name=wisdom_script)。

同时，我也**只推荐免费的字体**。为啥？这份学习指南是给**学习者的**。外面有超多免费的字体，所以就让我们用吧。

我推荐你现在就下载，然后当你开始为项目设计的时候就用。

![](https://cdn-images-1.medium.com/max/800/1*5Uv1DnYGFp5vG4RvW4QdXA.png)

这个 Font Book 应用里“用户”这一栏可以很方便得帮你记住你下载了什么。

![](https://cdn-images-1.medium.com/max/800/1*J_5zAxGLGQxma9wq5mZAYw.png)

Ubuntu

**Ubuntu** (以上)。有非常多的字重。对于某些应用有点过于特殊了 — 不过对别的就很完美。可以在[Google Fonts](http://www.google.com/fonts/specimen/Ubuntu) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*qeIEbAW5ylrBL7SYjGfq5Q.png)

Open Sans

**Open Sans**（以上）。一个读起来容易也很流行的字体。时候正文部分。可以在 [Google Fonts](http://www.google.com/fonts/specimen/Open+Sans) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*YWlIwiUEZU184CBTxhS3sw.png)

Bebas Neue.

**Bebas Neue**（以上）。做标题很棒。全是大写的。可以在 [Fontfabric](http://fontfabric.com/bebas-neue/) - 这里面有很棒的“Bebas Neue in use”的展示。

![](https://cdn-images-1.medium.com/max/800/1*lXoXBsreAzsDUNakvTTcQg.png)

Montserrat

**Montserrat**(以上)。只有两种字重，但是足够用了。绝对是最好的 Gotham 和 Proxima 的免费替代品，但是并没有这两个好。可以在 [Google Fonts](http://www.google.com/fonts/specimen/Montserrat) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*ffj71mDykTq41o2P2Y7XUA.png)

Raleway

**Raleway**（以上）。对于标题非常好；可能对于文本正文**有点** 过了（你看那些 W）。有非常好看得极细的字重（并没有照片）。可以在 [Google Fonts](http://www.google.com/fonts/specimen/Raleway) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*1ZvAfIv56PYBxJe0cvWzqw.png)

Cabin

**Cabin**(以上)。可以在 [Google Fonts](http://www.google.com/fonts/specimen/Cabin) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*u0LHdpKxw076R1MGNWemiQ.png)

Lato

**Lato**(以上)。可以在 [Google Fonts](http://www.google.com/fonts/specimen/Lato) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*st1Z0NEH4ORQKnUyBojmqQ.png)

PT Sans

**PT Sans**(以上)。可以在 [Google Fonts](http://www.google.com/fonts/specimen/PT+Sans) 上找到。

![](https://cdn-images-1.medium.com/max/800/1*MntHOFiV1tpNPoPp76Wovw.png)

Entypo Social

**Entypo Social** (以上)。这是个图标字体。没有错，一旦你用了 Entypo,你会在**所有地方**看到它，但是这些社交网站的图标真是太棒了。不想在小小的有颜色的圈圈里重新创造一堆社交网站的 logo？没错，我也不想。在 [Entypo.com](http://www.entypo.com/) 可以找到。

我会在这里给你留下一些资源：

*   [**Beautiful Google web fonts**](http://hellohappy.org/beautiful-web-type/)。这个网站**非常棒**得展现出 Google Fonts 能有多好看。我从它那找了好多好多次灵感。
*   [**FontSquirrel**](http://www.fontsquirrel.com/)。一堆最棒的商业用途的字体，并且全部都是免费的。
*   [**Typekit**](https://typekit.com/)。如果你有 Adobe Creative Cloud（就是订购了 Photoshop 或者 Illustrator 等等），那么你可以有免费用到很棒的字体。没错，连 [Proxima Nova](https://typekit.com/fonts/proxima-nova) 都有！

* * *

### 规则7：像艺术家一样借鉴

当我第一次试图坐下来然后设计应用的元素的时候 —— **一个按钮，一个表格，一个图标，一个弹出框， 所有的所有** —— 也是我第一次意识到自己对于如何让一个元素好看的知识是如何匮乏的时候。 

但是多幸运的是，我并不是一定需要创造出什么新的 UI 元素。这就意味着我可以一直看别人是如何做的然后从中间挑点好的。

但是我们要从哪里挑呢？这里有。

#### [1. Dribbble](http://dribbble.com)

这个特邀的“给设计师展示”网站有**网络上最好质量的 UI 设计作品**。你可以在这里找到几乎最好的网站。

事实上，**你应该**关注我在 Dribble 上的作品[**这里**](https://dribbble.com/erikdkennedy)。这里也有一些人你可以关注：

*  [Victor Erixon](https://dribbble.com/victorerixon)。他有一个非常独特个人样式 — 并且他的作品**很棒**。漂亮，干净，扁平的设计。这货做设计师只有大概 3 年，但是他已经是做得很顶尖了。
*  [Focus Lab](https://dribbble.com/focuslab)。这些人是“Dribbble 名人”，并且他们的作品名副其实。非常多元化；一直是最顶尖的。
*  [Cosmin Capitanu](https://dribbble.com/Radium)。一个非常厉害的多面手。他做得东西未来感十足，但又不过于高调。他**非常**善于使用颜色，然而他并不十分注重 UX 的东西 — 当然这个批评也针对 Dribbble 这个网站。

![](https://cdn-images-1.medium.com/max/400/1*RBeNdi_ihQcqPkhDDB9Iig.png)

![](https://cdn-images-1.medium.com/max/400/1*Ak6v-B69tzGoLQL9pjh1Yg.png)

![](https://cdn-images-1.medium.com/max/400/1*FO0Qaq9QDSF4R7p-ZFzpLg.jpeg)

这些分别都是 [Victor Erixon](https://dribbble.com/victorerixon)，[Focus Lab](https://dribbble.com/focuslab) 和 [Cosmin Capitanu](https://dribbble.com/Radium) 的作品。

#### [2. Flat UI Pinboard](https://www.pinterest.com/warmarc/flat-ui-design/)

我压根没听说过 "warmarc"，但是他手机 UI 的 pinboard（译者注：pinboard 指的是 pininterest 里的专栏) 在我绞尽脑汁找好看的 UI 时候**令人震惊**得好用。

![](https://cdn-images-1.medium.com/max/800/1*eDgNkeU45KBKvw1Tb35WJw.png)

#### [3. Pttrns](http://pttrns.com/)

这里有一个列表的移动应用的截图。Pttrns 的好处是它整个网站是按照 —— 你懂得 —— UX 模式。这可以帮助你非常快速得搜索各种界面要素，无论你在做什么，管它是登录界面，用户信息，搜索结果，等等。

![](https://cdn-images-1.medium.com/max/1000/1*Cacg0SgS2Mm7n-qaZyj6TQ.png)

* * *

我是那句**直到善于能模仿最好的作品之前，所有艺术家都应该是只鹦鹉**的坚信者。之后你就可以你自己的风格；开发出新的潮流。

在这之间，让我们像小偷一样作图。

这个章节的想法中，“像艺术家一样借鉴”是从这本书[eponymous book](http://www.amazon.com/gp/product/0761169253/ref=as_li_tl?ie=UTF8&camp=1789&creative=390957&creativeASIN=0761169253&linkCode=as2&tag=e03fd7-20&linkId=EOZRG5UP4D6JMFIR)中借鉴出来的。我并没有读那本书，主要原因是这个标题很好的概括了这本书里想表达的想法。

* * *

### 总结

我写这篇文章是因为我希望自己在以前可以读到这篇。我希望这篇可以帮助你。如果你是个 **UX 设计师**，在你素描出个大框架后做一个好看的 mockup。如果你是个**开发者**，接手下一个自己的项目然后让它变得很**好看**。我不希望需要去上几年艺术学校才能做好的 UI。只要**观察**，**模仿**，并且**告诉你的朋友哪些可以用**。

无论怎么样，这是迄今为止我学到的所有东西，同时我也一直会是个初学者。


—-

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
