> * 原文地址：[7 Rules for Creating Gorgeous UI (Part 1)](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-1-559d4e805cda)
> * 原文作者：[Erik D. Kennedy](https://medium.com/@erikdkennedy?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md](https://github.com/xitu/gold-miner/blob/master/TODO1/7-rules-for-creating-gorgeous-ui-part-1.md)
> * 译者：[wzasd](https://github.com/wzasd)
> * 校对者：[xujunjiejack](https://github.com/xujunjiejack)、[lihanxiang](https://github.com/lihanxiang)

# 创造华丽 UI 的 7 个规则（Part 1）

## 数学美学的非艺术性入门指南

### 介绍

好的，让我们先说重要的事。这个指南并不适用于所有人。那这本指南的目标用户是谁呢？

*   **开发人员** 希望能够在一个开发中设计一个属于他们的看起来很不错的用户界面。
*   **UX 设计师** 希望他们的产品组合看起来比五角大楼幻灯片更好看。或者那些知道他们可以在一个漂亮的 UI 中更好的实现他们出色的用户体验的设计师。

如果你去过艺术学校或者自认为已经是一名 UI 设计师，那么你可能发现这个指南结合了 a.) 无聊、b.) 错误和 c.) 令人生气。没关系，您的所有批评一定都是对的。让我们一起关闭标签。


让我告诉你会在本指南中找到什么。

首先，我是一名没有任何 UI 技能的 UX 设计师。我**热爱** UX 设计，很久以前，我并不关心用户界面，在我意识到有很多好的理由来学习如何使界面看起来不错后，才下定决心学习。

*   我的作品集看起来很糟糕，没办法充分反应我的思考过程和我的工作。
*   咨询我 UX 的客户宁愿购买其他人的技能，因为他们的专长不仅仅是绘制箱子和箭头。
*   我是否像在某个时期进行创业工作？最好做一个清扫工。

我有我自己的借口。**我并不理解美学，因为我认为他们都是在说废话，我主修工程学 — 我都快以创造一些难看的东西为荣了。**

> **“我并不理解美学，因为我认为他们都是在说废话，我主修工程学 — 这简直就是一种标签，我都快以创造一些难看的东西为荣了。”**

最后，我终于学会了到底什么是应用程序的美学，就像是我努力学习其他创作的事物一样：**冷静，理性分析**。厚颜无耻的复制了有用的东西。我已经在一个 UI 项目上工作了 10 个小时，然而实际只为了项目付出了 1 个小时。其他 9 个小时拼命搜索谷歌、Pinterest 和 Dribbble 去里面复制有用的东西！

我在这些时间里学到的教训。

**对于书呆子而言：如果我现在擅长设计用户界面，那是因为我已经分析很多东西 — 而不是因为我通过直观的对美以及平衡的理解才走出误区。**

这篇文章并不是理论的阐述。只是很纯粹的应用文章。你不会看到关于黄金分割线的任何信息。我甚至不会提色彩理论。只有我从错误学到的东西，并不断将进行[刻意练习](http://calnewport.com/blog/2010/01/06/the-grandmaster-in-the-corner-office-what-the-study-of-chess-experts-teaches-us-about-building-a-remarkable-life/)。

用这种方式思考：柔道是根据几个世纪的日本武术和哲学传统演化而来的。你参加了柔道课程，除此之外，你还会听到关于能量、流动以及和谐等知识。

另一方面，Krav Maga 则是由一些在 30 年代捷克斯洛伐克犹太人在街头与纳粹抗争时发明的。那并没有**艺术**在中间。在 Krav Maga 课程中，你将会学到如何用笔刺入某人的眼睛。

这是屏幕中的 Krav Maga。

#### 规则

规则在这里:

1.  **光线来自天空。**
2.  **首选白色和黑色。**
3.  **添加更多的空白。**
4.  **学习如何在图片上添加文字。**（查看[部分](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96) 2）
5.  **使文本弹出和取消弹出。**（查看[部分](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96) 2）
6.  **只使用好看的文体。**（查看[部分](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96) 2）
7.  **像艺术家一样借鉴。**（查看[部分](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96) 2）

让我们开始吧。

### 规则一：光线来自天空

**阴影是最有效的提示，用来告诉人类的大脑哪些是他们正在查看的用户界面的元素。**

这也许是**容易被忽视却很重要**去学习 UI 设计的一个内容：**光线来自天空。**光不断的从天空而来，因此如果光从下而上则确实看起来非常怪异。

![](https://cdn-images-1.medium.com/max/400/1*eFJGYuA67SIzu9pB1MZFKQ.jpeg)

妈呀~

当光线来自于天空的时候，它照亮了物体的顶部并在其下面投下阴影。物体的顶部较为明亮，底部较暗。

你绝不会**认为**人们的下眼皮是需要画出来眼影的，但是当一个化了下眼影的女孩突然出现在他们门前的时候确实会亮瞎那些呆子的眼睛。

那么，用户界面也正是如此。正如我们在所有的面部特征的下侧都有少量的阴影，几乎每个 UI 元素的底部都有可以被发现的阴影。**我们的屏幕是平的，但是我们投入了大量的艺术创作来制作出 3D 的效果。**

![](https://cdn-images-1.medium.com/max/800/1*DTB4xeMLpg0DW6NLOYBehw.png)

这张图片中我最喜欢的就是右下角的手指。

拿按钮举例。即使有了这个相对“平面”的按钮，仍然有一些与光线相关的细节：

1. 按钮没有按下的时候具有**黑色的底部边缘**，太阳并没有照耀到的位置。
2. 按钮没有按下的时候**顶部会亮一些**对比底部。这是因为它模仿了一个稍微弯曲的表面。就像当你需要倾斜一面在你面前的镜子来观察太阳一样，在上面的镜面会向你的身上反射多一丁丁丁丁点的阳光。
3. 按钮没有按下的时候投射了**微妙的阴影** — 如果放大可能看的更清楚一些。
4. 按下的按钮虽然底部比顶部暗一些，但是**整体颜色更深**，因为他们虽然位于屏幕的平面上，太阳并不容易照射到它。有人可能会说我们在现实生活中看到的所有按钮都会变暗，因为我们手挡住了光线。

这只是一个按钮，然而这里有四个小小的灯光效果。这些灯光效果就是我们的经验。现在我们应该将它用于**所有的东西**。

![](https://cdn-images-1.medium.com/max/800/1*4FCAIgmJa8BuildjlnsDeA.png)

虽然 iOS 6 有点过时了，但是它在光照行为方面确实是很好的研究案例。

这里有一对 iOS 6 设置 — “请勿打扰”和“通知”。很简单，对吧？但是看看他们有多少灯光效果。

*   插图的控制面板边缘投下了一个小阴影。
*   “ON” 滑块轨道也跟着设置了一点。
*   “ON” 滑块轨道为凹型，底部反射了更多的光线。
*   图标**边缘**被设置了一点点。看到他们顶部的明亮边框了吗？这代表一个垂直于光源的表面。因为垂直，所以这个表面接受了大量的光线，将大量的光线反射到眼睛中。
*   分隔的凹口在远离太阳的部分被遮盖，反之亦然。

![](https://cdn-images-1.medium.com/max/800/1*gWuSN3QN9dSeVwSP2LZVow.png)

**分割线的凹槽的特写镜头。来自我的一个旧 [Hubster](http://hubster.tv/) 概念。**

通常在**嵌入**的界面元素：

*   编辑栏
*   按下的按钮
*   滑块
*   单选按钮（未选中）
*   复选框

通常在**突出**的元素：

*   按钮（未按下）
*   滑块按钮
*   下拉控件
*   卡块
*   所选单选按钮的 **button** 部分
*   弹出窗口

现在你知道了，你会注意到他们到处都是。不客气，初学者。

#### 等等，扁平化设计怎么样呢，Erik?

iOS 7 让“半扁平化设计”在科技界引起了轰动。这就是说他的**半扁平化。** 没有模拟凸起或者凹痕 — 只是纯色的线条和形状。

![](https://cdn-images-1.medium.com/max/800/1*YAB8zDDxCmvegvxCu7d8kw.png)

我虽然和大家一样喜欢**干净和简单**。但是我认为这不是一个长期的趋势。如何将我们的界面用 3D 来在细微处进行模拟的更加自然是不能完全放弃的。

**更多的可能是，我们将会在不久的将来看到半扁平化的 UI 设计**（而且我建议你精通这种设计）。我们将会继续称之为“扁平化设计”。依旧干净，依旧简单简单，但是会有**一些**阴影和点击/滑动的提示。

![](https://cdn-images-1.medium.com/max/800/1*gWvCSNxqNjyYaq4IF31ZhQ.png)

OS X Yosemite — 扁平化而不平面化。

在写这篇文章时，Google 正在他们的产品中推出他们“Material 设计”语言。这是一种统一的视觉语言，它的核心理念就是模仿现实的世界。

Material 设计指南中的例证展示了如何使用不同的阴影来表达不同的深度。

![](https://cdn-images-1.medium.com/max/800/1*TtuBo6cCUTyP8XIYGSrIyg.png)

![](https://cdn-images-1.medium.com/max/400/1*sHg3HCEciqqAk1xE8qMrdg.png)

我感觉这种东西是一种长期的趋势。

它使用了现实世界的微妙的线索来传达信息。**关键词，微妙。**

我们并不能说它没有模拟现实世界，但是它又不像是 2006 年的网络。没有纹理，没有渐变，没有发光。

我认为扁平化是未来的一种方式，平面化？切，只是过去而已。

![](https://cdn-images-1.medium.com/max/800/1*Zqcjyz-oIqZZojyYyWVl2Q.png)

这样的平面化设计现在看起来很火！

### 规则 2：黑色和白色优先

**在添加颜色之前进行灰度设计可以简化视觉设计中最复杂部分 — 并且可以使强迫使您专注于间距和布局元素。**

UX 设计师现在真的是“移动优先”来进行设计。这意味着您在想象无法想象的像素的 Retina 显示器前**优先**考虑手机上的页面和互动是如何工作的。

**其实这种约束很好。它可以简化思想。**您从较难的问题开始（在小屏幕上可用的应用程序），然后通过同样的解决方案去解决简单的问题（大屏幕上可以使用的应用程序）。

那么这里就是一种类似的约束：**优先设计黑色和白色**。首先是在没有色彩的帮助下让应用变得美观并且可用。**最后添加色彩，仅此而已。**


![](https://cdn-images-1.medium.com/max/800/1*qheNNhQhjjwxMeJ5XGocsA.png)

[Haraldur Thorleifsson](http://ueno.co/) 的灰度线框看起来就如同极少的设计师完成的网站设计一样好。

这是保持应用程序“干净”和“简单”最可靠也是最简单的方法。**在过多的地方使用过多的颜色很容易搞砸设计的简单和干净**。黑和白优先这个原则强迫你首先关注诸如间距，尺寸和布局等事情。这些都是干净简单设计的首要关注点。

![](https://cdn-images-1.medium.com/max/600/1*YxV7C-nHHir-PSbJ4-jqhQ.png)

![](https://cdn-images-1.medium.com/max/400/1*RckBhZxKQfveClU7rwGuyg.jpeg)

![](https://cdn-images-1.medium.com/max/400/1*EnbssykGOuXeXMV3AQFyjw.png)

优雅的灰度

有些情况下黑白优先的原则并不是那么有用。那些需要特殊感觉的设计 — “动感”、“华丽”或“卡通”等等。需要一个能够非常好使用多种颜色搭配的设计师。但是**大多数的应用程序没有一个特别强烈的需求属性，除了“干净”和“简洁”**。那些需要特殊设计的很难设计。

![](https://cdn-images-1.medium.com/max/600/1*OraO1vxtkxYteZyE4CXrOQ.png)

![](https://cdn-images-1.medium.com/max/600/1*JsbQFaIY6g697PMeEuMwvA.png)

[Julien Renvoye](http://www.julienrenvoye.fr/) （左）和 [Cosmin Capitanu](http://radium.ro/) （右）的华丽和充满活力的设计。比看起来更难。

对于其他的设计来讲，都是黑和白优先原则。

#### 步骤 2：怎么去添加颜色

只加一种颜色是能添加的最简单的颜色。

![](https://cdn-images-1.medium.com/max/800/1*YxV7C-nHHir-PSbJ4-jqhQ.png)

添加一种颜色在灰度设计的网站可以很简单而又有效的吸引眼球。

![](https://cdn-images-1.medium.com/max/800/1*pds21170RP-6ZIkuSxgI2Q.png)

您同样可以采取更深的一步。灰度 + **两种**颜色，或者灰度 + 单一色调的多种颜色。

> **让我们用下颜色代码 — 等等，什么是色调？**

> 网页上大体将颜色作为 RGB 十六进制代码进行讨论。其实忽略他们才是最有用的。RGB 并不是适合着色设计的一个有用的框架。[HSB](https://learnui.design/blog/the-hsb-color-system-practicioners-primer.html)（与HSV同义，与HSL类似）更有用。

> HSB 比 RGB 更好，因为它符合我们对颜色自然的看法，并且您可以预测 HSB 值的变化所给您看到颜色来带的影响。

> 如果这对你来说是个新的东西，这里 [HSB 颜色的优质入门文章](https://learnui.design/blog/the-hsb-color-system-practicioners-primer.html)。

![](https://cdn-images-1.medium.com/max/800/1*tZRxO2DReDduBqOwgqd_yw.jpeg)

单色调金色主题来自 [Smashing Magazine](http://www.smashingmagazine.com/2010/02/08/color-theory-for-designer-part-3-creating-your-own-color-palettes/)。

![](https://cdn-images-1.medium.com/max/800/1*-rbrbh20EHL_Ue_IDxl_0A.jpeg)

单色调蓝色主题来自 [Smashing Magazine](http://www.smashingmagazine.com/2010/02/08/color-theory-for-designer-part-3-creating-your-own-color-palettes/)。

通过修改单色调的**饱和度**以及**亮度**，您可以生成多种颜色 — 深色、亮色、背景、重点以及各种吸引注意的效果 — 而且不会让人眼花缭乱。

使用来自一种或者两种基本色调的多种颜色是为了**在保持设计不凌乱的同时又可以强调和中和元素**的最可靠的方法。

![](https://cdn-images-1.medium.com/max/800/1*_fM8VVYx7hMgdJ_Wy24AXg.png)

倒数计时器来自 [Kerem Suer](http://kerem.co/)。

#### 关于颜色的其他一些说明

色彩是视觉设计中最复杂的领域。虽然很多关于色彩的东西在你完成设计时并不是很实用，但是我却看到了一些非常有用的东西。

一个小工具箱：

*   [**学习 UI 设计**](http://learnui.design/?utm_source=medium&utm_medium=content&utm_campaign=7-rules-part-1)。无耻的推广：这是我创建的一门课程，它包含3个小时的关于颜色设计的视频（以及在 UI 设计中的其他主题总共13个多小时）。请看 [**learnui.design**](http://learnui.design/?utm_source=medium&utm_medium=content&utm_campaign=7-rules-part-1)。
*   [**设计色彩学：（实用）框架**](https://medium.com/@erikdkennedy/color-in-ui-design-a-practical-framework-e18cacd97f9e)。如果你喜欢这个部分，但是希望听到更多的**颜色**（而不仅仅是黑色和白色），这是属于你的文章。猜猜是谁写的！
*   [**永远不要用黑色**](http://ianstormtaylor.com/design-tip-never-use-black/) （Ian Storm Taylor）。这篇文章谈论了完全平面化的灰色几乎从来没有出现在现实世界中。同时它也提到了如何饱和灰色阴影 — 尤其是深色阴影 — 为设计增添了视觉丰富性。另外，饱和的灰色其实更贴近现实世界，这是它最美的地方。
*   [**Adobe Color CC**](https://color.adobe.com)。一个很棒的工具，用于查找、修改和创建配色方案。
*   [**Dribbble 通过颜色进行搜索**](https://dribbble.com/colors/BADA55)**。** 另一种很棒的方式来查找特定颜色的作品。如果您已经确定了一种颜色，那就看看世界上最好的设计师是怎么与这种颜色搭配。

### 规则 3：多用空白

**为了让 UI 看起来设计感十足，要添加更多的呼吸空间。**

在规则 2中，我说使用白或者黑原则迫使设计者在考虑颜色之前考虑**间距**和**布局**，为什么这是件好事，那么，现在就是讨论如何进行间距和布局的构造。 

如果您从头开始编写 HTML 代码，你可能很熟悉HTML在页面上默认的布局方式。

![](https://cdn-images-1.medium.com/max/800/1*fS6ixQIk88MJlEmph7PeJA.png)

基本上，所有的东西都拥挤在屏幕的顶部。字体很小，线条之间是绝对没有空间的。段落之间确实有一**丢丢**空白，少得可怜。段落只是延伸到页面的末尾，无论是 100 px 还是 10000 px。

从审美的角度上来讲，这太**糟糕**了。**如果你想让你的 UI 看起来很有设计感，您需要在这之间添加呼吸的空间。**

有时候就是一个荒谬的数值。

> **HTML 和 CSS 的留白**

> 如果你像我一样经常使用 CSS 进行格式设置，那么**默认情况下不会有留白的**，现在是时候解决这些不良的习惯了。开始考虑将空格作为默认空间 — 所有的内容都是以空格开始，直到您通过添加页面元素将其删除。

> 听起来像是禅学？我认为这是人们仍然素描出这些东西的重要原因。

> **从空白页开始意味着以空白**开头。您从一开始就会想到利润率和间距。您绘制的所有内容都是有意识的去删除空白。

> **从一堆无格式的 HTML 开始，意味着就是以内容**开头，间距则是后来才考虑的事情。这必须明确说明。

以下是 [Piotr Kwiatkowski](http://www.piotrkwiatkowski.co.uk/) 的音乐播放器概念图。

![](https://cdn-images-1.medium.com/max/1000/1*qFwXZ_05pRv2OtiaJHIp6Q.jpeg)

要特别注意左侧的菜单。

![](https://cdn-images-1.medium.com/max/400/1*jSC64LYfVYlMHaI_B7xfKQ.png)

左侧菜单

菜单项之间的垂直空间完全是文本本身高度的**两倍**。您注意到这是 12px 的字体，并且在上面和下面填充同样多的间距。

或者看看标题列表。**“PLAYLISTS” 和它自己的下划线之间有 15px 的间距。这比字体本身的**[高度](http://en.wikipedia.org/wiki/Cap_height)还要高。更别提每个列表之间间隔了25个像素了。


* * *

![](https://cdn-images-1.medium.com/max/400/1*43qoikq5esyOer2PpETX_Q.png)

顶部导航栏中有更多的空间。文字 “Search all music” 是导航栏高度的 20%。图标也是相应的比例。

左侧边栏显示了充裕的文本行间的间距，等等。

Piotr 认真考虑在这里增加更多的空白，并且效果很好。尽管这只是他为了更有乐趣（据我所知），就美学而言，它非常漂亮，足以与最好的音乐用户界面进行竞争。

* * *

适当的留白可以使一些复杂的界面看起来很简单 — 就像是论坛。

![](https://cdn-images-1.medium.com/max/800/1*g6m0YZVyMEVMuLXzO512gg.png)

论坛的设计来自于 [Matt Sisto](http://sis.to/)。

或者维基百科。

![](https://cdn-images-1.medium.com/max/800/1*SVtl39B-dSsHo3HFI0h4FA.png)

维基百科设计理念来自 [Aurélien Salomon](https://www.behance.net/aureliensalomon)。

你可以找到更多的样例，比如说，维基百科的重新设计舍弃了一些关键的网站的功能。但是你不得不说这是一个很好的学习方式！

在你的线条之间预留空间。

在你的元素之间预留空间。

在你的元素组之间预留空白。

**分析可行性**。

* * *

**好的，第一部分已经完结，感谢你坚持看完！**

在 [Part 2](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96)，我会继续讨论剩下的 4 条规则:

> **4. 学习在图片上叠加文字的方法。**

> **5. 使文本弹出或者取消弹出。**

> **6. 只使用优秀字体。**

> **7. 像艺术家一样复制。**

如果你学到了有用的东西，[读 Part 2](https://medium.com/@erikdkennedy/7-rules-for-creating-gorgeous-ui-part-2-430de537ba96)。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
