> * 原文地址：[7 Principles of Icon Design](https://uxdesign.cc/7-principles-of-icon-design-e7187539e4a2)
> * 原文作者：[Helena Zhang](https://medium.com/@minoraxis)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/7-principles-of-icon-design.md](https://github.com/xitu/gold-miner/blob/master/TODO1/7-principles-of-icon-design.md)
> * 译者：[Jessica](https://github.com/cyz980908)
> * 校对者：[Chorer](https://github.com/Chorer)，[niayyy-S](https://github.com/niayyy)

# 关于 icon 设计的 7 个准则

> 明确性、可读性、校准、简洁性、一致性、特性、易用性。

![](https://cdn-images-1.medium.com/max/9600/1*a-zerv-uouThOe0ItxW8bQ@2x.png)

打造出一套高质量的 icon 库需要深思熟虑、专业的眼光、一些迭代和大量的实践。在这篇文章中，我将通过 7 个准则和大量的实际例子来说明 **高质量** icon 库的特征。希望您从中能学习到设计优秀 icon 的技巧。

## 明确性

icon 的主要目的是快速传达一个概念。

![普锐斯主仪表盘上的 icon（来自：[2020 年手册](https://www.toyota.com/t3Portal/document/om-s/OM47C77U/pdf/OM47C77U.pdf)）](https://cdn-images-1.medium.com/max/8000/1*gIW6QI70azGalzYXicxj6A@2x.png)

在上面这一系列符号中，哪些您能马上读懂？有经验的驾驶员也许能够了解这些图标的含义。但是的确，某些图标并不直观。您甚至需要一本手册才能明白它们含义。

以下是我对它们大致的感受：

![](https://cdn-images-1.medium.com/max/8000/1*JOQqjiYvUCeyxZIk2t0FQA@2x.png)

当 icon 使用了不熟悉的隐喻时，我们很难理解它。安全带提醒灯的 icon（从左数第三个）非常直观，我们马上就能明白它的意思。而电力转向系统警示灯的 icon（最右边）的意思我们就很难读懂。

通常，一个难以理解的 icon 会令人沮丧。并且对于驾驶员来说，误解了警告 icon 将是十分危险的。

下面是一些我们比较熟悉的 icon —— 爱情、警告、音乐以及向上/向前的符号：

![人们熟悉的隐喻 icon，来自 [Phosphor Carbon](https://play.google.com/store/apps/details?id=com.tobiasfried.phosphor) icon 库](https://cdn-images-1.medium.com/max/8000/1*qLfMs1ZZBWVI7QUlkKcLxg@2x.png)

箭头是在指路中使用的强大符号：

![纽约地铁标志（来自：[纽约市交通管理局图形标准手册的原件的原始副本的截取](https://standardsmanual.com/pages/original-nycta)）](https://cdn-images-1.medium.com/max/8000/1*Qo1uR98wkC29ZyvLSzbguw@2x.png)

最理想的 icon 不仅对于一群人来说是易于理解的，而且在不同的文化、年龄和背景下都是通用的。站在您的用户角度思考，使用能与用户产生共鸣的隐喻和色彩。

请记住，如果 icon 所表示的意思太抽象，那么单独的 icon 可能不是表达性最好的解决方案。在这种情况下，将 icon 加上文本标签，或者寻找其它的解决方法。

## 可读性

有了可以理解的 icon 后，请确保其可读性。

![Amtrak App 中的 icon](https://cdn-images-1.medium.com/max/8000/1*NbBP3PbawGUgXxzzrj-T1g@2x.png)

上面（第一行）的 **Amtrak** （美国铁路）App 中的车站 icon 就很难辨认出来，因为细节太多了。

**Transit** （美国公交）App 也有类似的问题。因为在板子和夹子之间的间隙太小，所以它们的剪贴板图标看起来像一团墨水：

![Transit App 中的 icon](https://cdn-images-1.medium.com/max/8000/1*UPqYFGMOC_eCb0DiE97NRA@2x.png)

稍作调整将带来很大的改进：

![调整后的 剪贴板 icon](https://cdn-images-1.medium.com/max/8000/1*g-CLlEXT-PChQCVoQCb19Q@2x.png)

当处理多个形状时，在它们之间留出足够的空间。过细和更多的笔触会使得 icon 更复杂，更难以阅读。

**谷歌地图** 在这一方面就做得很好，他们的交通图标即使在极小的尺寸下也非常易读：

![Google Map 的 icon](https://cdn-images-1.medium.com/max/8000/1*hFjIw309hZhvYpMTi5XV-g@2x.png)

## 校准

为确保每个图标看起来平衡，需要在视觉上校准元素。

![](https://cdn-images-1.medium.com/max/8000/1*JPa-0i__W8X0pnciM8lAYQ@2x.png)

在这个播放 icon 中，尽管三角形按长度标准放在了圆的中心，我们的眼睛还是认为它不在中心。这是因为三角形较宽的部分看起来比点“重”，使得三角形视觉上向左侧偏移。

这就像排版人员通过视觉错觉来精细调整字体，从而达到平衡的视觉效果。（注意下图中，字母 “i” 和字母 “j” 上偏移中心的点以及[超出准线](https://frerejones.com/blog/typeface-mechanics-001/)的字母 “O”)

![](https://cdn-images-1.medium.com/max/8000/1*LqX2JnQGszK7jtY0cw4r2A@2x.png)

—— icon 设计师会进行类似的调整以平衡图标。要更正上面的示例，请稍微移动元素：

![](https://cdn-images-1.medium.com/max/8000/1*R3xPSuB-vICjJAig6rQ0xA@2x.png)

这看起来就好多了。

这里我们学到的是：不要简单地相信数字；用您的眼睛检查您的工作。

## 简洁性

用简单的几句话完整地表达一个想法，会让人感到高效和优雅。比如下面这句话：

> 教授您所知道的东西可以加强您对这门学科的理解。（Teaching what you know strengthens your own understanding of the subject.）

我们可以更简洁地说（来自 Robert Heinlein）：

> 教学相长。（When one teaches, two learn.）

这就十分优雅了。

在将简洁性作为系统中 icon 的设计导向这个方面，**Material** 风格就做得很好。与其使用这种 icon：

![过于复杂的船 icon（来自：[Material](https://material.io/design/iconography/system-icons.html)）](https://cdn-images-1.medium.com/max/8000/1*MRInntlrUtShOA1q2o5hBA@2x.png)

不如使用简单的：

![简洁的船 icon （来自： [Material](https://material.io/design/iconography/system-icons.html)）](https://cdn-images-1.medium.com/max/8000/1*smf9YlD_yZ59FMx7d1x1AA@2x.png)

简洁性尤其适用于 icon 设计，因为我们经常在小画布上工作。为您的图标使用适当的细节就好，不要增加一些您不需要的。

在用户界面中，简化的风格可以帮助用户抓住重点并为突出内容。比如，**Telegram** 的 icon 就很简洁有趣：

![Telegram icon](https://cdn-images-1.medium.com/max/8000/1*iF_GaiwikGuOO9aWlteRzA@2x.png)

有时，UI icon 需要具有更强的说明性。**Yelp**（美国商户点评）中这些多色调的 icon 是显示热门食物搜索的一种令人愉快的方式。泰国菜里的虾很精致：

![来自 [Scott Tusk](https://www.instagram.com/scottt0023/) 的 Yelp icon](https://cdn-images-1.medium.com/max/8000/1*sfStr_fEdvb8IkkvP3DwiQ@2x.png)

对于代表移动、平板和桌面应用的 **App** icon，可以用更多的深度和颜色来增加适当的细节。因为用户清楚自己现在是在设备主屏幕还是屏幕下方的菜单栏（在 iPhone 手机中，指 dock 栏）还是应用商店，所以使用更好地表达品牌和产品的 icon 会比较好。

![Apple 中[一些应用的 icon](https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/app-icon/)](https://cdn-images-1.medium.com/max/8000/1*TkO-RQ90wHYlFa2EAigG5w@2x.png)

## 一致性

为了使 icon 库看起来和谐，请始终保持相同的样式规则。

在 iOS 13 之前，**Apple** 的图标展具有各种笔触，填充和大小：

![在 iOS 13 之前，来自 Apple [主页屏幕的快捷操作](https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/system-icons/) 的 icon](https://cdn-images-1.medium.com/max/8000/1*Fg6ZRRCMGCEw1oS90ucBhg@2x.png)

瞇着眼睛看这一组 icon。您有感觉到有些图标比其它的看起来更“重”吗？

任何给定的 icon 都有一定的视觉**权重**，这是由填充、笔触厚度、大小和形状等参数决定的。在一系列 icon 中保持这些参数不变就可以建立一致性。

![](https://cdn-images-1.medium.com/max/8000/1*tZ2fvHU7CErrqkvgtSvFXg@2x.png)

**Apple** 最近修正了他们 [SF Symbols 的介绍](https://developer.apple.com/videos/play/wwdc2019/206)，SF Symbols 是 [San Francisco](https://developer.apple.com/fonts/) 字体的绝佳伴侣。SF Symbols 拥有 9 种权重和 3 种比例的图形 icon 风格（也许有点复杂，绝对详尽）。我们可以发现 icon 之间的过渡 ，填充和轮廓变量变得更加和谐了。

![来自 Apple [SF Symbols](https://developer.apple.com/design/human-interface-guidelines/sf-symbols/overview/)的 icon](https://cdn-images-1.medium.com/max/8000/1*4mYEN31EDW-0sPygspMWdw@2x.png)

要维护一个庞大 icon 库的一致性可不是一件容易的事，特别是当多个作者参与其中时。遵循明确的原则和规则是至关重要的。

**Phosphor** icon 库 —— 由我设计并由[我的另一半](https://github.com/rektdeckard)搭建，通过坚持相同的设计原则和严格测试每个图标来保持 700 多个图标的一致性。虽然每一个都有不同的形状，但它们都有相同的视觉权重，并且很好地结合在一起：

![[Phosphor Carbon](https://play.google.com/store/apps/details?id=com.tobiasfried.phosphor) icon 库中的一个子集](https://cdn-images-1.medium.com/max/8000/1*EjIs1qySoJTw7uq3Hup9Rg@2x.png)

## 特性

每个 icon 集都有自己的风格。是什么让它风格独一无二？它是如何对品牌进行的表达？它会给我们带来怎样的心情？

![Waze 的 icon](https://cdn-images-1.medium.com/max/8000/1*YnZ3LY648T0ewn4JfBj9Bw@2x.png)

**Waze** 的可爱的界面很大程度上依赖于它们的 icon。这些五颜六色、矮胖的图标上仿佛写着：我们不一样！ 

**Twitter** 的 icon 是比较柔软、轻盈的：

![Twitter 的 icon](https://cdn-images-1.medium.com/max/8000/1*jTJJN-bL43r9w1h4hRdeLw@2x.png)

**Sketch** 的 icon 是比较精致和轻快的：

![[Sketch](https://www.sketch.com/) 的 icon 来自 [Janik Baumgartner](https://dribbble.com/janik)](https://cdn-images-1.medium.com/max/8000/1*8RUcOyj47DMvDWj32aVzlg@2x.png)

**Freemojis** 的 icon 是比较可爱的：

![[Freemojis](https://app.streamlineicons.com/freemojis) 的 icon 来自 [Streamline](https://streamlineicons.com/)](https://cdn-images-1.medium.com/max/8000/1*Pz-DDw-6DhwZTXZKdxXfBg@2x.png)

Android 的 icon 包迎合了主屏幕主题的多种需求，下图分别是抽象、像素、泡沫、和霓虹灯风格：

![从上到下，从左到右分别是：[iJUK](https://play.google.com/store/apps/details?id=com.sikebo.ijuk.icons.simple&hl=en_US)、[PixBit](https://play.google.com/store/apps/details?id=pixbit.prime)、[Crayon](https://play.google.com/store/apps/details?id=com.jndapp.cartoon.crayon.iconpack)、[Linebit](https://play.google.com/store/apps/details?id=com.edzondm.linebit)](https://cdn-images-1.medium.com/max/8000/1*RMr0OXf8Sx3usFwGL3HGpQ@2x.png)

## 易用性

一个 icon 集被完美地设计出来还不够。它需要进一步的测试和准备，以确保贡献者可以方便地添加新 icon，设计师可以在设计中使用它们（用于屏幕、打印等），工程师可以在开发中使用它们。

一个高质量 icon 集应该是**组织有序的**、 **文档完善的**，并在上下文中进行过**测试**了的。除此之外，它最好还能：支持一些**自定义工具**，如 icon 管理器。

#### 组织有序的

保持 master 分支文件干净，正确命名和存放您的资源文件，这样就很容易可以找到它们，正确命名您的资源文件，把它们放在容易找到的地方。选择一个最适合的分类方法。按字母顺序？按大小？按类型？

![[Nucleo](https://nucleoapp.com/premium-icons) 的 Sketch 文件，按类型组织并分页。](https://cdn-images-1.medium.com/max/8000/1*GRmcLkIwBIiF_x3J-4puYA@2x.png)

#### 文档完善的

表达清楚 icon 库的关键原则：

```
Phosphor icon 库的原则示例（其实就是对上面介绍的内容）：

• 明确性。首先 icon 要清晰明确。使图标易识别和易读。永远不要舍弃 icon 所表达的明确性。

• 简洁性。使用尽可能少的细节。Phosphor 的风格是简化的风格。icon 中的每一笔都要简明扼要，有意识地传达所要表达的本质。

• 特性。可以是独具特色的。适当地添加独特的细节，可能会为原本非常严肃正经的 icon 集增添一丝温暖和乐趣。
```

列出技术规则：

```
Phosphor icon 库的技术规则示例：

• 使用 48x48px 的画布

• 使用 1.5px 的中心笔触

• 使用圆角

• 除非断开有助于 icon 的理解，否则请使用连续的笔触。

• 尽可能使用笔直的线段，完美的弧度和 15° 的角度增量

• 必要时调整曲线以遵循设计原则

• 尽可能使用整数、偶数增量进行测量；必要时可以折至 1px 和 .5px 

• 使用以下的形状关键线：28x28px 圆形、25x25px 正方形、28x22px 横向矩形、22x28px 纵向矩形

• 保留 6px 的修剪区域
```

重复上面的这些，如果您愿意，可以像下面一样将文档公开：

* [Material 系统 icon](https://material.io/design/iconography/system-icons.html)
* IBM 的 [UI icon](https://www.ibm.com/design/language/iconography/ui-icons/design/)、[App icon](https://www.ibm.com/design/language/iconography/app-icons/design/) 以及 [icon 贡献者指南](https://www.carbondesignsystem.com/guidelines/icons/contribute/)
* [Shopify Polaris 的 icon](https://polaris.shopify.com/design/icons)
* [Atlassian Iconography（产品）](https://www.atlassian.design/guidelines/product/foundations/iconography)

#### 测试

检查一致性。确保 icon 在上下文中以相应的大小工作。确保它们在更大的视觉系统也能协调工作。

将 icon 放在一起有助于验证我们的原则，这些原则包括明确性、可读性、校准、简洁性、一致性和特性：

![[Phosphor](https://play.google.com/store/apps/details?id=com.tobiasfried.phosphor) 在质量保证过程中的测试 icon 样单](https://cdn-images-1.medium.com/max/8000/1*cgP99N8laiD4jA6wh43yTA@2x.png)

#### 自定义工具

最后，如果您有足够的资源和能力，请创建能够方便使用图标的工具。

**Material** 通过自定义 icon 资料库我们能够更方便地访问他们的 icon。我们可以搜索需要的 icon，在喜欢的文件格式中下载不同风格（主题）、不同颜色、不同大小的 icon：

![Material’s easy-to-use [icon library](https://material.io/resources/icons/?style=baseline)](https://cdn-images-1.medium.com/max/8000/1*6xbfiFeRNVYQITy64tYYGg@2x.png)

我们使用的 icon 是有生命的。我们要给予它成功和成长所需要的爱和工具。

---

## 相关资源

#### icon 资料库

一些可选项：

* [Feather](https://feathericons.com/)，精美的 icon 集，提供 200 多个可以自由缩放的最小轮廓 icon。
* [Material system icons](https://material.io/resources/icons/?style=baseline)，1 千多个具有 5 种风格的实用 icon。
* [Nucleo](https://nucleoapp.com/premium-icons)，约有 3 万种 icon，提供 3 种样式：轮廓，平面/彩色和字形。
* [Streamline](https://streamlineicons.com/)，精美的 icon 集，提供 3 万多个具有 3 种视觉权重的线性风格 icon。

#### icon 大集合

* [Noun Project](https://thenounproject.com/)， 尽管 icon 的质量参差不齐，但这也是从样式和隐喻中寻找灵感的好方法。

#### icon 管理器

* 使用 [Nucleo app](https://nucleoapp.com/application)，在您导入 icon 集后，可以查看、导出 icon，还可以将 icon 拖拽到您喜欢的设计软件中。

---

🎶 **文章的音频版：[The Black Dog](https://open.spotify.com/artist/7qdsk0UXx2jCX7jbp6rxeq?si=R2z1R-xpT9K3Cmfp40lcrQ) 和 [Autechre](https://open.spotify.com/artist/6WH1V41LwGDGmlPUhSZLHO?si=9PBpv0i5QSiM66cd1G7mxQ)**

🙏 **感谢：Toby Fried、Monica Chang、Darcy O’Donnell、Sara Thompson、Lonny Huff、Stephany Shigekuni、Clarissa Soto、Tate Chow、Christine Lee、Victor Vasquez、Chris Rodemeyer、David Landa、Pawel Piekarski、Matthew Vargas**

```
这是我们 icon 系列的第一篇文章。请敬请关注该系列的后续文章：

• 5 步创建一个 Settings icon 

• icon 网格 & 关键线大揭秘

• icon 设计中的像素捕捉：捕捉或不捕捉
```

> 如果发现译文存在错误或其它需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
