> * 原文地址：[5-rules-for-designer-engineer-collaboration: Tips to Improve Quality and Productivity](https://medium.com/tradecraft-traction/5-rules-for-designer-engineer-collaboration-182fd74bd09f?ref=uxdesignweekly)
> * 原文作者：[Andrew Yang](https://medium.com/@andrew.yang804?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/5-rules-for-designer-engineer-collaboration.md](https://github.com/xitu/gold-miner/blob/master/TODO1/5-rules-for-designer-engineer-collaboration.md)
> * 译者：[Starrier](https://github.com/Starriers)
> * 校对者：[PokerF](https://github.com/PokerF)、[NoName4Me](https://github.com/NoName4Me)

# 设计师与工程师协作的 5 项准则

## 提高质量与生产率的小贴士

![](https://cdn-images-1.medium.com/max/800/1*hNscHHl45Q6s3dARFiaw0A.jpeg)

设计师 vs 工程师，源于 [society6](https://society6.com/)。

设计师和工程师被看作是完全相反的。设计师被描绘成敏感的创造者，工程师被描绘成冷酷的后勤人员。然而，作为一名前软件工程师出身的产品设计师，我认为这些对立面**可以**在工作场所中有效地协同工作。只要多了解一下对方的角色，设计师和工程师之间的关系就会大大改善。以下是设计师在与工程师一起工作时应遵循的五条一般准则，其次是从工程师的角度来看的另外五条准则。

### 给设计师的 5 项准则

![](https://cdn-images-1.medium.com/max/800/1*RlD_EebvaZt--pxPDmc0rQ.jpeg)

图片来自 [Upslash](https://unsplash.com)，作者 [William Iven](https://unsplash.com/@firmbee)。

#### 1）避免自定义样式

实际上，所有前端工程团队都使用某种类型的库或 CSS 框架来实现跨应用程序使用的样式。这些库通常包含一些通用样式，如预定义的边距、颜色和其他类，这些工具是工程师用来使开发更快速、更一致的。这意味着，如果您决定添加自定义页边距、字体大小或组件，工程师必须从头开始编写自定义 CSS 以覆盖基本样式。偶尔这样也不错，但很快就会变得单调乏味了。仅在特殊场合或绝对必要时保存这些自定义样式。毕竟，在一个框架内设计可以简化我们的许多决策，这往往是好事。

#### 2）尽早与工程师沟通

让我们现实一点，除非您正在为一个初创公司工作，或者您是工程副总裁，否则工程师们不会得到多少产品的发言权。设定产品愿景在一定程度上通常取决于高管、产品经理和产品设计人员。然而，即使工程师在设计方面没有太多投入,他们仍然**感觉**正如他们自己在设计一样。当您和产品经理开会时，请一位工程主管参加。此外，与您的工程团队一起设置一些设计评审来检查您的设计。向他们解释您做出设计决定的原因，并征求他们的反馈。如果工程师觉得他们对设计过程做出了贡献，他们在实现设计时自然会更加用心。

#### 3）听取工程反馈

信不信由你，工程师通常都是相当不错的设计师。特别是在 UX（译者注：用户体验） 方面，我曾和许多有很强设计意识的工程师一起工作过。这些工程师想要被倾听，他们的反馈是非常有价值的，而且往往是准确的。当你信任的工程师针对你的设计给你反馈时，倾听。更好的方法是，拿出笔记本并记下他们的想法，让他们知道你在听。你不必使用所有的想法，但要给予他们应有的尊重，有些建议是一定要坚持的。

**当然，并非所有来自工程师的设计反馈都是好的。以怀疑又开放的心态来对待它，你总会有所得，而且又有谁不喜欢被聆听呢**。

#### 4）了解基础的 HTML/CSS/JS

![](https://cdn-images-1.medium.com/max/800/1*uL5yjFLIeRYvmZR9w3mLHg.png)

当我还是 [SalesforceIQ](https://www.linkedin.com/company/salesforceiq/) 的软件工程师时，和我一起工作过的最好的设计师之一可以和我一起直接进入 Web 检查器，并在控制台中直接使用 HTML/CSS 快速原型。作为一名工程师，知道与你一起工作的设计师理解你正在使用的技术，并且在设计时考虑到这些限制，这是令人难以置信的安心。要成为一名优秀的产品设计师，完全没有必要拥有完整的前端开发技能，但一些基本的前端知识会发挥很大作用。获得您最亲密的同伴的尊重 -- 学习一些代码。

#### 5）批量小修正

[心流](https://en.wikipedia.org/wiki/Flow_%28psychology%29)是工程师最有生产力的一种状态 -- 它在很大程度上意味着『在区域内』。工程师需要大量不间断的时间才能实现流程。这就是为什么会议最好安排在一天的开始或结束，而不断的干扰是工程师生存的祸根。是的，这意味着你今天早上洗澡时想要用更深的蓝色来做按钮的想法可以暂时搁置。设计是一个迭代的过程，产品无疑会不断的变化。然而，在向工程师询问之前，先让这些小的变化积累起来。例如，在接近工程师进行修复之前，设置五个小的更改的基线。没有什么比打破他们的流程更让工程师烦恼的了（仅仅改变按钮的颜色七次）。

* * *

### 给工程师的 5 项准则

![](https://cdn-images-1.medium.com/max/800/1*h-pctC-YtNZT8Os_pb8BxA.jpeg)

[William Iven](https://unsplash.com/@firmbee) 通过 [Upslash](https://unsplash.com) 拍摄。

#### 1）理解用例 

作为一名工程师，您有大量权力可以用指尖进行创造，而且它真的很容易用代码实现。然而，巨大的权力带来了巨大的责任。退一步说，了解您正在构建的产品或特性的『原因』。去和您的产品经理和产品设计师谈谈。理解为什么要构建这个特性，以及为什么它是按照这样的方式设计的。没有这种洞察力，你的工作只是作用在产品边缘。另外，通过对产品的理解，您将能够在实现中考虑所有不同的用例和边缘案例，并将您的代码水平提升到下一个层次。 

#### 2）先实现 UX

在敏捷环境中，设计是基于用户测试和反馈不断迭代的。您昨天刻意实现的一个具有5个像素的 border-radius 和 box-shadow 蓝色按钮而现在却是一个有着平面设计和尖锐边缘的绿色按钮。搞砸了。但是，不要气馁：接受这是产品开发过程的一部分。首先实现 UX - 设计的流程、功能和总体布局。获得整体效果，但不要疯狂于像素的完美实现。一旦设计经历了更多的迭代测试并且版本稳定下来后，栩栩如生的元素会逐渐融入其中。。 

#### 3）回退

![](https://cdn-images-1.medium.com/max/800/1*595UUrTLxUioKqL6TjMaTg.gif)

还记得上次设计师要求您实现一个改变颜色并每隔一分钟翻转一次的自定义组件吗？是的，别那么做。设计是双向的行为。不要害怕回退，给出技术约束和限制的反馈。在大多数情况下，即使是最好的设计人员也不会拥有您的技术能力或对系统的理解。然而，与其一味地说“这是不可能做到的”，不如提供一个替代的解决方案。试试看，“这个解决方案的实现成本很高，我可以建议您使用…吗？”。请记住，大多数事情都**可以**用我们现有的工具来完成，但这并不意味着所有的事情都**应该**完成。作为工程师，你的工作就是帮助设计师找到最好、最经济有效的解决方案。

#### 4）与设计师保持联系

沟通确实是本文的主题。 在您实现设计时，务必始终向设计师展示您的进度。 设计师喜欢看到他们的作品变得栩栩如生，所以对每个人来说这真是一件有趣的事情。 让设计师及时了解您的进展情况将有助于确保您的实现符合预期，并且不会出现任何意外情况。 这也是一个很好的机会向设计师询问任何关于设计或未来任务的问题。

#### 5）填补空白

在实现设计时，总会有一些地方需要您用自己的最佳判断来填补空白。您实现的设计不会完全类似于交给您的设计 --  这只是底线。您肯定有遇到过这样的情况：您觉得在某些屏幕上需要更大的外边距，或者在实际应用程序中某个特定的颜色看起来不太合适。不要每次都带着问题去找设计师。把你的设计师帽子戴上，告诉自己你有解决它们的能力。你有这个本事。

**但也不要太过疯狂，做重大决定的时候记得要和你的设计师沟通。用您最好的判断力 :)**

* * *

现在你明白了吧！这是我为设计师和工程师改善他们工作时的协作而编写的 5 项准则。这些准则都是完全主观的，来自以前我作为软件工程师时的经验，以及现在我作为产品设计师的经验。请告诉我，您是否同意我的观点，这样我们好在下面继续讨论！


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
