> - 原文地址：[13 Reasons Why you should choose/ consider to move to Flutter](https://medium.com/flutter-community/13-reasons-why-you-should-choose-consider-to-move-to-flutter-in-2019-24323ee259c1)
> - 原文作者：[Ganesh .s.p](https://medium.com/@ganesh.s.p006)
> - 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> - 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/13-reasons-why-you-should-choose-consider-to-move-to-flutter-in-2019.md](https://github.com/xitu/gold-miner/blob/master/TODO1/13-reasons-why-you-should-choose-consider-to-move-to-flutter-in-2019.md)
> - 译者：[YueYong](https://github.com/YueYongDev)
> - 校对者：[MeandNi](https://github.com/MeandNi)

# 13 个你应该选择/考虑使用 Flutter 的理由

![](https://cdn-images-1.medium.com/max/800/1*28u1IZzOkTeQMso-2eZZWw.png)

> 13 个你应该[**转向 Dart**](https://twitter.com/scottstoll2017) 并且选择或者学习利用 Flutter 去开发你的下一个 app 的理由。

如今的企业需要在选择移动技术时做出关键选择。他们不断的测试和评估技术，以求不论用户使用什么移动设备或操作系统都能有强大的数字体验。企业如果不能提供易于使用的产品和服务，那么无论使用何种渠道或设备，都有可能落后于竞争对手。

![](https://cdn-images-1.medium.com/max/800/1*ECNAUzNJCkkl7EJKk2Esrw.gif)

目前面临的挑战便是跨平台应用的开发存在问题。在某些情况下，尽管开发人员尽了最大努力，其用户体验仍然落后于原生 app 。近年来，我们看到了各种移动框架的出现，如 React Native、Xamarin 和 AngularJS，它们帮助我们更容易地产生较好地数字体验。最近我们看到一个新玩家加入了这场游戏——谷歌的 Flutter。

![](https://cdn-images-1.medium.com/max/800/1*ymhzy0pX-tFncyB-jD8Opw.gif)

从内部来看，Flutter 看起来像是谷歌各种技术和概念的大杂烩，然而却产生一个不可思议的强大的移动框架。它是基于 Dart (谷歌的内部编程语言)开发的，它可以让 Flutter 访问 Skia 图形库，而这正是 Chrome 浏览器所使用的。除此之外，Flutter 与谷歌的 Material Design 规范紧密结合；其中最著名的便是 Android 用户已经熟知的“卡片图案”。

------

让我们看看 13 个选择 Flutter 作为你的开发环境甚至可以选择它开始你的职业生涯的理由。

**1. Flutter 克服了传统跨平台的限制**

长期以来，创建真正的跨平台方法一直是技术顾问的苦恼所在，他们厌倦了为同一产品制作多个版本。但是，实际上，跨平台应用的用户体验通常落后于原生 app，因为你经常需要即时编译 JavaScript 来构建 UI 体验。

![](https://cdn-images-1.medium.com/max/800/1*QVvruYyZj4d7xPnO5HLWvA.jpeg)

使用 Flutter，你不仅可以拥有“一次编写”的优势，还可以创建高性能的“原生”体验，因为 Flutter 应用程序是提前编译出机器可执行的二进制文件。它克服了其他跨平台方法中的一些常见问题。

**2. 开发人员的生产力提高了十倍**

这种生产力的提高来自 Flutter 的“热重载”（也就是所谓的“有状态的热重载”和“热重启”）。这样，开发人员可以在不到一秒的时间内看到他们对应用程序状态所做的更改；并且在不到 10s 的时间内改变 app 的结构。

![](https://cdn-images-1.medium.com/max/800/1*52k_IC8lfsVnHzwLOcF55w.gif)

没有必要去启动另一个 Gradle 构建程序——因为你可以在保存后查看你的修改。对于开发人员来说，这通常很容易掌握——在使用“热重载”时几乎没有等待时间，因为在默认情况下，每次保存时都会实时改变。

然而，优势是至关重要的。使用 Flutter 开发时间通常会减少 30-40%，因为在 Android 开发中，每次修改后 Gradle 都需要重新构建，这会降低 Android 开发人员的速度。

**3. 前后端只需一套代码**

在 Android 编程中，前端（Views）有单独的文件，由后端（Java）引用，与之不同的是，flutter 使用一种语言（Dart）来完成这两项工作，并使用一个响应式框架。

Dart 借鉴了其他语言众多流行的特性，同时不会让你感到陌生，因为它和 Java 或者其他语言相似。Dart 的构建考虑了开发人员的易用性，从而使许多常见任务变得更加容易。你可以在这学到更多有关 Dart 的知识：[Dart 语言之旅](https://www.dartlang.org/guides/language/language-tour)。

**4. 这是一种强大的开箱即用的设计体验**

由于 Flutter 团队对 Material design 规范的积极适配，使得开发者很容易就可以创建出功能强大的 UI 体验。它可以帮助你生成通常只能在原生 app 中才能体验到的平滑、流畅，因为 Flutter 的发行版构建的就是一个原生 app。

Flutter 的小部件同时也实现了 iOS 的人机界面设计规范，可以让你在 iPhone 和 iPad 上也能获得那种原生的“体验”。

![](https://cdn-images-1.medium.com/max/800/1*AwlIaO9hQAMAYQ9oQjHtKw.png)

**5. 有一个数量众多且开源的软件库**

大量可用的开源包可以帮助你更快、更轻松地创建应用程序，而且目前有许多可用的包可以使许多复杂的任务变得更容易。

由于不断加入的开发人员对 Flutter 的作出的积极贡献，所以即使这个开源库还不够成熟，但它依然在积极壮大。

**6. 与 Firebase 的紧密结合**

Firebase 为云存储、云功能、实时数据库、托管、身份验证等一系列服务提供开箱即用的支持。你的基础设施完全可以是无服务器的、冗余的和可扩展的。这意味着你不必花费大量时间和资源来构建后端。

它还可以直接与一个工具结合使用来自动化你的开发和发布过程以促进持续交付（例如 Fastlane）。因此，你不必在团队中提供专门的 DevOps 支持。

**7. 大量 IDE支持 Flutter**

在使用 Flutter 进行编程时，你可以从许多集成开发环境中进行选择。一开始我使用的是 Android Studio，但后来我看 Flutter Live 时使用的是VS Code。这让我很疑惑，因为我发现很多 Flutter 开发人员都在使用 Visual Studio Code。当我尝试之后，我明白为什么这么多人喜欢它了。VS Code 相较于 Android Studio 和 IntelliJ 更加轻量，速度也快得多，并且具有两者中的大部分特性。就我个人而言，我已经转向 VS Code，但是你也可以使用许多其他的 IDE，你无需切换就可以开始 Flutter 的工作。

**8. UI遵从性 — —一切都是一个小部件**

在 flutter 中，所有的东西都是一个小部件，例如 Appbar、Drawer、Snackbar 和 Scaffold 等等。开发者可以很容易地将一个小部件包装在另一个小部件中以实现一些效果，例如将一个部件包装在一个 Center 小部件中，就可以让其居中。

以上这些都是为了确保你的用户无论使用什么平台运行你的软件都可以有相同的用户体验。你还应该阅读下述 flutter 文档：[Everything’s a widget](https://flutter.io/docs/resources/technical-overview#everythings-a-widget)

**9. Android/iOS 的不同主题**

根据用户的平台分配正确的主题就像使用三元 if 检查用户正在运行的平台一样简单；允许 UI 在运行时决定使用哪些 UI 组件。

下面是一个示例代码，它用于检查当前运行的平台，如果是 iOS，它返回一个以紫色作为主色调的主题。

```
return new MaterialApp(
  // default theme here
  theme: new ThemeData(),
  builder: (context, child) {
    final defaultTheme = Theme.of(context);
    if (defaultTheme.platform == TargetPlatform.iOS) {
      return new Theme(
        data: defaultTheme.copyWith(
          primaryColor: Colors.purple
        ),
        child: child,
      );
    }
    return child;
  }
);
```

**10. 使用 Code Magic 进行持续集成.**

Code magic 是 2018 年 12 月 4 日在 Flutter Live 中使用的一个开源工具。Code magic 很容易学习，并且完全免费！它是一种高度复杂的 CI 工具，专门针对 Flutter 进行了优化。Code magic 使构建过程无缝对接。

![](https://cdn-images-1.medium.com/max/800/1*gdnx0Dcqm6_uEWaoghtvIA.png)

运行中的 Code Magic 

**11. [2Dimensions](https://www.2dimensions.com/) 让动画制作更简单**

![](https://cdn-images-1.medium.com/max/600/1*b3Z0cow_co15WpjLYELqSQ.gif)

我第一次尝试使用 Flutter + Flare — Bouncy

同样是在 Flutter live 2018 期间推出的惊人的在线工具，可以轻松创建非常棒的 UI 或动画。它弥补了 UI 设计人员和开发人员之间的差距，减少了应用 UI 或动画相关更改所需的时间。

Flare的学习曲线很浅，我在使用了它之后，对创建动画的简单性感到惊讶！ 你可以看到 app 在这里工作，我甚至在球上加了一个反射，给它一个更逼真的外观。

**12. 运行在桌面和 Web 端的 Flutter**

Flutter 团队现在已经有了可以在 web 浏览器中工作的 Flutter 原型 app，这让所有人都感到震惊。在 Flutter Live 中，之前的绝密项目 “Hummingbird” 向世界公开。很快，你就可以使用相同的代码轻松地为移动端、桌面端和 web 端创建应用程序。

![](https://cdn-images-1.medium.com/max/800/1*OlrI9IphckWpiNEzS9ielg.png)

**13. 来自 Flutter 团队和 Flutter 社区的持续支持**

在过去的三周里，我一直在用 Flutter 工作，并注意到来自 Flutter 团队和社区的很多支持和鼓励；尤其是 [Scott Stoll](https://twitter.com/scottstoll2017)、[Nilay Yener](https://twitter.com/nlycskn) 和 [Simon Lightfoot](https://twitter.com/devangelslondon)（仅举几个例子）。每个星期三，Flutter 社区中许多比较知名的名字都可以在 Zoom at #HumpDayQandA 上看到，在那里你可以实时获取来自真人的有关 Flutter 的帮助。即便你没有任何问题，那也是一个很好的地方，因为你可以从他们回答别人的问题中学到很多。

![](https://cdn-images-1.medium.com/max/800/1*6fuFPHO1w15e3kPk8qp7GA.jpeg)

这是我参加 #HumpDayQandA 的照片。来自 Flutter Egypt 的创始人，谷歌开发者 Amed Abu Eldahab的推文。

使用 Flutter 的价值很明显，也很有吸引力，因为它减轻了初创公司试图将产品发布到多个平台所面临的许多困难；特别是处理在有限的时间和预算内将软件产品推向市场的时候。

------

大家好，我是 Ganesh S P.，是一名经验丰富的 Java 开发人员，具有广泛的创造性思维，同时是一名企业家和演说家，现在正冒险进入 Flutter 的世界。你可以在 [_LinkedIn_](https://www.linkedin.com/in/ganesh-sp-a5981a7a) 或者 [_github_](https://github.com/ganeshsp1) 找到我，或者关注我的 [_twitter_](http://Check%20out%20Ganesh%20S%20P%20%28@ganeshsp007%29:%20https://twitter.com/ganeshsp007?s=09)。在空闲时间，我是一名在 [_GadgetKada_](https://www.youtube.com/gadgetkada) 上的内容创造者。你也可以给我发邮件 ganesh.sp006@gmail.com 讨论任何有关科技的话题。

感谢 [Nash](https://medium.com/@Nash0x7E2?source=post_page) 和 [Scott Stoll](https://medium.com/@scottstoll2017?source=post_page)。

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

------

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
