> * 原文地址：[101 Tips For Being A Great Programmer (& Human)](https://dev.to/emmawedekind/101-tips-for-being-a-great-programmer-human-36nl)
> * 原文作者：[Emma Wedekind](https://dev.to/emmawedekind)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO1/101-tips-for-being-a-great-programmer-human.md](https://github.com/xitu/gold-miner/blob/master/TODO1/101-tips-for-being-a-great-programmer-human.md)
> * 译者：
> * 校对者：

# 101 Tips For Being A Great Programmer (& Human)

## 1. Get good at Googling

Being a programmer is all about learning how to search for the answers to your questions. By learning to Google things effectively, you'll save a lot of development time.

## 2. Under promise and over deliver

It's better to let your team know a task will take three weeks and deliver in two than the other way around. By under promising and over delivering, you'll build trust.

[![Designer](https://res.cloudinary.com/practicaldev/image/fetch/s--XuAuxqWV--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/umrbnosn8g68nep19y21.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--XuAuxqWV--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/umrbnosn8g68nep19y21.png)

## 3. Be nice to your designers; they're your friends

Designers provide solutions to user pain points. Learn from them and work cohesively to build effective products.

## 4. Find a mentor

Find someone you can learn from and bounce ideas off of. [Coding Coach](https://codingcoach.io/) is a great place to get started if you need a technical mentor!

## 5. Be a mentor

Be someone others can learn from and bounce ideas off of. We'd love to have you as a mentor over at [Coding Coach](https://codingcoach.io/)

## 6. Write useful comments

Write comments which explain the "why" and not the "what".

## 7. Name variables and functions appropriately

Functions and variables should accurately denote their purpose, so `myCoolFunction` won't fly.

## 8. Take vacations

We all need time to de-compress. Take that trip you've been wanting. Your brain and your co-workers will thank you.

## 9. Delete unused code

No reason to accrue more technical debt.

## 10. Learn to read code

Reading code is an undervalued skill, but an invaluable one.

## 11. Establish a healthy work/life balance

You need time to de-compress after a long workday. Shut off work notifications, remove apps off your phone.

[![Meeting](https://res.cloudinary.com/practicaldev/image/fetch/s--VqSUBCSo--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/fv2vh91wlhe9dh046mub.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--VqSUBCSo--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/fv2vh91wlhe9dh046mub.png)

## 12. Only schedule necessary meetings

Can it be solved in an email or a Slack message? If so, avoid a meeting. If not, be conscious of the duration. Aim for less.

## 13. Pair program

Pair programming allows you to play the role of both teacher and student.

## 14. Write great emails

Learn to capture your audience in your emails by being succinct yet clear. Nobody wants to read your four-page email Jerry.

## 15. Get involved in the community

Surrounding yourself with like-minded people will motivate you to push through the lows.

[![Tree](https://res.cloudinary.com/practicaldev/image/fetch/s--T7zjbX2p--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/gpvnfky8mmwakwy8eix1.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--T7zjbX2p--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/gpvnfky8mmwakwy8eix1.png)

## 16. Clean up your branches

Clean up your version control branches like you'd clean your house before your in-laws came for a visit. If you don't need it, discard it; don't just throw it in the closet.

## 17. Don't gate keep

Be inclusive. Don't tell others they aren't good enough to be in the industry. Everyone has value.

## 18. Keep learning

You've chosen a profession that requires continuous learning. Learn to love it.

## 19. Don't give up

It won't always be easy. But we all started at the same place. You can do it.

## 20. Take tasks that scare you

If it doesn't scare you, it isn't going to help you grow.

## 21. Clarify requirements before starting

You should understand the acceptance criteria before delving into writing the code. It will save you time and pain later down the line.

[![React](https://res.cloudinary.com/practicaldev/image/fetch/s--LXs3CSyq--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/iiagpq5fbypu8h9sggqn.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--LXs3CSyq--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/iiagpq5fbypu8h9sggqn.png)

## 22. Have a toolbox

Have a set of tools which you know inside-and-out. Know which tools serve which purpose and when a project can benefit from using one over another.

## 23. Learn to love constructive criticism

Ask trusted colleagues and friends for constructive criticism. It will help you grow as a programmer and as a human.

## 24. Be open-minded

Technology changes, and it changes quickly. Don't oppose new technology; learn it and then form an opinion.

## 25. Stay relevant

Stay up-to-date on the latest tech news by following publications, blogs, podcasts, and tech news.

## 26. Focus on problem solving

Strong problem solving skills can conquer any problem. Hone in on what it takes to solve a problem.

## 27. Stay humble

No matter what title you hold or what company you work form, stay humble.

[![Presentation](https://res.cloudinary.com/practicaldev/image/fetch/s--nhgfS-7z--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/3skzkor6amr46291uvtp.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--nhgfS-7z--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/3skzkor6amr46291uvtp.png)

## 28. Learn to give a great presentation

Learn how to captivate your audience and give effective presentations.

## 29. Examine all solutions before jumping in

Don't jump straight into the first possible solution. Examine all paths before delving into the code.

## 30. Find your niche

There are many divisions within the tech industry. Find the area that interests you most and become an expert.

## 31. Develop good habits

Try to build consistent, and healthy, habits such as removing distractions, time-boxing tasks, being present in meetings, and starting with the most important task first. It might take some getting used to but it will be worth it in the long-run.

[![Debug](https://res.cloudinary.com/practicaldev/image/fetch/s--zD_K7d71--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/scn44lf4b9moiyp1teei.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--zD_K7d71--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/scn44lf4b9moiyp1teei.png)

## 32. Learn to debug

Explore the browser debugger tools. Learn the ins-and-outs of debugging with your IDE. By learning the most effective methods for debugging a problem and tracing errors, you'll be able to solve even the most difficult bugs.

## 33. Exercise your current skills

Just because you currently know a skill doesn't mean you shouldn't exercise it. Skills fade with time unless consciously improved upon, and this industry evolves so rapidly it's important to keep practicing. Get out of the mindset that "I've always done it this way" and into the mindset of "Is there a better way to do this?"

Just because you've got a six pack now, doesn't mean you can eat a 🍩 a day and stay that way.

## 34. Understand the why

There will be times when you have to voice your opinion, so it's important to understand the why behind it. Why is solution A better than solution B? Provide a valid argument and your opinions will be much more sound.

[![Money](https://res.cloudinary.com/practicaldev/image/fetch/s--3rau99gs--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/bwftxcf9uigytg4bgfxm.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--3rau99gs--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/bwftxcf9uigytg4bgfxm.png)

## 35. Know your worth

You are a commodity, and should be paid appropriately. Be aware of the industry averages in your geographic location. If you're making less money, it's time to have a chat with your manager. Go after what you deserve.

## 36. Don't be afraid to ask for help

If you're stuck on a problem and spending too much time searching for a solution, it's time to ask for help. We're all human. We all need help. There is no shame in reaching out to a colleague for support.

## 37. Learn to learn

People learn in different ways. Some learn best through video tutorials, others through reading a book. Figure out your learning style and practice it diligently.

## 38. Be kind

There will be times when you're asked to provide feedback on a colleague. Be kind. You can voice your opinions about Deborah's lack of initiative without ripping her to shreds.

## 39. Take breaks

It's nearly impossible to spend 8 consecutive hours coding. You'll burn out quickly and make a lot of mistakes. So set a timer to remind yourself to stop and take a break. Go for a walk. Get a coffee with a colleague. Stepping away from the screen will positively impact your productivity and the quality of your work.

## 40. Track your progress

Learning to code takes time and can be extremely disheartening when you don't see progress. So it's important to track your achievements and progress towards your goals. Keep a small list next to your computer and each time you achieve something, write it down, no matter how small. Atomic achievements compound to much larger rewards.

[![React](https://res.cloudinary.com/practicaldev/image/fetch/s--97NnU31z--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/iu5gfm3zns37g763quxt.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--97NnU31z--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/iu5gfm3zns37g763quxt.png)

## 41. Don't rely on a framework or library

Learn the nuances of a language better than the ins-and-outs of a framework or library. You don't necessarily need to learn one before another, but understanding why a framework or library works the way it does will help you write cleaner and more performant code.

## 42. Learn to love code reviews

Having someone read and analyze your code can be terrifying, but can offer you invaluable feedback which will make you a better programmer. You should also work on your ability to conduct a good code review.

## 43. Learn about tangential spaces

Learn some basics about tangential spaces, such as design, marketing, frontend development or backend development. It will help you to become a more well-rounded programmer.

## 44. Don't choose the comfortable technology; choose the right one

Each project will have different needs, and as such we must choose the right tools for the job. Although it's comfortable to choose technologies you've worked with previously, if they don't suit the needs of the project, alternatives should be explored.

## 45. Take responsibility for your mistakes

All humans make mistakes and you will many many throughout your career. Thus it's important to own up and take responsibility when you've made a mistake. It will build trust with your team members and management.

## 46. Review your own code

Before opening a pull request, review your own code. If this were the work of a colleague, what comments would you make? It's important to first try to diagnose problems or mistakes before requesting a code review.

## 47. Learn from your failures

Failure is simply not achieving the expected outcome, and is not necessarily a bad thing. We all have many failures during the course of our careers. Learn from your downfalls. What can you do differently next time?

## 48. Recognize your weaknesses

Get to know yourself. What are your weaknesses? Maybe you always forget to update the tests before pushing. Or maybe you are really bad at replying to emails. Learn your weaknesses so you can actively work to address them.

## 49. Stay curious

This industry is ever-evolving, so curiosity will be important. If you don't understand something, be it a project requirement or a line of code, speak up. Nobody will criticize you for asking for clarification and you'll create better code as a result.

[![Book](https://res.cloudinary.com/practicaldev/image/fetch/s--ypw1fzcI--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/qzhic8yqs0pu28bo78lf.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--ypw1fzcI--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/qzhic8yqs0pu28bo78lf.png)

## 50. Don't try to learn everything

There is an infinity pool of knowledge in the world and it is simply impossible to conquer it all. Pick several topics to master and leave the rest be. You can acquire working or tangential knowledge about other areas, but you cannot possibly master everything.

## 51. Kill your darlings

Just because you write some code doesn't mean you need t be emotionally attached to it. Nobody likes their work being thrown out, but code has a life cycle, so there's no need to be territorial about it.

## 52. Have your team's back

Good teams have each others' backs. This creates a safe space to try new things without fear of retribution.

## 53. Find inspiration in the community

Find a few people in the industry you admire. It will inspire you to keep working on your projects or try new things.

## 54. Value your work

Regardless of how much experience you have or what your job title is, your work has value. Give it the value it deserves.

[![Phone](https://res.cloudinary.com/practicaldev/image/fetch/s--QyhOZjHL--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/9gg3o6rl7retjl9n90ku.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--QyhOZjHL--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/9gg3o6rl7retjl9n90ku.png)

## 55. Disable distractions

Turning off Slack notifications, text messages, emails, and social media will help you focus and maximize your workday.Jerry won't fall apart if it takes you 30 minutes to respond to his message.

## 56. Be supportive

Try and support your team members whether that's by attending an important presentation or helping them if they get stuck.

## 57. Give credit where credit is due

If someone does great work, tell them. Positive re-enforcement is a great way to build trust with your team members and help their careers. They'll be more likely to help you along as well.

## 58. Test your code

Tests are important. Unit tests, regression tests, integration tests, end-to-end tests. Test your code and your product will be much more stable.

## 59. Plan out your approach

When you receive a new feature request or get a new bug ticket, first plan your attack. What do you need to solve this problem or develop this feature? Taking even just a few minutes to plan your attack can save you hours of frustration.

## 60. Learn to pseudocode

Pseudocoding is a great skill to have because it allows you to think through complex problems without wasting time writing lines of code. Write an approach down on paper, run through different test cases and see where the pitfalls are.

[![Win](https://res.cloudinary.com/practicaldev/image/fetch/s--uQ2UJkJY--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/6l0lkgxbxz60sbsa3o59.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--uQ2UJkJY--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/6l0lkgxbxz60sbsa3o59.png)

## 61. Keep track of your achievements

If you win an award at work, write it down. If you develop a crucial feature, write it down. You'll create a backlog of things which can aid with a promotion or boost your morale on a tough day.

## 62. Learn programming foundations

Learn some basic sorting and searching algorithms and data structures. These are language-agnostic and can help you solve problems across languages.

## 63. Choose technology for longevity & maintainability

Although it's fun to test out the newest technologies, pick those which will be easy to maintain within an enterprise application. Your team will thank you for years to come.

## 64. Learn design patterns

Design patterns are useful tools for architecting code. You may not need them for every project, but having a basic understanding of them will help scaffold out larger applications.

## 65. Reduce ambiguity

Instead of writing convoluted code which shows off your snazzy programming skills, aim for readability and simplicity. This will make it easier for your team members to contribute.

[![Debt](https://res.cloudinary.com/practicaldev/image/fetch/s--fX3cKq9j--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/6rg8pvj8ezhreshjjx6o.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--fX3cKq9j--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/6rg8pvj8ezhreshjjx6o.png)

## 66. Pay off technical debt

Technical debt can have massive performance implications, so if you're able to refactor, you should.

## 67. Ship often

Instead of shipping a massive upgrade once every month, ship more frequently with smaller changelogs. You're less likely to introduce bugs and breaking changes.

## 68. Commit early and often

Committing early and committing often is the best way to ensure that your work remains clean and also reduces the stress of accidentally reverting important changes.

## 69. Learn when to ask for help

Not only should you not be afraid to ask for help, but you should learn when to ask for help. You should always try to solve a problem before asking for help, and keep track of the things you try. But when you've been stumped by a simple problem for over an hour, the cost outweighs the benefit, and you should reach out to a colleague.

## 70. Ask effective questions

When asking a question, try to be as specific as possible.

## 71. Get feedback on unfinished work

Your work doesn't need to be finished for you to get feedback. If you're uncertain of the direction, ask a trusted colleague to review the validity of your solution.

[![Read](https://res.cloudinary.com/practicaldev/image/fetch/s--ajqLQ2p0--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/pizzzb8twdan6231fdjq.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--ajqLQ2p0--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/pizzzb8twdan6231fdjq.png)

## 72. Read documentation

Documentation is the purest source of truth about a technology, so learning to read it can quickly help you to become an expert.

## 73. Try all the things

Nothing is stopping you from trying a solution to a problem. What do you have to lose?

## 74. Speak up in meetings

Your ideas and opinions are valuable so participating in meetings will help you develop a rapport with your team as well as management.

## 75. Collaborate cross-team

If you get an opportunity to with with another team in your company, go for it.

## 76. Have passion projects

When you work 40 hours a week, it's important to take time for passion projects. They help you reinvigorate your love of programming and try new technologies you might not have access to at work.

## 77. Define your career goals

It's important to have an idea of your ideal trajectory for your career. If you don't, you're trying to shoot an arrow without having a target.

[![Talk](https://res.cloudinary.com/practicaldev/image/fetch/s--SPitWbzG--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/fjqq1ghzpz4qqcjhoew6.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--SPitWbzG--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/fjqq1ghzpz4qqcjhoew6.png)

## 78. Get involved in the conversation

Comment on blogs, participate in Twitter threads. Engage with the community. You'll learn a lot more from being an active bystander than a wallflower.

## 79. Prioritize tasks

Learning to prioritize your tasks will help you enhance your productivity. Keep an active to-do list of immediate daily tasks as well as longer-term tasks and order them by most important.

## 80. Don't overlook the details

Details can make a big difference in a project.

## 81. Trust your teammates

Your teammates were hired for their skills. Use them and trust them to get the job done.

## 82. Learn to delegate

If you're in a leadership position, learn how to delegate effectively. It will save you time and frustration. You cannot do it all.

## 83. Don't compare yourself to others

The only thing you should compare yourself to is who you were yesterday.

## 84. Surround yourself with allies

Learning to program will be a long, and not always easy, journey. Surround yourself with the people who build you up and encourage you to keep going.

[![Build](https://res.cloudinary.com/practicaldev/image/fetch/s---Cgcxmny--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/84lhizall1hn9flgvudv.png)](https://res.cloudinary.com/practicaldev/image/fetch/s---Cgcxmny--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/84lhizall1hn9flgvudv.png)

## 85. Don't start for scale

Starting for scale is a surefire way to become overwhelmed. Build with scalability in mind, but don't start scaling until you need it. This way you don't overwhelm your team with unnecessary bloat, but you maintain the ability to grow.

## 86. Weigh performance implications

If you want to use a cool, new technology you should weigh the performance implications of doing so. Could you implement something similar without taking a performance hit? If so, you may want to re-think your approach.

## 87. Don't discriminate

Don't discriminate against new technologies or ideas. Be open-minded about the possibility of learning new skills. Also don't discriminate against people. We all deserve respect.

## 88. Apply for jobs you aren't qualified for

You will never meet every requirement for a job. So take a chance and apply! What do you have to lose?

## 89. Modularize your code

You could write all of your code in one long file, but this isn't maintainable. By modularizing, we ensure that our code is easily digestible and testable.

## 90. Don't JUST copy and paste

If you're going to copy and paste a solution from Stack Overflow, you should understand **exactly** what it does. Be intentional about the code you choose to introduce.

[![Coding](https://res.cloudinary.com/practicaldev/image/fetch/s--YyPmerE5--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/uts4vd8ab10x8oct7fwb.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--YyPmerE5--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/uts4vd8ab10x8oct7fwb.png)

## 91. Create an inspiring environment/setup

You'll be much more motivated to work if you enjoy your workspace and technical setup. Make it you.

## 92. Remember where you came from

We all started from the same place. As your skills and your job titles evolve, don't forget where you came from.

## 93. Try to remain optimistic

If something goes wrong, try and be optimistic. Tomorrow is a new day. Optimism will help your team dynamic and your mental health.

## 94. Continually re-assess your workflow

Just because something works now doesn't mean it always will. Re-evaluate your workflow and make adjustments where necessary.

## 95. Learn how to work from home

If you have the ability to work from home, learn to do so effectively. Find a separate office space, devoid of distractions. [Boneskull](https://dev.to/boneskull/pro-tips-for-devs-working-at-home-3b63) wrote a great article on working from home you should check out.

[![Accessibility](https://res.cloudinary.com/practicaldev/image/fetch/s--Y-0GPXeE--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/a45rv6rwqin3pzs3ztoo.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--Y-0GPXeE--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/a45rv6rwqin3pzs3ztoo.png)

## 96. Code for accessibility

Accessibility isn't an afterthought, and it doesn't have to be difficult. Everyone should be able to use your products.

## 97. Honor your commitments

If you tell someone you'll deliver something by a certain date, honor that commitment. And if you can no longer make the deadline, speak up early.

## 98. Be proactive

If you have some extra bandwidth, find a task to help your team! They'll be thankful you were proactive.

## 99. Build an amazing portfolio

A great portfolio sets you apart from the crowd. Use this as a chance to show off your programming and design skills!

## 100. Remember why you love programming

You got into this profession because it sparked an interest. If you're getting frustrated and resentful, take a break. Give yourself space to reignite your passion for programming.

## 101. Share your knowledge

If you learn something cool, share it! Present at a local meetup or conference. Teach your coworker or mentee during lunch. Sharing your knowledge reinforces your knowledge while spreading the wealth.

* * *

[![Finished](https://res.cloudinary.com/practicaldev/image/fetch/s--pg0k20vY--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/2hi4fky9ayd9dswlbdns.png)](https://res.cloudinary.com/practicaldev/image/fetch/s--pg0k20vY--/c_limit%2Cf_auto%2Cfl_progressive%2Cq_auto%2Cw_880/https://thepracticaldev.s3.amazonaws.com/i/2hi4fky9ayd9dswlbdns.png)

And that's it! I hope you enjoyed my tips for being a great programmer (and human)!

> 如果发现译文存在错误或其他需要改进的地方，欢迎到 [掘金翻译计划](https://github.com/xitu/gold-miner) 对译文进行修改并 PR，也可获得相应奖励积分。文章开头的 **本文永久链接** 即为本文在 GitHub 上的 MarkDown 链接。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
