> * 原文地址：[How to Write Clean CSS in 10 Simple Steps Pt1](http://blog.alexdevero.com/write-clean-css-10-simple-steps-pt1/)
* 原文作者：[Alex Devero](http://blog.alexdevero.com/)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[王子建](https://github.com/Romeo0906)
* 校对者：[Mark](https://github.com/marcmoore)、[Tina92](https://github.com/Tina92)

# 如何书写整洁的 CSS 代码？只需十步！

[![How to Write Clean CSS in 10 Simple Steps Pt1](https://i2.wp.com/blog.alexdevero.com/wp-content/uploads/2016/12/How-to-Write-Clean-CSS-in-10-Simple-Steps-Pt1-small.jpg?resize=697%2C464)](https://i2.wp.com/blog.alexdevero.com/wp-content/uploads/2016/12/How-to-Write-Clean-CSS-in-10-Simple-Steps-Pt1-small.jpg)

你觉得自己可以写出整洁的 CSS 代码吗？许多网站的设计开发者都认为编写良好整洁的 CSS 代码很难。事实上，许多人根本就不喜欢 CSS，对他们来说 CSS 是一个痛点。好消息来了！使用 CSS 实际上可以很简单，你甚至可以乐在其中。这个迷你系列的文章可以助你实现这个目的，只需十步即可得到整洁的 CSS 代码。要知道，书写整洁的 CSS 代码是简单愉快地使用 CSS 的关键之一呢！

##　内容列表：

简介

No.1: 坚持一种命名规范

良好的有意义的 CSS 类名

语义化命名规范之美

No.2: 使用外链样式表文件

No.3: 验证 CSS 代码

火的淬炼

No.4: 使用 CSS 代码 linter

No.5: 采用模块化的 CSS 代码

如何选择模块化框架

No.6-10 在[第二部分](https://github.com/xitu/gold-miner/blob/master/TODO/write-clean-css-10-simple-steps-pt2.md) 

# 简介

本文中有许多方法可以称得上写出整洁的 CSS 代码的第一要务，同时也可能有一些你不想使用的方法。因此很难决定哪个方法最重要，也很难对这 10 个方法进行排序。考虑良久并重排了多次之后，我决定把这个问题留给你们。在这个只有两部分的迷你系列的文章中，我仅仅是展示给你们写出整洁的 CSS 代码的 10 个简单的方法而已。

我以一种既定的顺序把这些方法展示给你，这是按照理论上每个方法所需的知识量来排序的。换句话说，前面的方法会比后面的方法容易实现。然而，这种顺序也不是一成不变的。很可能你会在排序或者方法内容上与我产生分歧，因此你可以把它想象成餐台并各取所需。

如果你发现了美味佳肴，拿走不谢，否则跳过然后继续。所有这些书写整洁的 CSS 代码的方法都基于十年来我从事的网站设计工作的经验。如果你在实践中另有所得，你完全可以有不同的见解，但请不要不加尝试地否定它。一些方法没有生效的话，请试试其他方法，或者反其道而行之，最起码你应该尝试一下。没时间啰嗦了，快上车~

# No.1: 坚持一种命名规范

你考虑过该如何创建 CSS 类和 ID（请尽量避免 ID）吗？我不是指一闪而过的念头，而是花费若干时间来深度思考。当然，我假设你使用 CSS 是迫于工作，也许你并不想把写代码搞的多么有哲理。另外还可能有些人将 CSS 视如芒刺在背，找个借口赶快写完然后去做更有趣的事情，对吧？

别担心，我不是来说服你使用 CSS 是一件多简单的事情。如果你不喜欢它，那也是你的选择。然而，我会试着说服你尝试一些其他方法，你可能经常使用 CSS，那么怎样把它变得有趣一点呢？你只需思考如何实现良好的命名规范，然后坚持下去。为什么要这样做呢？这会让你的 CSS 代码变得更具可读性。

理解了 CSS 代码，你就能更高效地书写和使用它，也更容易写出整洁的 CSS 代码，过程也就不会那么痛苦了。也就是说，好的命名规范就等于容易理解的 CSS 代码，你将向整洁的 CSS 代码迈近了一步，而远离了使用 CSS 代码的痛苦。听起来很简单是吗？那么问题来了，良好的有意义的命名规范长什么样呢？

## 良好的有意义的 CSS 类名

我觉得良好的或者有意义的命名规范很容易辨认。当看到样式表内容的时候，你就能大致了解这段代码所控制的元素，这也可以用来测试你写的代码有多整洁。你是否需要查看 HTML 代码或者加载网站才能理解 CSS 代码？果真如此，我认为你的 CSS 代码还不够整洁，至少还有进步的空间。简言之，良好的有意义的命名规范应具有描述性。

整洁的 CSS 代码中没有基于某人天马行空的想象而命名的类。如果你想发挥自己的想象力，我建议你用在其他地方。确实，以你最喜欢的书或者电影命名的类并不会造成危险，但你在酩酊大醉或者磕了药的时候修改密码就非常糟糕了，一时心血来潮起的类名与此如出一辙，因此这并不是书写整洁的 CSS 代码的正确方法。如果别人并不了解你所写的书或者电影，读你的代码简直就像读火星文一样。并且，万一你发现了另外一本好书或者好电影，你还要换类名吗？

当然，你可以按自己的喜好改变而重写所有的 CSS 代码，但是这既不高效也让人无法忍受。通常来说 CSS 或者其他任何代码都必须要如洪荒宇宙一般经得住时间的考验，其复杂性也要如此。因此最好的办法是尽快开始书写整洁的 CSS 代码，最好是从一开始就这样。如果你现在还一头雾水，那就一个月之后再回过头来看这篇文章。除了凭借想象力命名，你可以使用哪些其他的命名规范呢？

## 语义化命名规范之美

易实现且有助于写出整洁的 CSS 代码的命名规范都是基于语义化的，简言之，类名应当可以清楚地描述其控制的元素。你用过 [Bootstrap](http://getbootstrap.com/) 或者 [Foundation](http://foundation.zurb.com/) 框架吗？去看一下他们的文档你就能明白什么是语义化的类名，比如：breadcrumb、btn、dropdown、jumbotron、pagination 或者 nav。你不用查看 HTML 代码也不用加载网站就能明白这些类名的含义。

同样，这种方法也可以用于通过类名改变状态的元素。这种情况下类名应当描述其作用，比如：btn-raised 表明按钮凸起，btn-disabled 表明按钮失效，sidebar-left 表明侧边栏在左边，nav-primary 和 nav-secondary 清楚地说明了导航的重要级。

你需要照抄这些类名才能写出整洁的 CSS 代码吗？不，你可以使用自己的命名规范去创建类名。你必须要牢记类名必须具有描述性，要让其他的网站设计开发人员无需与你沟通 ，也无需查看代码或网站就能够读懂你的 CSS 代码。如果你自我感觉良好，那么让其他人来看一下你的 CSS 代码，结果可能会令你大吃一惊。

关于命名规范和书写整洁的 CSS 代码，我最后想要提醒的事情就是当你选择了自己的命名规范之后要坚持下去。最好将一种命名规范应用到所有的项目中，这会让你适应原来的项目，并且在新项目中如有神助，因为你不必每次都去琢磨起名字的事情了。我最喜欢的命名规范是啥？是 [BEM](http://blog.alexdevero.com/bem-crash-course-for-web-developers/)！

# No.2: 使用外链样式表文件

对许多网站设计开发者来说这是秃子头上的虱子——明摆着的事情，但是我认为提示一下总是有益无害的。你的大部分 CSS 样式都应该在外链样式表中，为什么是大部分而不是全部呢？根据谷歌对于优化 CSS 传输的[建议](https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery)，少量内联的 CSS 代码是有好处的。问题是，哪些是少量的可内联的 CSS 代码呢？有一些关键的样式，请戳[这里](http://blog.alexdevero.com/50-landing-pages-4-startups-lessons-pt1/)查看。

除了这些关键的 CSS 样式你可以写在 head 标签内或者小的 CSS 样式文件中，其他都应当写在主要的外链样式表文件中。要注意，外链文件需要经过压缩处理来[优化](http://blog.alexdevero.com/performance-budget-website-optimization-the-right-w)网站的性能。

只写一个主要的外链样式表文件有助于书写整洁的 CSS 代码，原因有二：第一，所有的 CSS 代码都集中在一个文件内，有助于 CSS 文件的管理，不太可能会漏掉引入某个文件。第二个原因主要是心理上的，你很难对那些突然映入眼帘的乱糟糟的 CSS 文件视而不见。在写那些小的 CSS 样式文件的时候，你会觉得它们是有顺序的，只有当所有的文件都整理到一起的时候，你才会发现那真是一团乱麻。只写一个外链的 CSS 样式表文件能迫使你关注自己的 CSS 代码。谁会愿意翻几百行的代码去改一点点内容呢？更不要说你可能根本没在用那些样式。一段时间之后，你就会决定停止这种写很多文件的荒唐的做法，并做出些改变。值得庆幸，这会是好事，比如你会花时间将一团糟的 CSS 代码整理得整洁有序，即[重构你的 CSS 代码](http://blog.alexdevero.com/refactoring-css-without-losing-client/)。最后，一个样式表文件可以助你保持你的 [CSS DRY](http://csswizardry.com/2013/07/writing-dryer-vanilla-css/)，你节省的每一行甚至每一个 kB 都是好事。

# No.3: 验证 CSS 代码

又一个无脑的建议哈？如果你想写整洁的 CSS ，你应该确保代码生效。如果这真的非常简单，那为什么网页设计开发者中很少有人使用验证服务来检查他们的 CSS 代码呢？

不管怎么说，除了维护整洁的 CSS 代码还有两个使用 [CSS 验证](http://jigsaw.w3.org/css-validator/#validate_by_input)的理由。

第一，这很容易确保你向客户端传送了完美的内容，客户端当然不大可能会验证 CSS 代码。你不会知道验证的结果将会如何，并且这仅仅是确保你的工作完美无瑕。验证器只需几秒钟时间去分析 CSS 代码，如果没有问题或者警告，你可以奖励自己一朵大红花。但是如果出现了问题或者警告呢？太棒了！这是你提高工作水平和代码质量的好机会！当你思考的时候，你就在走上坡路了！整个过程中，你要么通过了验证，要么学到了新东西，何乐而不为呢？

## 火的淬炼

接下来是我们使用 CSS 验证器的第二个理由，你可以发现自己的弱项、发现自己的错误，然后改正错误并将弱项巩固成强项。你将再次向整洁的 CSS 迈近了一步。我想强调一件事情，验证器并不能用来评判你的优劣，时刻记住它只是个工具。所以，无论结果如何都不要太往心里去。

上文提到，使用验证器跑一下 CSS 代码有利无害，你要么通过测试要么学到所需的知识。现在我要修正一下，还有一种情况是失败的，那就是你忽视结果并决定不再学习如何做得更加出色。其他的任何情况对你而言都是胜利。

我们还有一些心理上的坎要过，比如我们害怕技能测试。上学的时候，考试不及格是非常糟糕的事情，拿到一个 F 简直就是世界末日。为什么要这样呢？如我所言每一次测试都是机会，你能发现自己不擅长的东西并且巩固它，不然如果连自己的弱项都不知道，又怎么能巩固它呢？这么说来，验证器是否正中你的要害？是的！打开 Google 找到你的代码哪里出错了，为什么会错，你也可以在 [Stack Overlow](http://stackoverflow.com/) 上寻找最佳答案。记住，变的优秀的唯一的办法就是不断学习和巩固你的弱项。

# No.4: 使用 CSS linter

你是不是觉得使用验证器就像是打了鸡血一样？或者像是搏击俱乐部的 Tyler Durden？那么我来给你介绍一个叫做 [CSSlint](http://csslint.net/) 的东西。如果你认为 CSS 验证器正中你的要害并且有点伤感情，那就尝试一下这个工具吧。

这两者有什么区别吗？验证器只会提示你无效的代码，即被反对或没有完全实现的代码、语法错误以及不支持的元素。另一方面，linter 就显得更加主观一些。基于可以自定义的规则，它能提示许多被验证器忽略的内容，通常 linter 用来检测错误、重复的样式、性能、兼容性和可及性的问题。一旦你违反了规则，linter 都会有提示。我觉得使用 linter 更容易写出整洁的 CSS 代码。你也可以只使用验证器，事实上我关注的一些 CSS 最佳实践都是基于 CSS lint 的。

你记得我们第一次讨论过的 [CSS 最佳实践](http://blog.alexdevero.com/css-best-practices-become-css-ninja-pt1/)吗？如果你关注了这些内容，你可以使用 linter 测试一下，比如你可以测试关键元素的使用、ID 和过时的元素。Linter 的好处就在于你可以自己选择要检查的规则，比如你想使用 box-sizing（谁不想呢？），就把该条规则禁用掉。记住，linter 应该助你写出整洁的 CSS 代码，而不是给你造成麻烦。

同样要记住 CSS linter 中的规则并不是一成不变的，也没有人人都要关注的最佳实践。因此我建议你使用 linter 之前，按照需要自定义设置，如果你不喜欢一些规则，不要使用就是了。

# No.5: 采用模块化的 CSS 代码

第五个方法中，我们将接触更高级一点的书写整洁的 CSS 代码的方法。为什么要 CSS 代码模块化？真的有必要吗？我先回答第一个问题，CSS 代码模块化有助于我们构建和识别 CSS 样式，也有助于实现 DRY CSS。换句话说，它让你更容易写出整洁的 CSS 代码。模块化 CSS 潜在的不利因素就是需要使用预处理器，我使用的是 [Sass](http://sass-lang.com/)。

你可以书写原生的 CSS 代码并将其模块化，使用预处理器的好处就是能够切分 CSS 代码，你可以分别存储每一个代码块文件，然后在一个单独的样式表文件中将其引入。这属于管理代码的范畴了，因此并不是 CSS 代码模块化的必须方式。CSS 代码模块化是指书写可重用的代码，你将创造能够用于任何位置的模块而不用书写更多代码，这能优化性能也有利于网站维护。

我们可以花一整天的时间来讨论各种各样的框架，然而这并不是本文的目的。另外本文也已经够长了，我尽可能地长话短说。最后，有许多模块化的  CSS 框架，你可以用来书写整洁的 CSS 代码。因此……

## 如何选择模块化框架

最重要的问题来了，哪个才是最好的框架呢？我的答案是没有。根本就没有最好一说，实现方法和需求因人而异。适用于我的框架也许并不适合你，另外你也可以博采众长创造一个新的框架。因此我建议你尝试多个框架，并找到适合你的那个。

拿我自己举个例子吧。我决定使用模块化的 CSS 代码的时候，刚开始使用的是 SMACSS，这个框架简单易学容易实现，基于对 CSS 代码的五种分类，即基础代码、布局、模块、状态和主题，需要学习的就是如何识别 CSS 代码的分类。你对 SMACSS 感兴趣吗？最好的学习方法是阅读官方文档，[官网地址](https://smacss.com/)。

由于 SMACSS 的性能很好，我很长一段时间都在使用它。但是当我发现 Atomic design 的时候，我决定要上升一个档次。Atomic design 也是基于五个分类，即原子、分子、物体、模板和页面，也清楚地说明了每个特定的 CSS 样式所属的分类。我最喜欢将 Atomic design 和 BEM 一起使用，并用在了所有的项目中。你想学习更多内容吗？我给你推荐两个资源。

第一个就是 Atomic design 的[官网](http://atomicdesign.bradfrost.com/)，介绍的地非常深入，因此你需要时间来消化。第二个就是[利用 Atomic design 书写可扩展的 & 模块化的 CSS 代码指南](http://blog.alexdevero.com/atomic-design-scalable-modular-css-sass/)，这个文章会帮助你学习如何利用 Atomic design 快速书写模块化 CSS 代码的所有内容。BTW，我在博客上也发布过这篇指南。除了 SMACSS 和 Atomic design，我还会介绍至少两个更流行的框架来书写模块化和整洁的 CSS 代码。

一个是 Object Oriented CSS 也称 OOCSS。它将代码块视作可重用的对象，这仍然是模块化 CSS 代码，因此它的工作原理类似 SMACSS 和 Atomic design。我以前用过所以可以介绍地更多，请查看 GitHub 上的[文档](https://github.com/stubbornella/oocss/wiki)或者这篇 Smashing Magazine 上的[说明](https://www.smashingmagazine.com/2011/12/an-introduction-to-object-oriented-css-oocss/)。

第二个是新出的 [ITCSS](http://itcss.io/)，其基于七个层——设置层、工具层、一般层、元素层、对象层、组件层和最高层。ITCSS 乍看之下稍有难度，其实不然，一旦你理解了规则和思路使用起来非常简单。如果你对 ITCSS 感兴趣，欢迎查看 [ITCSS 全方位简介](https://www.xfive.co/blog/itcss-scalable-maintainable-css-architecture/)。模块化 CSS 的框架千千万，但弱水三千只取一瓢，今天讨论的这些足够你起步了，我希望能尽快帮助你写出整洁的 CSS 代码，而不是将你淹没在可能的选项中。

## 写在文末

第一部分到这里就结束了。今天我们学习了五个写出整洁的 CSS 代码的方法，大部分都很简单，你能马上测试并实现。你可以简单地从验证和检查 CSS 代码开始，也可以使用外链的样式表文件。或者，如果喜欢更有趣的内容，你可以创造你自己的命名规范。如果你想挑战自己，不如来尝试使用一些框架写模块化的 CSS 代码？

如果你觉得这些方法很难，请记住我们为什么要这样做——这有助于你书写易于维护的整洁的 CSS 代码。相信我，最初的不适是值得你去花费时间和精力去渡过的，把它想象成对自己的投资并且将会在未来收获成倍的回报。预知后事如何？我们会讨论一些关于 CSS 文件、自动操作、技术债务和更多内容，回见！