> * 原文地址：[Women and mobile games: learnings for developers](https://medium.com/googleplaydev/women-and-mobile-games-learnings-for-developers-cc4ac63da3f2)
> * 原文作者：[Tobias Knoke](https://medium.com/@tobias.knoke?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/women-and-mobile-games-learnings-for-developers.md](https://github.com/xitu/gold-miner/blob/master/TODO/women-and-mobile-games-learnings-for-developers.md)
> * 译者：[corresponding](https://github.com/corresponding)
> * 校对者：[hanliuxin5](https://github.com/hanliuxin5)，[tanglie1993](https://github.com/tanglie1993)

# 开发者须知：女性玩家和手机游戏

## 让手机游戏变得更加多元化，更具包容性，更具吸引力的市场机遇

![](https://cdn-images-1.medium.com/max/800/0*U3P6oAG_I-73IuY6.)

目前世界上有二十多亿部活跃的安卓设备，这意味着比起过去更多的人在玩手机游戏。手机游戏玩家的增长导致了这些游戏玩家的特点，需求和动机的多样性在不断扩大。我们之前文章 [谁在玩手机游戏](https://medium.com/googleplaydev/who-plays-mobile-games-8b33f76bb6d8) 讨论过，现在需要以满足在玩家玩游戏时的需求来对待玩家，而不是根据一些刻板印象和像人口统计那样的死板数据。与此同时，现在在游戏界有很多关于性别和包容的讨论，而关于**女性手机游戏玩家**的研究和讨论却很少。

我们想更多的了解这方面，所以我们和游戏情报商 NewZoo 合作，进行定量的研究，希望以此了解美国女性玩家的体验和看法。我们和数十位游戏作者，测评人员，玩家和学者一起合作，把我们的研究场景化。通过 [交互性的体验](https://play.google.com/about/changethegame) 和 [在总结中收获更多](http://services.google.com/fh/files/misc/changethegame_white_paper.pdf) ，我们深入研究。请继续读下去，了解开发者如何让游戏更具包容性，并吸引近在咫尺的玩家。

![](https://cdn-images-1.medium.com/max/800/0*CJxXRMyFuqRKo9kU.)

### **了解你的用户**

无论从人数上和偏好上来说，女性手机游戏玩家有巨大市场潜力。在我们的调查中，美国有大量女性手机游戏玩家（其中 65% 都处于 10 - 65 岁年龄段）。在过去的一年里，这比去电影院看过电影的比例（62%）或读过一本书的比例（44%）更加高。这里可以清晰的看出，比起其他娱乐活动，女性更愿意玩手机游戏。报告还表明，女性就和男性一样喜欢玩手机游戏 — **有一半的玩家是女性**！相比其他平台，女性不仅更喜欢在手机上游戏，而且**女性玩的频率比男性更高**。

作为游戏开发者，你意识到女性游戏的机会了吗？这可能是个通过了解这些用户而进入这个未开发的市场的机会。第一步，你可能要衡量和评估女性玩家的占比。**在你的用户群体中，女性是否被很好的代表了？她们和男性是否有不同的游戏体验？**

对开发新游戏时的建议：当你在设计游戏或者思考未来的发展方向时，多去想想那些目标用户，而不用去讨好那些你所认为的"典型"用户。不同用户的游戏体验可能会不同吗？通过彻底分析和研究用户，你可以从那些尚未被顾及的用户（比如那些女性游戏玩家）中寻找商机。

![](https://cdn-images-1.medium.com/max/800/0*0Cc60YU1-Qd9vLyl.)

### **制作更具包容性的游戏**

如果你观察 [ Google 应用市场](https://play.google.com/store) 中受欢迎的游戏，部分图像和图标的性质暗示着女性玩家在游戏世界中是一个相对较小的群体。在Google应用市场收入前 100 的游戏中，以男性角色作为图标的游戏数量比以女性角色作为图标的游戏数量多 44%。所以在我们的调查中，尽管女性玩家玩的更多，但是她们还是认为自己不属于现在的游戏社区。在推广游戏时，更换更合适的图标和形象，会让你从竞争中脱颖而出，也会减少你错过潜在玩家的可能。请尝试以下几点：

* 在做 [商店列表](https://support.google.com/googleplay/android-developer/answer/6227309?hl=en-GB) 时，**测试更有包容性的图像**。
* **多关注应用的图标，截图和视频**，并考虑测试不同图像对转换率的影响。
* 考虑下**使用女性角色来体验游戏**，或者在运行**电话回访**时**尝试新的可能性**。
* 追踪用户对游戏角色的共鸣，同时**倾听用户群体的反馈**也很重要。

### **发展一个多样化的开发团队**

在一大群人中提取共同需求很难。我们都想开发**自己**想玩的游戏。为了减少偏见，**在游戏生命周期的几个阶段，都需要获取潜在用户的反馈**。

你的开发团队的形象也影响能否取到悦更多的用户。尽管有如此多的女性玩家，游戏行业仍然只关注男性用户: IDGA的调查发现，女性、跨性别者和其他只占 [全球 27.8% 的游戏产业](http://c.ymcdn.com/sites/www.igda.org/resource/resmgr/files__2016_dss/IGDA_DSS_2016_Summary_Report.pdf) 。这种不平衡的现象呼应我们的研究结果，只有 23％ 的女性和 40％ 的男性认为在游戏行业中人人享有平等的待遇和机会。

来自团队成员多样化的观点将帮助您开发真正创新且有意思的游戏，并且吸引更多的潜在玩家。现在就看下自己的团队和游戏的用户构成的差别。你的团队成员能代表你的受众吗？您的团队是否已经整装待发，来帮助您最大化的捕获潜在受众，并且让您的游戏吸引所有人？

![](https://cdn-images-1.medium.com/max/800/0*yzQKH9Q6AmI0Ex-x.)

### **把握这个机遇**

尽管未来女性玩家数量巨大，但研究结果却让人惊讶，他们比男性更难以真正接受自己的游戏爱好。大部分女性玩家不属于游戏世界。一般女性玩家不太喜欢和朋友交谈游戏内容，为游戏付费，以及享受付费所带来的快乐。

我们相信，这是一个游戏产业真正与女性玩家互动的绝佳机会。随着用户获取成本的上升，需要想想如何能开发出与所有玩家产生共鸣并且能病毒式传播的游戏。只有让女性玩家参与到游戏中，你才能解决这个问题。

### **着眼未来**

我们相信，游戏市场还有很大的空间，能让我们使手机游戏更加多元化，更具包容性，更吸引所有玩家。为了把握这个机会，您的第一步是：

* 了解你的用户：当前用户和潜在用户
* 研究你的游戏是怎样把一些潜在用户排除在外的
* 评估你团队观点的多样性，这将如何影响你开发的游戏
* 头脑风暴，你可能会想出一款所有人都喜欢的游戏

手机游戏生为大众。为了褒奖和激励女性玩家和女性开发者，我们启动了 [改变游戏](http://g.co/changethegame) 的计划。这是 Google 应用商店的一项旨在促进游戏多样性的计划，同时这项计划也褒奖所有女性玩家，并通过正在进行的研究和合作为下一代游戏开发者提供支持。

作为一个应用开发者，你能影响未来游戏的走向。我希望你能参与到我们活动中，和我们一起让游戏世界变得更加包容性。如果我们一起努力，手机游戏的世界会变得更加有趣。

* * *

### 你是怎么想的呢？

你有没有想过开发人员怎样去设计更有包容性的游戏呢？在文章下面留言或者 twitter 中添加**#AskPlayDev**标签后发言，我们会通过 [@GooglePlayDev](http://twitter.com/googleplaydev) （那里我们会展示在 Google 应用商店获得成功的窍门）回复。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
