
  > * 原文地址：[Why we desperately need women to design AI](https://medium.freecodecamp.org/why-we-desperately-need-women-to-design-ai-72cb061051df)
  > * 原文作者：[Kate Brodock](https://medium.freecodecamp.org/@Just_Kate)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/why-we-desperately-need-women-to-design-ai.md](https://github.com/xitu/gold-miner/blob/master/TODO/why-we-desperately-need-women-to-design-ai.md)
  > * 译者：[TobiasLee](http://tobiaslee.top)
  > * 校对者：[Larry](https://github.com/lampui)、[Xinyu Zhang](https://helloworldzxy.github.io)

  # 为什么我们渴求女性来设计 AI

  ![](https://cdn-images-1.medium.com/max/2000/1*BNY9_C8mmlofjyQGEwHD4w.jpeg)

[Siyan Ren](http://unsplash.com/photos/qLiFcanSpuA?utm_source=unsplash&amp;utm_medium=referral&amp;utm_content=creditCopyText) 在 [Unsplash](https://unsplash.com/?utm_source=unsplash&amp;utm_medium=referral&amp;utm_content=creditCopyText) 上的摄影作品

现在，在互联网和软件行业的工程师中，只有 12-15% 是女性。

这里有两个例子来说明为什么这是一个严重的问题：

- 你还记得 Apple 几年前发布的“健康”app 吗？它本意是提供一个健康信息和数据的“综合”接入点。但是，它却遗漏了一个几乎是所有女性都要面对的[健康问题](https://www.theverge.com/2014/9/25/6844021/apple-promised-an-expansive-health-app-so-why-cant-i-track)，然后 Apple 又花了一年来弥补这个缺陷。
- 有个非常喜欢玩游戏的中学生女孩，但在游戏里她却找不到她能用的头像，因此非常沮丧。她[分析](https://www.washingtonpost.com/posteverything/wp/2015/03/04/im-a-12-year-old-girl-why-dont-the-characters-in-my-apps-look-like-me/)了 50 款流行的游戏，然后发现其中 98% 都提供了男性头像（绝大多数是免费的），而只有 46% 的游戏提供了女性头像（绝大多数是收费的）。当你知道几乎有[一半的玩家是女性](http://www.ecnmy.org/engage/45-percent-of-gamers-are-women-but-in-every-other-way-theyre-still-not-equal-to-men/)，是不是感到更加不公平了。

我们不想让这样的事情再次发生，并且坚持在 [Women 2.0](https://medium.com/u/594d2bf6a0ba) 上强调这一点，我们已经做了十多年了。我们思考了很多关于多样性如何产生或为何缺乏的问题，我们认为它已经影响到并将持续影响到我们生活中的技术成果。这些技术与我们息息相关：决定我们的行为、思维过程、购物方式、世界观……以及任何其他你能提及的范围。这是我们最近推出一个女性技术人员的招聘平台 [Lane](https://lane.women2.com/) 的一部分原因。

是谁来**创造**技术，这会直接影响到我们自身和周遭的世界。

没有比 AI 和机器学习更具话题性了，它们渗透进了各个领域 — 家庭、金融、购物、娱乐……以及其他你能说出的领域。

除了一些显而易见的原因，还有什么呢？

### 多样的技术人员，才能有多样的产品

你可以说 AI 是迄今为止我们见过能够对人类社会产生最大范围、最深远影响的技术之一，它触及或将触及我们所关心的绝大部分领域。而 AI 产品的形成和创造它的人的道德伦理水平、价值取向（是否存在偏见）以及个人权利是密切相关的，这就意味着我们需要密切关注：产品是否能代表所有的使用者。

但这并不是一个既定的事实，谷歌 AI 和机器学习首席科学家[李飞飞](https://www.wired.com/2017/05/melinda-gates-and-fei-fei-li-want-to-liberate-ai-from-guys-with-hoodies/)早就已经认识到了这个问题。

> “如果我们不让女性和有色人种参与技术工作 - 把她们当做真正的技术人员，让他们做真正的工作 - 那么我们的系统就会存在偏见。若想在从今往后的十到二十年之内扭转这个现象，即便有这样的可能性，也是微乎其微的。是时候让我们听听女性和其他的声音了，这样我们才能创造合理的产品，难道不是吗？这会很棒很酷，并且逐渐普及。但重要是我们必须让他们参与进来”  —— 李飞飞


![](https://cdn-images-1.medium.com/max/1600/1*HlvAvkUrrZHRVaqHfERc0g.png)

AIForAll 的 Melinda Gates 和李飞飞，感谢 Pivotal 提供的照片。

Melinda Gates 和李飞飞创立了 [AI4All](http://ai-4-all.org/)，这是一个针对部分 9 年级学生的课程，它将让这些学生们体验 AI 和机器学习。目前他们最大的障碍之一就是，AI 方面的技术领军人物自身缺乏多样化，所以挖掘具备代表性的编程人才需要大量的搜寻和筛选工作。

构建 AI 的工程师的价值体现在他们拿出来的解决方案里，选择你家卧室粉刷的颜色可能不会有多大社会影响，但是如果你是在考虑如何改善癌症护理的质量，那就是另一个故事了。

[IBM](https://www.ft.com/content/ca324dcc-dcb0-11e6-86ac-f253db7791c6) 知道这一点，所以他们设计了无性别的头像，来和医生一起改善癌症护理。

IBM 的 Waston IoT 业务部门总经理 Harriet Green 表示，这是他们公司已有的“生活和呼吸多样化”的企业文化，引导下的结果。她说：“IBM 拥有不同性别和不同国籍的混合工程师团队，有来自中国、斯里兰卡、德国、斯堪的纳维亚和英国的成员”。

### 管理机器永久化的行为

[Leah Fessler](https://qz.com/911681/we-tested-apples-siri-amazon-echos-alexa-microsofts-cortana-and-googles-google-home-to-see-which-personal-assistant-bots-stand-up-for-themselves-in-the-face-of-sexual-harassment/) 在测试了几个个人助理机器人之后，写了一篇令人大开眼界的文章：看看她们是如何忍受性骚扰的（从字面上来看，他们性骚扰了女性机器人。顺便一提，如果你不改变设置的话，助理的声音默认是女性的）。

结果并不是很好：机器人并没有反抗骚扰，而是被动消极的回应，这巩固了性别歧视。

文章里这句话特别吸引我：

> “之所以 Siri，Alexa，Cortana 和 Google Home 是女性的声音，是因为这样能够赚到更多的钱。是的，硅谷是一个由男性主导并且性别歧视到[臭名昭著](https://qz.com/531257/inside-the-surprisingly-sexist-world-of-artificial-intelligence/)的地方，但该现象的内在原因远不止于此。顾客们喜欢数字助理有女性的声音，而机器人助理的设计者为了获得顾客的满意，来收获市场上的成功，从而被驱动着把助理们的声音设计成女性。”

我们可以进一步讨论机器人设计如何与资本主义相联系，使之成为历史规范而永久化，但 Leah 更甚。除了这些机器人“是女性”之外，她们会如何被对待？她们会做什么？

下面是一些 Fessler 提供的她工作中的样例：

![](https://cdn-images-1.medium.com/max/1600/1*Cv2NMnSbl1P8oqegGpcFoQ.png)

> “Siri 和 Alexa 仍然是回避、感激或者是调情，而 Cortana 和 Google Home 则为了回应她们所理解的骚扰而开始讲笑话。”

Leah 还提供其他几个例子，所有这些都表明，负责这些机器人的程序员在构建响应集时已经意识到了一些问题，但是直到“强奸”这个词被提出之前，对这些行为的回应都是错误的（如你所见，上面和在其他例子中，一些响应集是彻头彻尾的可怕... Siri 实际上想要调戏回去！）

最后：

> “尽管这些机器人背后的开发人员的确切性别比例我们不得而知，但我们绝对可以肯定绝大多数是男性；在创造这些机器人的科技公司里，女性只承担了 20％ 不到的[技术工作](http://graphics.wsj.com/diversity-in-tech-companies/)。因此，男性的机器人开发人员在编程这些机器人的时候，很有很可能用笑话作为对性骚扰的回应。他们是喜欢机器人这样“幽默”地回应，而不是明智和直接地对性骚扰做出反抗吗？

这只是一个例子，说明如果您的工程师团队思想单调（或称为**缺乏多样性**），那么在创造我们每天都要交互的技术产品的时候，他们可能会巩固（甚至加剧？）一些我们正努力去改变的低俗文化和社会习俗。

### 解决的方法：让工程师团队有更多的女性

有大量的研究表明：公司中女性比例的上升在各个层面 — 特别是[领导力](https://www.fastcompany.com/3033950/why-the-most-successful-organizations-have-women-and-millennials-in-charg) — 都有着积极的影响。没错，这意味着更多的[钱](https://www.inc.com/melanie-curtin/science-companies-with-women-in-top-management-are-significantly-more-profitable.html)。

那么创造一些东西，比如 AI 的时候，会怎么样呢？思想的多样化可以帮助[解决问题](http://www.scientificamerican.com/article/how-diversity-makes-us-smarter/)，女性被认为是更具有[协作能力](https://medium.com/@theBoardlist/5-reasons-why-having-women-in-leadership-benefits-your-entire-company-labor-day-2016-a3e46162a7a0)。有更多女性的团队和全是男性的团队相比，会更有[生产力、创造力和实验精神](http://www.popularmechanics.com/technology/a19908/secret-weapon-women-in-technology/)。程序媛也可以写出[很棒的代码](https://www.usnews.com/news/blogs/data-mine/2016/02/18/study-shows-women-are-better-coders-but-only-when-gender-is-hidden)。

如果我们想设计能解决实际问题并且能够可持续化发展的 AI 驱动型产品，那么我们需要最好的团队。我们在项目中需要有不同的意见和想法，这意味我们需要增加工程师团队里的女性数量。

所以，快去招聘女性吧，你会回来感谢我们的！


---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
  
