> * 原文地址：[Why User Experience Always Has to Come First](https://hbr.org/2016/09/why-user-experience-always-has-to-come-first)
* 原文作者：[Michael Schrage](https://hbr.org/search?term=michael+schrage)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Nicolas(Yifei) Li](https://github.com/yifili09)
* 校对者：[Linpu.li (llp0574)](https://github.com/llp0574), [Siegen (siegeout)](https://github.com/siegeout)

# 为什么用户体验最重要！最重要！最重要！

事实胜于雄辩。如果一个 `UX` (用户体验) 感觉上更像是“用户开发”而不是“用户体验”，那这笔生意离失败不远了。建立在与用户发生冲突，干扰以及刺激行为之上的盈利一定是无法维持下去的。只顾挣快钱而不是提供更好的用户体验，这有悖于以用户为中心的理念。  

这就是为什么一般而言数字服务，尤其是移动手机广告为了评估商业模型设计要制作最好的模板。将实时数据和预测分析紧密结合，可以让严格的企业能快速地在理论和实际的用户体验之间计算和权衡。这些利弊已经变得相当明确了。几乎企业中的每个人现在都可以在价值创造中知道那些受尊重的用户在哪里，以及哪里能收集到他们形成的数据集群。

举例来说，`Facebook` 从移动广告客户那里赚到了大笔的钱，但是它目前拒绝资助那些破坏整体用户体验的低效率的技术。大概 40 % 的用户会放弃（继续浏览）网站因为[它需要三秒才能加载页面内容](https://www.facebook.com/business/news/improving-mobile-site-performance?__mref=message_bubble)。延迟问题经常导致了用户的流失，对 `Facebook` 来说也不可避免。毫不意外，这些公司都会告知广告客户加快他们的加载速度，否则就会终止生意。

“我们的目标是在移动设备上带给用户最好的广告体验。通过考虑网站的性能和单个用户的网络关系，我们能提高这些体验并且带来广告商期待的结果。” 一位 [Facebook 的发言人如是说道。](http://www.wsj.com/articles/facebook-pushes-advertisers-to-speed-up-their-mobile-sites-1472673181)

大致来说，当加载广告带来的延迟明显破坏了用户体验质量的时候，`Facebook` 就会对那些拖节的广告商的广告延迟开销进行用户体验的优化。任何形式的用户流失是一个日益可衡量的结果。`Facebook` 曾有力地宣称，比起劣质的广告，他们更看重优秀的用户体验。

这凸显出了一个基本动态，它就是将数字产品和服务转为全球化: 动态定价被动态投机主义取代。这就是，平台的提供商和创新生态圈开始重新思考，怎样真正通过用户和合作伙伴赚钱。这意味着他们必须一直计算通过降低他们的用户体验来换取热钱或者块钱在什么时候是否值得。

持续网络融合数据和分析基本上迫使企业透露他们如何看待用户关系的价值，作为合作伙伴，或作为对手经过一系列事件的积累。比起后一种看法，前一种看法激励了一个不同的用户体验上的投入。

减少用户体验的烦恼和干扰是毫无疑问的，它与钱和创造价值无关。但对更多的企业来说，技术让他们很轻易就能侥幸做出一些给自己[带来效益，却干扰](https://www.sitepoint.com/why-i-love-interstitials-2/)了用户体验的小缺陷。换句话说，对每个用户和合作伙伴们微不足道的诱惑和机会都成倍增长。

`Google` 的策略[减少了插页式广告](http://www.theverge.com/2016/8/23/12610890/google-search-punish-pop-ups-interstitial-ads) - 到处传播，错综复杂，充满整个手机屏幕的弹窗广告 - 更是增强了这个主题。 

“`Google` 的目的不仅仅只是让人们搜索到更多的信息结果，也是希望这些结果可以让他们更好地工作 - 例如，不要用弹窗广告惹恼他们，” 弗奇观察到。“这也是 `Google` 用他们的搜索算法正在干的事情。” 去年他们开始[提高 ‘移动端友好’ 网站的搜索排名](http://www.theverge.com/2015/4/21/8463401/google-now-boosting-mobile-friendly-websites-in-search)，以及在 2014 年，也开始提高[加密网站的搜索排名](http://www.theverge.com/2014/8/7/5979609/google-is-nudging-us-towards-a-more-encrypted-web)。”

注意这个弹出框的 `IQ` - 干扰指数 - 它是 `Google` 用来加权其移动搜索算法的千百种统计元素中的一个。这意味着，`Google` 追踪用户流失率和 `Facebook` 一样严格。但主要问题还是没有解决: 什么时候开始用户体验感觉像，或者说变成了用户开发？ 

那些真正让用户感兴趣或者讨好他们的广告显然很受欢迎，无论它的出现会怎么干扰到了用户。接纳率和流失率现在被越来越严格地追踪和分析。

但是最重要的收获不应该反复掂量有关广告的效率，而应该是怎样 - 从个人和整体上 - 去定义广告和决定用户体验。这些现象，例如细琐的错误（灭顶之灾），或者弹窗广告，对可持续性的平台和生态圈的增长来说都是一个实实在在的威胁。

所以这些用户体验的主题超越了数字广告的趋势。例如一位亚马逊的开发工程师告诉我，她的公司花费了很大的力气去避免对用户的数字化干扰。整个 `KPI` 的评价标准都是围绕着接纳/流失率的表现来创建的。一些测试正在被激烈的讨论着，它们明确地检查了“最优质”的用户或者“普通”用户是如何响应数字带来的干扰。她坚持认为提高亚马逊整体的用户体验是首要任务。优化整体的关系，而不是个体事务，是核心价值。

企业内外领导者围绕以用户为中心的挑战变得越来越鲜明和严酷。商业规则是否会围绕为用户价值优化用户体验而重新考量？或者“动态投机”是否转交到用户开发？你的企业是如何定义和管理它的接纳/流失率将会让你找到答案。
