> * 原文地址：[Why do people open emails?](https://blog.mixpanel.com/2016/07/12/why-do-people-open-emails/)
* 原文作者：[Justin Megahan](https://blog.mixpanel.com/)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Deadlion](https://github.com/Deadlion)
* 校对者：[Aberfield](https://github.com/lk415064460), [mypchas6fans](https://github.com/mypchas6fans)

# 人们为什么会打开你的营销电子邮件？

人们为什么打开电子邮件？每次将文章推送给 _The Signal_ 的订阅者我都会思考这个问题。当文章到达你的收件箱，还有共享谷歌文档和其他简讯可以选择，是什么让你打开邮件然后阅读它呢？

我听说过最佳做法，我努力坚持下去，但是我忍不住想它们是否真的有区别。但是要搞清楚这些的话，我需要数据，很多很多的数据。

所以，**分析了来自 Mixpanel 85,637 个活动的主题行 - 总共发送 17 亿封电子邮件，其中 2.32 亿封被打开**，时间跨度从 2012 年 6 月到 2016 年 5 月，我期待着为这个一直困扰我的问题找到答案——究竟是什么让人们打开一封电子邮件？

有件事情值得一提的是，Mixpanel 活动不一定是一次性群发给整个邮件列表的。它们可以这么做，但更多的时候它们是事件驱动的电子邮件，意味着用户的某些动作触发了邮件通知。举个例子，一个活动可能把最近30天内创建账号，但是最近7天没有登录过的用户作为目标用户。然后在该活动有效期内，只要用户符合要求，他们就会收到电子邮件。

好吧，下面就是我所学到的东西。

## 大多数邮件是没人看的

出门右拐，不管其他的数据。我们都知道，这是个残酷的现实，就是大多数邮件不会被打开。我关注的那些邮件跨行业，有着不同的目的。它们包含了一切东西，当用户完成某项特定任务而发送非常有针对性的邮件，或非常广泛的"欢迎"或电子商务销售电子邮件。**所有这些发送的邮件打开率为 13.53%**

#### 所有活动

85,637 活动数  

232,706,223 打开数  

1,720,490,613 发送数  

**13.53% 打开率**

但有些活动确实不符合平均比例，而是比别人更好，超过 100 位接收人的 49k 个活动中，**五分之一打开率超过 50%**。同时，**超过五分之二打开率低于 10%**。

所以，差异还是蛮大的，显然这里有很多因素在影响着结果。只控制主题行，不同主题对整体打开率有怎样的影响呢？

## 主题行不能太长

很长一段时间，我听说主题行字符长应该是[在 40 和 60 之间](http://www.universalwilde.com/blog-0/bid/140949/5-Tips-That-Will-Get-Your-Email-Campaigns-Read)。比如，我们最近发出的一篇文章[“Survival Metrics”](https://blog.mixpanel.com/2016/06/23/survival-metrics-will-help-company-survive)，它的电子邮件主题行长 42 个字符：

_How will you help your company survive?_

这儿还有另外一个典型 [our profile of Hunter Walk](https://blog.mixpanel.com/2016/07/06/hunter-walk-early-stage-venture-capital/?discovery=homepage%20feature)，这篇就超过了范围, 65 个字符:

_Hunter Walk grew YouTube by 40x. Here’s his advice to startups_

但是通过分析大数据中的打开率和主题行字符数的相关性发现，40-60 字符数的“标准”很明显有点过时了。

[![](https://blog.mixpanel.com/wp-content/uploads/2016/07/subject-length-ctt-228x300.png)](https://twitter.com/intent/tweet?text=Why%20do%20people%20open%20emails%3F%20%20https%3A%2F%2Fblog.mixpanel.com%2F2016%2F07%2F12%2Fwhy-do-people-open-emails%2F%3Futm_campaign%3D%26utm_source%3Dtwitter%26utm_medium%3Dsocial%26utm_content%3D%20pic.twitter.com%2FnY6uBYBnKd)  


虽然你可能不想再读 80 字符的主题行，桌面客户端仍然做了大量的工作全部显示它们。但是越来越多的时候，我们是在移动设备上阅读邮件。在 app 里，像 Google 的 Inbox，主题行被截断成 27 个字符，后面加上一个省略号。所以我们上面例子的主题行会变成这样：

_How will you help your comp…_

_Hunter Walk grew YouTube by…_

最佳做法绝对是少于 40 字符。想想我们现在是如何阅读邮件的，就不会觉得惊讶了。

让我们来看看截断的主题行的打开率，**主题少于 30 字符的有 15.05% 的打开率，那些主题超过 30 字符的打开率为 12.92%**。

![IMG_0394](https://blog.mixpanel.com/wp-content/uploads/2016/07/IMG_0394-300x154.png)

#### 小结

尽量简短。超短。而当主题行超长了，至少要确保前 30 个字符是诱人且有足够的信息让移动端读者有欲望打开它。

## 个性化有实质性的帮助吗?

另一项标准的建议是个性化的电子邮件。你可以使用任何一项你收集到的和邮件地址相关的信息，但最常见的还是收件人的姓名。个性化的核心思想就是通过使用个性化的东西，主题行显示给收件人更多的照顾，她就更有可能将其打开。

但是，当实际上我看到数据的时候，并不是所有个性化都有这种效果。

#### 包含变量

6,117 活动数  

14,361,034 打开数  

153,694,066 发送数  

**9.34% 打开率**


我分析了包含变量的 7% 的活动，但是打开率非常低，只有 9.34 %，远低于 13.53% 的整体打开率。

但是当我审视自己的个人 Gmail 时，这么低的打开率也就不足为奇了。我看到大量 “personalized(个性化)” 邮件。很少一分部我会打开，但是大多数我都不会。

更重要的是，我的名字在主题行不再值得关注了。邮件合并并不是什么新东西，像 Andrew Chen 在[增长骇客](https://blog.mixpanel.com/2016/03/16/andrew-chen-and-the-state-of-growth-hacking/)中提到的战术衰减。我敢肯定为每个用户定制电子邮件仍然有增长的空间，但是需要比名字更个性点。

#### 小结

如果你真的想让主题行更加引人注目，包括一个名称变量。但是不要因为你可以放就一定要放一个名字在那。五年前，可能在主题行看到自己的名字会觉得与众不同，但是现在真的过时了。

## 别嚷嚷，矜持点。

之前的最佳实践现在都有些过时了，那来看看有哪些习惯是应该避免的：惊叹号。很长一段时间里，大家都形成一个共识，带感叹号的都是垃圾邮件，应谨慎使用，否则你的邮件有被垃圾邮件过滤器拦截的风险。然而，我发现很多主题行仍然使用感叹号。看看下面的数据：

#### 包含 ‘!’

22,844 活动数  

62,989,308 打开数  

576,772,852 发送数  

**10.92 % 打开率**

看起来像是这么回事，老实说，打开率并没有我预期的打击那么大。当我开始看到有多个感叹号的主题行，打开率骤降。带三个感叹号的主题行遭受的打击最大，打开率下降到凄惨的 7.59%。

那么，如果一个感叹号是垃圾，那三个感叹号简直就是粗鲁。那么来对比下礼貌的词语，如“谢谢你”、“请” 和“对不起”，来看看礼貌对打开率的影响。

#### 包含 ‘谢谢’, ‘谢谢你’, ‘请’, ‘对不起’

1,478 活动数  

3,911,452 打开数  

17,022,299 发送数  

**22.98% 打开率**

####

正如你所看到的，它是一个相当可观的增加。原来礼貌点很有帮助。

#### 小结

采取一些数据驱动的建议：不要叫喊，始终注意自己的礼貌。真诚的使用“请”、“谢谢”和“抱歉”等礼貌用语。

## 好奇心，想知道

在 Buzzfeed 的时代，你会经常看到“你永远不知道接下来会发生什么”这样的标题党。但是他们总能吸引人的眼球是有原因的，虽然其背后缺乏有价值的东西：它们很诱人，它们捕获了你的好奇心，想知道吗？快来点击吧。

看看那些带个问号或"如何"的主题行，挑逗着读者打开后面的答案。

#### 包含 ‘?’

10,724 活动数  

27,387,349 打开数  

180,003,478 发送数  

**15.21% 打开率**

#### 包含 ‘如何’

701 活动数  

2,747,926 打开数  

13,302,419 发送数  

**20.66% 打开率**

一个问号能提升一些打开率，但是一个像“如何”这样的短词通过引诱点击让读者知道点击后的内容。它们能有更高的打开率。

#### 小结

让读者们知道打开后能得到什么，比如回答一个问题，引诱他们打开它。

## 表现事情的紧迫性?

另一个最佳实践的建议是使用“今天”和“现在”这类词，创造紧迫感。在与日渐高涨的电子邮件浪潮抗争的今天，已经不是我们有意识的决定不打开某封电子邮件，通常我们只是没有理由立即打开它。然后老的邮件就被新的邮件所淹没，所以很多邮件从来没打开过。

在主题行中创造些紧迫感来制造点压力，当用户第一次看到电子邮件的时候可能回打开它。但是实际上真的有用吗？

#### 包含 ‘今天’, ‘明天’, ‘今晚’, 或者 ‘现在’

4,669 活动数  

11,979,604 打开数  

94,559,225 发送数  

**12.67% 打开率**

显然没有。事实上，它比平均打开率略低。创造一种紧迫感似乎并不足以伤害到开放率，但它肯定也不会让人们急于打开电子邮件。

#### 小结

只要适当的使用“现在”和“今天”之类的词是没问题的，但是不要仅仅因为你觉得这些词会让人们打开你的邮件而硬塞这些词。

## 用上 $$$

还有些大促销的电子邮件，试图带动收入增长。这些邮件不可能总是你喜欢接受的，但是他们发送的理由只有一个：挣你的钱。

#### 包含 ‘优惠’, ‘优惠码’, ‘优惠券’, ‘大减价’, ‘$’, ‘折扣’

9,370 活动数  

21,900,339 打开数  

211,747,667 发送数  

**10.34% 打开率**

说实话，比我预期的要高。当你不想看到这些促销的时候这些就是垃圾邮件。所以，根据促销活动或者发件人，很多人可能还愿意在收件箱中看到包含这些词语的主题的邮件。至少直接表明了邮件的目的。也许诚实不负有心人。

但最烂的推销词是“免费”。一般要避免用它，它会被垃圾邮件过滤器屏蔽。我完全理解。但我仔细查看后发现这一惯例在数据面前站不住脚。

#### 包含 ‘免费’

2,017 活动数  

6,272,514 打开数  

36,312,363 发送数  

**17.27% 打开率**

这很难理解啊。前面我们可能看到一些老的最佳实践已经过时，但这个结果让我大吃一惊。也许我们反对使用“免费”这么久，可能有些矫枉过正了，那些敢用的人受益了。我也搞不懂为什么，但不管怎样，“免费”这个词还是有用的，所以我们再推翻一遍之前的说话。

#### 小结

这里要记住重要的一点，对于促销邮件来说，打开速度并不能代表什么，还是得看结果——收入的增长。不过出乎意料的是，带“大减价”和“优惠”这类词的促销邮件维持着不俗的打开率，而带“免费”的邮件打开率却大幅的增加。

## 尽量避免广撒网?

我研究的最后一件事是关于每个活动发送给多少接收人。有针对性的发送给 5,000 人，和发送给 500,000 人打开率会有什么不同？

原来答案是肯定的，比我预期的多。

[![number-of-sends-ctt](https://blog.mixpanel.com/wp-content/uploads/2016/07/number-of-sends-ctt-223x300.png)](https://twitter.com/intent/tweet?text=Why%20do%20people%20open%20emails%3F%20%20https%3A%2F%2Fblog.mixpanel.com%2F2016%2F07%2F12%2Fwhy-do-people-open-emails%2F%3Futm_campaign%3D%26utm_source%3Dtwitter%26utm_medium%3Dsocial%26utm_content%3D%20pic.twitter.com%2FDXV10CD4w7)


你可以看到，发送的越多，打开率越低。这说明，使用电子邮件营销，一种“口味”并不适合所有人。那些大型群发电子邮件毫无针对性，这意味着不同群体的读者会发现他们并不被关注。另一方面，小范围的邮件——比如用户做了特定的事情满足群发条件，然后（被）发送的邮件，能达到更高的打开率。给 5,000 人发送的活动打开率是给 500,000 发送的两倍。

#### 小结

不是要少发邮件，而是有针对性的创建一些更有特点的邮件活动，精心维护每一个小用户群体。

## 别用过去的最佳实践来创建未来的电子邮件

分析完这些数据，数据再好看也不能代表什么，我想表达的是，我们需要去质疑曾经的最佳实践。想想六年前你开始发送邮件，学到了什么。看看你们公司还在用的方法。事物变化的太快，不要把营销戒律当成箴言刻在石头上。

从数字和这篇文章中所学到的，同样也需要去质疑。惯例也会变。人们阅读邮件的偏好也会变，2011 年觉得这个主题行很吸引人，2016 年可能就不感兴趣了。像在主题行中包含用户的名字，这种策略也很快过时了。曾经“有毒”的一些词，可能今天就“没毒”了。

看起来很简单。我们都只是在想尽办法让大家点主题行，瞄一眼我们的邮件。但大家都一样。花时间来构思好的主题行，找出有效的方法，然后发出让用户想要打开的邮件。

_还有你想知道，但我们没有测试到的好办法? 快告诉我们吧。 邮件 [blog@mixpanel.com](mailto:blog@mixpanel.com) 或 tweet [@mixpanel](http://twitter.com/mixpanel) 我们会看的._

[![](https://blog.mixpanel.com/wp-content/uploads/2016/07/why-do-people-open-emails-ctt-300x150.png)](https://twitter.com/intent/tweet?text=Why%20do%20people%20open%20emails%3F%20%20https%3A%2F%2Fblog.mixpanel.com%2F2016%2F07%2F12%2Fwhy-do-people-open-emails%2F%3Futm_campaign%3D%26utm_source%3Dtwitter%26utm_medium%3Dsocial%26utm_content%3D%20pic.twitter.com%2FoRptlv49gp)

_图片来自 [Andrew Taylor](https://www.flickr.com/photos/profilerehab/5707316547/in/photolist-9Gkunr-7bfPS1-KzGwZ-oxMAXY-hRmQD-J2dst-bBavHS-jWUyA-2q6n8-8F2iz9-6cdZ7H-FDFThy-3KMTAm-4kC7Ca-ouAjEm-7ZNTFh-5Qmfb6-5pw1mA-wUdon-6B817j-Bddh5-4gEfk-e3G5f-83bVCz-6k1NHD-4BSCA-bEGXg2-4qwMSH-bkbnqV-4kXzr5-kVsR6-48G2hm-4SKBZG-8iq4Go-vJs7G-cHDRcC-FF1gsD-daVFYT-33wxA-59sbz3-FCPKt-6HknLQ-2keEL6-4kTxdr-MGo5-fdVi2-afBt81-284GwD-oFg5-LLPYr), 遵守版权 [Attribution 2.0 Generic license](https://creativecommons.org/licenses/by/2.0/) 下可用_
