> * 原文地址：[Why design principles shape stronger products](https://uxdesign.cc/why-design-principles-shape-stronger-products-ae677bdd831b#.20fz1utbj)
* 原文作者：[Jessie Chen](https://uxdesign.cc/@lovejessiecat)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[rottenpen](https://github.com/rottenpen)
* 校对者：[mypchas6fans](https://github.com/mypchas6fans) [Graning](https://github.com/Graning)

# 好的设计准则是如何塑造更强大的产品形态的

我们设计团队没有任何设计原则，这导致我们很难评判设计。

我的工作是为房地产专业人士设计/改善一个旧的 CRM 系统。我们常常会碰到设计的瓶颈，因为我们没有任何设计原则可做参考。我们的用户有着自己对产品喜好的标准。有的用户觉得这个系统是一个能创造销售机会，推进业务和管理联系人的好工具。但有些人会认为这系统奇怪且不易操作，会使完成任务变得繁琐费时。是什么限制了它，让它需要改进那么多东西呢？

#### 新功能 vs. 存在的问题

我们与我们的研究团队合作，对用户进行测试与访谈。包括测试已有功能和重新设计原型。我们收集用户的反馈，并进行分类，以明确或确认适用性问题。我们进行了一次又一次的用户测试，设计和迭代。然而，当我们努力提高产品的同时，新的需求往往会被提出。这可能是令人沮丧的，尤其是在已经出现适用性问题的页面上。你添加的函数越多，它就会变得越复杂。

#### 传统的设计模式

在工作中，我们有我们的传统设计模式。因此，新的设计往往都有着一致性。从理论上说，一致性是必要的，因为我们不想阻碍用户流畅地使用我们的界面。与此同时，我们希望页面跳转更快，任务点击更少。但是这样就必须牺牲一致性。那我们该怎么办呢？一致性与效率哪个更重要呢？

#### 用户需求 vs. 设计需求

通过用户测试，我们了解到用户的需求往往和设计的需要不一致。承认吧，我们经常会基于假设进行设计。我们认为，我们清楚用户流程而无需进一步进行研究。实际上我们并不总是对的。事实教会了我们要有以人为本地思考“为什么”的意识。为什么用户就是不明白呢？为什么他们找不到这样一个明显的按钮呢？为什么他们不想使用我们认为有用的功能呢？为什么他们不喜欢现有的功能？那么多的为什么一直困扰着我们。

我们了解到，该公司建立了多年的 CRM 客户关系管理。它从版本 1 开发到了如今的版本 3 。为什么现在版本的工作模式没有做成跟过去版本一样呢？我们从这里开始意识到，用户是不同的。当你对待不同的用户，先去了解他们的需求是很重要的。我们需要了解我们为谁设计。确保你知道他们的用户背景，以及他们背后的故事等。

### 启示

我们得出的结论是，我们需要建立一套设计原则。我成立了一个设计团队会议，并要求每个人都提出自己的想法。我推荐了一个网站叫 [ Design Principles FTW ](http://www.designprinciplesftw.com/)来获取灵感。你可以在列表上查看到诸如谷歌， Facebook ，苹果等公司的设计原则。




![](http://ac-Myg6wSTV.clouddn.com/a13b7b74f03349e04055.png)







### 明确设计原则

通过报告，我们想到了很多关于设计原则实实在在的理念。我们需要更深一层地去明确它们是什么。我设置了第二次会议，并要求每个人都在便签上写下自己的原则。然后，我们都将它挂在墙上将他们分组和按重要性排名。




![](http://ac-Myg6wSTV.clouddn.com/f6d978f0db09b523a34c.jpeg)







#### 马斯洛的需求层次结构理论

当我们开始找到设计原则应该是什么。我们需要找到更好的方法来将它们可视化。 在六月的时候, 我写了一篇 [关于 Lyft 重新设计的文章](https://uxdesign.cc/lyft-re-design-case-study-3df099c0ce45#.x9kc0h6om) 并且讨论了他们的设计原则。 他们使用了一个金字塔模型 ([马斯洛的需求层次理论](http://www.simplypsychology.org/maslow.html)) 来明确重要性的排名。 我从中受到了启发，也想这样试试看。

我打印出我们创建的设计原则并剪裁成一张张纸片。我在白板上画出了一个巨大的金字塔，并把需求层次理论放在它的旁边。我们每个人都得到了一套设计原则，将他们作为金字塔的基础以我们需要的方式进行排名。



![](http://ac-Myg6wSTV.clouddn.com/f15e77f06b873f017603.jpeg)



设计原则的优先级 (round 2)



#### 哎呀，发生冲突了

我们意识到有一些冲突。我们不能决定哪个更重要，一致性或效率？我们讨论了很长一段时间。最后我们决定将一致性和效率组合在一起。因为根据你的项目，你的工作往往不同。例如，我们的工程师喜欢一致性，因为他们已经建立好了一个风格库。但作为设计师，我们能理解我们的用户，因为他们（被迫）得多点鼠标。我们需要用户留存，必须吸引竞争对手的用户使用我们的产品。我们知道一些旧的模式阻止我们完成它，所以为什么不探索实际上可以帮助他们更有效运行他们业务的选项呢？如果有一个需要优先考虑效率而不是一致性的情况呢？





![](http://ac-Myg6wSTV.clouddn.com/2d074f803563186941ce.jpeg)



[图片来源](http://ccwatraining.org/avoiding-conflict-is-not-the-goal-resolving-conflict-is/)



**这是我从设计活动中所学到的东西:** 如果特定的传统模式无法正常工作，请不要害怕创建新的模式。请与工程师和产品经理沟通，帮助他们了解特殊的需求。如果顺利的话，你可以再下一个迭代中得到新的设计模式。

### 确定设计原则

我们是如此兴奋！然后，我们停了下来。“合作”存在于每一步中，我们应该把它从金字塔中取下来。美是一种有效的形容词，但是我们为什么不让它听起来更文艺一些呢？





![](http://ac-Myg6wSTV.clouddn.com/6be67aa77b71124cc69e.jpeg)



优先的设计原则(round 2)



我们有一个想法，将可视化的金字塔放在图片例子的旁边。我想到了汉堡包的组成，面包，肉和酱。我尝试了一些想法，觉得肉太具体了。我用“馅料”替代“肉”，因为它更广泛，能更好表达心理需求。

**最后：**

*   了解你的用户= **面包** (基础需求)
*   清晰 + 一致 & 效率= **馅料** (心理需求)
*   美学 = **酱料** (自我实现的需求)







* * *







#### 设计原则

如图，设计原则这个概念应该是不言自明的，同时每个原则的重要性都是可视化的。





![](http://ac-Myg6wSTV.clouddn.com/dd597a25d6cbeed4d22f.png)







### 定义:

#### 清楚你的用户


*   **明白用户的需求 ** 在能够提供正确的解决方案之前了解他们的需求。通过采访了解到用户的目标和遇到的困难。

*   **通过契合用户需求来表达对用户的理解 **了解用户的需求和实际行为。处理好用户的期待，同时理解你不是你的用户。









* * *







#### 清晰

*   **清晰是连接所有元素的桥梁 ** 要考虑到页面上项目之间的关系和基于重要程度来布局页面。
*   **创建结构和等级系统 ** 提供及时的反馈，从而形成对制度的信心。用户应该知道他们采取的每一个行为的结果。











* * *







#### 一致

*   **一致的****界面 **  允许用户形成使用模式。使用标准的控制和手势，使他们的行为如预期一致。
*   **一致的语言 ** 当制定一个特定的行为或对象和通信部件时，使用相同的术语以避免混乱。
*   **一致使用既定的模式 ** 用户寻找他们已经知道的模式，以缩短学习曲线，并了解整个程序。 











* * *







#### 高效

*   **用户体验是无缝的 ** 它工作在不同尺寸的屏幕，不同的平台，不同的产品中。当人们想去使用这个应用程序，准备花时间去学习使用它时，效率就显得格外重要了。
*   **高效的系统能节省你的时间 ** 效率反应了系统通过设计任务的最短时间，最少次数的点击来达成用户目的的能力。
*   **利用技术驱动效率 ** 使用技术来适应现需的功能，而不是让用户适应电脑。











* * *







#### 美学


*   **第一印象 ** 一个好看的系统可以增进人们对这个系统的信心与信任。
*   **美学是一种人们意识到的，想要的和需要的品质 ** 它使得无论在生活中还是设计中，都因美学充满乐趣。
*   **令人愉悦 ** 当你的产品好用，你的用户会期待用到你的产品。

### 重要性

最近，我收听了一个播客[ Julie Zhuo ](https://medium.com/u/b8a4e5ae7490)，她是脸书网的产品设计副总裁。她谈到及早启动建立一套清晰的设计原则是多么重要。她的见解增强了我的信心，相信我们的原则会使我们的产品更好。
> 设计原则的目的是让员工统一认识，什么是重要的。
> 一套好的原则是这样的，所以每个人都能够感同身受，什么对我们来说是重要的，什么对我们来说是真实的，当新的人加入，或当你的公司扩张，设计原则可以让新人们更容易了解公司里独有和重要的理念，也是人们做事的方式和价值观所在

>  我们的关注点很简单。我们关心的是人。在必须做出决定的时候，你必须做出权衡，作为一个团队或一个公司需要优先考虑到什么？该怎么做？你最关心的是什么？

要收听完整的播客，请单击下图。

[![](https://i1.sndcdn.com/artworks-000166652068-8clzcy-t500x500.jpg)](https://w.soundcloud.com/player/?referrer=https%3A%2F%2Fuxdesign.cc%2Fmedia%2Fd1a2603d7df6acc2f23c9b9f9c7cf402%3FmaxWidth%3D500&show_artwork=true&url=http%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F268298285)

### 展望
设计原则可能并不适用于每个公司工作。虽然对我们来说，有一套完整的设计的原则是有助于我们团队确立一致的设计方向。我们需要原则来明确方向和减少歧义。
>有着分量和确定性的设计原则往往是靠谱的。外观和感觉不过是些肤浅的东西一个伟大的设计师会把工作建立在持久的原则之上，不管做一个决定，还是一千个决定，都不会像墙头草一样随风倒。
我们期待着在实践中能应用到我们的原则。我希望能够在不久的将来分享一些个人的见解。
