> * 原文地址：[Why and how the Cryptobubble will burst](https://medium.com/@dennyk/why-and-how-the-cryptobubble-will-burst-de9bc7fc5332)
> * 原文作者：[DK](https://medium.com/@dennyk?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/why-and-how-the-cryptobubble-will-burst.md](https://github.com/xitu/gold-miner/blob/master/TODO/why-and-how-the-cryptobubble-will-burst.md)
> * 译者：[十七粒](https://github.com/GreenLim)
> * 校对者：[Damon Yuan](https://github.com/damonYuan)

# 为什么加密货币泡沫会破裂？

![](https://cdn-images-1.medium.com/max/800/0*idzMb5bMLqYRdbWU.png)

加密货币泡沫（Cryptobubble），图片来源：TechCrunch

即便是对于一个经历过互联网泡沫的人来说，如今加密货币市场的火爆程度也令人叹为观止。17 年前的错误今天再次重演，是如此震慑人心。当然，今天的投资者也许和以前不同，他们的大多数并没有经历过互联网泡沫。

想了解更多关于加密资产（Cryptoassets）的内容，本文末尾有我收集的更多趣文:)。

**写在前面**

首先我需要给出几个基本定义。对我来说，加密资产主要分为下列三种：

a) 加密货币：是一种主要用于在区块链上储藏价值、进行投机或者交易的加密资产。例如 Bitcoin、Litecoin、Dash 和 ZCash。

b) 平台或功用代币：是一种用于构建去中心化应用（DApps）的加密资产，或用于构建其它代币使其能在它们的区块链上进行交易。例如 Ethereum、Lisk、Blockstack 和 Tezos。

c) 证券代币：通过 ICO[[1]](https://baike.baidu.com/item/ICO/21498451) 渠道售卖给投资者的代币，用于投资创业公司。这包括 TenX、Monaco、Status、Iconomi 等。

**对比互联网泡沫**

让我们回到 1999～2000 年的那个年代，在当时，有任何与互联网沾边的事物，都会让整个股票市场为之疯狂。如今，历史重演：

* ICO = IPO

在上世纪 90 年代末和本世纪初，IPO（首次公开募股）空前繁荣。纳斯达克指数日日创新高，新兴公司将在各个交易所的“新兴板”或“科技板”上市。如果你在 IPO 期间参与了某只股票的询价申购，那么你通常能在上市交易的第一天就实现本钱翻番。所有人都在参与 —— 不仅仅是机构和高净值投资者，甚至你家门口超市的员工和出租车师傅都来凑热闹。出租车师傅将即将大热的 IPO 项目宣传给乘客。大多数 IPO 项目，只要有和互联网沾边的商业计划，就能成功上市。

如今发生在 ICO 世界的故事和历史是惊人的相似。似乎所有人都在参与 ICO 或者代币预售，项目承诺使用区块链来交付商品，或者使用区块链来实现其它一些荒谬的点子，这些项目可能会从 Dapp 中收益，但完全不需要靠代币来运转。其中一些 ICO（17 年初尤甚）使投资者获得了 10 倍的收益，正是它们推动了 ICO 的繁荣。需要注意的是，能够以比特币（而非美元）为结算单位，良好完成售卖的非诈骗 ICO 是相当少的。今天与历史不同，大部分靠以太坊区块链完成交易的代币完全没有所有权。这一点我将在后文提到。现在，你只需要记住 ICO 狂热就是约 20 年前的 IPO 狂热的翻版。

* 任何区块链相关的都在飙升

在互联网泡沫时代，纳斯达克的一些科技公司给自己的公司名字加上“.com”，然后股价便有 30~50% 的涨幅。

猜猜现在发生的是什么...已经有一些公司将公司名字加了上了“区块链”。请注意，大多数情况他们仅仅是给公司换个名字而已...然而，它们的股价却因此而大幅上涨。

* 正在考虑新的估值模型

在换联网泡沫期间，分析师和投资者面临的主要问题是，大多数公司一直在亏损而没有利润，几乎没有可行的估值方法。分析股票的传统方式有：自由现金流息率、EV/EBITDA、P/E 倍数或 DCF（现金流折现）分析。这些方法都存在一个问题，如果在未来相当长的一段时间内利润预计为负数，或与市值的比值为一个相当小的数，靠计算比率来估值的方法都将不起作用，而 DCF 又相当依赖于“终端价值”（基于未来 10 年或 20 年利润的一个恒定假定值）。因为这些方法都行不通（并不是这些方法不管用，而是股价被炒得离谱），当时分析师想出了用于互联网股票估值的种种新方法。这甚至在经常阅读的“估值”标准卷对互联网股票估值增加了大量内容，不过随后又被删除了，因为当时的市场显然是一个虚假的市场。

快进到今天 —— 同样的事情再次上演。我承认在"价值储藏"上比特币具有独特价值，但人们赋予代币以网络价值的行为却显得十分荒谬。今天，分析师和投资者都不再关心估值方法，即使项目没有任何回报、启动就估值过亿美金，他们也不会觉得有任何问题。

**区块链泡沫和互联网泡沫之间令人担忧的差异**

尽管这两个泡沫之间存在着明显的相似之处，但更令人担忧的是它们的差异。

* 投机的对象

在互联网泡沫期间，人们至少用血汗钱至少换回了实打实的股权，但大多数的 ICO（前面说的证券代币）投资不会获得任何权利。让我强调一下：**他们不会获得任何权利**。他们投资的完全是空气。对于那些提供商品或服务并不需要代币的 ICO 来说尤其如此。我们花一分钟来理解一下：你从一个你不知道的人那里购买了“区块链”空气，然后希望别人能以更高的价格从你那买走。唯一能对你起到帮助的是“博傻理论”（意思就是：在这个世界上，傻不可怕，可怕的是做最后一个傻子）。

* 市值的含义

我以前写过相关的东西。市值被定义为所有普通股的当前股票价值。

然而，如果你看看统计加密市场市值的首选网站 coinmarketcap.com，你就会发现它们只统计了“流通供应”部分，这通常是被销售出去的那部分货币总量，而并未包括销售该代币的公司团队成员所持有的那部分。换句话说，如果与股票进行比较，该网站只显示了“自由浮动”的那部分市值。

你想一想 —— 当你认为 XYZ 项目市值 1 亿美金时，实际上它的市值可能有 2 亿美金，因为你忽略了项目创始人还持有 50% 的代币。这些代币同样可以在市场上销售...所以除了在估值上的泡沫，还有更多的不为人知的风险。

顺便提一下，Coinmarketcap.com 以前有显示“全部市值”的功能，不过后来被随意的去掉了。（编辑：实际上，该网站现在还有“全部市值”功能，它隐藏在 Coins 标签下面。）

一个默认显示全部市值甚至还标记诈骗信息的网站：https://onchainfx.com ‬

* 诈骗的数量

在股票市场，当然也偶尔有骗局，甚至还发现有些公司的 IPO 建立在传销基础上。然而，看看加密行业的 ICO，明显就是骗局的项目数目惊人。

像 Veritaseum、Monkey Capital 或 WCX 等项目都充斥着传销、骗局、不专业的味道。尽管 WCX 仍然还有机会翻身（ICO 还没有结束，但事情看上去相当怪异，没有公开的团队成员，提名的资金托管方表示并未为其托管任何资产），而其它两个项目已经被证实为骗局。真正令人可怕的是 ICO 结合了无监管、互联网匿名以及人性的贪婪。

* 投资者类型

尽管互联网泡沫有相当一部分的散户投资者，但主要驱动力仍然是机构投资者。在加密泡沫中，该领域几乎完全由新晋散户投资者组成，他们可能一辈子都没有持有过股票。这就是为什么像技术分析这样的东西在加密市场比股票市场受欢迎的原因，因为这明显是一个由恐惧和贪婪驱动的市场，这不是一个成熟的市场。技术分析只是一种分析恐惧和贪婪的方法而已。

我真正想说的是，大多数人在投资亏损方面没有任何经验。当泡沫破灭时，他们会在第一时间被清场。此外，他们缺乏认识到我们正处于泡沫之中的能力，而且他们投资的都是空气。在任何空气项目的 Slack 或 Telegram 的交流群中，不论是谁发表类似的言论，他都会被禁言，或者被指责为 “FUD”（fear uncertainty doubt，恐惧/不确定/怀疑，加密领域中的一个缩写词，意思就是说“他在散布恐慌，只要你不割肉，你就能赚到钱”）。

这些人确信他们还未痛哭的唯一原因就是，他们投资的证券代币仅仅只是在"比特币交易对"上有所亏损，但对美元仍然保持稳定或损失甚微。然而，如果你看一看任何一个证券代币或比特币的走势图，你可以清楚的看到，好的行情仅仅是短暂的“哄抬价格-拉高出货”。在涨一波之后通常会跌到比之前还低的位置。现在想象一下，如果比特币再次下跌，会发生什么？

* 缺乏强制的监管

显然，所有政府都被 ICO 的繁荣所震惊。因此，该领域的监管是匮乏、不一致和不明确的。这不仅催生了上述骗局的出现，还请考虑如下几点：

a) 只要代币不被明确界定为证券虚假交易、内幕交易、欺骗以及任何一种负面的市场行为，都不是被勒令禁止。代币可能会被参与其中的人认为是合法的，尤其是项目成员或社交媒体大号。

b) 许多代币实际上符合美国证监会对证券的定义。注意，作为一种证券，代币需要提供类似证券的权利（股息、利润分红、投票权），或提供给期望低买高卖的投机者。实际上，如果代币在交易所上市交易，并且这是 ICO 承诺的一部分，那么它就是一种证券。而大部分的既得利益者并不想承认该定义的第二部分实际上已经涵盖了所有的 ICOs 以逃避监管。如果要符合章程，证券需要满足特定的规约才能进行销售，并且只能卖给合格的投资者。

c) "加密世界"似乎认为它对未来的监管是免疫的，然而这是错误的。像美国或欧盟这样政府，对于那些不符合监管规定（监管提示）的证券，出售甚至是拥有它们都将被判入狱。当然，比特币不会消失，而加密行业应该拥抱监管。这能解决许多道德和其它方面的问题。值得注意的是，目前世界最大的交易所的实际位置位于美国，而交易所由有合法身份的人来运转。这些都不是对监管免疫的。

**那么在我看来将发生什么呢?**

我认为目前在开篇定义的“证券代币”行业中存在大量的泡沫。这个泡沫一定程度上会扩散到“功用代币”和“加密货币”，但显然主要还是在 ICO 领域中。

最有可能的情况是，房间里面的两头大象（美国和欧盟）为 ICO 和加密资产出台某种监管框架。我希望他们能够区分纯粹的网络代币、加密货币（Bitcoin、Ethereum 等）和证券代币三者。几乎所有的现有 ICO 市场都将严格按照证券代币监管规则实行。（编辑：美国证监会主席 Clayton 说：“我还没见过哪个 ICO 没有太多证券的印记。”，华尔街日报，2017 年 11 月 9 日。）

因此，所有的由人管理运作的大型交易所都将被强制要求立即去除所有证券代币，他们都将遵守这一指令。对于去中心化交易所，这些代币的交易将是非法的，而项目发起者将会向投资者退款，我不敢肯定这种方式能解决所有问题。我希望他们不会走到这一步，因为监管必然会是积极的。

当这些发生后，所有的 ICO 都将下跌 90％（就像在互联网泡沫中一样），不管项目多么强大。我经常提到的一点：2001 年亚马逊股价下跌到 5.5 美元每股，但现在价格是 1000 美元。所以在这个过程中，好的项目仍然会下跌 80～90%。

与此同时，与 ICO 繁荣息息相关的功用代币可能会串联暴跌（因为大部分人将证券代币换成功用代币，再换成比特币，最后换成法币），但可能不会太严重并且能够及时恢复。这些都是有价值的技术，没人想长期伤害它们。类似比特币这样的加密货币也会受到影响，但随着各大交易所推出比特币期货，我预计很可能是一个 V 型修复的走势，ETF基金的形式和监管无疑将引入机构投资者，并且其中 90% 的资金必将流向比特币。不过，毫无疑问的是比特币仍然会受到影响。

在这场 ICO 大地震的余波中，我预计将发生和 2001 年互联网公司同样的故事。真正优质的项目会给他们的代币持有者带来类似股票的权利，并且履行证券监管。新的 ICO 将是那些强大的公司，这些项目具有很好价值定位，它们也会出售一些有价值的东西，这肯定不会是空气。当 ICO 2.0 时代来临时，以太坊这样的平台也会强劲复苏。就像过去互联网公司一样，我希望这场冲击是一个积极的中期效应，并释放出大量的价值。我确信，区块链（像以太坊这样的网络、像比特币这样的货币）将在很大程度上取代目前的市场基础设施，甚至取代某些市场参与者（例如银行、清算所、股票交易所）。但在这之前，需要发生一场冲击，并且一定会发生。这不是“是否发生”，而是“何时发生”的问题。

对了，我敢打赌，我严重怀疑 USDT 项目的合法性。你真的认为美国政府会允许第三方机构在没有任何公开审计和牌照的情况下用他们自己发行的货币进行资产托管吗？我是不信的...

因此，在这场游戏的尾声，我个人不会对任何 ICO 项目进行投资，也不会投资它们的代币。在未来 12 个月的某个时间点，你入手的任何价格都可能是一个相当高的点位。再重申一遍，这并不是说区块链不是未来，这也不是反对比特币或以太坊的理由。但我希望这是给当下那些幻想加密世界让自己一夜暴富的人的一个小小的警钟。

**最后，一个简短而重要的声明：我所写内容不构成任何资产投资建议。这仅仅是我不专业的个人观点。一切资产都可能归零。**

**更多趣文**

- [**ICO**](https://baike.baidu.com/item/ICO/21498451)

- [**Everything I Learned About Investing I Learned While Crying**](https://medium.com/the-mission/everything-i-learned-about-investing-i-learned-while-crying-1cf239ef8da5)

- [**COIN SCAM ALERT -- Beware of Monkey Capital and Its Head Monkey Daniel Harrison! - Steemit**](https://steemit.com/cryptocurrency/@goldseek/beware-of-monkey-capital-and-its-monkey-daniel-harrison)

![1511164934(1).jpg](https://i.loli.net/2017/11/20/5a128c1a8067d.jpg)

- [**Losing Alpha: Why Most New Crypto Funds Are a Sh*t Deal**](https://medium.com/@twobitidiot/losing-alpha-why-most-new-crypto-funds-are-a-sh-t-deal-98ea0013971a)

- [**Introduction to Cryptocurrencies from a non-tech early adopter**](https://medium.com/@dennyk/introduction-to-cryptocurrencies-from-a-non-tech-early-adopter-dd6889c12d68)

- [**ICO Wizard: launch your crowdsale campaign in under 10 minutes**](https://medium.com/oracles-network/ico-wizard-launch-your-crowdsale-campaign-in-under-10-minutes-47df74c957ba)

- [**A Letter to Jamie Dimon**](https://blog.chain.com/a-letter-to-jamie-dimon-de89d417cb80)

- [**The Basics on FACTS: A New Model for Compliant ICOs - CoinDesk**](https://www.coindesk.com/basics-facts-new-model-compliant-icos/)

- [**The Crypto J-Curve**](https://medium.com/@cburniske/the-crypto-j-curve-be5fdddafa26)


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
