> * 原文地址：[What I would like to know before I code my first iOS application in Swift](https://medium.com/@bkzl/what-i-would-like-to-know-before-i-code-my-first-ios-application-in-swift-f11fcdde7887#.oeafmue7p)
* 原文作者：[Bartłomiej Kozal](https://medium.com/@bkzl?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[jiaowoyongqi](https://github.com/jiaowoyongqi)
* 校对者：[cbangchen](https://github.com/cbangchen), [owenlyn](https://github.com/owenlyn)

# 用 Swift 开发我的第一个 iOS 应用前，我想要知道这些内容

上周，我和我[哥哥](http://medium.com/@_mac)使用 Swift 语言开发了第一款[iOS 应用](http://echotags.io/appstore)。通过这篇文章，我想分享在此过程中所收获的心得体会。

*我是一位有六年网站应用开发经验，并且掌握 Ruby 和 JavaScript 的工程师，而最近3个月致力于学习 Swift 编程语言。*

### Objective-C 已亡？

Swift 是一款由苹果公司（世界最大的公司之一）创立的编程语言。这也表明了许多事：首先，苹果并不避讳向自己的平台中引入重大的更新。你需要知道的是，这里的重大更新，我指的是包括优先级更新在内的一系列更新措施。

例如，上一次 WWDC 大会中，苹果宣布了将大部分 API 进行重新命名。Swift 是基于原本面向 iOS 开发者的 Objective-C 的基础上进行重大革新的一款编程语言。而且，WWDC 对于我而言，就像放了一周的假前往现场享受有趣的展示和演讲。即使如此，Swift 是我见过卓越的具有公开学习资源的编程语言之一。来看看[相关的项目](https://github.com/apple/swift-evolution/tree/master/proposals)吧。

![](https://cdn-images-1.medium.com/max/1600/1*j4lJm5Dtpb4jLpGKlInOVA.png)

Swift 对阵 DHH ;)

这是否就意味着 Objective-C 已死，无需了解学习了？差不多是的，我能保证图书馆中大部分的书籍和互联网中大部分的代码案例都是由 Objective-C 编写而成的。但是有趣的是，当我在通过 Swift 语言编程的时候，我越来越了解 Objective-C。现在我可以很顺畅地理解 Objective-C 代码。

另一个你需要知道的事情是数量巨大的内部接口，当你准备调用 API 的时候，你可能会被之震惊。你可以通过调用手机功能权限来构建基础的功能，比如相机、麦克风、陀螺仪、加速器以及触摸屏幕等，比为网页编程简单得多。

### 开发工具

苹果公司出品的 XCode 是神奇的魔术箱。它包含了你在开发 iOS 应用时所需要的所有工具：代码编辑器、界面构建器、数据管理、调试器以及基础构建工具等。

可惜的是，这些工具都存在许多瑕疵。特别在使用界面构建器的时候，我总会在心里冒出黑人问号脸。当我第一次使用界面构建器的时候，我总会惊叹道“哇塞！我可以像使用图形软件 Sketch 和 Photoshop 那样来开发应用界面耶！”但是并未如此美好，界面构建器更像一个为了逃避写代码而生的不切实际的产物，而不是所谓简单的界面设计工具。

有时候你在界面构建器上进行一次操作而却没有什么反应，这并不少见。有很多事你无法预测，你要做的就是了解它；例如你可以直接点击错误提示以消去错误的约束警告。还有，当你移除属性或者事件的时候，也总是要记得把故事板上引用绑定的部分去除。如果你不这样做，也许在编程的时候不会出现什么错误警告，但是当模拟运行 App 的时候就可能会程序崩溃。

你需要找到一个平衡点。根据我的经验，界面构建器主要是用于设计应用主要页面流程，以及布局界面元素的，并做到不同视图控制器之间的无缝链接（而不是按钮与视图控制器之间）。使用代码存储的设置，并且继承已有的界面元素来自定义 UI 元素。

相比于 web 编程，iOS 应用显然有着更多的图形界面编程内容。我的建议是多了解一下那些基础信息，比如矢量图形是什么以及转换是如何实现的。了解这些知识对于你未来将会面对的问题很有帮助。

你时刻需要在真实的设备上来测试的你应用。用鼠标点击模拟器上的感觉和用手指在手机上触控的感觉是完全不一样的。

![](https://cdn-images-1.medium.com/max/1600/1*oiYF-MoPLhP-4TzkFdYggQ.png)

在模拟器看这个界面上的关闭按钮十分合理，但是在设备上往下滑关闭的手势则会更加直观。

官方的依赖库管理器至今尚未正式发布。但是你可以选择这两个第三方社区： CocoaPods 和 Carthage。目前我正在使用前者，并且至今未遇到太多的问题。

小贴士：别太依赖撤销操作。XCode 无法做到在点击 *cmd+z* 之后跳转到相应的页面，所以你无法看到哪里进行修改了。建议你使用 Git 并且多做修改记录。

### web 编程和 iOS 编程的差异

当你在创建一个新项目的时候，你会注意到这里没有任何约定俗成的条条框框。相比于具有相似代码结构的 Ruby 应用，iOS 程序对于你的代码没有一个硬性的格式要求。每一位开发者可以根据他们的想法来构建应用。但说实话我并不喜欢这样的方式。Ruby 的规范可以帮助你更直观、更方便地找到代码的位置。

![](https://cdn-images-1.medium.com/max/1600/1*iLaegkpeKax7WTn7wJNC-g.png)

所以我应该把那些新创建的类放在哪里呢？

我发现的另一件事就是那些很容易在 web 应用上实现的功能，在 App 端就不是一件简单的事，反之亦然。例如，让元素垂直排布是个简单的操作，然而改变标签标题的字体却不是个简单的事。

而那些酷炫的界面动效、页面跳转以及手势操作，使用 iOS 的 API 来实现远比用 JavaScript/CSS 简单得多。

另一大话题就是受限的手机资源和优化性能。你不能通过堆积便宜的硬件来提高应用程序的性能（来响应大规模的用户）。而且应用还会受制于手机自身的电量。使用 CPU 来优化应用的表现是个很常见的做法，但其表现结果因不同的手机型号而相差迥异，这也是一大问题。

调用外部 API 接口是一件十分棘手的事情。目前已经有太多极端错误的例子，如果没有合理地调用，就会出现黑屏或者闪退的问题。

静态类型和实时预编译是非常有用的工具，也能帮助你避免很多错误。我很喜欢可选性（ optionals）这个代码特性，它可以确保你不会遗漏那些不引人注意的空值（nil）。现在我在用 ActiveRecord 开发网页应用的时候很怀念可选性（ optionals）。

另一方面，我也十分怀念那些在 Ruby 标准库中内置功能的组件。你可以调用 *map()*， *filter()*， 还有 *reduce()* 等代码，以及大量其他有用的代码。多说一句，接口系统中不同的 API 之间常常存在着差异，这是你在设计之前需要注意的。我甚至见过不同名称但是却同一功能的接口，而其中一个只是另一个的老版本。

### 发布应用

我必须要说出一个事实：筹备发布应用所耗费的时间比我们开发的时间还长！请重视这件事，因为开发一款应用不仅仅只是写代码。

App Store 是唯一一个可以发布自己 iOS 应用的官方平台，而每笔交易需要向苹果支付30%的费用。这个比例的抽成看起来不多，但是看到销售报告的时候你就不会这样想了。更令人惊讶的是，当你再加上收入税的支出，你会发现你到手的仅仅只有销售额的50%。再刨去其他的开支，以及 App Store 上平均价格的制约（大部分的 App 都是免费的或者售价比一杯咖啡还便宜）你会发现你的产品需要有完美的定位以及优秀的运营手段才能走向盈利的道路。

苹果并没有给你足够的工具来支持你的运营推广。你可以制作30秒的广告视频，最多5个截图，还有应用标题、介绍文字及搜索关键词，这三项一共限制在100个字符以内。其他的只能靠你自己的努力了。我觉得他们不提供关键词统计工具这一点非常令人讨厌，因此你必须使用第三方工具。

最后一个细节就是应用的审核时间。一旦你将应用上传到苹果服务器上，并且点击“发布”按钮，你将不得不经历两次等待，第一次是等待被审查，第二次是等待审查完毕。所以不要指望你的新产品或者补丁将会在提交审核的第二天就出现在 App Store 上。

### 学习资料

即将结束时，我想列出部分自己看过的书单和资源：

[Design & Code ](https://designcode.io/)—我是通过这个教程开始学习的，一共包括5本书（其中三本直接关于开发）。这个教程很适合那些从未接触过代码的设计师。虽说这并不是所有人入门的最佳选择，因为里面的部分细节已经有些过时，但我依然推荐给大家。每一章节都有视频版本。

[Stanford CS 193P lecture on iTunes U ](https://itunes.apple.com/us/course/developing-ios-9-apps-swift/id1104579961)—我认为这是最佳的入门教程，因为里面事无巨细的讲解了所有编程时候应该注意的事情。但这不适用于所有新手，因为这需要代码经验。这个教程是免费而且是最新的（Xcode 7，Swift 2 以及 iOS9）。每个章节的最后都会有一个课后练习，确保你在本堂课学到了东西。

[Hacking with Swift](https://gumroad.com/l/hws-book-pack)—这本书包含 Swift 和 iOS 开发的所有知识。和上一本书配合阅读效果极佳。每一章节都是一个用来解释和练习某个 API 的迷你项目。你可能会觉得这本书太厚了，还没读完就会觉得无聊，但这确实物超所值的一本书。

[Pro Swift ](https://gumroad.com/l/proswift)—只写关于 Swift 的高级知识点。每个章节都会附带教学视频，视频中作者将会通过例子来解释知识点。这绝对是你提升 Swift 能力的必读资源。强烈推荐！

[100 Days of Swift](http://samvlu.com/tutorials.html) —通过视频教学的方式讲解40个真实的 Swift 编程案例。作者展示了很多“奇技淫巧”以及很多实用的开发技巧。虽说这是面向新手的教程，但是我并不想将之推荐给新手，因为书中缺少对于基本概念的解释。而如果你真的了解并且上手操作过 Swift 或者 iOS 之后，这本书十分值得你阅读。

[iOS Developer Library](https://developer.apple.com/library/ios/navigation/) —我现在使用的主要资源。起步的时候最困难的就是无从下手。在这里你可以看到苹果开发者是如何编写并且组织代码的。但你需要知道里面有些例子是用 Objective-C 写出来的，已经稍稍过时。而且这也是了解最新 API 接口信息的唯一来源。

![](https://cdn-images-1.medium.com/max/1600/1*ZhHNBLXvxMvjsIp1KIFSsw.jpeg)

爆照啦！右边的是我！ 👋
