> * 原文地址：[UX and design thinking: 5 tips for changing your company mindset](https://uxdesign.cc/ux-and-design-thinking-5-tips-for-changing-your-company-mindset-167177622651)
> * 原文作者：[Tania Conte](https://uxdesign.cc/@tania.conte)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：
> * 校对者：

# UX and design thinking: 5 tips for changing your company mindset

![](https://cdn-images-1.medium.com/max/800/1*V5dbnjBFOsoLI_cF4c4Jaw@2x.png)

image [designed by Creativeart / Freepik](http://www.freepik.com)

## An actionable guide to make the UX designer role clear to your company and team

---

The UX design is based off an attitude, a mindset that aims to catch those unfulfilled user needs in the context of a certain experience and turn them into design opportunities, through a process made of specific steps, mainly provided by the “design thinking tool set”.

Conversely, so many companies in the digital industry keep on working all centred on personal assumptions and tastes of the ones that are in charge for the ultimate decision or of those ones who put the money into the project. These assumptions and tastes are all conveyed into the final product!

Well, if you are reading this article, you may feel like a natural-born UX designer and you have probably spent your weekends and nights learning about UX methods, techniques, metrics and tools just to validate your natural attitude. You are probably convinced that your goal is to deliver successful products, but you feel like your working team doesn’t appreciate your work. You put all your efforts into it, but when you look at the final result you feel like an underachiever.

It may sound like a huge mission, but you should try to bring some of your UX designer mindset to your company both for your mental and professional well-being and for the company success. It may cost you some extra work to perform processes and tasks that, at the beginning, may not be appreciated and taken into account by the other members of the team but it’s worth a try.

### 1. User research process: make it accessible

> As a first step, you need to shift the focus of product design from managers’ assumptions and tastes to user needs.

For achieving this goal you need to apply some tweaks to your “get out of the building” mantra as a user researcher. Users are the only ones who can convince managers that they are a real goldmine for design opportunities, but as the one who conducts this game you must keep them real.

Managers and investors are hard to convince if you get out of the building for your user research work and get back to them later just for debriefing them with the final report. Make your user research process accessible! Social networks, where you can both join in groups and channels and create your own are definitely a valuable resource to get in touch and work with users.

![](https://cdn-images-1.medium.com/max/800/1*JQXjrHKYJeFI6Eyz_6Isbw.jpeg)

image [designed by Creativeart / Freepik](http://www.freepik.com)

You can invite managers and investors to join in as well, so they can follow all your work as a user researcher while you interact with users, build a relationship with them, administering questionnaires and ask for their help on a specific case. For each questionnaire you’ll produce a report with all the collected insights, and, hopefully, your managers and investors will perceive them with all their “scientific” and objective relevance.

### 2. Sharing deliverables: do it in a physical place!

Maybe in you office meeting room there’s already a white board or some boards for sticky notes. Right from there, you can start building a place where you can share your UX design deliverables with your team.

> Any digital platform for sharing documentation can be fine, of course, but a physical place where you can leave a copy of your deliverables just pinned on the wall can have a great impact on your (still) backward workmates.

An overall visual perception can provide them with such a powerful convincing evidence of your work relevance! You can even ask your team members to spend some time just sitting alone and quiet in the meeting room for giving a look at each new deliverable addition. They will appreciate your invitation to share with them your findings, as they will also be curious to know what your work is about. This way, you’ll also make sure that they will be much more focused, avoiding distractions while away from their computers.

![](https://cdn-images-1.medium.com/max/800/1*1JrVye9Yj1-SqGe8N_V_iA.jpeg)

image [designed by Creativeart / Freepik](http://www.freepik.com)

### 3. User stories: lines of code making sense

One of those attitudes that are hard to break is that “the user will get used to it” that’s very typical for developers. They spend too much time coping with their code and machines and they loose touch with users and their real needs. Moreover, their mindset is totally different from the average user mindset, so it’s important to provide them with something that keep their heads in the real world. So, for each chunk of functionality you’d better write some user stories to share with your developers: this will prevent them to feel free to change your UI just to make it quick and easy for themselves to develop. So, all of the elements in your UI, as well as every step in the interaction flow, will have a relevance clearly stated in the related user story. And… you will have plenty of evidence to defend your work when it comes to be turned from a prototype into a fully working application.

### 4. Giving key points: 10 heuristics in plain view

Well, just another way to help your team to get some UX design sense is to give them a list of defined key points, that they can recognise and apply in their own work. It would be great if developers could get involved in the user testing process with prototypes and all the heuristic evaluation work and iterations, but it would be extremely time consuming. Anyway, it can be very useful for the ultimate quality of the product that they endorse those [10 heuristic principles](https://www.nngroup.com/articles/ten-usability-heuristics/) stated by Jakob Nielsen.

When we were just kids, our teachers in the school used to hang on the wall all those posters with relevant information for supporting our learning. So, that’s about the same case! Just hang on the wall in the development team room a list with all the 10 heuristic principles with a short description of each of them, so that you can't miss to point them out, while working with developers.

![](https://cdn-images-1.medium.com/max/800/1*_Orlpba0Ey_o4SI6GfO-6A.jpeg)

Ten usability heuristics, summarised by professor Scott Klemmer for Interaction Design Specialization @ Coursera
### 5. Periodical checkpoints: “dating” your user personas

Make sure that among the deliverables, pinned on one of the meeting room board, there’s a couple of your user persona posters. It will be essential for your team have periodical “dates” with your “users representative” just n0t to forget where everything started and to check if their expectations have been disappointed at some stage of the production process. These periodical checkpoints are needed to always stay on track with a mindset focused on user-centred and UX design, make critical analysis and find an adjustment, if some technical or budget issues determine any constraints.

![](https://cdn-images-1.medium.com/max/800/1*uJpRxOLziPlPUWIu8rRZHA.jpeg)

A user persona is a key component in every UX design project and every team member has to keep it in mind.

---

Well, this can be just the starting point to introduce UX design and Design Thinking in your company by improving the understanding of it with these 5 actionable tips. I really wish that in every business there was room for let such a user-centred mindset in, as well as for some bold natural-born UX designer, fool enough to make the job. In a few years we expect that user experience will make the difference between brands. Is the digital industry ready to meet the challenge? This is another story that I’m going to discuss in my next article. Stay tuned!

### Worth reading?

Do not forget to click the **♡** below to help others find it, and leave a comment. Thanks for reading!

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
