
  > * 原文地址：[UI vs UX: What is the Difference?](https://www.sitepoint.com/ui-vs-ux-what-is-the-difference/)
  > * 原文作者：[Darin Dimitroff](https://www.sitepoint.com/author/darin-dimitroff/)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/ui-vs-ux-what-is-the-difference.md](https://github.com/xitu/gold-miner/blob/master/TODO/ui-vs-ux-what-is-the-difference.md)
  > * 译者： [Nicolas(Yifei) Li](https://github.com/yifili09)
  > * 校对者：[Frank(xfffrank)](https://github.com/xfffrank), [杨柳青](https://github.com/ylq167)

  # UI 和 UX，区别在哪里？ 

  作为一位全能的产品设计师，我观察到很多年来这个行业内一直存在着对各种头衔的痴迷。当然，我们尽可以去嘲讽，同时发些搞笑的推文段子，但这样对谁有帮助呢？

就好像“设计师应该敲代码么？”，这个“UX vs UI”的问题已经成为圈内人的玩笑了。

[![](https://ws3.sinaimg.cn/large/006tNc79ly1fidh1mes79j30qa0qetbr.jpg)](https://twitter.com/sdw/status/709853249407361024/photo/1)

[![](https://ws2.sinaimg.cn/large/006tNc79ly1fidh23pw82j30pw104td8.jpg)](https://twitter.com/ezyjules/status/797121630287888384/photo/1)

一方面，这种趋势也给那些有经验的设计师一个发泄之处。事实上，有一个[Tumblr 博客专门为此而生](https://shittyuiuxanalogies.tumblr.com/)。

然而，这会造成一个问题，对于新手来说这个行业看上去会很难上手苦难重重。但是惭愧的是，一个新手设计师进入行业的门槛从未如此低过。(我想说这其实很棒。)

## 太长，所以别看 ：）

**UI 代表了用户界面。** 它是用户可以在软件或者网页内直接交互的对象，例如那些你能看到、触摸到的和听到的。他就是一个应用程序的最外层 - 控制器。 

目前状况来看 - 鉴于我们正在使用的设备类型 - 尽管语音和手写输入得到了广泛的认可，多亏了各种语音助手和语音交互，但是 UI 设计仍遵从可视化界面设计规范。 

**UX 代表了用户体验。** 它是一个整体性的术语，囊括了用户使用一个产品时所涉及到的每种不同类型的接触点。 

对于数字产品来说，UX 不仅包含了软件的前端展示，也包含了整个技术栈的实施、客户服务、品牌理念、企业的公共形象、产品的实用性、价格和客户沟通，当然不仅仅于此。

UX 包含了 UI。两者有不同的意义，在任何时候都不应该混淆使用。从语义学的角度来看，“UX/UI 设计师” 这样的头衔是完全没有意义的。参照定义来说，每一个 UI 设计师都是 UX 设计师，不具备专业领域知识的 UX 设计师是很少见的。在缺乏具体领域知识的基础上讨论“UX”会让任何交谈变得没有意义。

## 所以，“UI/UX 设计师”到底遇到了什么问题？

就我看来，主要有三个问题：

1. 它容易让人产生误解： 设计师、开发者、招聘人员、投资人等等。越来越多的初级设计师使用这个头衔 - 并且我没法责怪他们。每个人都那么做了，在这股趋势下，若你对自己的技能实力太诚实往往会让你觉得自己落伍了。
2. 它让人队职业发展方向有错误想法，认为仅成为一个“UI 设计师”是远远不够的。如果数字产品像“神奇宝贝手游”一样，“UX/UI 设计师”不会是比“UI 设计师”更酷更高级的版本。
3. 它大大地破坏了“UX 设计师”的重要性，而 UX 设计实际上是所有人工作的总和。

## UI 是 UX 的**一部分**

简单来说，人机交互发生在 UI 上。虽然这是重要的一部分，但是它也只是整个 UX 栈上的一层，它包括了很多设计原则。

让我们看一下实际生活中的例子： 看电视。

有关看电视的 UX 设计包括节目内容的质量、电视机的规格说明书、放置位置、配套家具、你目前精神状态等等。另一方面而言，**看电视的 UI设计**就只占一小部分了：遥控器的品质和在电视屏幕上菜单的设计。

## 有关**这些**图片

![UI vs UX analogies](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/08/1501634649path-e1501833312222.jpg)
UI vs UX . Credit: [http://digitalfractal.com/](http://digitalfractal.com/)

是的，**这些**图片。我不想让你们觉得我是那个辛普森动画中朝着天空吼叫的老人，但是大部分用于比较 UI 和 UX 的图片都没有戳中要点。一位名叫 Sebastian de With 的设计师在他一年前的[推文](https://twitter.com/sdw/status/709853249407361024)中也表达出了相同的观点。

许多反复出现的图片（就好像这一个有两瓶番茄酱的图，还有一个展示了在草坪上的一条捷径）不仅仅缺乏意义，还有可能产生相反的效果。这些图片让 UI 和 UX 陷入对立面，也暗示着 UI 设计师的工作是没用的，因为用户已经采用其他方式使用这个产品。

我们可以看下以下有关番茄酱的瓶子的这个例子并且修正它。我们将只需要使用一个瓶子，因为把两种不同的设计标记成“UI Vs UX”一点都没有意义：

![UI vs UX analogies. Ketchup example](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/08/15016346441-cYDgrGRLkIioJxkHUjrqaA.jpeg)

- **UI 层**是瓶子本身，包含了瓶盖和标签。这表示任何瓶子 - 而非仅是那个瓶口朝上摆放的版本[1](#fn1)
- **UX 层**是一系列要素的组合，比如企业品牌和市场营销能力、番茄酱本身的营养和质量、具体在线上或者线下发现和购买产品的举动、在社交媒体网络上企业与客户的互动和每一个企业和他现有以及潜在客户之间的接触点。

## UX 这个术语到底从哪里来？

UI 的起源远早于 UX。它从早期计算机时期就被使用，因为他是一种科学通称。而 UX 要过了很久后才开始流行。

在 90 年代中期，Don Norman 才让大众熟知了 UI 这个术语，他是 Nielsen Norman 集团的合伙人之一，他也是畅销书籍 ”The Design of Everday Things“ 的作者。刚开始的时候，UX 的含义很清晰，Don Norman 甚至还制作了[一个完整的视频](https://www.youtube.com/watch?v=9BdtGjoIN4E)来处理这个问题的细节。

## UI 不仅仅是 GUI: 设计一个 API

当我们考虑界面的时候，我们一般会提到图形化用户界面或者 GUIs。几乎当今我们使用的所有设备和系统都通过一系列可视化界面模型进行交互：操作窗口、图标、按钮、导航条、页面滑块、输入端口等等。

UI 和 GUI 已经几乎同义了，这样也有好处：在日常工作中，大部分的用户需要直接使用基于指令/代码的工具。尽管如此，UI 并不仅是 GUI。

在我的日常工作中，我关注于前端设计系统，所以设计一个系统中的面向开发人员层是我工作的一部分。既然这样，一个组件的 API 层就是给程序员使用的交互界面。设计和记录 API 层是我这些年来处理的最棘手的任务之一。

即使你不敲代码，我也不建议你把时间花费在这类任务上，甚至把它作为一个个人挑战。许多现代化的框架，例如 React，在鼓励和执行团队合作上做得很棒，他们采用一种更有意义的方式，而不是共享一个 Sketch 文件，然后一天就这样结束了。

## 拒绝伪二分法

虽然在设计界，对某些头衔和语义上变得更加专业绝对是一件好事，但是过分讨论 ”UI Vs UX“这样的话题将会产生反作用。这是一个热门话题，我也完全赞同 Jared Spool 的观点：“**人人都是设计师。**”

我已经数不清有多少来自开发者们非常棒的 UI 设计点子和来自视觉设计师的很有价值的 UX 改进建议。意识到你在公司组织中的拥有的头衔职责是很重要的 - 但仅限于这样的称谓不会阻碍你向其他领域发展。

---

1. 亨氏食品公司继续出售瓶口向上的玻璃瓶产品，因为还有情怀的老客户，也因为有不信任塑料包装的客户。[↩](#fnref1)


  ---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
  
