> * 原文地址：[Typography can make your design… or it can break it](https://medium.freecodecamp.com/typography-can-make-your-design-or-break-it-7be710aadcfe)
> * 原文作者：[Jonathan Z. White](https://medium.freecodecamp.com/@JonathanZWhite?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：
> * 校对者：

![](https://cdn-images-1.medium.com/max/1000/1*BVoyx8ImTwpRv36xVy6RyQ.png)

# Typography can make your design… or it can break it. #

One of the most important skills you can learn as a designer is how to choose type. This is because **text is one of the primary ways designers can communicate with users.** Typography can make or break a design.

There’s a beauty and complexity to typography. Some people devote their entire careers to type. Thankfully, their work is well documented, so we have tons of online resources for typography.

This article is designed to serve as a starting point for helping you learn how to choose type for your designs. It will encourage you to explore fonts and font combinations beyond those you’re familiar with.


### Identify your purpose ###

Before you do anything else, first identify the purpose of your design. What information do you want to convey? What is the medium for your design?

**Good design aligns its typography with its purpose.** This is because typography is key to setting mood, tone, and style in your designs.

For example, if you are designing a greeting card that’s illustration heavy, choose a font that fits the style of your illustration. Harmonize your type with the rest of your design.

![](https://cdn-images-1.medium.com/max/1000/1*J4sjruq6WffKZR0ukOFNxw.jpeg)

[Choose a font that suits the style of your illustration](https://dribbble.com/shots/3403715-Little-Tokyo-Los-Angeles/attachments/743158)

If you’re designing an image-driven landing page, choose a simple font that doesn’t detract from your images. Use type as a way to emphasize information to communicate meaning.

![](https://cdn-images-1.medium.com/max/800/1*3hkvdEybfIT3cgad20quEw.png)

[If images are the focus of your design, choose simple fonts so that the images stand out](https://dribbble.com/shots/3416904-Stripe-Atlas)

### Identify your audience ###

After determining the purpose of your design, identify your audience. This step is crucial because age and interest will influence your font options.

After clarifying the purpose of your design, identify your audience. This step is crucial because **information about your users such as age, interests, and cultural upbringing could influence the decisions you make for your type.**

For example, some fonts are more appropriate for children. When learning to read, children need highly legible fonts with generous letter shapes. A good example of this is [Sassoon Primary](https://www.myfonts.com/fonts/mti/sassoon/). Sassoon Primary was developed by [Rosemary Sassoon](https://en.wikipedia.org/wiki/Rosemary_Sassoon) and based on her research into what kind of letters children found easy to read.

![](https://cdn-images-1.medium.com/max/800/1*25G6PgjrO44fepoou-a8kg.png)

[Sassoon Primary was developed Rosemary Sassoon](http://www.sassoonfont.co.uk/aboutsassoon.html) 

Other fonts are more appropriate for seniors. Senior-friendly fonts use readable sizes, high contrasting colors, and avoid scripts and decorative styles.

When choosing type, take into account your audience and their needs. Simply put, **empathize with your users**.

### Look for inspiration ###

Look at the work of other designers. Try understand how they made their decisions for type.

#### Font Inspiration ####

For font inspiration, [The 100 Best Free Fonts](http://www.creativebloq.com/graphic-design-tips/best-free-fonts-for-designers-1233380) by CreativeBloq is a great article to put you in the right mindset for choosing type. In the article, CreativeBloq explains the motivations behind each font.

Another useful resource is [100 Greatest Free Fonts Collection for 2015](https://www.awwwards.com/100-greatest-free-fonts-collection-for-2015.html)  by Awwwards.

Invision also compiled a [giant repo of typography resources](http://blog.invisionapp.com/free-typography-resources/?imm_mid=0ef3cd&amp;cmp=em-web-na-na-newsltr_20170322) . You’ll find lots of sources for inspiration there.

![](https://cdn-images-1.medium.com/max/1000/1*fevzbXE7wwbwEt186SHmew.png)

[Typ.io curates font inspiration from around the web](http://typ.io/)

For inspiration from actual websites, check out [Typ.io](http://typ.io/). The site curates font inspiration from around the web. In addition, the site provides CSS font definitions at the bottom of each inspiration sample.

Asides from looking at dedicated font inspiration websites, visit your favorite sites and check out what fonts they use. A good tool for this is [WhatTheFont](https://chrome.google.com/webstore/detail/whatfont/jabopobgcpjmedljpbcaablpmlmfcogm?hl=en) . WhatTheFont is a Chrome extension that lets you inspect web fonts by hovering over them.

#### Pairing Inspiration ####

Beyond just fonts, also look at font pairing inspiration. Font pairing is just as important as the fonts themselves. Good font pairing helps establish visual hierarchy and improve the readability of your designs.

![](https://cdn-images-1.medium.com/max/1000/1*MVyB8tT4xlLZ4pXZ_SXx8Q.png)

[Font pairing is just as important as the fonts themselves](https://www.typewolf.com/site-of-the-day/new-american-economy) 

For inspiration, start with [Typewolf](https://www.typewolf.com/). Typewolf curates font pairing inspiration from different sites. Beyond that, they also have font recommendations and in-depth typography guides. It’s a treasure trove for typographers.

[FontPair](http://fontpair.co/) also curates font pairing inspiration, specifically for [Google Fonts](https://fonts.google.com/) . You can sort by type style combinations such as sans-serif and serif, or serif and serif.

![](https://cdn-images-1.medium.com/max/1000/1*MAfGLpDsPhPjQKPjgwbsbA.png)

Lastly, there are tons of font pairing collections created by designers online. For example[Typography: Google Fonts Combinations](https://www.behance.net/gallery/35768979/Typography-Google-Fonts-Combinations) and [Typography:Google Fonts Combinations Volume 2](https://www.behance.net/gallery/41054815/Typography-Google-Fonts-Combinations-Volume-2). Just search “font pairing” on sites like [Behance](https://www.behance.net/) and [Dribbble](https://dribbble.com/).

### Choose your fonts ###

Armed with research and inspiration, you are ready to choose your type. When it comes to choosing type, keep the following principles in mind: **readability, legibility, and purpose**.

![](https://cdn-images-1.medium.com/max/1000/1*5mhptSeNTRmPKD-A12dDhg.png)

[Before choosing a font, research into its intended purpose](https://www.typewolf.com/site-of-the-day/kvell)

Choose fonts that are conventional and easy to read. Avoid highly decorative fonts in favor of simple and practical fonts. Also, be mindful of the purpose of a font. For example, some fonts are more suited to be headers rather than body text.

For this reason, **before choosing a font, research its intended purpose.**

![](https://cdn-images-1.medium.com/max/1000/1*9COkZCDVar_HxpC2FyIF3w.png)

[Pair fonts that contrast one another](https://www.behance.net/gallery/41054815/Typography-Google-Fonts-Combinations-Volume-2)

In terms of font pairing, keep it simple with a maximum of three different fonts. In addition, pair fonts that contrast one another. Doing so will help guide the eyes of readers, first to headers and then to body texts. **You can also create visual contrast using different font sizes, colors, and weights.**

For web fonts, you can use [Google Fonts](https://fonts.google.com/), [Typekit](https://typekit.com/) , and [Font Squirrel](https://www.fontsquirrel.com/) . Google Fonts is free, Typekit and Font Squirrel have free and paid fonts.

### Determine font sizes ###

The next step after settling on a font combination is determining sizing. A great tool for this is [Modular Scale](http://www.modularscale.com/)  by [Tim Brown](https://twitter.com/timbrown?lang=en) , the head of typography at Adobe. Modular Scale is a system for identifying historically pleasing ratios to create scales to determine type sizes.

![](https://cdn-images-1.medium.com/max/1000/1*XiKcg1uRlq-2Z8MYz7bzTA.png)

[Modular Scale is a system for identifying historically pleasing ratios to create scales to determine type sizes](http://www.modularscale.com/)

For example, you might use a scale based on the golden ratio. Here would be your first five computed font size options:

```
Golden Ratio (1:1.618)

1.000 x 1.618     = 1.618
1.618 x 1.618     = 2.618
2.618 x 1.618     = 4.236
4.236 x 1.618     = 6.854
6.854 x 1.618     = 11.089
```

One issue that you might encounter is that your ratio is too large. Take a look at what happens to the later intervals of our scale based on the golden ratio.

```
Golden Ratio (1:1.618)

...
11.089 x 1.618    = 17.942
17.942 x 1.618    = 29.03
29.030 x 1.618    = 46.971
46.971 x 1.618    = 75.999
75.999 x 1.618    = 122.966
```

As you can see, the intervals between numbers start to become too large. For most interfaces, you need smaller intervals. Thankfully, [Modular Scale](http://www.modularscale.com/)  has a variety of ratios based on geometry, nature, and music.

```
Minor Second    15:16 
Major Second    8:9
Minor Third     5:6
Major Third     4:5
...
```

So instead of using the golden ratio, you can use a ratios that yield smaller intervals like the Perfect Fourth.

```
Perfect Fourth (3:4)

...
9.969  x 1.333     = 13.288
13.288 x 1.333     = 17.713
17.713 x 1.333     = 23.612
23.612 x 1.333     = 31.475
31.475 x 1.333     = 41.956
41.956 x 1.333     = 55.927
```

Once you have settled on a scale, you can cherry pick font sizes from your list and round them to the nearest decimal.

```
Font Sizes

Header 1: 55px
Header 2: 42px
Header 3: 31px
Header 4: 24px
Header 5: 14px

Body: 17px
Caption: 14px
```

The Modular Scale method uses mathematical precision in order to generate font sizes. However, it’s only a guide. **Use this method as a starting point and then adjust sizes with your eye.**

### Create a typography styleguide ###

The last step of the process is to create a styleguide for your typography to help standardize type across your designs.

![](https://cdn-images-1.medium.com/max/1000/1*ekIKHSrO94ay_6q56XZysA.png)

Shared styles in Sketch

In programs like [Sketch](http://sketchapp.com/), you can create shared text styles to quickly insert text with styles already applied from your guideline.

It’s during this step of the process that you can tweak and finalize your text attributes such as color, weight, and size.

A word on color: when choosing color, take into account your color palette. **Choose colors for your type that harmonize with your color palette.**

![](https://cdn-images-1.medium.com/max/1000/1*-xGeenSuQTpCLhVFxS08lA.png)

[Use styleguides to standardize type across your designs](https://dribbble.com/shots/2641393-Organizer-UI-Styleguide) 

In your styleguide, make sure to at least include the following things: font definitions, font sizes, font colors, and example usages.

[Google’s Material Design typography guidelines](https://material.io/guidelines/style/typography.html) is a good example of what to include in a styleguide. A couple of other examples includes the typography guides of [Mailchimp](https://ux.mailchimp.com/patterns/typography) , [Apple](https://developer.apple.com/ios/human-interface-guidelines/visual-design/typography/) , and [Focus Labs](https://dribbble.com/shots/2909744-UI-Kit) .

### **Typography is all about experimentation. It’s both a science and an art.** ###

I challenge you to break out of your comfort zone and explore type in your design.

What are your favorite fonts? Leave me a note or send me a [tweet](https://twitter.com/jonathanzwhite)  on Twitter.

You can find me on Medium where I publish every week. Or you can follow me on [Twitter](https://twitter.com/JonathanZWhite) , where I post non-sensical ramblings about design, front-end development, and virtual reality.

*P.S. If you enjoyed this article, it would mean a lot if you click the 💚 and share with friends.*



---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
