> * 原文地址：[Top JavaScript Libraries & Tech to Learn in 2018](https://medium.com/javascript-scene/top-javascript-libraries-tech-to-learn-in-2018-c38028e028e6)
> * 原文作者：[Eric Elliott](https://medium.com/@_ericelliott?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/top-javascript-libraries-tech-to-learn-in-2018.md](https://github.com/xitu/gold-miner/blob/master/TODO/top-javascript-libraries-tech-to-learn-in-2018.md)
> * 译者：[gy134340](https://github.com/gy134340)
> * 校对者：[moods445](https://github.com/moods445), [vuuihc](https://github.com/vuuihc)

# 2018 要学习的优秀 JavaScript 库与知识

![](https://cdn-images-1.medium.com/max/2000/1*POlkeGC7T-F0jIqYJpom_A.jpeg)

Alex Proimos — 纽约公共图书馆自修室 (CC BY 2.0)

去年，我写了一篇关于 [2017 需要学习的技术](https://medium.com/javascript-scene/top-javascript-frameworks-topics-to-learn-in-2017-700a397b711) 的文章。今年有一些惊喜。

> 我们致力于回答 “在你投资学习的时候，哪些最高效？” 的问题

![](https://cdn-images-1.medium.com/max/800/1*eLeegNau5KrKlpE0MDh61Q.png)

JavaScript 有最多的包，取得压倒性胜利。

首先，软件吞噬了世界，web 吞噬了软件，同时 JavaScript 吞噬了 web。而在 2018 年，React 正在吞噬 JavaScript。

### 2018: React 之年

React 在 2017 年赢得了人气之战。

从 Google 趋势可以看出，还是有很多开发者基于 Angular 开发：

![](https://cdn-images-1.medium.com/max/800/1*Z5dxtF877QndConbs0Tglg.png)

但是 React 持续的赢得用户满意度。它迅速增长并远远抛开 Angular (以及其他) 框架。

#### Vue.js 呢? 我听说它很火

每个人都喜欢口头上谈及相关的替代选项，比如 Vue.js。这是我去年说的：

> [**Vue.js**](https://vuejs.org/) 有很多的 GitHub star 和下载量。如果情况继续发展的话，它在 2017 年将会表现的很好，但我不认为它会在下一年里替换 Angular 或者 React。所以在你学习 React 或者 Angular  **之后**再学习它吧。

Vue.js 在 2017 年表现出色，赢得了很多新闻头条和人们的兴趣。像我所预测的那样，它没有**赶上 React**, 同时我也肯定的说在 2018 年也不会发生。即便如此，它可能在 2018 年超过 Angular:

![](https://cdn-images-1.medium.com/max/800/1*IWIeZaJGBd82ZnIk4vYtnw.png)

Vue.js 下载量/月

如你所见, Vue.js 正在赶上 Angular 的下载量：

![](https://cdn-images-1.medium.com/max/800/1*AOyTSi4Fs5uKNHZoyFcfHQ.png)

angular/core 下载量/月

但是 React 有很强的领先趋势和与之相同的增长率：

![](https://cdn-images-1.medium.com/max/800/1*XKJokKyWBzwqNgG2Nzckiw.png)

React 下载量/月

Vue.js 比 React 增长的更快，那与 2017 年 React 和 Angular 的对比有什么不同呢？

在 2016 年末，JavaScript 世界准备好迎接新的框架了。Angular 的用户非常的不满，React 的用户则与之相反，许多人想学习 React，很少人愿意学习 Angular。在 2017 年年尾，Angular 2 之后的用户满意度还是不到一半，只有 49%。

**React 和 Vue.js 则是完全不同的情节** [React 的用户满意度更高](https://stateofjs.com/2017/front-end/results) (93% to 90%)。2017 年早期，从 React 转向 Vue 的最大的刺激是 React 的开源许可证的问题。。Facebook 听取了用户的建议后来更改了协议。

在这一阶段，我看不到任何迹象可以让市场从 React 切换到其他的。Vue.js 从 React 手中夺取用户要比从 jQuery 和 Angular 那里难的多。

从 Angular 和 jQuery 那里夺取用户有很多空间，但是从 React 那里获取用户来获得持续的增长将会很快碰到瓶颈。

我预测 Vue.js 这种快速的增长只会持续一到两年，它会在顶部与 React 进行激烈的竞争，然后会停在第二位，除非有大的改变可以打破这个平衡。

### 职位

> jQuery 凉了。

在职位列表中, React 完全取代了 jQuery 之前的位置———**_这是十年来第一个超越 jQuery 的库_**¹。我们看到一个时代的终结。

![](https://cdn-images-1.medium.com/max/800/1*Zsfr-vAuQXc95A7j1ebyEg.png)

React 取代了十年来 jQuery 第一的位置
 (来源: Indeed.com)

对比一下去年的图:

![](https://cdn-images-1.medium.com/max/800/1*ZruXZe2HKfu2av8h4WBDfA.png)

jQuery 2016 年是这样的

有趣的点在于其他库的增长值大于 jQuery 滑落的值。总的来说，库相关的职位在去年增长了 10k 或更多。

在职位的增加下，我们还看到平均工资的增长 [$110k](https://www.indeed.com/salaries/Javascript-Developer-Salaries) 对比 2016 年的 $93k。通货膨胀同期保持在[2% 一下](https://data.bls.gov/timeseries/CUUR0000SA0L1E?output_view=pct_12mths)，并不会过多的影响这一爆炸式增长。

显然，在 2018 还有是卖方市场。

> **1. 方法:** 职位的搜索在 Indeed.com 完成。为了增强数据的可靠性，我成对的搜索 “软件” 相关的关键字扩大相关性，然后乘以大约 1.5 （粗糙的区分那些编程工作列表使用 “软件” 关键字和不使用的）。所有相关的都按日期排序记录相关性，其结果不一定 100% 准确，但是已经足够用来在此文中表示粗略的度。

### 框架推荐

在看了今年的数据之后，我强烈用最广泛使用的 React 来开发应用，包括移动端应用（PWAs, React Native），web 应用，大部分的生产力工具，以及桌面媒体应用（[Electron](https://electronjs.org/)）。

某些明显的情况下，其他的可能更为适用好：轻量的营销页面（完全不需要框架），3D 游戏，AR/VR。对于 3D 的内容，看看 [Unity](https://unity3d.com/), [Unreal](https://www.unrealengine.com/en-US/what-is-unreal-engine-4), 或者 [PlayCanvas](https://playcanvas.com/)。即便如此，React 也可以作为 3D 内容的 UI 库。

我强烈不建议转向其他可以备选的前端框架。这并不是说它们不好，只是它们不是市场上 React 有力的竞争者。记住，这个列表是关于投资回报率，而不是哪一个技术是最棒的。

### 为什么对 React 这么感兴趣?

浏览 React 的职位列表，我注意到很多本不应该属于前端工作的有趣的趋势：

* React Native (看起来, 这些需求总量比 Vue.js 的还多)
* React IoT
* React AR/VR (Oculus Rift 主导需求市场)
* React 对那些你从来没听说的模糊计算

> React 已经脱离了它 web 的土壤

灵活性是 React 最大的卖点。不像其他框架，采用 React 并不意味着关注它的数据模型，甚至浏览器和 DOM。事实上，我发现不少 React 的工作需求完全没有提到 JavaScript。

React 提供了基于其标准的丰富的充满活力的生态系统，这些从 jQuery 统治 web 以来从来没有看到过。

> 问题不再是“哪一个框架？”
> 问题是 “什么技术可以更好的搭配 React?”

没有任何事物可以在 2018 改变 React（也许 2019 也是）。你很安全。JavaScript 疲劳渐渐稳定了。我们有了一个伟大的构造应用的框架，同时有着相关的优秀的生态系统。

### 你应该学习哪些话题?

像去年一样，你不能错误的关注一些要点，但是你应该更加重视 React 应用的函数式编程。

React 有两点优秀之处:

* 确定性的视图渲染
* 将视图层从 DOM 操作中抽象出来

确定性通过使用纯函数构建应用来实现，这本质上也是函数式编程的定义。

考虑这一点, 这是一些你需要学习的内容:

* [**基础的 ES6 语法**](https://medium.com/javascript-scene/a-functional-programmers-introduction-to-javascript-composing-software-d670d14ede30)
* [**类的语法和它的各种陷阱**](https://medium.com/javascript-scene/why-composition-is-harder-with-classes-c3e627dcd0aa) — 可以对 React 组件使用类，但是应该避免继承你自己的类，避免 `instanceof`, 避免类的使用者使用 `new`关键字。
* [**函数式编程 和 软件组成**](https://medium.com/javascript-scene/composing-software-an-introduction-27b72500d6ea)
* [**Currying**](https://medium.com/javascript-scene/a-functional-programmers-introduction-to-javascript-composing-software-d670d14ede30#0355)
* [**闭包**](https://medium.com/javascript-scene/master-the-javascript-interview-what-is-a-closure-b2f0d2152b36)
* [**纯函数**](https://medium.com/javascript-scene/master-the-javascript-interview-what-is-a-pure-function-d1c076bec976)
* [**Promises**](https://medium.com/javascript-scene/master-the-javascript-interview-what-is-a-promise-27fc71e77261)
* [**Generators**](https://medium.com/javascript-scene/7-surprising-things-i-learned-writing-a-fibonacci-generator-4886a5c87710) **和** [**异步函数**](https://medium.com/javascript-scene/the-hidden-power-of-es6-generators-observable-async-flow-control-cfa4c7f31435)
* [**TDD**](https://medium.com/javascript-scene/the-outrageous-cost-of-skipping-tdd-code-reviews-57887064c412)
* [**RAIL 性能模型**](https://www.smashingmagazine.com/2015/10/rail-user-centric-model-performance/)
* **Progressive Web Applications (PWAs):** 看一下 [“Native Apps are Doomed”](https://medium.com/javascript-scene/native-apps-are-doomed-ac397148a2c0) 和 [“Why Native Apps Really Are Doomed”](https://medium.com/javascript-scene/why-native-apps-really-are-doomed-native-apps-are-doomed-pt-2-e035b43170e9)
* **GraphQL** 在 2017 年成熟了很多，非常快速的取代 REST API, Apollo 采用了内置的离线客户端缓存架构让 Apollo 和 GraphQL 成为 2018 Redux 的一个真正的备选方案（或补充）。

### 库和工具

这里是一些我发现的最有用的库和工具：

* [**React**](https://reactjs.org/)
* [**Redux**](https://redux.js.org/)
* [**Redux-Saga**](https://github.com/redux-saga/redux-saga) 管理异步 IO 分离副作用
* [**Next.js**](https://github.com/zeit/next.js/) — Node 和 Express 的服务端喧嚷, 自动的分离打包, styled-jsx
* [**Material UI**](http://www.material-ui.com/)
* [**Storybook**](https://github.com/storybooks/storybook)
* [**Cheerio**](https://github.com/cheeriojs/cheerio) 用来做 React 组件的单元测试（相比 Enzyme 我更喜欢它）
* [**Lodash**](https://lodash.com/) (我更倾向于 `lodash/fp`)。只导入需要的包避免增大打包体积。 
* [**Babel**](https://babeljs.io/)**:** 编译 ES6 使它在更老的浏览器上运行
* [**Webpack**](https://webpack.github.io/)**:** 最流行 JavaScript 打包工具，向 [kit/boilerplate](https://github.com/kriasoft/react-starter-kit)找一些简单的样例来快速的开始。
* [**ESLint:**](http://eslint.org/) 提早检测语法错误和样式问题，在 code review 和测试驱动开发之外最好的可以减少你代码里错误的工具。
* [**Ramda**](http://ramdajs.com/)— 主要是为了 lenses 和 transducers.
* [**Node & Express**](https://medium.com/javascript-scene/introduction-to-node-express-90c431f9e6fd#.gl2r6gcnn)
* [**RxJS**](http://reactivex.io/rxjs/)**:** 让 JavaScript 可观察，最近我一直在使用 transducers，记着使用 [patch imports](https://github.com/ReactiveX/rxjs#es6-via-npm) 来减小包体积。

**TypeScript**2017 年表现不错, 但我认为它增加应用的复杂度的弊端大于它的帮助，它的主要缺点是过分依赖注释而不是接口，同时对高阶函数的类型有无法形容的扭曲，我做了一整天的试用，这些情况仍然存在：[“静态类型之秘”](https://medium.com/javascript-scene/the-shocking-secret-about-static-types-514d39bf30a3) 和 [“你也许不需要呀 JavaScript”](https://medium.com/javascript-scene/you-might-not-need-typescript-or-static-types-aa7cb670a77b)。Flow 跟 TypeScript 有相同的问题同时开发者工具也不如 TypeScript 的棒。


### 2018 技术展望

所有的这些都是 2018 研究与开发领域真实的工作：

* Progressive Web Apps (PWAs)
* 区块链与金融科技
* 医疗科技
* AR/VR — Hololens, Meta, 和 ODG 现在可以出货了。 ODG R-9 本来预计 2017 发售但是很有可能放在 2018。MagicLeap 承诺 2018 发布。AR 将会比过去手机更加改变人们的体验。
* 3D 打印
* AI
* 无人驾驶

量子计算也将改变世界，但是也许在 2019 或者更晚改变才会开始。目前有在网上工作的量子计算机，但是他们还做的不是很多。现在对于大多数开发者来说开始试验性生产还太早。微软最近发布了它的量子计算编程语言 [Q#](https://arstechnica.com/gadgets/2017/12/microsofts-q-quantum-programming-language-out-now-in-preview/)，[IBM](https://www.forbes.com/sites/alexkonrad/2017/12/14/why-companies-like-jpmorgan-chase-and-samsung-are-partnering-with-ibm-in-quantum-computing/#123ce0592c4d) 和 [Google](https://www.inverse.com/article/38917-google-quantum-simulator-creates-a-butterfly) 也继续大量投资自己的量子云计算市场。

如果你想学习量子计算，你也许需要学习 [线性代数](https://mitpress.mit.edu/books/quantum-algorithms-linear-algebra)，同时也有对于量子计算也有一些基于 [lambda 演算](https://plato.stanford.edu/entries/lambda-calculus/) 的函数式探索。

很有可能，像我们看到的 AI, 云 API 将会被开发出来让有不同数学背景的人来更好的利用好量子计算的能力。

### 需要为你的团队教授 React?

DevAnywhere 提供一些 React 的线上教程，和一对一的关于 React 中函数式编程及软件构建原理的指导。

[![](https://cdn-images-1.medium.com/max/800/1*pskrI-ZjRX_Y0I0zZqVTcQ.png)](https://devanywhere.io/)

[https://devanywhere.io/](https://devanywhere.io/)

* * *

**_Eric Elliott_** _is the author of_ [_“Programming JavaScript Applications”_](http://pjabook.com) _(O’Reilly), and cofounder of_ [_DevAnywhere.io_](https://devanywhere.io/)_. He has contributed to software experiences for_ **_Adobe Systems_**_,_ **_Zumba Fitness_**_,_ **_The Wall Street Journal_**_,_ **_ESPN_**_,_ **_BBC_**_, and top recording artists including_ **_Usher_**_,_ **_Frank Ocean_**_,_ **_Metallica_**_, and many more._

_He works anywhere he wants with the most beautiful woman in the world._


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
