> * 原文地址：[Think Less. Design Better.](https://medium.com/@xtianmiller/think-less-design-better-f812c1617888)
* 原文作者：[Christian Miller](https://medium.com/@xtianmiller)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Siegen](https://github.com/siegeout)
* 校对者：[jiaowoyongqi](https://github.com/jiaowoyongqi),[Newton](https://github.com/Newt0n)                                           

# 顾虑越少，设计越好。

<blockquote>在设计过程中，存在的可能性越多，需要进行的思考就越多。</blockquote>


美国心理学家 Barry Schwartz 在 [The Paradox Of Choice](https://en.wikipedia.org/wiki/The_Paradox_of_Choice) 这本书中写到，排除一些选择可以大幅度的减少焦虑。
> **最优解不是成为一个完美主义者，而是让最为人所赞同的决定变得可行，这可以让我们共同创造出最佳体验。**


* * *



### 1\. 限制变量


为了制作出高度精确的概念，如果我们要考虑所有潜在的变量，那将会有很多，而如果我们在早期就限制和定义这些变量，制作过程会变得很明朗。



> 有了这个经验，限定某些变量组之后，我们预测在创造过程中如何产生几倍的效果变得更加简单了。 

减少选择不会导致独创性的减少。我们假设把围绕预先制定好的规则来创造概念作为一个限制，但是作为设计者我们可以创建我们自己的规则，完全掌控创造它们的过程。


#### 尺寸与间距






UI 设计的每个方面都需要围绕一个系统进行，以此来改善节奏感并在一个项目成长的时候帮助保持尺寸与间距的一致性。一个我爱用的像这样的系统是   [modular scale](http://www.modularscale.com/),它可以使制定尺寸变得便利它可以通过任意指定比列来测量、设定某个元素或者某个整体中负空间的尺寸。




![](http://ac-Myg6wSTV.clouddn.com/606ead6ffa394a345f2f.jpeg)











一旦我们采用了某个比例，modular scale 会使得定义尺寸和间距变得更加简单。

尽管它可以在栅格，排版，垂直空间以及一个布局的综合方面减少变量，来使这个设计达到一个易操作的层次，但是它也提供了令人愉悦的美感和韵律。设计 UI 相当容易。



####  栅格



[栅格系统](https://en.wikipedia.org/wiki/Grid_%28graphic_design%29)是一个绝佳的设计方法，当把内容实现成具体的 UI 界面的时候，它不仅可以对页面内容组织的方式加以限制，还可以简化实现方式。但是，栅格经常被不加思考的采用，变成了一个被当作万金油的方案。大多数设计师都没有意识到，相对于使用万金油方案，专门设计一款[适用于你产品](http://www.iamtomnewton.com/blog/grid-guide/)的栅格系统会是更好的一个方案。


![](http://ac-Myg6wSTV.clouddn.com/013c2d0de9ed5e3a9947.jpeg)






栅格系统可以减少影响布局的变量。

这意味着理想情况下应该提前对内容的大致情况有一个清晰的了解，以便于思考如何设计出最适合于特定内容的栅格系统。根据预存的资源和品牌指南来考虑商业限制，例如一个拥有具体空间规则和要求的 logo，或者可能是有着具体的固定单元的广告。



内容的类型也是一个因素。设计时还需要考虑到内容的不同类型，如商品包装、新闻出版物、博客或者是简单的引导页，它们之间的差异十分之大。要考虑到布局是以图片为主还是以文字为主。要理解 [eye-scanning patterns](http://www.webdesignerdepot.com/2015/03/how-eye-scanning-impacts-visual-hierarchy-in-ux-design/)  和它们是如何对一个视觉层次产生作用，这会对设计很有帮助，



对商业和内容的重要限制理解的越深刻，采用栅格系统并作出布局决定就越容易。



#### 字体

我觉得字体是 UI 设计最重要的方面，因为它[占据了网页的 95%](https://ia.net/know-how/the-web-is-all-about-typography-period)，是信息交流的驱动力量。




尽管像 modular scale 这样的系统可以应用在尺寸和行距上，但是字体族和风格是被限制的。一个 UI 布局不应该超过两个字体类型和多个字重。规则可以拓展到如何应对摘要和标题。



#### 颜色




使用调色板很容易过度用心。几种色调就可以产生一个充足并且一致的视觉效果。通常在一开始我们有 [5  种色卡](http://www.colourlovers.com/palette/15/tech_light)就够了。








![](http://ac-Myg6wSTV.clouddn.com/fc3b8fb6c99856d9deb4.jpeg)







诸如 Adobe Color CC 之类的工具可以使预定义一个调色板变得非常容易。





大部分品牌应该采用了一个主要的或者重要的颜色以及一些中立的或者差异的色调来实现。一开始的时候，界面中并不需要用到 15 种不同明度的颜色。最佳的做法应该是从单一的明度起步然后逐步增加更多不同的明度。

#### 图片



我们如何把图片插入到 UI 中在很大程度上是由内容的上下文所决定的。如果我们对那个有一个大致的了解，我们可以为我们的图片创建一个起始点，这些图片有着比例，尺寸，形状和论述等等的变量。我们可能会发现我们不需要那么多。




限制我们图片的变量可以强制的获得更好的一致性，并且使得在长期过程中管理图片资源变得更加容易。这对标志来说也是一样。



![](http://ac-Myg6wSTV.clouddn.com/d49c1d37d22011c9d42d.jpeg)







对于图片的比例和尺寸我们确实需要的有多少变量？












* * *









### 2\. 尽早的创建一个风格指南


作为一个概念上的 UI 项目，创建和维护一个风格指南或者模式库变得越来越重要。这将建立设计准则来帮助项目扩展，维护节奏感和一致性。如果我们正在事先定义变量，为它们写文档是一个好的方法。相比于没有文档来说，拥有一份文档在未来进行决策的时候会更加容易。


根据项目的情况，有时候创建一个风格指南是一件奢侈的事，经常需要依据未来的计划进行改动。这也是为什么大部分风格指南都在最后一分钟或者是在项目完成后才准备好，当然这仍然是个好习惯。但是对于风格指南来说有着大量致力于预期设计和发展的[主张和论证](https://www.smashingmagazine.com/2010/07/designing-style-guidelines-for-brands-and-websites/#why-create-a-style-guide)，它可以为早期概念化打好坚实基础提供帮助。




> 在开始的时候正确创建一个基本的风格指南不仅可以早早建立原则来减少设计抉择，还可以作为一个基础设施帮助参与和添加主要的内容。

在开始的时候制作一个东西不意味着它需要是完整的——可以差的很远。这些风格在早期总是会演变出许多的可能性，一个项目变得越大，它的边界也就越清晰越严谨。











* * *









### 3\. 基于模块的优先级和适应性



在基于模块的设计系统中，例如 Brad Frost 的[原子设计](http://atomicdesign.bradfrost.com/)，布局可以在具体的关键区域外进行制定。模块可以在各种各样的布局里面重复使用。界面被当作系统对待而不是页面，使用基于模式的设计和部署是进程中的一个重要环节。



这是一个很好的方法，它使得 UI 设计更加容易管理，但是为了使它更加有效率我们不得不优先考虑关键区域，并让关键区域周围的所有内容去适应它们。这样将会相应的确定[视觉连贯性](https://about.futurelearn.com/blog/visual-connections-in-modular-design-systems/)。



#### 确定关键区域



我们的设计应该围绕重要的部分进行。每个区域的优先级是由它在界面内的内容或者功能所决定的，这是这个问题基本答案。

> 通过首先聚焦于重要的区域，我们正在减少此后的设计抉择，因为随后的区域不得不进行变通来适应已经建立的周围内容。




#### 聚焦于关键区域


一旦高优先级的区域已经被确定下来，对于这些关键的区域需要高度关注并且将它们完成。这个观点主要是指，在适应次要区域之前，我们需要确保它们是简单可用并且符合所有的要求的。







* * *








### 4\. 让它为每个人工作



几千年来设计师们都一直尽力做一件事——高效的沟通。我们持续不断地在视觉和听觉方面，迭代重构一个对于用户而言更为友好的沟通方式。


>随着我们从广阔的潜在用户群不断的获得信息，为了从中得到尽可能多类型的人群信息，优化获取方式变得迫在眉睫。



#### 无障碍使用是一件因祸得福的事情



迎合更广泛的用户听起来意味着更多的工作，把无障碍使用视作为[革新的障碍](https://medium.com/salesforce-ux/7-things-every-designer-needs-to-know-about-accessibility-64f105f0881b#3a51)是很诱人的。但是，遵循最新的标准会是件因祸得福的事，尤其是如果它们已经成为习惯了。

在设计期间的例子包括一系列的要求——我们需要一个最小的字体尺寸用在文本主体，或者是正文和背景资料之间的一些有意义的差异，或者是触摸设备上更大的链接区域。



#### 这不仅仅是关于残障人士的。

无障碍使用[不仅仅是为了服务残障人士](http://alistapart.com/article/reframing-accessibility-for-the-web#section2)，一些人可能会这样暗示，但其实也是服务于那些用着老式设备和浏览器的用户，他们的设备往往无法支持所有的最新特效和提升。意识到这些标准并且遵守它们将会很自然的减少设计抉择。












* * *









### 5\. 使用经过考验和测试的模式



事实是，当用户遵循数百个普遍的设计模式的时候，这些设计模式他们已经从多年的使用和了解过程中完全吸收了，所以现在用户凭借直觉发现界面。一旦我们开始打破传统模式并且发展新的趋势，我们会发现让一种新模式完全变成用户的直觉会花费大量的时间。
> 制作原创的 UI 模式是可行的，但是我们不应该对常见的方式心怀顾忌——毕竟它们的成功是有理由的。



少考虑重新创造，聚焦于美感是我们的一线希望。基于已建立的模式进行原创的工作仍然是可行的。





对于成功的设计模式我们了解和融入的越多，作为设计师我们需要做的选择就越少。我们不需要考虑什么**可能**会起作用，转而去考虑什么**将会**起作用。






* * *








### 最后的注意事项



对于这些方法中的一部分方法来说，单独使用可能对于减少我们的思考量和抉择帮助不大，或者说无法大幅度的改善我们的设计。但是把它们合并在一起，持续获取好的反馈，可以使得设计更好 UI 的这件事变得相当容易。




