
> * 原文地址：[The Ultimate Guide to Creating a Mobile Application](https://uxplanet.org/the-ultimate-guide-to-creating-a-mobile-application-8e2b265580d9#.sk3bzlt5z)
* 原文作者：[Tubik Studio](https://hackernoon.com/@talkol)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[PhxNirvana](https://github.com/phxnirvana)
* 校对者：[lovelyCiTY](https://github.com/lovelyCiTY)、[Gocy015](https://github.com/Gocy015)

# 创建一个移动应用的终极指导

![](https://cdn-images-1.medium.com/max/2000/1*ecU3mH6ajULJpcVFvLGcaQ.png)

大多数现代人都难以想象有一天他们拿着智能手机却只用来打电话的情境。当今移动设备的迅猛发展早已超出了当初发明它们的目的——打电话和发短信。现今，即便是最普通的手机也提供了一个承载着众多日常应用的平台，这些应用使人们的生活更加愉悦。有轻便也有庞大，有资讯也有娱乐，有极简也有拟物，有提升自我的也有仅供消遣的，能够满足不同用户的不同需求，并使他们的生活更加美好。大量应用的盛行使得用户仅靠一部手机就可以完成众多工作。设个明天的闹铃，算算下周的预算，又或者给老妈发个自拍彩信，人们甚至不用去想这些简单操作后有多少专业人士的辛劳。

我们早先在 [Tubik Blog](http://tubikstudio.com/blog/) 发表的文章以及这篇发表在 Medium 上的文章已经揭露了设计移动应用界面的一般步骤。今天让我们更进一步，从创意到 App Store 上架，完整地走一遍如何建立移动应用的过程。

![](https://cdn-images-1.medium.com/max/800/1*LzSzKxNOKNCFTy7gEPBNtA.png)

和其他创造性劳动一样，从无到有建立一个移动应用是个庞杂的过程，在每一个特定阶段都有其独有的问题和特性。尽管如此，通过在 [Tubik Studio](http://tubikstudio.com/) 上创造各种各样不同应用的基础扩展训练也可以定义一些典型的创新共性，如下所列：

- 设立任务和初始工作范围
- 估算
- 用户/市场调研
- UX 线框图
- 原型
- UI 设计
- 动画
- 软件架构设计
- iOS 开发
- 测试
- 打包
- 更新。

尽管上面的排列是有序的，但这并不意味着你需要在完成前者之后才开始下一步。尽管上列的众多过程和阶段是有联系的，但也不能简单臆测成线性关系。不仅如此，其中的一些如测试或估算会贯穿整个流程。现在就让我们来一步一步地将灵光一闪变成真正的应用。

![](https://cdn-images-1.medium.com/max/800/0*sUp1d1u14doiNvBH.png)

### 设定任务和起始工作范围

就像我们之前在 [logo design stages](http://tubikstudio.com/logo-design-creative-stages/) 中提过的那样，设立任务这一点是设计和随后的开发的基础。在这个阶段设计师和开发者应该从客户那里获取尽可能多的信息来制定正确的方法去实现目标。若行走无向，则寸步难进。产品设计也是一样的：若想有所产出，则必须在开始前就明确目标。这并不意味着在整个过程中目标是一成不变的：我们必须保留一定的变更灵活性，因为随着创造、调研和测试过程的不断推进，我们的目标或多或少都会发生一些变动。话虽如此，但如果在开始时没有设立目标的话，整个过程就会轻易变成一团乱麻。

我们在长期实践中得出的另一个关键点是和用户交流时不仅要了解他们的需求，也要努力明白需求背后的想法和理由。如果你明白为什么你的用户想要特定的颜色、形状或过渡后，（必要时）你就更容易在其它的地方将这些想法转化成相应的实现，以满足用户的需求，同时也能在保证用户体验的前提下，兼顾资源消耗及交互控制。

从用户那里得来的信息越多就越容易设定正确的方向。设计概要、电话或网络会议、闲谈、头脑风暴、心情版等都是创造性工作的良好开端。就我们而言，这些经验丰富的销售经理和商业分析师打响了与用户交流的第一枪，并能很好的搭起沟通桥梁。

![](https://cdn-images-1.medium.com/max/800/0*CKlxuiZEL4IpMha7.jpg)

在此阶段十分推荐获取如下信息：

- 产品的核心价值和卖点
- 目标人群
- 目标地域（如果需要的话）
- 代表独特性的关键词
- 用户眼中产品不可或缺的主要结构和功能
- 用户偏好的视觉特性（颜色、风格、亮点、与其他已有电子产品或品牌的联系等）
- 可能使用该应用的潜在科技、设备和平板（译者注：潜在目标平台）
- 与公司已有产品的一致性（如果需要的话）（译者注：界面风格等能让人一眼就能认出来是某公司的产品的特性） 
- 数据传输，需要服务端或其他技术的支持
- 特殊要求

很明显，这份清单并没有罗列全部信息，但它包含了一般设计和开发流程中最重要的要素。在此阶段应该得出进一步工作的各部分基础信息，计划出时间点和冲刺阶段，以及高效设计和开发的解决方案。

### Estimation

前一阶段收集的信息使得商业分析师和销售经理可以初步预估项目的开发周期和经费开销。就像其他任何创新过程一样，计划总是赶不上变化：这时就应该在设计的每一阶段都回头重新审视数据。当然，也有一些产品十分简单、结构明确、平台单一，整理用户数据和需求并估计就会变得相当准确。然而，项目越复杂，重新估计和调整的可能性就越大。更重要的一点：重新估计并不一定意味着时间或预算的增加，创新过程中的设计师和开发者可能会找到优化设计和技术的解决方案，这甚至能缩短预估（的时间或金钱）。

如果是全栈团队的话这个流程会相当完美的：这意味着商业分析师可以让设计师和开发者在分析和评估的最早期就参与到进程中，因此可以提供更真实准确的时间和金钱预算。还有就是有专家参与的讨论可以从技术角度提供大量独到知识和见解，这些会影响应用设计和开发阶段对时间和资源的需求。

![](https://cdn-images-1.medium.com/max/800/0*pT7VMdDUoUsTElBa.jpg)

### 用户/市场调研

这一阶段要基于已建立的任务和目标，UI/UX 设计师会在对应用整体功能有进一步了解之后开始行动。调研阶段通常是用户调研和市场调研分头并进。

用户调研意味着对核心目标人群心理特性的更深入研究，不同因素的影响如颜色、样式选择、情感交互和特定群体体验上的逻辑，信息资源和一些创造性的表现形式都可以让用户参与进来并提高其活跃度。市场调研意味着浏览市场部分，主要是对竞品的深入研究。视觉设计应追求原创性和辨识性（独到性），使得产品能鹤立鸡群并牢牢吸引目标人群的注意力。

广告业知名专家 David Ogilvy 强调了调研对有效成果的重要性：忽略调研的广告人就像忘记解密敌方通信一样愚蠢。方法、目标和技术随时间而改进，但调研扮演的角色却越来越重要。忽视调研阶段而只依赖于他们的创造性直觉、经验和天赋的话，设计师有失败的危险了，因为他们不会知道应用实际工作场景，也无法使其变得高效、用户友好而且独特。

![](https://cdn-images-1.medium.com/max/800/0*_zW-wAx5G6vZLeTe.jpg)

### UX 线框图

这个阶段的目标是为产品所要解决用户最基本的问题和痛点设定一个清晰、有序的结构来合理的布局，过度和交互。通常情况下会完成一套示意性的精度不高的草稿（数字或纸张形式）。

在 [我们先前的一篇文章中](http://tubikstudio.com/design-faq-platform-customers-set-two/) 提供了一些这方面的示例。举个例子，当我们想到要盖一栋房子的时候，我们往往想到的是其物理上从无到有的过程，而不是一大堆的计划表、草图和各种计算。当然也可以什么都不考虑直接盖个空中楼阁。那当它有一天毫无征兆地塌了的时候麻烦你合上那脱臼的下巴。华而不实的应用并不会吸引到任何死忠用户。如果你想有一幢可靠的房子，一套可持续运转的机器，一个强大的应用又或者是个高度集成的网站，原理都一样——多花点时间来设计和计划。这并不会浪费时间，恰恰相反，这将节省你在未来可能花在重新设计和找问题上的时间。 

这就是 UX 设计阶段的目标。UX 线框图应该紧密结合用户调研，竞品调研以及对获取数据的分析结果。该阶段应该产出明晰的策划，包括产品功能复杂度、系统事务映射和包含各界面元素在使用中的位置的交互。在某些情况下，铅笔描绘的线框图就够用了，当然，用特定工具和软件优化设计并提升体验就更好了。

![](https://cdn-images-1.medium.com/max/800/0*0DYWLqF8FG_JT5DU.jpg)

### 原型

“原型”最初的含义是用来测试解决方案或设计是否有效的样品。原型不应该被看作最终产品的相似物，因为它们本来就不是（用来做最终产品演示的）。原型的目标是让设计师、顾客和用户来检查设计是否正确且合适。.

最近几年在 APP 和网站设计领域产品原型的价值飞速提升。事实上这很容易解释，尽管原型相对粗糙，但相比复杂计划、图示和线框图来说，原型使设计师、顾客和测试离最终产品的外观和功能更近了。当然，这并不表示计划和线框图可以被省略，它们仍是设计中必不可少的一部分。然而，当你想提升效率并检查设计是否有遗漏时，原型会有很大的帮助。

考虑到实际上许多客户都将原型当作十分接近最终版的产品设计，或者叫做 “变动中的 UI”，这种操作在实际中效率并不高。原型是在 UX 设计和 UI 设计中更高效和有用的一步。所以我们在 [Tubik Studio](http://tubikstudio.com/) 中提供了 UX-原型-UI 步骤的工作流。

UI 阶段的原型是建立用来展示应用大概样式的而不是测试和提升功能特性。这是一个经常被搞混的点。在 UI 设计的最终阶段为所有细节建立原型在大多数时候没有想象的那么合乎情理。这会花费巨大的时间代价，与其这样，还不如将时间花在构建一个 demo 版本上。此外，可用性应该在 UX 阶段就已经完整地检查过了，否则，在大部分 UI 工作完成后再去改变那些不够高效的用例就会非常困难。当然，为 UX 和 UI 各自建立原型是非常棒的，但目前为止并不是所有的设计师和顾客都同意将大量时间耗在设计阶段，他们想又快又便宜地测试和改善设计。

![](https://cdn-images-1.medium.com/max/800/0*geebEHILlFz0INfp.jpg)

### UI （用户界面）设计

用户界面实际上是一块能让用户和产品进行交互的固定区域。其包含所有提升易用性的工具以及满足目标用户需求和愿景。所有会影响产品使用和用户交互的视、听、触摸感官的特性都应该被分析和优化，以满足应用或网站的设计目标。例如颜色、样式和字体、形状和形式、配图和动画等都可能对最终产品体验产生巨大的影响，或好或坏。

通常情况下，UX 研究和线框阶段是关于网站或应用如何运行的，而 UI 是关于其长什么样的。这些阶段都是为打造成功的交互而努力，但 UX 更强调逻辑、联系和用户行为，而 UI 则提供所有概念的具体视觉表现。这意味着理想情况下设计师应该先开始 UX 部分，专注于布局并使其更强大、合逻辑、明了且易上手。没有这些重要工作的话你的界面很有可能会一团乱麻。

在以原型的形式测试了 UX 并对布局、过渡和特性达成一致之后就开始了 UI 的步骤。这是为你刚搭建好骨骼和心脏的产品，添加血肉的过程。在此阶段，产品会被赋予色系、形状、布局细节特征、样式、动画元素等。

对用户界面的一切决策都会直接对用户体验产生积极或消极的影响，所以 UX 线框图和 UI 设计应该互相支持并遵循相同的策略，否则某一阶段的高效解决方案就无法在另一阶段得到发挥了。

![](https://cdn-images-1.medium.com/max/800/0*xkI4lh2vKpFI6KdL.jpg)

### 动画

说到 [界面动画](http://tubikstudio.com/ui-animation-eye-pleasing-problem-solving/) 在移动应用中的细节和优点时，我们提及到的最有效的方式是在产品创造的每一个阶段都对这一层面进行思考。然而，最佳敲定方案的时机是在当 UI 设计基本完成，通用样式确定下来的时候。

像所有被放到交互中并起到作用的元素一样，动画必须是功能性的元素，不能仅仅是个装饰。如在计划用户使用流程时放进运动元素，设计师在规划用户使用产品流程时，就应该考虑如何添加运动元素，并且他们应该在将运动元素加入布局或过场之前，仔细考虑清楚这是否能提高产品的可用性、多用性以及用户黏性。[UI 中的动画](http://tubikstudio.com/ui-animation-eye-pleasing-problem-solving/) 要求三思而后行并且其背后总是要有着明确的目标。在交互过程中使用动画必须要有显著的优点和实用性，并且能够盖过与之伴随的潜在缺点。

![](https://cdn-images-1.medium.com/max/800/1*j6Gn2p0WGOKpR4Vh1hEXdQ.gif)

在这个阶段完成后，视觉细节任务就完成了，设计师将素材转给开发者，后者会巧夺天工地为它们赋予生命。当然，这是再次审视估算的好时机，同时可以靠已完成的设计来明确计划的各开发阶段。

### 软件架构设计

一个值得注意的细节是扩展性在移动应用中是很重要的东西。计划软件架构可以和设计齐头并进。这是一个复杂的过程：通常会包括许多次迭代，同时接收设计团队和开发团队的不断反馈。架构设计的主要目标是建立健全完整软件应用架构（前端和后端）。在这个阶段开发者决定最有效率的 开发和维护应用的技术和工艺解决方案。最终决定取决于诸多因素，如信息传输环境、设计的复杂性、存储数据的必要性和记录功能等。后端开发通过网络建立与应用双向同步数据的桥梁。

### iOS 开发

在 Tubik ，我们和其它的 iOS 开发者一样，使用高效、灵活、功能齐全的 Xcode 进行实际的编码。就像在 [官方网站](http://help.apple.com/xcode/mac/8.0/#/devc8c2a6be1) 上描述的那样，**Xcode 是 Apple 的集成开发环境（IDE）。使用 Xcode 来为苹果设备开发软件，包括 iPad、iPhone、Apple Watch、Apple TV 和 Mac。Xcode 提供管理整个工作流的工具，从建立应用到测试、优化和在 Apple Store 上架。**

Xcode 只在 Mac 设备上运行，并且拥有开发 iOS 应用所需的一切。官方没有提供在 Windows 或者 Linux 上运行的方式。这意味着如果想为iPad、iPhone、Apple Watch、Apple TV 和 Mac 开发应用而没有 Mac 的话，就必须买一台去。

iOS 开发者最常用的两种语言是 Objective-C 和 Swift ——我们在 [早期的博文](http://tubikstudio.com/swift-or-objective-c-tool-tips-for-ios-developers/) 里对比了两者的优缺点。从 2014 年开始，Swift 在开发中开始被更多的使用，因为 Objective-C 对于开发者而言是一种较难上手的语言。尽管如此，Objective-C 对于早期低 RAM 和处理器的 iPhone 硬件来说有着良好适配性，并且更易维护基于 Objective-C 开发的应用。Swift 紧跟最新设备的步伐，让编程人员在编码过程中更快（译者特别保留的校对注：真的能更快啊，语义精简，语法糖多），它也更易用、更精简、更安全。创建 iOS 10 的应用时，需要安装 Xcode 8 和 iOS 10 SDK，也可以在 Apple 找到。在这个版本的 Xcode 上 Swift 和 SDK 有些重要更新。

![](https://cdn-images-1.medium.com/max/800/1*GrfK3MtvPGwQwHoFP_hm7A.png)

在这个建立移动应用的阶段，iOS 开发者们考虑应用架构，编写代码，将功能和界面结合起来，修改代码调试直到最终发布到 App Store。还有，编写单元测试和整体测试都是这个阶段的相关步骤。Interface Builder 是 Xcode 的特性之一，该特性是相对于纯手写客户端代码的一种替代方案，它允许开发者在可视化界面上完成应用的开发。这项特性允许开发者通过拖拽来向应用中加入可视控件。 AutoLayout 则能根据不同屏幕的尺寸实现应用界面的布局自适应。而在 Storyboard 中，开发者能够准确的查看应用在不同屏幕上的各种布局，使用预览模式，就能在完成编辑后实时展示应用的（在不同屏幕上的）实际视觉效果。

许多开发者都认为文本编辑器是必需品，尽管理论上 Xcode 可以完成所有工作。又长又复杂的代码是很难操控的，除非程序猿有一款支持所有相关语言语法的编辑器。

![](https://cdn-images-1.medium.com/max/800/0*CZeHN4LEVF-unrs4.jpg)

大多数情况下，当一部分程序猿在完成客户端时，另一部分在编码整合前端和服务端，如数据库、接口、中间件等。

另一个需要写明的点是计划工作流和参与开发的人数取决于项目的复杂度和紧要性。对于小项目来说，一个 iOS 开发者可能就搞定了应用里的全部架构。对于十分复杂的项目来说，至少需要两个对软件架构和客户端以及服务端都有经验的程序员。.

这个阶段的主要目标是建立一个具有完整功能的应用，具有可扩展性并已经和服务端如数据库、接口和其他相关必要组件连接起来。如果客户没准备好建立自有的服务端组件，可以购买 BaaS(Backend as a Service) 服务或其他产品。服务包括大量存储选择和特性，但它们不能是完全的一站式，因为它们通常不能提供深度和广度的分析。这就意味着客户端需要一个了解后端的工程师来将其加到应用中。

![](https://cdn-images-1.medium.com/max/800/0*dOaBffq7pdVmef7e.jpg)

### 测试

**“高质量从来不是幸运的偶然，它一定是高度转注、辛勤付出、明智选择和正确执行的必然结果。”**，William A.Foster 曾这样说到。在数字产品测试方面，它毫无疑问是正确的。

测试是整个应用设计和开发周期中最关键的阶段之一，它可以在应用上线前就找到问题。App Store 不会接受任何有编译错误的应用，所以有上述问题的待提交应用是不可能通过审核的。通常情况下，当应用有功能性问题时，用户会很快弃用该应用，无论吹得多天花乱坠。如果他们正确而高效地工作来迎合目标用户的期许并解决他们的问题，即使最简单的应用也可能获得贸易、商业、广告或其他目标上的成功。

测试并不意味着开发者无需关注质量。类比来看，每一本书、杂志甚至报纸都会经过编辑的审核，但这并不是说记者或作家毫无天赋或不合格的。在提升可用性和效率方面，术业有专攻，设计和开发移动应用也是如此。如果开发者干得相当漂亮没有任何问题，测试的目的就不仅仅是找出问题。恰恰相反，它帮助了解应用的质量并通过实际交互找到改进的方法。

![](https://cdn-images-1.medium.com/max/800/0*hLQDATaKyLwRspQ3.jpg)

自动化测试很受欢迎，因为其高效、便宜、可信赖。iOS 模拟器和其他测试工具如 Appium、Frank、Calabash、和其他都可以帮助测试应用并指出需要注意的地方。每个阶段都持续测试可以避免小问题累积成大问题。

在测试过程中，开发者通常会讲应用的全部流程在真机或是 iOS 模拟器上走一遍，确保每个界面都没有问题并可以完成期望操作。修复和调试都可以在 Xcode 上完成。

测试应该涵盖应用的全部方面。开发者需要在不同设备上检查（iPhone、iWatch、iPad、iPod等）因为诸如屏幕分辨率，处理器，电池和内存可能不同从而影响到应用的运行。也要测试功能性（是否运行完好？），操作和加载时间（密集操作是否会响应变慢？）和 UX（是否易用？）。除了上述的几点之外，开发者也会查看崩溃报告来查找修复点。

![](https://cdn-images-1.medium.com/max/800/0*Pf9qn283QTtoDySN.jpg)

以下是移动应用测试的几个方面：

**功能测试。**是任何应用最基本的测试，来确保应用按需求完成功能并且在交互中没有遗漏的功能。.

**性能测试。**这方面包括用户应用性能、服务器性能和网络性能。举个例子，检查特定状况下的性能指标和应用行为，如低电量、网络不好、内存不足等。

**内存测试。**测试每个应用是否会在浏览时优化内存占用。

**打断测试。**一个应用可能在工作时面临许多打断的情况，如来电或网络时断时续。这种测试可以测出应用在这些情况下的表现。常见的打断情形如下：

- 来电和去电，短信或彩信以及其他通知
- 低内存预警
- 插拔数据线
- 网络断续
- 媒体播放器开关
- 设备不同电量，如低电量警告等。

**安全测试。**检查应用被攻击的弱点，认证和授权策略，数据安全，会话管理以及其他安全标准。

**易用性测试。**这项测试应该在早期阶段就开始实施，来验证应用是否达成目标以及是否受到用户好评。正如 Apple 人机工程设计部门发言人 Joyce Lee 所说的那样：“易用性所回答的问题是，’用户是否能达成期望的目标？‘”

### 提交 / 发布

最后就是应用准备上线向用户发布的时候了。要想提交到 App Store，需要加入 iOS 开发计划。Apple 保留应用上线前复审和通过审核的权利。一般建议计划一周左右的时间来等待 Apple 审核通过。如果应用有商业需求，还需要额外填几个表格等待另外的审核，通常在一天之内完成。

在 Apple Store 发布应用有几个步骤，包括设置代码，建立配置和清单，然后通过 Xcode 来提交，等待验证。可能会修改并重新提交几次，所以一开始就了解过程和打磨细节可以节省时间。

![](https://cdn-images-1.medium.com/max/800/1*rtx4DdO8kvQF303W4Bv3aA.png)

正如你所见，一个移动应用走过的道路是相当复杂的，包括大量保证功能性、美观和性能质量的步骤。别忘了我们的下一篇文章将提供每一步更深入的研究以及对设计和开发大有裨益的工具和技巧。
