> * 原文地址：[The Secret of Nice Typeface Combinations](https://blog.prototypr.io/the-secret-of-successful-typeface-combinations-2e30c740255c#.280jx4ij6)
* 原文作者：[Simon Li](https://blog.prototypr.io/@simonlidesign?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Ruixi](https://github.com/Ruixi)
* 校对者：[L9m](https://github.com/L9m)、[wild-flame](https://github.com/wild-flame)

# 漂亮的字体组合的秘密 #

每当我和别人问起他们觉得字体排印中最难的是什么的时候，一个经常听到的回答就是字体的搭配。  我们总是想要使用多种字体来让我们的设计更加生动有趣，但我们中的大多数人其实并不清楚该选择哪些字体来搭配。不同字体该如何搭配，更像是一个秘诀。你一旦知晓，就可以创造出漂亮的字体组合。

### 字体匹配与层次 ###

除去让我们的设计在视觉上更有趣之外，使用多种字体更重要的目的是营造出字体的层次。层次意味着差异。若无差异，则无层次。因此，为了营造出有效的层次，（我们）需要明显的差异，或是强烈的对比。**如果你希望你的字体组合更加完美的话，强烈的对比就是秘诀。**

### 我们一般是怎样做的 ###

我们一般通过在下列三个维度营造对比，以试作标题与正文的区分。

- **字重（Fontweights）：** 标题字体更粗，或者更细。(想要了解更多如何巧妙驾驭字重的信息？移步我的文章 [*What You Can Do with Different Font Weights*](https://blog.prototypr.io/what-you-can-do-with-different-font-weights-1b464caaf0d4#.8hjlg82qu).)

- **字号：** 标题字体更大。

- **颜色：** 为标题字体选择一种与众不同的颜色。

改变字重、字号和文字颜色可以制造对比并营造层次感，但其实我们还可以通过在其他的方面再玩点花样来制造对比（如果我们有不只一种字体可供选择的话）。而且，这些把戏相当有趣。

### 更多的可能性 ###

不同的字体和不同的版式设置为创造对比提供了更多的可能性。字重、字号和字体颜色之外，我们再来看看字体比例、字型、大小写和字距。

#### 字体比例 ####

字体的宽度或比例各有不同。有些狭长而拥挤。有些很规则，在标准范围之内。还有一些粗重而扁阔。下表总结了一些 web 字体应用中的常用比例。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*4OEWTdhzcimqnGUlwOBOtg.png">

按照比例对 web 常用字体进行分类。

对于设计师来说，我们可以通过字体的宽度来将它们区分开。比方说，我们可以在标题中使用 **Open Sans Condensed Bold** 而在正文中使用 **Open Sans Regular** ； 在标题中使用 **Montserrat** ，在正文中使用 **Source Sans Pro** ； 在标题中使用长体的 **Oswald**，在正文中使用标准的 serif 或者 sans serif ……

![](https://cdn-images-1.medium.com/max/800/1*lllKDvUV84-vW8oUxbzafQ.png)

用字体的不同比例来搭配，形成对比。

注意，太长或是太扁的字体的可读性相较标准字形来的差一些，所以正文部分还是保守一点比较好。

#### 字型（Letterforms） ####

字型即字体的形状。我们对字型比较熟悉，毕竟总得靠它来区分不同的字体。衬线（serif）和无衬线（sans serif）是两种很常见的字型。其他还有包括特印（display）， 书法（handwriting）， 手写（script）等等。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*h7tQtEzQ1wjEbpYLrMJQTw.png">

Google 字体中的不同类型。

为了营造对比，我们挑选出字型不同的字体。还记得我们总会听到的超简单的原则吗？就是选择一种无衬线字体，在挑一种衬线字体来搭配它。这其实是利用字型之间的差异来营造对比。我们也可以选择一种手写（script）或者特印（display）字体作为标题的字体，然后再选择一种衬线（serif）或者是无衬线（sans serif）字体来作为正文字体。这有着无限的可能。 

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*bNGYs6TTds0lOX--pjyUtg.jpeg">

在网页模板 [Big Day](https://themeforest.net/item/big-day-a-modern-onepage-wedding-template/18163388?ref=DesignHarbor) 中， 我将书法字体 **Dancing Script** 与优雅的无衬线字体 **Fira Sans** 组合，因为它们在字母结构上的对比十分强烈。

两种字体的字型特征越明显，我们能营造出的对比就越是强烈。相应的，字体搭配的效果也会越好。同理，我们得尽量别要把字型相似的字体组合到一起。这就是为什么你在处理两种不同的衬线字体或者无衬线字体的时候要格外小心。

![](https://cdn-images-1.medium.com/max/800/1*C1NpMFvoM6N2Hal8whoohA.png)

将字型相似的两种字体组合到一起营造出的弱对比只会让读者感到困惑。这时候就不如只用一种字体来的好。

#### 大小写 (小写字母与大写字母) ####

大写字母由于字母等高而看上去像是一个个的方块。小写字母则由于字母上下出头不一而显得轮廓起起伏伏。利用这点不同，我们可以搞一些对比的例子。

![](https://cdn-images-1.medium.com/max/800/1*yGvV_SlWZkk79WUMLEx28w.png)

单词大写与小写所形成的轮廓不同。

如果文档标题不长，我们可以利用全大写来使它看上去和由小写字母组成的段落的区别更加明显。（要是你的标题很长而且长篇连句的话，你可能并不想让它们全部大写。毕竟可读性略差。）

#### 字距 ####

字距，即字母间的距离，也可以用来营造对比。它一般会搭配大写来用，因为大写字母之间的间距可以让词句更容易阅读，还会让它们看起来有一种沉稳而成熟的感觉。

![](https://cdn-images-1.medium.com/max/800/1*dMshyM6p-itEQVll-wr03g.png)

额外的字母间距可以让大写的单词更容易阅读，且看上去带有一种沉稳而成熟的感觉。

记着，尽量避免增加小写字母间的字距，因为这样会破坏词句的轮廓，从而使它们难以阅读。 还有，正文不要增加多余的字距，以便与带有更大字距的标题文字形成对比。

### 增加对比 ###

到此为止，我们总共谈及了 7 种可以营造对比的方法。总结一下：

**字重／字号／文字颜色／字体比例／字型／字母大小写／字距**

记着，对比越强烈，你的字体组合效果就越棒。为了得到更加强烈的对比，我们可以将上述几点叠加使用。举个例子，在我的博客主题 [Jordan](https://themeforest.net/item/jordan-modern-onepage-resume-portfolio-theme/17542551?ref=DesignHarbor) 中，我将 **Oswald** 和 **Merriweather** 进行了组合。 我将 Oswald 用作标题字体，将 Merriweather 用作正文字体。 Oswald 是一种长而瘦的字体。我同时使用了字母全大写和增加字距。这样一来，我在字号、文字颜色、字体比例、字型、字母大小写和字距上都作出了一些区别。强烈的对比，美妙的组合。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/1000/1*V7KUJtW8Hy20SZ6KFt4lCw.png">

我在博客主题 [Jordan](https://themeforest.net/item/jordan-modern-onepage-resume-portfolio-theme/17542551?ref=DesignHarbor) 中使用的 **Oswald** 和 **Merriweather** 的组合。在字号、文字颜色、字体比例、字型、字母大小写和字距上都有所不同，因而对比效果十分强烈。

根据这个准则，我们可以很容易的弄出一些很棒的或者是不怎么样的字体组合。在你浏览下面每一组字体组合的时候，利用我们刚刚谈及的 7 个维度来思考一下为什么它们很棒或是有点糟糕。

#### 成功的组合 ####

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*K8elFg6XMjotKe4AgNuoTg.png">

#### 不那么成功的组合 ####

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*ZXfqTYMbL8opowuQjBHTAg.png">

### 结语 ###

字体组合是字体排印中的一个重要组成部分。我希望通过阅读本文，可以让你了解到对比即是成功的字体组合的评价标准，以及如何更为有效的将字体进行组合。祝在字体组合这上头玩得开心！

This article was originally published at [http://www.simon-li.com/design-and-code/the-secret-of-nice-typeface-combinations/](http://www.simon-li.com/design-and-code/the-secret-of-successful-typeface-combinations/).

**喜欢本文？如果是，请点击下方的 ♡ 并分享给你的好友。这对我来说意义重大。你也可以关注我的** [**Twitter**](https://twitter.com/simonlidesign)  **或者 Medium。**

### 更多字体相关 ###

想要了解更多字体相关？请查看我的个人主页 [other typography articles](https://medium.com/@simonlidesign)。

### 小调查 ###

**对你来说字体排印中最难的是什么？** 填写这份 [简短的调查](https://docs.google.com/forms/d/e/1FAIpQLSfR4XcAyyg_9qeQBxNUMoXkf1Bm5eXu6p2XgGCG268NE9AoZw/viewform)  并告知我们。这会帮我为你创作最棒的字体排印相关内容。
