
> * 原文地址：[The future of deep learning](https://blog.keras.io/the-future-of-deep-learning.html)
> * 原文作者：[Francois Chollet](https://twitter.com/fchollet)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/the-future-of-deep-learning.md](https://github.com/xitu/gold-miner/blob/master/TODO/the-future-of-deep-learning.md)
> * 译者：[Changkun Ou](https://github.com/changkun/)
> * 校对者：[MoutainOne](https://github.com/MoutainOne), [sunshine940326](https://github.com/sunshine940326)

# 深度学习的未来

这篇文章改编自我的书 [Deep Learning with Python](https://www.manning.com/books/deep-learning-with-python?a_aid=keras&a_bid=76564dff)（Manning 出版社）第 9 章第 3 节（译者注：「结论」一章最后一小节）。
它是讨论当前深度学习的局限性及其未来系列文章的第二篇。
你可以在这里阅读第一篇：[深度学习的局限性](https://github.com/xitu/gold-miner/blob/master/TODO/the-limitations-of-deep-learning.md)。

---

鉴于我们已经了解深度神经网的工作原理、局限性以及目前的研究现状，那我们能够预测它未来的趋势吗？ 这里给出一些纯粹的个人想法。 注意，我并没有预知未来的能力，所以我预测的很多东西可能并不会成为现实。这是一个完完全全的思考性文章。我与你们分享这些不是因为我希望它们在未来被证明完全正确，而是因为它们在现在很有意思并且可行。

从高处审视，我觉得比较有前途的主要方向有：

- 构建于顶层丰富的原始数据之上而不是当前的可微层次的模型，将更加接近通用目的的计算机程序 —— 当前模型的根本弱点是我们将如何得到（数据的）**推理 (reasoning)和抽象(abstraction)**。
- 允许模型摆脱（每一步之间的）可微变换 (differentiable transformation) 限制的新学习模式使得实现上述模型成为可能（译者注：神经网络的每一步传播本质上是一个可微的线性变换，借助神经元的激活函数产生了非线性）。
- 不需要人工调参的模型 —— 你的工作不应该是无休止地测试不同的参数。
- 更好地、系统地复用学过的特征和架构；基于可复用和模块化子程序的元学习（meta-learning）系统（译者注：元学习的动机是自动理解并应用什么类型算法适合什么样类型的问题）。

此外，请注意，这些考虑并不是特定于已经作为深度学习基础设施的有监督学习，而是适用于任何形式的机器学习，包括无监督、自监督及强化学习。你训练数据标签的来源或你的训练循环怎么样其实并不重要，机器学习的这些不同的分支只是同一结构的不同面而已。

就让我们来一探究竟吧。

## 模型即程序

正如我们在上一篇文章中指出的那样，我们可以预计的是，机器学习领域开发的一个必要转型就是：从使用模型本身进行纯模式识别并仅能实现局部泛化当中脱离开来，转为能够进行抽象及推理的模型，从而实现极端泛化（extreme generalization）。目前的 AI 程序所具有的基本形式的推理能力均为程序员们手动写死的代码，例如：依赖搜索算法、图操作、形式逻辑的软件；又比如 DeepMind 的 AlphaGo，大多数所谓的「智能」其实都是被专业程序员设计并写死实现的（例如 Monte-Carlo 树搜索）；从数据中学习只发生在特殊的一些子模块（价值网络及策略网络）中。但是，这样的 AI 系统在未来可能会在没有人为参与的情况下被充分学习。

什么可以使得这种情况成为可能呢？考虑一个众所周知的网络类型：RNN。很重要的一点就是，RNN 的局限性远小于前馈神经网络。这是因为 RNN 不仅仅只是一个简单几何变换，而是在 for 循环里不断重复的几何变换。时间 for 循环本身由程序员写死的，这是网络本身的假设。当然，RNN 在它们能够表示的方面依然十分有限，主要原因是它们执行的每个步骤都是一个可微的几何变换，并且它们每一步传递信息的方式是通过连续几何空间中的点（状态向量）。现在，想象神经网络将以类似编程原语（例如 for 循环，但不仅仅是一个单一的写死的具有写死的几何记忆的 for 循环）的方式「增强」，具有一组大量的编程原语，使得模型能够自由的操纵并且扩充它的处理函数，例如 if 条件分支、while 循环语句、变量创建、长期记忆的磁盘存储、排序运算符、诸如列表、图、哈希表等的高级数据结构等等。这样一个网络可以表示的程序的空间将远大于当前深度学习模型所能表达的范围，其中一些程序可以实现更高的泛化能力。

总而言之，我们将远离写死的算法智能（手工软件）和学会的几何智能（深度学习），取而代之的是去提供混合推理和抽象能力的正式算法模块和非正式直觉和模式识别功能的几何模块，使得很少甚至没有人参与整个系统的学习。

有一个相关的 AI 子领域我认为可能会出现巨大突破，那就是程序合成（Program Synthesis），尤其是神经程序合成（Neural Program Synthesis）。程序合成在于通过使用搜索算法（可能的遗传搜索、遗传编程）自动生成简单的程序，从而探索可能程序的一个更大的空间。当找到符合要求的程序后，停止搜索，并作为一组输入输入对来提供。正如你所看到的，这让我们高度联想到机器学习：给定训练数据作为输入输出对，找到一个程序使其匹配输入输出对，并能够泛化新的输入。不同之处在于，我们不用去学习写死程序（一个神经网路）的参数，而是通过离散的搜索过程来生成源代码。

我相当期待这个子领域能在未来的几年里掀起一股新浪潮。特别地，我期望深度学习和程序合成之间能够再出现一个交叉子领域，在这里我们不再用通用语言来写程序，而是生成通过丰富的算法原语集增强的神经网络（几何数据处理流），比如 for 循环等等。这会比直接生成源代码要容易且有用得多，而且他会大大的扩展机器学习可以解决问题的范围 —— 我们可以自动生成给定适当训练数据的程序空间。一个符号 AI 与几何 AI 的混合。当代的 RNN 可以看做是这种混合算法与几何模型的鼻祖。

![A learned program relying on both geometric (pattern recognition, intuition) and algorithmic (reasoning, search, memory) primitives.](https://blog.keras.io/img/future-of-dl/metalearning1.png)

**图：一个依赖几何原语（模式识别、直觉）和算法原语（推理、搜索、记忆）的学习程序。**

## 超越反向传播与可微层

如果机器学习模型变得更像程序，那么它们将几乎不再是可微的 —— 当然，这些程序依然会将连续的几何图层作为可微的子程序，但是整个模型却不会这样。因此，使用反向传播来调整固定、写死的网络权重不能成为未来训练模型的首选方法 —— 至少不能是唯一的方法。我们需要找出有效地训练不可微系统的方法。目前的方法包括遗传算法、「进化策略」、某些强化学习方法和 ADMM（乘子交替方向法）。自然地，梯度下降不会被淘汰 —— 因为梯度信息总是对优化可微参数的函数有用。但是，我们的模型肯定会变得越来越有野心，而不仅仅只满足于可微参数的函数。因此它们的自动开发（「机器学习」中的「学习」）将需要的不仅仅只普通的反向传播。

此外，反向传播是端到端的，这对于学习良好的链式变换（Chained Transformation）是一件好事，但它却计算效率低下，因为它不能充分利用深度神经网络的模块化性质。 为了使事情更有效率，有一个通用的方案：引入模块化和层次结构。 因此，我们可以通过引入具有一些同步机制的解耦训练模块，以分级方式组织，从而使反向传播本身更有效率。 DeepMind 最近在「合成梯度」(Synthetic Gradient) 方面的工作（译者注：指这篇[论文](https://arxiv.org/abs/1703.00522)），反映了这一策略。 我希望在不久的将来会有更多的这方面的工作。

可以想象这样一个未来，那时人们可以训练全局不可微（但具有可微的部分）的模型，他们使用一个高效的搜索过程，而非利用梯度方法。但与此同时，可微的部分则通过使用的某些利用梯度优势从而更高效版本的反向传播而训练得更快。

## 自动化机器学习

在未来，模型架构也是学习的对象，而不再由工程师手工搭建。学习架构将自动与使用更丰富的原语，以及类似程序的机器学习模型配合使用。

目前，深入学习工程师的大部分工作就是用 Python 脚本清洗数据，然后对深度神经网络的架构和超参数进行长时间的调优，最终获得一个有用的模型 —— 如果工程师有野心的话，甚至可以说是当下最好的模型。无需多说，这并不是一个最理想的设置，但 AI 其实也可以帮忙。不幸的是，数据清洗的部分很难自动化，因为它通常需要对应的领域知识（Domain Knowledge），以及对工程师想要实现的工作有明确的高层理解。 然而，超参数调优其实只是一个简单的搜索过程，我们已经知道工程师在这种情况下需要实现什么：它由被调整网络的损失函数所定义。 设置基本的「AutoML」系统已经是一个常见的做法了，它负责大部分模型的参数调优。我甚至在几年前就这么干了，还赢得过 Kaggle 的比赛。

在最基本的级别上，这样的系统将简单地调整（网络）栈中的层数、它们的顺序以及每一层中的单元或过滤器的数量。 这通常可以由诸如 Hyperopt 的库来完成，我们在第 7 章中讨论过（注：[Deep Learning with Python](https://www.manning.com/books/deep-learning-with-python?a_aid=keras&a_bid=76564dff)）。但是我们也可以更加有野心，尝试从头开始学习一个适当的网络架构，尽可能少的约束。这可以通过加强学习来实现，例如遗传算法。

另一个重要的 AutoML 方向是与模型权重一起学习模型架构。因为每次尝试一个稍微不同的架构都需要重新训练模型是异常低效的，所以一个真正强大的 AutoML 系统将通过对训练数据的反馈来调整模型的特征，同时管理网络架构，进而消除所有计算冗余。这样的方法已经开始出现，因为我正在写这些东西。

当这种情况开始发生时，机器学习工程师的工作并不会消失 —— 相反，工程师将在价值创造链上站的更高。他们将开始更多地努力制定真正反映业务目标的复杂损失函数，并更加深入了解他们的模型如何影响其部署的数字生态系统（例如，消耗模型预测内容并生成模型训练数据的用户）—— 考虑那些目前只有大公司才能考虑的问题。

## 终身学习与模块化子程序复用

如果模型变得更加复杂，并且建立在更丰富的算法原语之上，那么这种增加的复杂性将需要更高的任务之间的复用，而不是每当我们有一个新的任务或一个新的数据集从头开始训练一个新的模型。实际上，很多数据集并没有包含足够的信息来从头开发新的复杂模型，而且利用来自先前遇到的数据集的信息也是有必要的。 这就像你每次打开新书时都不会从头开始学习英语 —— 这是不可能的。此外，由于当前任务与以前遇到的任务之间的重叠很大，对每个新任务重头开始训练模型的效率是非常低的。

此外，近年来反复出现的一个值得注意的现象是，同一个模型同时进行多个松散连接任务的同时会产生一个更好的模型，而这个模型对每个任务的结果都更好。例如，训练相同的神经网络机器翻译模型来涵盖「英语到德语」的翻译和「法语到意大利语」的翻译将获得对每个语言间翻译效果都更好的模型。与图像分割模型联合训练图像分类模型，并共享相同的卷积基，能得到对于两个任务更好的模型，等等。这是相当直观的：在这些看似断开连接的任务之间总是存在一些信息重叠。因此，联合模型可以获得比仅针对该特定任务训练的模型更多的关于每个独立任务的信息。

你已经在第 5 章中看到，我们目前是沿着跨任务复用模型的方式，利用预训练的权重来执行常见函数的模型，如视觉特征提取。在未来，我会期望出现这种更一般的版本：我们不仅将利用以前学习的特征（子模型权重），还可以利用模型架构和训练过程。随着模型越来越像程序，我们将开始复用程序的子程序，就像编程语言中的函数和类那样。

想想今天的软件开发过程：一旦工程师解决了一个特定的问题（例如 Python 中的 HTTP 查询），他们将把它打包成一个抽象的和可复用的库。未来面临类似问题的工程师可以简单地搜索现有的库，下载并在自己的项目中使用它们。类似的方式，将来的元学习系统将能够通过筛选全局库中高度可复用块来组装新程序。当系统发现自己为几个不同的任务开发类似的程序子程序时，如果可以产生一个「抽象的」子程序的可复用版本，就会将其存储在全局库中。这样的过程将实现抽象的能力，这是实现「极端泛化」的必要组件：在不同任务和领域中被发现的有用的子程序可以说是「抽象化」问题解决的一些方面。 「抽象」的定义与软件工程中抽象的概念相似，这些子程序可以是几何（具有预先训练表示的深度学习模块）或算法（更靠近当代软件工程师操纵的库）。

![A meta-learner capable of quickly developing task-specific models using reusable primitives (both algorithmic and geometric), thus achieving &quot;extreme generalization&quot;.](https://blog.keras.io/img/future-of-dl/metalearning2.png)

**图: 元学习者能够使用可复用的（算法与几何）原语快速开发特定任务的模型，从而实现「极端泛化」。**

## 长期愿景

简单来说，以下是我对机器学习的一些长期愿景：

- 模型将更像是程序，并且具有远远超出我们目前使用的输入数据的连续几何变换的能力。这些程序可以说是更接近于人类对周围环境和自身的抽象思维模式，而且由于其丰富的算法性质，它们将具有更强的泛化能力。
  环境及其自身，由于其丰富的算法性质，它们能够获得更强的泛化能力。
- 特别地，模型将混合提供正式推理、搜索和抽象能力的算法模块，和提供非正式的直觉和模式识别功能的几何模块。AlphaGo（一个需要大量手动软件工程和人造设计决策的系统）提供了一个早期的范例，说明了符号与几何 AI 之间进行混合可能的样子。
- 它们将不再由人类工程师手工打造，自动成长并使用存储在可复用子程序的全局库中的模块化部件（通过在数千个前有任务和数据集上学习过的高性能模型而演变出现的库）。由于常见的问题解决模式是通过元学习系统来识别的，它们将变成可复用的子程序并被添加到全局库中，像极了当代软件工程中的函数和类，进而实现了抽象的能力。
- 这个全局库和相关的模式增长系统将能够实现某种形式的人类「极端泛化」：给定一个新的任务、一个新的情况，该系统将能够使用非常少的数据组装适合于任务的新的有效模型。这归功于：第一，可以像原语一样使用，丰富且泛化良好的程序（包）；第二，丰富的类似任务的经验。同样地，人类也可以用很少的游戏时间来学习复杂的新游戏，因为他们有许多以前的游戏的经验，并且从以前的经验得出的模型是抽象的和类似程序的，而不是刺激和行动之间的基本映射。
- 就此来看，这种永恒学习的模型成长系统可以被解释为人造通用智能（AGI, Artificial General Intelligence）。但请不要指望任何奇点主义的（Singularitarian）机器人灾难发生：那是纯粹的幻想，是来自一系列长期对智能和技术的深刻误解。然而，这个批评不在本文讨论的范围之内（译者注：奇点主义是指采取有益于人类、避免导致超越人类智慧的人造智慧出现的行动）。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
