> * 原文地址：[The Details That Matter](https://uxplanet.org/the-details-that-matter-8b962ca58b49#.ypigeruoq)
> * 原文作者：[Nick Babich](https://uxplanet.org/@101?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：[ivyxuan](https://github.com/iloveivyxuan)
> * 校对者：[ylq167](http://www.11167.xyz)、[gaozp](https://github.com/gaozp)

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*9QIpe-Mce0ltsgQ0f0lYWQ.png">

# 细节是产品设计的重中之重 #


一个产品的成功是由各种因素共同造就的，而其中最重要的因素，就是整体的用户体验。在设计一款新的应用或是网站的时候，坚持最佳的实践规范是一个可靠的方法，但是在创造宏伟蓝图的时候，人们很容易就会省略掉那些能让人有更好的体验但却并非必要的设计元素。然而，设计的优劣往往在于我们能设计出多么体贴的细节。

在这篇文章中，我将会重点关注**可视化反馈**、**小的文字信息**还有**留白**这几个方面，你将会发现为什么这些不起眼的细节和那些显眼的设计元素相比同样重要，而这些细节又是怎样决定你产品成败的。

### 可视化反馈 ###

可视化反馈在较大的设计方案里很容易就会被忽视掉，但它实际上贯穿整体的用户体验流程。可以说，如果没有反馈就没有所谓的交互，你能想象和一个人聊天，可他一点反应也不给你吗 —— 你根本就聊不下去。而对于你的应用也是同样的道理。

> **缺乏可视化的反馈会让用户感到困惑。**

你必须要确保对于用户的每个动作都有相应的反馈，因为这会让用户感觉应用运行一切正常。可视化反馈

- 首先表明这个应用接受到了用户的操作。
- 然后它通过一种可视化而且易于理解的方式告诉用户这次交互的结果是什么，通过给用户一个信号，来告诉用户自己对于这个任务的执行是成功还是失败。

#### 让按钮或是其他开关看起来是可触摸的 ####

在现实生活中，按钮、开关还有其他东西都会对我们的动作有所回应，人们觉得世界就是这样运转的。而同样，人们也会期待应用里的元素能有类似的回应。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*CJmWiRBN2cwd53TfcyTd8g.gif">

图片来源：[Ramotion](https://dribbble.com/shots/1749645-Contact-Sync)

#### 操作的结果 ####

当你需要告诉用户他的操作结果是什么的时候，可视化反馈就很有用了，你可以利用现有的元素去传递反馈信息。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*6YGP-5TxLJSuDwBYsKzREg.gif">

图片来源：[Colin Garven](https://dribbble.com/ColinGarven)

#### **系统需要告诉用户他当前的状态是什么** ####

在系统中，用户任何时候都会想知道他此刻的状态是什么，而这不应该让用户自己去猜 —— 所以系统应该通过恰当的可视化反馈告诉用户此刻正在发生什么。对于一些常见而且次要的操作，简单的反馈就可以了，而对于不寻常而且重要的操作，反馈就需要更明显一点。

- [动态提醒](https://uxplanet.org/3-key-uses-for-animation-in-mobile-ui-design-4d7c482dd84b#.x07lyyazb)可以让用户立刻明白此时的状态。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*wU-ATdbQDPg6MTYZtNfTxw.gif">

图片来源：[Eddy Gann](https://dribbble.com/SMSeddy)

- [加载动画](https://uxplanet.org/progress-indicators-in-mobile-ux-design-a141e22f3ea0#.etoavwmbw)是对于应用进程的实时提醒，可以让用户立刻明白现在加载到哪里了。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*cd858x6Yb2k7lountEkefA.gif">

应用加载信息的时候，进度条可以避免让用户感到困惑。图片来源：[Mark](https://dribbble.com/milkycookie)

### 少量的文字信息 ###

少量的文字信息是一些用来是指导用户行为的一点点文字。举一些例子就是，错误信息、按钮对应的标签、提示信息。乍看之下，这么少的文字和整个应用设计比起来一点也不重要，但出人意料的是，它们对转化率有着极为重要的影响。

> 在应用里写出好的文字信息，和让应用正常运行、用户界面易于使用一样重要。

#### 让应用看起来像是一个人 ####

有一个快速的方法能让你的 UI 变得温暖而不呆板，就是用人说话的口吻去描述内容。如果你的产品听起来好像是一个人，用户就会更加的信任你。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*r8YCZlga38mG_gX1JyLZWQ.png">

Yelp 表现得好像他们是真人在负责这件事情。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*BOI3X5Qe6tflo6yCDmNmoA.png">

Airbnb 的提示听起来像人说的话而且语气还很随和。

#### 报错的方式要友好而且有效 ####

表达错误信息的方式会严重影响产品的用户体验。通常来说，省略错误信息或是没有正确描述错误信息都会让用户受挫。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*1EESYQmM9pt_SScMmgQqEg.png">

**像“出错啦”这种警告对所有的用户都会造成困扰，而且还会惹恼专家级用户。** 但是，一个精心设计过的错误信息，会顿时化失望为欣喜。所以，把报错变得人性化、不用技术性的语言并且适合你的用户群体。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*gX0GBH3BM_d_yjhk8Yvlaw.png">

错误状态一定要具体、友好而且有用，要告诉用户下一步怎么做。

#### 减少用户的担忧 ####

这些少量的文字信息是很情景化的，这也是为什么它很重要的一个原因。它可以解答用户具体情况下的问题，并针对他们所担忧的事情进行直接地交流。举例来说，当用户选择订阅或是提供了具体信息的时候，一些文字信息对于消除用户担忧会起到相当关键的作用。对于优秀的营销人员来说，“不会有群发消息或是自动关注”是理所当然的事情，但用户自己会存疑。因此，当用户添加了他们的邮箱地址或者绑定了 Twitter 账号的时候，一定要明确表态“我们和你一样讨厌垃圾消息”。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*Cl0P6ebhZTDkCGAHGjLnhA.png">

这只是一小段紧凑的文字，却涵盖了用户所有潜在的担忧。

### 留白 ###

留白（或者说是负空间）是设计师没有摆放设计元素的地方。而设计元素间的留白是指处在图片间距、内边距、外边距、行间距和字间距的空白。虽然很多人觉得这些空白浪费了宝贵的界面位置，但其实，留白是用户界面设计的一个重要元素。

#### 让用户界面更容易理解 ####

**杂乱的堆砌是很糟糕的一件事情。** 在界面上杂乱堆砌元素会给用户带来过多的信息：每一个被添加的按钮、图片和文字都会让界面显得更加复杂。如果你不想你的设计有任何刻意的留白的话，下面这个例子就能很明白的告诉你，有太多东西一起吸引你的注意力是多么可怕的事情。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*nzZwU1-KnaFrSpzMl04dWg.png">

杂乱堆砌的 UI 尤其是没有视觉层次的 UI 会让用户没有一点想要审视的欲望。

留白之所以很重要，是因为用户的注意力还有记忆是很有限的。我们的短期记忆只可以在短时间内（通常来说是 10 到 15 秒钟、或者是 1 分钟以内）记住一点有效的既有信息（通常来说[是 7 个事物或者比这个更少](http://www.human-memory.net/types_short.html)）。

> 用户的注意力是很珍贵的资源，所以必须合理的分配。

如果因为你界面上的胡乱堆砌使得用户接收过多的信息，那么减少一些杂物就能改善用户的理解。大方地使用留白可以让凌乱的界面变得简单而有吸引力，留白削减了用户乍看之下接收到的元素数量，这使得浏览信息变得更加容易。留白的使用技巧在于只给用户提供能让他消化的数量的内容（[一定数量的内容](https://uxplanet.org/best-practices-for-cards-fa45e3ad94dd#.by8pzk56q)），然后去掉不必要的细节。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*cY8Jewt4J1xUKyt2rla9nQ.png">

Medium 是一个典型的例子，它善于使用留白来改善用户对内容和 UI 的理解。

#### 让元素更具有吸引力 ####

留白在设计中是通过在元素周围留出空白，以让元素更加突出或是和其他元素以进行区分。它可以告诉用户什么是最重要而且是需要格外注意的。

> 元素周围的留白越多，元素就会越引人注目。

谷歌搜索的首页就是一个使用留白的典型例子，它通过在正中央摆放其最重要的交互元素（搜索框），并且在周围留出足够的空白以凸显其重要性的布局，直接实现了用户目标。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*UbEexVXM8GYMNuwYNqd2PQ.png">

去掉其他的元素可以更加凸显留下来的元素。

#### 明确关系 ####

[接近法则](https://www.interaction-design.org/literature/article/laws-of-proximity-uniform-connectedness-and-continuation-gestalt-principles-2)描述了人的眼睛是如何划分视觉元素的，它阐述说距离更近的物体看起来更相似。我们可以利用留白，在不同的元素间产生视觉联系。你看下面这幅图片，几乎所有人都会说看到了两组点，而不是16个点。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*U_YCbTW_AEHSLMnLSqIlqQ.png">

将信息拆分成合适的组别可以让信息更好的被识别和阅读。右边的表单将 15 栏拆分成 3 组，这样填写表单也变得相对容易了。虽然内容的数量仍然相同，但是给用户的感觉却完全不同。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*xv6xhcRljayCKY15LDekfQ.png">

图片来源：NNGroup

### 总结 ###

**用心设计**，应用界面上的每一个小的细节都值得细心揣摩，因为用户体验就是由这些小的细节相互协调作用而成的：

> “细节不只是细节，细节成就了设计。” —— Charles Eames

谢谢！

**关注 UX Planet：** [*Twitter*](https://twitter.com/101babich) | [*Facebook*](https://www.facebook.com/uxplanet/)
---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
  
