>* 原文链接 : [The Basics of Designing Mobile Apps](http://www.designyourway.net/blog/inspiration/the-basics-of-designing-mobile-apps/)
* 原文作者 : [Bogdan Sandu]
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [shenxn](https://github.com/shenxn)
* 校对者: [markzhai](https://github.com/markzhai)，[ZhaofengWu](https://github.com/ZhaofengWu)

# 设计一款移动应用前你应该知道这些事情

我们有一些好消息也有一些坏消息，也可能在你眼中这些都是好消息。好消息是，你终于拥有了所有用于构建你自己应用的工具！

构建应用的技术和工具都在变得更容易获得和使用。坏消息是，你不是唯一知道这个事实的人。全世界的人都在着手于构建他们的第一个应用。但是不用担心，还有更多的好消息：在这篇文章中，你可以了解到构建一个完美应用的所有知识。

当今的移动应用产业比以往的任何时候都更发达。所有的业务，从体育用品经销商到食品杂货店都在试图设计一个移动应用。试想哪个消费者会不希望将他们最喜欢的球队或是他们的购物清单放在口袋里呢？

![线框图](https://dn-shenxn.qbox.me/1207907.jpg)  
[图片来源](https://dribbble.com/shots/1207907-Wireframes)

在设计移动应用的时候，你需要对产品的外观、体验、以及应用和用户之间的关系负责。只要你知道这一点，可能性将会是无穷的。然而，有这么多成功的机会，也会有很大犯错的可能。

我们来了解一些设计应用时非常重要的事，从如何做研究到如何与开发团队合作。

### 第一，做研究

在我们开始讨论研究部分前，先回顾一下你之前所做的。恭喜你！你将要踏上一个非常有趣、有一点困难并且非常值得的旅程。

有句格言说：写你所知道的。这对于应用设计来说同样适用。如果你想要做一个应用的设计师，你应该先成为一个应用的用户。作为一个用户，你会开始了解你喜欢应用的哪些部分，又不喜欢哪些部分。比如哪些字体看起来最棒，或者哪些布局最易于使用。

你应该知道，移动应用与网站或者在线应用有很大的不同。你现在欧美很好是一个活跃的应用用户，也是一个重度依赖的智能手机拥有者。你知道移动应用是有重心的、具有特殊性的，并且是独立的、封闭的。在你设计你自己的应用时也要牢记这些。

另一件需要记住的是，移动应用是一个全新的产业！同时，智能手机，作为移动应用的平台，也是全新的。保持在世界智能手机创新的顶峰能让你在设计领域不断向前，也让你的应用成为最新、最闪耀的应用。

此外，阅读官方的设计指南不是一个坏主意，像是 [iOS 用户界面指南 - iOS Human Interface Guidelines](https://developer.apple.com/library/iOS/documentation/userexperience/conceptual/mobilehig/) 或是 [Android 用户界面指南 - Android User Interface Guidelines](https://developer.android.com/design/index.html)。

### 第二，做更多的研究

你为什么要做这个？你打算怎么做？这是两个令人胆怯，但显然是非常重要的问题。在你开始你的应用设计之前，你必须要问自己这两个问题。

![第二，做更多的研究](https://dn-shenxn.qbox.me/a490147fjw1f1zzi4m85sj20jg0elwiw.jpg) 
[图片来源](https://dribbble.com/shots/992731-Wireframing-Close)

你为什么要做这个？你想通过设计一个应用做到什么？这是一个市场化还是品牌化行动？它是为了获得额外的收入渠道吗？这只是你在线产品的一个移动端版本吗？你有两个目标。

第一是设计一个应用，第二是使应用达成你的目的，不论是为了钱、交流或是便利性。如果你能在设计进程中牢记第二个目标，最终的产品就会更加有效。

你打算怎么做一个应用？列出你构建应用所必须完成的任务是非常有帮助的。做一个计划日程来检查列表上所有的项目是创建一个应用最有效率的方式。

此外，思考一下谁将要使用你的应用。如果你同时从设计者和用户的角度去思考你的应用，你将能创造一个两边都感到开心的应用。

### 研究你的竞争对手

![研究你的竞争对手](https://dn-shenxn.qbox.me/922825.jpg)  
[图片来源](https://dribbble.com/shots/922825-close-side-menu)

不论你是在一个乐队比赛或是烹饪比赛中，了解你的对手总是明智的。对移动应用来说，有太多不同的网站、论坛和帖子可以让用户分享他们对于应用的观点。

花上几个小时详细阅读这些网站和评论，你就可以对市场上的应用有一个比较全面的认识，同时也可以了解到用户想要什么。在开始设计应用之前知道你用户的偏好可以在之后为你节省很多修改的时间。

用户至上自然是没错的，但是也别总把互联网上的各种言论都当成是对的。下载一些应用，考虑哪些观点是正确的，而哪些地方你不认同。

### 获得灵感

![获得灵感](https://dn-shenxn.qbox.me/1367175.jpg)  
[图片来源](https://dribbble.com/shots/1367175-Sleep-Tracker-UI-Part-2-UX-iPhone-interface-App-iOS-7)

就像之前提到的，你正在进入一个巨大的、瞬息万变的、并且年轻的领域。每天都有成百上千的应用被创造出来，每一天都会有新的东西。流行语“有一个实现了该功能的应用”不是凭空出现的。市面上应用的数量以及它们实现的功能都是令人震惊的。你希望你的应用是独特但易于使用的。

视觉灵感是非常重要的。这甚至是一种可以让你在整个产业留下自己印记的方式。想想那些手机上已经存在的手势。在手机上做事的方式是不断发展的。想想那些还没有出现的手势。你应该时刻想着：“完成这项任务最自然的方式是什么？”双击？滑动？还是输入文字？

记住：寻找灵感但不要剽窃。你可以通过观察那些已经存在的应用学到很多，并且极大地改善你自己的应用。

### 是时候设计应用了

![是时候设计应用了](https://dn-shenxn.qbox.me/934508.jpg)  
[图片来源](https://dribbble.com/shots/934508-Secret-Project)

终于，是时候应用所有的研究成果了！想想你使用应用时所有的体验，以及你读到的所有用户的评论、顾虑和意见。那么，你希望你的应用长什么样？带给用户怎样的感觉？怎样来使用？不论是画草图还是 Photoshop，开始设计你的应用吧。

这一部分可能会很难而且很耗费时间。记住：现在花费的时间就是将来节省的时间。

当你的应用有一个基本草图的时候，不论是在纸上的还是在你的硬盘里，你就可以开始构建应用的结构了。有很多的原型设计工具可以使用，只需要确保你使用的应用与你设计的界面兼容就可以了。

确保应用的基础组件具备功能性显然是非常重要的。创建一个强健的核心可以保证你的应用易于使用，而不是使用户感到困扰的。多个设计稿或版本是必要的，所以如果从基础开始设计你的应用，所有这些版本版本都会是可用的，甚至是完美的。

### 关于细节

如果魔鬼存在于细节中，那天使也同样在其中。一个好看的重音符号或是一个有风格的字体都会是你的应用在巨大的市场中获得成功。那些细节可以成就一款应用，也可能毁掉一款应用。

**导航**

![导航](https://dn-shenxn.qbox.me/889785.jpg)  
[图片来源](https://dribbble.com/shots/889785-Profile-Sreen)

在你的应用中浏览应该是非常容易的。如果用户不能找到他们想要的，他们就不能获得完整的应用体验。符合用户的使用习惯应该比好看更重要，这样才能创造流畅的用户体验。将谷歌、必应、或是其他流行搜索引擎作为参考不失为一个好方法。

有经验的应用设计师都赞同，导航不应该是一个有过多创新的元素。可以在传统的搜索系统上增加一些个人的特色，但不要创造一个用户需要学习的系统。

**排版**

![排版](https://dn-shenxn.qbox.me/1139651.jpg)  
[图片来源](https://dribbble.com/shots/1139651-Tiny-green-app)

这是设计应用最重要的一个方面。如果你的文本难以阅读或者你的字体很难看，你的应用将会变得无法使用。

行间距以及字间距都是非常重要的，特别是对于移动应用，因为它们只有有限的展示空间。你要确保在不影响文字阅读的前提下最大化利用你的空间。

有经验的应用设计师都赞同，你可以让你的用户自定义文字样式，但是你依然应该使用好看的字体。如果用户可以选择字体将会给他们留下更深的印象，但是不论你的设计中是否包括字体设置，你的字体都应该是易于阅读的，有风格的，并且合适的。

**配色方案**

![配色方案](https://dn-shenxn.qbox.me/1382687.jpg)  
[图片来源](https://dribbble.com/shots/1382687-FM-Radio-UI-iOS-7-App)

如果你像我一样，这将会是有趣的一部分！选择完美的颜色来补足你的设计是有趣且重要的。过多的颜色可能会分散用户的注意力，或使用户感到困惑。

尝试不同的配色方案是最好的测试方法。你肯定希望你的颜色没有冲突，并且你的文字在背景上清晰可见。有经验的应用设计师会告诉你，在颜色上，少即是多。

### 测试是至关重要的

现在你的想法是一流的，你的设计是漂亮的，颜色是完美协调的，并且文字也拥有完美的字体，那接下来你要做什么呢？你需要确认真实的用户在使用你的应用时是怎样的体验。在应用将会被运行的设备上测试无疑是非常重要的，这确保你的设计可以给用户最大限度的享受和生产力。

细节在设计中非常关键，在测试中也是。你能够单手够到所有的按键吗？可以的话，那你在打字的时候另一只手会遮住重要信息吗？

![测试是至关重要的](https://dn-shenxn.qbox.me/thumb_zone.jpg)  
[图片来源](http://uxmag.com/articles/excerpt-from-the-new-book-the-mobile-frontier)

此外同样重要的是，你的应用在比你的测试机更老更差的设备上是否依然运行良好。确保所有的用户都能完整体验你的应用是成功的一个重要因素。

### 结语

现在你已经知道设计移动应用所有的基本内容了，去制作你自己的杰作吧！移动应用平台是一个极棒的平台，那上面有大量的选择和机会。

最后我要提的是，与应用的开发者紧密合作总是一个好主意。你希望确保你应用的方方面面都跟你预想的一样。花几个月的时间设计一款应用，开发者却按照他自己的思路应付你的项目将会让人沮丧。所以即使进程的最终部分是沉闷冗长的，这将是创造出完美的最终应用的最佳方式。
