> * 原文链接: [The Art of Minimalism in Mobile App UI Design](http://babich.biz/the-art-of-minimalism-in-mobile-app-ui-design/)
* 原文作者 : [Nick Babich](http://babich.biz/about/)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [edvardhua](https://github.com/edvardHua)
* 校对者 : [owenlyn](https://github.com/owenlyn), [jiaowoyongqi](https://github.com/jiaowoyongqi), [Graning](https://github.com/Graning)

# 移动开发中的极简设计

设计是一件用户驱动很强的工作。随着用户越来越偏好更简洁的交互界面，如何剔除多余的元素，保留最基础最重要的元素是极简设计的关键。极简设计形式和功能完美结合。它最大的优点是极简的表现形式，简洁的线条，大方的留白，简约的图形化元素，就算是很复杂的内容，在这样的设计下也会显得很简洁和干练。当然，如果能有效的利用这些元素。

极简设计必须要 _简洁明了和一致的可用性_ 。你的交互系统应该通过 _清晰的视觉传达（clear visual communication）_ 来解决用户的问题。这也是为什么具备简洁设计和高可用性的应用如此让人深刻。即便只是一个通过极简设计的导航，都能够提供很强的交互方式。要做到这一点，你需要注意以下几个方面。

## 简单的配色方案

简单的配色方案能够提高用户体验，相应的 _太多的色彩则会给用户负面的影响_。针对于初学者，有一些预先定义的标准颜色方案能够让你轻松创建新的颜色方案。

*   **单配色方案。** 单配色方案由特定色彩的不同的色调，阴影或颜色深浅所构成。他们的原理是通过修改特定颜色的饱和度和亮度，可以生成多种协调的颜色，这种颜色方案比较简洁和优雅，不会给眼睛产生太大负担。

![](http://babich.biz/content/images/2016/07/1--rbrbh20EHL_Ue_IDxl_0A.jpeg)

蓝色的单配色方案。素材来源: Smashing Magazine

![](http://babich.biz/content/images/2016/07/0-w_FvxwQG_6Px2vGE.jpg)

素材来源: [Dribbble](https://dribbble.com/shots/1054717-Hack-Day-App-Preview)

*   **近似色彩配色方案** [近似色彩配色方案](http://babich.biz/a-guide-to-color-and-conversion-rates/) 的思路是从色轮上取三个相邻的颜色来做为配色。全手势操作的应用 _Clear_ 使用了近似色彩配色方案，它使用不同颜色来区分任务的优先级或者高亮关键的任务。（顶端的任务使用最鲜艳的颜色，而底部的任务则使用明亮精致的颜色）

![](http://babich.biz/content/images/2016/07/0-GmWqCn_trRfbguAX-1.jpg)

渐变的黄色和橙色也是近似色彩配色方案的一个例子。素材来源: tuts+

![](http://babich.biz/content/images/2016/07/1-Y03ERRYZ_gHCw7cEnLmr2w.png)

IOS 平台的 Clear 应用

## 模糊效果

模糊效果出现在极简UI设计中是一件非常符合逻辑的事情，它能够增加 UI 的层次感。如果你的 UI 拥有多个层级，使用模糊效果能够让用户清晰的了解到 UI 的前后层级的关系。这也给了设计师一个完美的机会来设计多样化的菜单和层级效果。

[雅虎天气](https://itunes.apple.com/us/app/yahoo!-weather/id628677149?mt=8) 显示了一张当前位置的风景图片，如果需要查看天气的详细信息，你只需要向上滑动便会马上显示出来。与在原先的页面上叠加一层相比，这种方式在增加了详细信息的易于获取的情况下还保存了上一张图片作为模糊背景后，帮助用户在操作之后有更为直观的反馈。而且交互方式极为自然，你可以很方便的就返回到上一层。

![](http://babich.biz/content/images/2016/07/1-v6JG6G4UCwdS7XbXp0pZXA.jpeg)

IOS 上的雅虎天气

## 一个应用中只使用一种字体

在一个应用中使用多种字体会看起来很散乱和马虎。减少屏幕上字体的类型数量可以增强排版的效果。当你在设计应用的时候你可以通过更改字体的字重，样式，尺寸和大小来优化布局效果，而不是更换字体。

![](http://babich.biz/content/images/2016/07/1-PuctKONH65PUaGAgj_IDPQ.png)

通常来说，一个应用中只使用一种字体 素材来源: Apple

当你在为APP选择字体的时候，选择平台的默认字体可能是最安全稳妥的选择：

*  苹果使用 _San Francisco family_ 字体来提供全平台一致的阅读体验。（在 IOS 9 中简称为 SF-UI）
*   _[Roboto](https://www.google.com/fonts/specimen/Roboto)_ 和 _Noto_ 分别是 _Android_ 和 _Chrome_ 的默认字体

 ![](http://babich.biz/content/images/2016/07/1-h9TgxM4LubkjVDIhEG5U4g.png)


减少屏幕上使用的字体类型能够获得较好的排版效果。素材来源: Dribbble

## 数据的视觉焦点

你应该使用大号字体和醒目的颜色来让特定的数据成为视觉的焦点。使用中性的颜色（黑白灰）来展示普通的内容，而一些具备操作的部分则使用强对比的颜色来吸引用户注意，从而给给予用户正确的指导和操作。

![](http://babich.biz/content/images/2016/07/0-pgeX-afdEGctxooq.jpg)

素材来源: Smashing Magazine

明亮的色调+中性的色调是最容易搭配的方案，同时也是视觉上最引人注意的方案之一。素材来源: Smashing Magazine

被放大的字体和显眼的色彩能够很好的吸引用户的注意力，而不需要多余的文字提示。与此同时还提供了简洁易用的信息收集体验。

![](http://babich.biz/content/images/2016/07/1-3DfrZ4Lr5o0Z1GGUSBKMPA.gif)

在屏幕特定的区域使用放大的字体和弹出的颜色能有效吸引用户注意力。
素材来源: [Dribbble](https://dribbble.com/shots/2278322-Adding-a-new-goal-animation)

## 使用留白代替线条来区分元素

设计师通常使用线条和分割线来给屏幕划分区域和功能类别，但是增加太多这些元素会 UI 界面过于臃肿。 

_更少的线条和分割线_能够让我们的页面看起来更加的干净，现代化和功能突出。我们可以使用间距，留白和色块来区分不同的元素。谷歌日历就是一个很好的例子，它使用[投影](http://babich.biz/graphical-user-interface-as-a-reflection-of-the-real-world-shadows-and-elevation/)将两个内容不同的区块清晰地拉开层次，而不是用线段来简单地分割。

间隔不仅提供了清晰的视觉也增加了日历应用的易用性。

## 图标：线条和填充

我们使用图标用来表达某种功能或者内容，图标作为一种视觉语言，它应该是简约易于识别和理解的。IOS 7 后许多极简设计的 UI 都使用线条或者填充的图标。来看看同一个图标分别使用线条和填充的效果。

![](http://babich.biz/content/images/2016/07/1-q4lDSWO0aKUux47R-85CWA.jpeg)

时钟图标 素材来源: [icons8](https://icons8.com)

我们来看看底部菜单栏的图标。该图标在应用中通常是作为导航的存在，所以指示当前用户所在区域是很重要的，我们通常使用_高亮_图标来表示当前用户所选中的区域。这个时候，灰色的线性图标表示为未选中的状态。这样一来我们的底部菜单栏就很直观了。

![](http://babich.biz/content/images/2016/07/1-RfRHuM_4PB6BY7tDLSjGIQ.png)

苹果商店的底部导航 素材来源: viget

## 总结

简约的 UI 和设计技术是完成优秀设计的关键，但是极简设计的本身不是设计的目的。我们最终的目标是要简约 UI 的同时需要保证功能的完整性和高可用性。简单的流程，清晰的视觉传达和与设计的结合来打造无缝的交互体验才是最重要的。
