> * 原文地址：[The Art of Designing With Heart](https://m.signalvnoise.com/the-art-of-designing-with-heart-f5dc4df21697?swoff=true#.bwkktzgf7)
* 原文作者：[Jonas Downey](https://m.signalvnoise.com/@jonasdowney)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[llp0574](https://github.com/llp0574)
* 校对者：[Graning](https://github.com/Graning),[cyseria](https://github.com/cyseria)

# 用心设计的艺术

我喜爱软件开发的其中一个原因在于，它是一种深入的脑力锻炼，充满着令人兴奋的过程、各种抽象思想以及错综复杂的关联关系。

你可以用诸如 IT 研究、策略、原型、编程、UI、运营等更多这些实际性的具体细节来丰富自己。

如果这些都还不够呢？那就让自己尽情追求各项指标和性能吧。每一个最后的细节都可以被测试、量化以及优化，从而达到最完整的状态。努力提高各项 KPI（业务关键指标）并紧盯你的 ROI（投资回报率）吧！

问题在于：有这么多事情去考虑，以及这么多逻辑去操心，那么就很容易忘记你开发软件的初心：

### 🚨️ 你的软件的存在是为了帮助人们！🚨

设计师们通常把这个概念称为**用户体验**或者**用户心理**。我认为这些称谓很糟糕，它们都过于套话和含糊，在不同的环境下可以有着不同的意思。

但我认为它真正是什么我们就应该称作什么：**用心设计**。

这并不是某个在你的公司里一个特定小组的职责，或者在一个过程当中你可以检查的某一步骤，它是一个会告诉你做每一个决策的核心价值。


* * *

下面将说明它在实践中意味着什么。

在所有的策略、指标和技术的另外一端面临的是**真实的人**，这些人生存、呼吸，忙于处理他们各自稀奇古怪的生活琐事，和他们的小孩争论，试图弄清晚饭要吃什么。

当开发软件的时候，不免你会站在自己的角度发明一种机器，假设用户的感受，并以自己为代表用户模拟人机交互好让它们能有意义地实现某些功能。

你的软件不仅仅只是杂糅在一起的一堆代码和 UI。它还是你的最佳想法、最佳意图、帮助他人的渴望、你的爱、感受和灵魂的一个编译结果。

你的软件就是你自己。

（如果你相信它的艺术，那它就是，并且如果你做的是对的话那就更应该是了。）











* * *







当你从这个角度看待软件的时候，就将注意到大量的软件其实是无聊且缺乏生命力的。

仔细想想你经常登录的银行网站，或者你的保险公司的账单系统，它们大概都是冰冷且没有生命力的。那是因为这些设计师都把他们的工作当作了一种机械操作：接受一组需求、创造想象的人物、写用户故事以及在需求到来前混混他们的工作。这些都是机械的工作，没有用心。





![](http://ac-Myg6wSTV.clouddn.com/609b0b4489cc00c13ed7.png "Capital One 的登录页面")








现在，你可能会认为对于一个银行网站来说，看起来简单朴素且属于交易型并没什么问题。毕竟，银行业不夸张地说就是**一组组交易的集合**。

但相比起你可能曾经遇到过很体贴的银行柜员带来的体验（如果你仍然记得那是怎么样的一种体验），柜员对你微笑，询问你今天过得怎么样，仔细检查你的账目是正确的，为你可能忘记的事情提供帮助以及送你一根棒棒糖！🍭

这就是用了一点心思的交易过程。









* * *







好了，接下来讲一下我们的软件如何来替代银行柜员。这意味着软件在理想情况下，应该提供同样的人性化和真正有帮助的服务。但怎么做呢？

选项之一是将对外接口拟人化并为软件赋予一些[个性](http://alistapart.com/article/personality-in-design)，这么做就可以让 UI 变得有趣、友好、智能、带有批判性或者卡通化。





![](http://ac-Myg6wSTV.clouddn.com/dbff6848bb76ed648c8a.png "Poncho生动的天气猫给你发送 “Zzz Zzzzzzz” 和 “Purrrrrrrrrrrrr.” 的信息")








我认为这只是其中一小部分，因为人们对胡说八道的忍耐力很低。除非你能**真正**起到好的作用，否则好玩和有趣的东西将会很快变得让人恼火不已，甚至比机械化还要糟糕，因为它很浪费时间，开门见山往往会更好。


所以如果机械化不好，做的个性化也不好，那么什么是好的呢？

最佳选择则是两者适中。好的软件是友好、随性以及容易上手的，但同时也是严格、亲切以及有礼貌的。就像你曾经在本地交易中体验过的一次舒适的真实生活经验。









* * *







要实现这样听起来很困难（确实也是），但有一个简单的技巧可以帮上很多忙。

**当你设计某样东西的时候，想象你坐在一个房间里，正手把手地帮助真实的人解决问题。**你将会对他们说些什么？你会怎么解释这个页面或特性？你会给出什么建议？你将告诉他们什么去进行下一步操作？

大声说出这些答案来，然后写下你所说的。现在你就已经完成80%了！

如果你正在亲自帮助某人，你肯定不会很严格或者拘谨，不会使用流行语、术语或一些商业辞令，你也不会向他们丢什么开玩笑的炸弹或者用旁边的高飞（迪士尼角色）来让他们分心。你肯定会观察他们在做什么，看看他们哪里遇到了困难，并帮助他们解决。**你将用心和他们交流。**











* * *







这个常识性的技巧可以让你不会只见树木不见森林。如果你费尽心思解释某样事情，那么可能往往还解释得不清楚。这个观点会让你问出类似下面的这些问题：

*   我们可以让这个接口变得更简单或者更直接吗？
*   我们可以减少或者去掉这些用户必要的选择吗？
*   我们有没有用自然、随性的语言来充分解释这些操作？
*   这个设计有没有充分利用用户的时间和注意力？
*   这是一个我个人来说会很享受使用过程的东西吗？
*   我们有没有采取一些捷径让我们而不是他们受益？
*   我们有没有作出一些不正确的假设？

现在你的设计完成后肯定更加清楚和友好。这就会让你的消费者更加开心并且更高效率，那么他们就可以停止摆弄软件，然后回去和他们那好争论的小孩继续吃晚饭了。

**这应该成为你工作的潜在动力。**不是技术，不是样式，不是数据，也不是金钱。帮助人们是首要的，其他的都是次要的。











* * *







**用心设计**不仅仅只是创造一个产品。它同样可以指导你去营销、做广告以及销售。

比如说，你想要为你的产品增加付费用户。（谁不想？）这是一个商业为先的问题，不是一个用户为先的问题。

如果你仅仅考虑商业为先，你可能会发出一大堆促销邮件，或者在页面上到处展示 “BUY NOW” 入口，或者用弹窗广告去打断他们的关键工作流。





![](http://ac-Myg6wSTV.clouddn.com/ca97682bbc36bfdccc4f.png "Wall Street Journal 甚至在你进入页面之前就弹窗询问你是否购买")








这些技巧或许对增加业务指标有所帮助，但它们对消费者来说却是恼人和讨厌的。这并不是我们想要的结果。那我们怎么来解决两者之间的冲突呢？

简单：再次考虑用户！

清楚地传达产品的价格、让其变得更容易购买、给新用户传播你的信息甚至寻求推荐或点评，这些本来就不是一件坏事情 --- 只要你这么做的方式考虑周全、诚实并且在对的时间去做，就没问题了。

不要在用户处理事情的中途去打断他们，不间断地去骚扰他们，或者强行去推销你想的主意。如果想要得到青睐，那么就该考虑清楚去解释为什么你需要他们的帮助，从而让他们的时间变得有价值，同时或许应该在交易过程中提出激励。

遵循这些方法，你的推销将会是一个双赢的结果。









* * *







还有一件事情可以让你做到用心设计：**不要害怕去展现自己。**

人们会和其他非人类机器建立起情绪化的连接。

当你的消费者可以看到是谁在背后和其交流，并且当你诚实可靠地和他们交流时，他们就将更加可能确认你的信息和入口。





![](http://ac-Myg6wSTV.clouddn.com/5231e87d2a52db32e720.png "Nate Kontny’s Highrise更新总会有一个人性化提示。")








如果你创造某个东西是因为你从根本上在意如何帮助用户，并且想要留住他们，那么就更应该说出来了！把你的名字放上去、讲述你的故事、展示你的形象并站出来为你的工作负责。分享你**真实的**个性肯定比捏造一个虚假的形象放在一个死气沉沉的应用上要好得多。


你的消费者将会以同样的方式作出回应，并且这就是所有回报里最有价值的东西。💞


* * *

