> * 原文地址：[The 9 Rules of Design Research](https://medium.com/mule-design/the-9-rules-of-design-research-1a273fdd1d3b?ref=uxdesignweekly)
> * 原文作者：[Erika Hall](https://medium.com/@mulegirl?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/the-9-rules-of-design-research.md](https://github.com/xitu/gold-miner/blob/master/TODO/the-9-rules-of-design-research.md)
> * 译者：[zhmhhu](https://github.com/zhmhhu)
> * 校对者：[Starriers](https://github.com/Starriers)

# 设计研究的 9 条规则

![](https://cdn-images-1.medium.com/max/2000/1*Q5-y_Q5CnX4oKHnlM5vUOA.jpeg)

[Kathleen Borgmeyer](https://www.flickr.com/photos/landhofgreaterswiss/) 家的全部九只小狗。

最近，我注意到早期阶段的创业公司和老牌机构对研究的热情高涨。企业已经认识到，要想进行有意义的创新就需要将客户理解为具有多彩生活的人类。

这真的不可思议。

我也听到过许多相同的谬见、误解和冲突。所以，为了帮助读者 —— 因为我喜欢帮助别人 —— 这里有一份广泛分享的简单实用的设计清单（我确信，研究证明读者将喜欢这份清单的观点，就像喜欢那些小狗一样）。

#### 1. 让舒服变得不舒服

**“我所知道的一切就是我什么都不知道。” —— 苏格拉**

在我们成长过程中总是重视答案和恐惧问题。我们因在学校指出正确答案而获得奖励，我们因在工作中提出好点子而获得奖励。难怪有这么多人找理由避免做研究，特别是定性研究。很多人对于缺少资料的研究充满焦虑。至少定量的东西能舒舒服服的进行标准化测试。保持研究思维意味着你必须明白偏见无处不在，确定性犹如幻觉，答案却只有短暂的有效期。从长远来看，一个好的问题更有价值。如果你不承认自己没有答案，你就不能提出很好的问题 —— 这意味着你将无法学习新的东西。

#### 2. 先提问，再做原型

**“如果我们只测试开瓶器，我们可能永远不会意识到客户更喜欢螺旋瓶。” —— Victor Lombardi,** [**为什么我们会失败**](http://rosenfeldmedia.com/books/why-we-fail/)

当然，赶快做原型并对原型进行测试不会错。原型是一个有形的答案，即使它只是一份在纸上的素描。这比提问要舒服多了，即使这无异于烧掉了一大笔钱。对于那些喜欢做出快速和明显的进步来证明其价值的人来说，简单地问些问题就像[浣熊洗棉花糖](https://www.youtube.com/watch?v=qkTzDh8IKNU)一样做无用功。

过早制作原型，就好像不计成本地将资源投资在一个无人回答的问题上一样充满危险。测试一个原型可以帮助你完善已经很好的想法，而不是告诉你是否正确地解决了问题。而且很容易将原型的改善误认为是想法的质量（**cough** Juicero **cough**）。不管有用与否，也很容易将研究报告的注解误认为洞察力的价值。

提出正确的问题可以帮助你更快地识别并消除不良想法，而不是保存和捍卫无力的想法。你必须足够坚强才能接受错误。

#### 3.了解你的目标

除非你**事先**知道为什么要这么做，否则提问题就是在浪费时间。而且你必须公开宣称你的理由不是“求证”。这是**每个人**的秘密目标。见＃1。

通常在热衷于研究的情况下，团队会在没有明确共同的目标的情况下开始与客户交谈。然后，他们觉得自己花了宝贵的时间，却不明白该如何运用他们所学的知识，因而没有什么可以展示的。这导致了诸如“我们去年尝试做研究并且浪费了时间”这样的结果。因此，又恢复到了舒舒服服做工作和做测试的状态。或者，他们对他们所听到的内容有不同的解释，这会导致更多关于谁被证明是正确的争论。

在大型组织中，不言而喻的目标有时“表现出对研究的承诺，同时允许我们的产品领导者做他们想做的事情”。这听起来可能很愤世嫉俗，但我曾与资金雄厚的研究部门的许多熟练从业人员进行了交流，他们撰写的报告对决策影响不大。承认这种情况是阻止它的第一步。

这很好，也是一个很好的开始，因为你的目标是“我们需要确定层次并[快速理解那些不是我们的人的观点](https://medium.com/research-things/minimum-viable-ethnography-a047e9358df0)”。在事实发生之后，不要着眼于其他目标。

只有在你有一个目标之后，你才会知道你需要知道什么。你必须知道你的问题，然后才能选择如何回答它。

#### 4. 在重大问题上达成一致

**“所有业务的核心都是关于人类行为的赌注。”**
—— **[‘Thick’ 数据的力量](https://www.wsj.com/articles/the-power-of-thick-data-1395443491), WSJ**

问题的质量决定了结果的实用性。提出错误的问题如同为错误的问题制定解决方案一样。他们都会给你一些你需要的东西。从你的高优先级问题开始。这些来自无知的假设或领域，如果你错了，它们会带来最大的风险。

**重大问题是你想知道的，而不是你在面试时要问的问题。** 事实上，直接询问你的研究问题通常是学习任何事物的最糟糕的方式。人们通常不知道或不愿意承认自己的真实行为，但每个人都非常善于提出答案。

设计研究一直与用户研究混为一谈。与用户代表交谈只是[回答高优先级研究问题的众多方法之一](https://abookapart.com/products/just-enough-research)。并非所有你需要知道的都是关于用户的。

通常最关键的问题类似于“基于种种迹象，关于我们的客户/竞争对手/内部能力，我们**真正**了解的是什么？”。这可能是一个非常可怕的方法，但是在一小时内你应该能够回答它。

#### 5. 总是有足够的时间和资金

当研究被定义为设计之外的一种工作类型时，很容易将收集证据定义为额外的工作，并找借口不去这么做。

通常，团队必须征得权威人士的许可才能开展相关的研究工作。[提出问题本身就是对权威的威胁](https://deardesignstudent.com/the-secret-cost-of-research-fbe95739afdd)。如果你曾经与一位拒绝定性研究（这一研究是某百万美元项目的一部分）的领导者合作过，那么问问自己，他们是否会在购买一辆 5 万美元的汽车之前跳过自己的调查。陈述的反对意见往往会因为害怕被破坏或被证明是错误的或者没有以正确的方式发挥作用而被掩盖。

如果你对自己的目标和高优先级问题清楚坦率，那么你可以在任何时间和预算内获得有用的信息。在线查找研究资料。在午餐时间到外面去观察他人。测试别人产品的通用性。获得创意。

[千万不要去做问卷调查](https://medium.com/mule-design/on-surveys-5a73dda5e9a0)。

#### 6. 不要期望用数据改变想法

**“当一个人的薪水依赖于他所不了解的领域时，很难让他理解这一领域的事情。” —— Upton Sinclair**

尽管[研究证明它是真实的](https://www.newyorker.com/magazine/2017/02/27/why-facts-dont-change-our-minds)，但对于训练有素的专业研究人员来说，这往往也难以接受。如果你习惯与重视某种数据的社区同行合作，那么你可能没有足够的能力说服人们放弃手中的数据。数据不足的问题，也会让人感觉是对个人专业能力的侮辱。

收集证据的重点在于做出基于证据的决定。如果这些证据破坏或违背了有权作出决定的人的信念，他们会找到拒绝或忽视的理由。这也是定性研究人员在一些工程驱动的组织中难以为继的核心。对数字感觉舒适且能胜任的人希望得到数字答案，即使这个问题需要一些更具描述性的东西。

因此，在尝试使用数据来影响这些决策之前，你必须将民族意志带入其中并[了解你的同事和领导人如何做出决定](https://medium.com/mule-design/everyday-empathy-6a475e03fd81) 。

#### 7. 拥抱不完美

**“人类是多变、愚蠢而健忘的动物，在自我毁灭方面倒是才智出众。” —— Suzanne Collins, Mockingjay**

人的生活是混乱的。如果人们没有问题，就不需要产品和服务来解决问题，我们也就没有工作。找出为人们解决问题的最佳方式，需要在真实、混乱的世界中花些时间，并放开一定程度的控制。尽管一个合乎伦理的、严谨的方法是有必要的，但也没有一片真正意义上的净土。一个明确的目标和一个好问题可以承受各种不可预测的情况。

当一些不太正式的方法会更有效的时候，对于规范的、舒适的、看起来非常专业的行动的渴望就会导致[小组讨论](https://medium.com/mule-design/focus-groups-are-worthless-7d30891e58f1)、可用性测试、眼球追踪、[问卷调查](https://medium.com/mule-design/on-surveys-5a73dda5e9a0)和正式报告的不适当使用。

将证据纳入设计决策本身就是一个学习的过程。你永远找不到正确的答案并完成任务。如果过程有效，你将继续以越来越高的自信心做出决定。

#### 8. 精诚合作

从事同一件事的每个人都需要在相同的共享环境中工作。作出关于产品决策的人员需要是最明智的。对于知识有多么好其实并不重要，如果知识只在一个人的头脑里，那么知识的好坏并不重要（除非你在伦敦，而那个人是你的出租车司机）。

没有合作的研究意味着，一组人在学习和创建报告，另一组人可能承认或忽略这些报告。即使是最强大的团队，这样工作也会遗漏知识。没有凭据的合作意味着每个人都可以以自己的偏好行事。这些都不是最有成效的方法。

直接参与创建产品的人员提出问题和回答问题是最有成效的方法。而且它也很有趣。有几种方法可以实现这一点取决于你所在的组织。

提出问题的重点在于建立共同的决策框架，以便你可以更快地做出更好的决策。[我为此创立了一个研讨会](https://muledesign.com/research-together)。它将改变生活。

#### 9.找到你的偏见伙伴

**“我们可以对显而易见的事物视而不见，我们也可以对我们的盲目视而不见。** [**思考，快与慢**](https://www.amazon.com/Thinking-Fast-Slow-Daniel-Kahneman/dp/0374533555)

所以，你做了这项工作，找到了一些答案。现在你需要确定他们的意思。在开始解释研究结果时，协作变得尤为重要。每个人在脑子里都有个人偏见。而且没有办法感觉到自己的偏见。我们看到的都是契合我们信仰的东西。所以，我们必须参考一个外部标准（包括预先制定的目标和问题）并一起工作来检查对方。

这与你的聪明程度或知情程度无关。一旦你接受了这一点，并且只要你在一个表现出心理安全和相互尊重的团队中工作，这可能是一个有趣的游戏，以识别偏差并将其剔除出去。

[维基百科](https://en.wikipedia.org/wiki/List_of_cognitive_biases)上有一个很好的列表，以及 Cognitive Bias Codex 可以打印和贴在你的墙上。

#### 也许，设计只是貌似正确

总而言之，当我们谈论设计研究时，我们所谈论的实际上是在做[基于证据的设计](https://medium.com/mule-design/lets-stop-doing-research-48efcd7118c9)。创作、批评和探究都是设计过程的组成部分。将他们分开导致从无知、自我或恐惧中优化错误的事物。

设计是一种价值交换。在对世人展示你的任何作品之前，你必须先问人们真正需要和重视什么，以及你期望获得什么商业价值。

只要你在方法上遵守道德，诚实地对待你所知道的事情，并且为自己设定一个有价值的目标，无论你问什么样的问题或如何找到答案都没有关系。没有永远正确的方法，也没有永远正确的答案。享受不确定性，因为它自始自终都是这样。

* * *

你好！如果你已经完成了一切，你就会想：“嘿！这是我的团队可以获得帮助的东西，”我会很高兴地在你的办公室流连一天，并[和你一起做研究](https://muledesign.com/research-together)。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
