> * 原文地址：[Story Thought and System Thought](https://medium.com/quora-design/story-thought-and-system-thought-188dce7a87e6#.lriaw6doa)
* 原文作者：[Mills Baker](https://medium.com/@millsbaker?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：
* 校对者：

# Story Thought and System Thought #

Many disputes — in product development and in life — reflect differences in *how* people think as much as in *what* they think about a particular issue. We can’t always persuade one another simply by expressing our positions, introducing information, and counting “pros” and “cons.” Instead, our disagreements often start upstream, so to speak, as we and others diverge in which modes of thinking we consider legitimate. [1]

Frameworks for understanding these modes can help us to translate between them, and one I’ve found useful was described to me by [David Cole](https://www.quora.com/profile/David-Cole) , who encountered it in a post by [Katja Grace](https://meteuphoric.wordpress.com/2010/04/23/systems-and-stories/). This is the **“story thought” vs. “system thought”** framework. [2]

For designers working with engineers, PMs, and others, I think it’s often very valuable.

#### A story or a system ####

Story thought and system thought as modes have the following properties:

- **Story thought** emphasizes subjective human experience, the primacy of individual actors, narrative and social ordering, messiness, edge cases, content, and above all *meaning.*

- **System thought** emphasizes 3rd-person descriptions of phenomena from a neutral perspective, the interchangeability of actors and details, categorical or logical ordering, measurements, flow, form, and above all *coherence*.

Some examples may be useful; when we think of any of these topics, we can usually imagine both the system view and the story view:

**A sign-up wall**

- Think of how frustrating a sign-up wall is for a person encountering it; perhaps imagine how obviously “system-benefitting” such a feature is, and worry that a user will “sense” that and think less of your brand; imagine how uncool it feels to have one, how “anathema to the spirit of the web” etc.

- Look at the data and see that more people sign up with the wall than without; consider the mandatory nature of growth for the success of your product, which you think is good for the world, and how unclear the idea of “brand affinity” is, as well as whether you can (or should) make a short-term penalty / long-term gain tradeoff in this instance

**The minimum wage**

- Picture a hard-working individual who cannot possibly make ends meet on their low wage; imagine them also being a parent, or a student; think of the absence of opportunities for promotion, the stultifying effect of bone-dead low-wage-job exhaustion on their ambitions, or the wealth of their employer; think of other people who don’t work at all and yet are rich, and how individually unfair the world is

- Imagine the systematic effects of raising the minimum wage; consider what evidence we have of the broadest effects of doing so, or how we’d generate evidence if no good evidence exists; think of the likelihood that every system will have costs, and compare the costs of ours to others, or the lives of minimum wage-earners today to people in the past; consider whether it’s relevant that some are rich; think of the best “overall” policy

**Love**

- Do you “love” your partner, or family or children? Does your love reflect who they are, who you are? Is it special, worth self-sacrifice? Is it unique or personal or beautiful, something worth celebrating with rituals, parties, tokens? Is it *meaningful?*

- Is it human nature to seek what’s rewarded by our neurotransmitters, usually higher-order actions which flush those chemicals because they’re evolutionarily rewarding, making your love as meaningful as your metabolism, as unique as a bowel movement? Is it perhaps “a good feeling” but not especially meaningful?

In all these cases, we should realize, both approaches have merit. They vary in how they address certain questions: how much does an individual’s perception matter, as opposed to objective fact? What kinds of things constitute evidence? Are analogies useful or distracting? Is everything measurable, or at least measurable by proxy? Is what’s immeasurable non-existent, or might you take it into account, and how might you? Our answers to these questions vary depending on the subject we’re considering. This is especially true when we’re thinking about areas we don’t know enough about yet to have complete theoretical systems. We’re *all* systems thinkers about physics; but we’re almost all story thinkers about love, at least at the level of action. We may blend modes, but when we marry, we don’t look at our spouse and think: *“Well, you or probably one hundred million others would work.”*

![](https://cdn-images-1.medium.com/max/600/1*yQRdAJV9bU567l1phVsO0g.png) 

Judith Rothschild, “Greenwich Village,” 1945.

It’s worth noting that we tend to favor story thought when considering ourselves, while all-too-readily subsuming others into system thought’s constructs. The more closely we look at a situation, the less “generally” we will describe it and the more every particular detail, exception, and element matters. And we know ourselves at this level of “full reality,” but very few others. [3]
 
It’s also worth noting that “areas we haven’t reduced to explanatory systems” tend to be areas that involve human beings as agents; as we have no explanatory model for mind, everything that involves mind — values, culture, society, history — is only somewhat reducible. This means that story thought will sometimes be the *only* mode available to us, or will at least be more useful than system thought whose depth is exaggerated.

#### In companies ####

Indeed, this is *why* we need story thought: it can give us insight into phenomena that system thought cannot. The opposite is also true, and it’s the nightmare of the scaled, contemporary world that no easy meta-framework exists for adjudicating when to use one or the other. In general, as human agency grows in importance for the things we’re thinking about, so too does the value of story thought; as scaled phenomena grow in importance, the value of system thought grows.
 
Putting aside politics and our love lives, this lens is extremely useful for navigating technology companies. In sum: I believe **it’s usually the responsibility of designers to insist that a balance of story thought and system thought is applied** to product development.
 
This is not because engineers, *as people*, or PMs, *as people*, are “prone to system thought”; they may or may not be, but their disciplines and the configuration of their organizations *almost always* are. This means that over time, best practices accumulate that favor system thought, and many of design’s partners will favor the measurable, the reducible, the general over the ineffable, the holistic, or the narrative in how they make decisions. (Bad designers will *only* favor the latter, giving their thinking a precious, privileged, arbitrary quality which can be costly).
 
Of course, technology itself makes system thought more important and more valuable than it’s ever been —if only by dramatically increasing measurability in systems— so it’s not absurd for it to enjoy primacy as a mode of analysis. But it can lead to failure if over-promoted or overly-relied-upon.

Let’s consider a stark example: if you’re a digital media company, how do you navigate the problem of “what content to produce”? You can

- imagine an ideal or “first principles” your content should reflect, based on imagined audiences or extrinsic morals or anything else; you can then make decisions based on this idea and these principles, asking yourself “what people think about this mix”; or you can

- measure what people click on and try to make more of that; assume that whatever they click on is what they want (how else can clicking be interpreted?), and made decisions based on usage data.

Obviously, good organizations mix these two approaches — the former a story approach, the latter a system approach — but observers of the media industry would likely agree that over-indexing on the latter is at least partly why media is distrusted and disliked by consumers. Yes, those same consumers — or a majority of them — “engage” more with clickbait, sensationalism, and news-as-entertainment, but in the longer-term, people think that the desperate pursuit of attention at the expense of principle is disgusting, and they lose trust in media *as such.*
 
There was probably no *measurement* that made that outcome clear as it happened. No one could have articulated a position against the stakeholders pushing CNN to become more sensationalistic which those stakeholders would have accepted; they would have had to appeal to “story thought,” including speculative assertions about long-term phenomena that we cannot measure well: values, culture, individual judgments apart from mob movements. Or they’d rely on the utility of *a priori *interpretive theories like “Jobs to Be Done” or “Kahneman’s two systems,” which may or may not resonate with system thinkers. [4] At best they’d have had “sentiment analyses” which do little in the face of “engagement data,” or perhaps they’d just blurt out their own personal claims that “over time, users don’t want trash even when they click on it more; they want quality,” whatever *that* is.

Of course: someone probably did try that appeal, and they probably lost. Such a position is hard to defend against data, and especially when revenue follows engagement. But more striking is this: **the position’s truth is so obvious that we’d expect a 10 year old to understand it,** yet media companies struggled to weigh it appropriately [5]. In addition to such silly errors, insisting on systems-only thinking can lead to local maxima that constrain product development over time, a common outcome in many companies. Indeed, as most creativity consists of innovations that aren’t obviously “the next logical extension” of some pre-existing system, creativity itself is usually a victim of over-emphasized system thought, too.
 
(There are also uncountable examples of story thought going awry. Almost every cockamamie app idea that fills you with despair arises from an underexamined, underchallenged story, such that many believe that systems thought is strictly superior. If there is *more *bad story thought, then advocating systems thought is useful generally. But in many technology companies, the dilemma is as often that systems thought is itself overrated. In any event: both lead to error if not checked, and sometimes even then).

![](https://cdn-images-1.medium.com/max/600/1*NzizwyFI-qb-BMsoQf85Mg.png) 

Wassily Kandinsky, “*Kleine Welten VII*,” 1922.

#### Known Unknowns ####

Sound organizations attempt to know both what they know *and* what they don’t and can’t, just as individuals should. Much of how humans think is mysterious still, but “mystery” simply isn’t part of any system. As individuals, we often navigate this easily: we alternate between modes based on which seems more useful, more valuable, more true. At a wedding, I’m unlikely to challenge anyone to justify their vows by bringing up evolutionary biology (not solely due to social cost, but also because I consider contemporary biology an incomplete account of love; most people do). But in technology organizations, being able to articulate why these two systems exist and persist — and what the strengths and weaknesses of each are — can help bridge gaps across functions and explain product proposals that would otherwise seem arbitrary and risky or reductive and short-sighted.
 
Not being able to do this can lead to rancorous functional factionalism or, worse, frequent product failures. Story thought, which captures and understands human meanings, is central to creating things humans use and find valuable; system thought, which captures and understands scale, iteration, flow, and many aspects of technology and business, is central to making these valuable things accessible, sustainably available, and continuously improving.
 
So consider the ways you lean on system or story thought; and consider when you’re collaborating how others do so. If you can explain your story in system terms, or your system in story terms — and why both modes matter — you’ll have an easier time attaining alignment and understanding what every kind of thinker can contribute to product development processes.

#### Notes ####

1. To be concrete, “thinking” here means: what sorts of entities appear in our arguments; what kinds of operations we accept on those entities (analogies or measurements or anecdotes or the like); what tradeoffs we’ll make between reach and accuracy in our thinking; how much, if any, evidence we require, and what constitutes evidence. People of relative overall similarity can have strikingly different attitudes about modes of thinking, and when this happens persuasion can be very hard.
2. This dilemma is an old one in philosophy, exemplified for most by Kierkegaard’s resistance to Hegel; Walker Percy described Kierkegaard as saying that Hegel is “a philosopher who can explain everything under the sun except one small detail: what it means to be a human…” And indeed most of our systems work in precisely this fashion: whatever their overall predictive power, they fail to account for the subjective experience of human beings, and for the meanings that arise from them.
3. One of the powers of art is to focus our attention to this level of detail in other lives and experiences. This is why it’s possible to have anti-heroes in novels, or complex moral figures in film. A truly realistic portrayal of another almost always arouses our sympathy, because it renders our reductive moral systems ineffectual and prompts us to “judge them as we’d be judged.”
4. [Abhinav Sharma](https://twitter.com/abhinavsharma) has written about [using Kahneman’s ideas in product design](https://medium.com/quora-design/designing-fast-or-slow-2a4db40c39aa#.6y19u14qv) and how that lens clarifies some of these issues.
5. It’s probable that many do and did understand this, but their business models and the environment their industry is in make it hard for them pursue any course other than engagement-seeking. If so, innovation in models is needed, which is even harder than innovation in content or products. It may merely be that cultures need to realize how desperately they need news well-covered and must increase what they’ll pay for—how much they value— it.
