

## Even at one of the low points in his career, Jobs still had confidence in the limitless potential of personal computing


> * 原文链接 : [Steve Jobs in 1994: The Rolling Stone Interview | Rolling Stone](http://www.rollingstone.com/culture/news/steve-jobs-in-1994-the-rolling-stone-interview-20110117)
* 原文作者 : [JEFF GOODELL](http://www.rollingstone.com/contributor/jeff-goodell)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : 
* 校对者: 
* 状态 :  待定

The story of Apple CEO Steve Jobs is one of the most familiar in American business -- shaggy Bob-Dylan-loving kid starts a computer company in a Silicon Valley garage and changes the world. But like any compelling story, it has its dark moments. Before the [iPad](http://www.inc.com/topic/Apple+iPod "Apple iPod") or the [iPhone](http://www.inc.com/topic/Apple+iPhone "Apple iPhone"), Jobs, then the head of the short-lived [NeXT Computer](http://www.inc.com/topic/NeXT+Computer+Inc. "NeXT Computer Inc."), sat down with [Rolling Stone](http://www.inc.com/topic/Rolling+Stone+LLC "Rolling Stone LLC")'s [Jeff Goodell](http://www.inc.com/topic/Jeff+Goodell "Jeff Goodell"). It was 1994, Jobs had long ago been booted from Apple, the internet was still the province of geeks and academics, and the personal computer revolution looked like it might be over. But even at one of the low points in his career, Jobs still had confidence in the limitless potential of personal computing. Read on to get Jobs' prescient take on PDAs and object-oriented software, as well as his relationship with [Bill Gates](http://www.inc.com/topic/Bill+Gates "Bill Gates") and why he wanted the internet in his den, but not living room. Steve Jobs [died of pancreatic cancer at the age of 56](../../../culture/news/steve-jobs-apple-founder-dead-at-56-20111005) on October 5th, 2011.

Like other Phenomena of the '80s, Steve Jobs was supposed to be long gone by now. After the spectacular rise of Apple, which went from a garage start-up to a $1.4 billion company in just eight years, the Entrepreneur of the Decade (as one magazine anointed him in 1989) tried to do it all again with a new company called NeXT. He was going to build the next generation of the personal computer, a machine so beautiful, so powerful, so _insanely great,_ it would put Apple to shame. It didn't happen. After eight long years of struggle and after running through some $250 million, NeXT closed down its hardware division last year and laid off more than 200 employees. It seemed only a matter of time until the whole thing collapsed and Jobs disappeared into hyperspace.

But it turns out that Jobs isn't as far gone as some techno-pundits thought. There are big changes coming in software development — and Jobs, of all people, is trying to lead the way. This time the Holy Grail is object-oriented programming; some have compared the effect it will have on the production of software to the effect the industrial revolution had on manufactured goods. "In my 20 years in this industry, I have never seen a revolution as profound as this," says Jobs, with characteristic understatement. "You can build software literally five to 10 times faster, and that software is much more reliable, much easier to maintain and much more powerful."

_This article appeared in the [June 16, 1994](../../plus/archive#/2/598/C1/S) issue of Rolling Stone. The issue is available in the [online archive.](../../../allaccess)_

Of course, this being Silicon Valley, there is always a new revolution to hype. And to hear it coming from Jobs — Mr. Revolution himself — is bound to raise some eyebrows. "Steve is a little like the boy who cried wolf," says Robert Cringely, a columnist at _Info World,_ a PC industry newsweekly. "He has cried revolution one too many times. People still listen to him, but now they're more skeptical." And even if object-oriented software does take off, Jobs may very well end up a minor figure rather than the flag-waving leader of the pack he clearly sees himself as.

Whatever role Jobs ends up playing, there is no question evolutionary forces will soon reshape the software industry. Since the Macintosh changed the world 10 years ago with its brilliant point-and-click interface, all the big leaps in computer evolution have been on the hardware side. Machines have gotten smaller, faster and cheaper. Software, by contrast, has gotten bigger, more complicated and much more expensive to produce. Writing a new spreadsheet or word-processing program these days is a tedious process, like building a skyscraper out of toothpicks. Object-oriented programming will change that. To put it simply, it will allow gigantic, complex programs to be assembled like Tinkertoys. Instead of starting from the ground up every time, layering in one line of code after another, programmers will be able to use preassembled chunks to build 80 percent of a program, thus saving an enormous amount of time and money. Because these objects will work with a wide range of interfaces and applications, they will also eliminate many of the compatibility problems that plague traditional software.

For now, the beneficiary of all this is corporate America, which needs powerful custom software to help manage huge databases on its networks. Because of the massive hardware requirements for object-oriented software, it will be years before it becomes practical for small businesses and individual users (decent performance out of NeXT's software on a 486/Pentium processor, for example, requires 24 megs of RAM and 200 megs on a hard drive). Still, in the long run, object-oriented software will vastly simplify the task of writing programs, eventually making it accessible even to folks without degrees from MIT.

No one disputes the fact that NeXT has a leg up on this new technology. Unlike most of its competitors, whose object-oriented software is still in the prototype stage, NEXTSTEP (NeXT's operating system software) has been out in the real world for several years. It's been road-tested, revised, refined, and it is, by all accounts, a solid piece of work. Converts include McCaw Cellular, Swiss Bank and Chrysler Financial. But as the overwhelming success of Microsoft has shown, the company with the best product doesn't always win. For NeXT to succeed, it will have to go up against two powerhouses: Taligent, the new partnership of Apple and IBM, and Bill Gates and his $4 billion-a-year Microsoft steamroller. "Right now, it's a horse race between those three companies," says Esther Dyson, a Silicon Valley marketing guru. A recent $10 million deal with Sun Microsystems — the workstation company that was once NeXT's arch rival — has breathed new life into NeXT, but it is only one step in a very long journey. Still, few dare count NeXT out.

Today, Jobs, 39, seems eager to distance himself from his reputation as the _Wunderkind_ of the '80s. He wears small, round John Lennon-style glasses now, and his boyish face is hidden behind a shaggy, Left Bank-poet beard. During our interview at the NeXT offices in Redwood City, Calif., just 20 miles north of his old Apple fiefdom, he took particular joy in bashing his old rival Bill Gates but avoided discussing other heavyweights by name. Trademark Jobsian phrases like "insanely great" or "the next big thing" were nowhere to be found. Friends say the _Sturm und Drang_ of the past few years has humbled Jobs ever so slightly; he is a devoted family man now, and on weekends, he can often be seen Rollerblading with his wife and two kids through the streets of Palo Alto.

"Remember, this is a guy who never believed any of the rules applied to him," one colleague says. "Now, I think he's finally realized that he's mortal, just like the rest of us."

**It's been 10 years since the Macintosh was introduced. When you look around at the technological landscape today, what's most surprising to you?**  
People say sometimes, "You work in the fastest-moving industry in the world." I don't feel that way. I think I work in one of the slowest. It seems to take forever to get anything done. All of the graphical-user interface stuff that we did with the Macintosh was pioneered at Xerox PARC [the company's legendary Palo Alto Research Center] and with Doug Engelbart at SRI [a future-oriented think tank at Stanford] in the mid-'70s. And here we are, just about the mid-'90s, and it's kind of commonplace now. But it's about a 10-to-20-year lag. That's a long time.

The reason for that is, it seems to take a very unique combination of technology, talent, business and marketing and luck to make significant change in our industry. It hasn't happened that often.

The other interesting thing is that, in general, business tends to be the fueling agent for these changes. It's simply because they have a lot of money. They're willing to pay money for things that will save them money or give them new capabilities. And that's a hard one sometimes, because a lot of the people who are the most creative in this business aren't doing it because they want to help corporate America.

A perfect example is the PDA [Personal Digital Assistant] stuff, like Apple's Newton. I'm not real optimistic about it, and I'll tell you why. Most of the people who developed these PDAs developed them because they thought individuals were going to buy them and give them to their families. My friends started General Magic [a new company that hopes to challenge the Newton]. They think your kids are going to have these, your grandmother's going to have one, and you're going to all send messages. Well, at $1,500 a pop with a cellular modem in them, I don't think too many people are going to buy three or four for their family. The people who are going to buy them in the first five years are mobile professionals.

And the problem is, the psychology of the people who develop these things is just not going to enable them to put on suits and hop on planes and go to Federal Express and pitch their product.

To make step-function changes, revolutionary changes, it takes that combination of technical acumen and business and marketing — and a culture that can somehow match up the reason you developed your product and the reason people will want to buy it. I have a great respect for incremental improvement, and I've done that sort of thing in my life, but I've always been attracted to the more revolutionary changes. I don't know why. Because they're harder. They're much more stressful emotionally. And you usually go through a period where everybody tells you that you've completely failed.

* * *

**Is that the period you're emerging from now?**  
I hope so. I've been there before, and I've recently been there again.

As you know, most of what I've done in my career has been software. The Apple II wasn't much software, but the Mac was just software in a cool box. We had to build the box because the software wouldn't run on any other box, but nonetheless, it was mainly software. I was involved in PostScript and the formation of Adobe, and that was all software. And what we've done with NEXTSTEP is really all software. We tried to sell it in a really cool box, but we learned a very important lesson. When you ask people to go outside of the mainstream, they take a risk. So there has to be some important reward for taking that risk or else they won't take it

What we learned was that the reward can't be one and a half times better or twice as good. That's not enough. The reward has to be like three or four or five times better to take the risk to jump out of the mainstream.

The problem is, in hardware you can't build a computer that's twice as good as anyone else's anymore. Too many people know how to do it. You're lucky if you can do one that's one and a third times better or one and a half times better. And then it's only six months before everybody else catches up. But you can do it in software. As a matter of fact, I think that the leap that we've made is at least five years ahead of anybody.

**Let's talk about the evolution of the PC. About 30 percent of American homes have computers. Businesses are wired. Video-game machines are rapidly becoming as powerful as PCs and in the near future will be able to do everything that traditional desktop computers can do. Is the PC revolution over?**  
No. Well, I don't know exactly what you mean by your question, but I think that the PC revolution is far from over. What happened with the Mac was — well, first I should tell you my theory about Microsoft. Microsoft has had two goals in the last 10 years. One was to copy the Mac, and the other was to copy Lotus' success in the spreadsheet — basically, the applications business. And over the course of the last 10 years, Microsoft accomplished both of those goals. And now they are completely lost.

They were able to copy the Mac because the Mac was frozen in time. The Mac didn't change much for the last 10 years. It changed maybe 10 percent. It was a sitting duck. It's amazing that it took Microsoft 10 years to copy something that was a sitting duck. Apple, unfortunately, doesn't deserve too much sympathy. They invested hundreds and hundreds of millions of dollars into R&D, but very little came out They produced almost no new innovation since the original Mac itself.

So now, the original genes of the Macintosh have populated the earth. Ninety percent in the form of Windows, but nevertheless, there are tens of millions of computers that work like that. And that's great. The question is, what's next? And what's going to keep driving this PC revolution?

If you look at the goal of the '80s, it was really individual productivity. And that could be answered with shrink-wrapped applications [off-the-shelf software]. If you look at the goal of the '90s — well, if you look at the personal computer, it's going from being a tool of computation to a tool of communication. It's going from individual productivity to organizational productivity and also operational productivity. What I mean by that is, the market for mainframe and minicomputers is still as large as the PC market And people don't buy those things to run shrink-wrapped spreadsheets and word processors on. They buy them to run applications that automate the heart of their company. And they don't buy these applications shrink-wrapped. You can't go buy an application to run your hospital, to do derivatives commodities trading or to run your phone network. They don't exist. Or if they do, you have to customize them so much that they're really custom apps by the time you get through with them.

These custom applications really used to just be in the back office — in accounting, manufacturing. But as business is getting much more sophisticated and consumers are expecting more and more, these custom apps have invaded the front office. Now, when a company has a new product, it consists of only three things: an idea, a sales channel and a custom app to implement the product. The company doesn't implement the product by hand anymore or service it by hand. Without the custom app, it doesn't have the new product or service. I'll give you an example. MCI's Friends and Family is the most successful business promotion done in the last decade — measured in dollars and cents. AT&T did not respond to that for 18 months. It cost them billions of dollars. Why didn't they? They're obviously smart guys. They didn't because they couldn't create a custom app to run a new billing system.

**So how does this connect with the next generation of the PC?**  
I believe the next generation of the PC is going to be driven by much more advanced software, and it's going to be driven by custom software for business. Business has focused on shrink-wrapped software on the PCs, and that's why PCs haven't really touched the heart of the business. And now they want to bring them into the heart of the business, and everyone is going to have to run custom apps alongside their shrink-wrapped apps because that's how the enterprise is going to get their competitive advantage in things.

For example, McCaw Cellular, the largest cellular provider in the world, runs the whole front end of their business on NEXTSTEP now. They're giving PCs with custom apps to the phone dealers so that when you buy a cellular phone, it used to take you a day and a half to get you up on the network. Now it takes five minutes. The phone dealer just runs these custom apps, they're networked back to a server in Seattle, and in a minute and a half, with no human intervention, your phone works on the entire McCaw network.

In addition to that, the applications business right now — if you look at even the shrink-wrap business — is contracting dramatically. It now takes 100 to 200 people one to two years just to do a major revision to a word processor or spreadsheet. And so, all the really creative people who like to work in small teams of three, four, five people, they've all been squeezed out of that business. As you may know, Windows is the worst development environment ever made. And Microsoft doesn't have any interest in making it better, because the fact that its really hard to develop apps in Windows plays to Microsoft's advantage. You can't have small teams of programmers writing word processors and spreadsheets — it might upset their competitive advantage. And they can afford to have 200 people working on a project, no problem.

With our technology, with objects, literally three people in a garage can blow away what 200 people at Microsoft can do. Literally can blow it away. Corporate America has a need that is so huge and can save them so much money, or make them so much money, or cost them so much money if they miss it, that they are going to fuel the object revolution.

**That may be so. But when people think of Steve Jobs, they think of the man whose mission was to bring technology to the masses — not to corporate America.**  
Well, life is always a little more complicated than it appears to be.

What drove the success of the Apple II for many years and let consumers have the benefit of that product was Visi-Calc selling into corporate America. Corporate America was buying Apple IIs and running Visi-Calc on them like crazy so that we could get our volumes up and our prices down and sell that as a consumer product on Mondays and Wednesdays and Fridays while selling it to business on Tuesdays and Thursdays. We were giving away Macintoshes to higher ed while we were selling them for a nice profit to corporate America. So it takes both.

What's going to fuel the object revolution is not the consumer. The consumer is not going to see the benefits until after business sees them and we begin to get this stuff into volume. Because unfortunately, people are not rebelling against Microsoft. They don't know any better. They're not sitting around thinking that they have a giant problem that needs to be solved — whereas corporations are. The PC market has done less and less to serve their growing needs. They have a giant need, and they know it. We don't have to spend money educating them about the problem — they know they have a problem. There's a giant vacuum sucking us in there, and there's a lot of money in there to fuel the development of this object industry. And everyone will benefit from that

I visited Xerox PARC in 1979, when I was at Apple. That visit's been written about — it was a very important visit. I remember being shown their rudimentary graphical-user interface. It was incomplete, some of it wasn't even right, but the germ of the idea was there. And within 10 minutes, it was so obvious that every computer would work this way someday. You knew it with every bone in your body. Now, you could argue about the number of years it would take, you could argue about who the winners and losers in terms of companies in the industry might be, but I don't think rational people could argue that every computer would work this way someday.

I feel the same way about objects, with every bone in my body. All software will be written using this object technology someday. No question about it. You can argue about how many years it's going to take, you can argue who the winners and losers are going to be in terms of the companies in this industry, but I don't think a rational person can argue that all software will not be built this way.

* * *

**Would you explain, in simple terms, exactly what object-oriented software is?**  
Objects are like people. They're living, breathing things that have knowledge inside them about how to do things and have memory inside them so they can remember things. And rather than interacting with them at a very low level, you interact with them at a very high level of abstraction, like we're doing right here.

Here's an example: If I'm your laundry object, you can give me your dirty clothes and send me a message that says, "Can you get my clothes laundered, please." I happen to know where the best laundry place in San Francisco is. And I speak English, and I have dollars in my pockets. So I go out and hail a taxicab and tell the driver to take me to this place in San Francisco. I go get your clothes laundered, I jump back in the cab, I get back here. I give you your clean clothes and say, "Here are your clean clothes."

You have no idea how I did that. You have no knowledge of the laundry place. Maybe you speak French, and you can't even hail a taxi. You can't pay for one, you don't have dollars in your pocket. Yet I knew how to do all of that. And you didn't have to know any of it. All that complexity was hidden inside of me, and we were able to interact at a very high level of abstraction. That's what objects are. They encapsulate complexity, and the interfaces to that complexity are high level.

**You brought up Microsoft earlier. How do you feel about the fact that Bill Gates has essentially achieved dominance in the software industry with what amounts to your vision of how personal computers should work?**  
I don't really know what that all means. If you say, well, how do you feel about Bill Gates getting rich off some of the ideas that we had ... well, you know, the goal is not to be the richest man in the cemetery. It's not my goal anyway.

The thing I don't think is good is that I don't believe Microsoft has transformed itself into an agent for improving things, an agent for coming up with the next revolution. The Japanese, for example, used to be accused of just copying — and indeed, in the beginning, that's just what they did. But they got quite a bit more sophisticated and started to innovate — look at automobiles, they certainly innovated quite a bit there. I can't say the same thing about Microsoft.

And I become very concerned, because I see Microsoft competing very fiercely and putting a lot of companies out of business — some deservedly so and others not deservedly so. And I see a lot of innovation leaving this industry. What I believe very strongly is that the industry absolutely needs an alternative to Microsoft. And it needs an alternative to Microsoft in the applications area — which I hope will be Lotus. And we also need an alternative to Microsoft in the systems-software area. And the only hope we have for that, in my opinion, is NeXT.

**Microsoft, of course, is working on their own object-oriented operating system —**  
They were working on the Mac for 10 years, too. I'm sure they're working on it

Microsoft's greatest asset is Windows. Their greatest liability is Windows. Windows is so nonobject-oriented that it's going to be impossible for them to go back and become object-oriented without throwing Windows away, and they can't do that for years. So they're going to try to patch things on top, and it's not going to work.

**You've called Microsoft the IBM of the '90s. What exactly do you mean by that?**  
They're the mainstream. And a lot of people who don't want to think about it too much are just going to buy their product. They have a market dominance now that is so great that it's actually hurting the industry. I don't like to get into discussions about whether they accomplished that fairly or not That's for others to decide. I just observe it and say it's not healthy for the country.

**What do you think of the federal antitrust investigation?**  
I don't have enough data to know. And again, the issue is not whether they accomplished what they did within the rule book or by breaking some of the rules. I'm not qualified to say. But I don't think it matters. I don't think that's the real issue. The real issue is, America is leading the world in software technology right now, and that is such a valuable asset for this country that anything that potentially threatens that leadership needs to be examined. I think the Microsoft monopoly of both sectors of the software industry — both the system and the applications software and the potential third sector that they want to monopolize, which is the consumer set-top-box sector — is going to pose the greatest threat to Americas dominance in the software industry of anything I have ever seen and could ever think of. I personally believe that it would be in the best interest of the country to break Microsoft up into three companies — a systems-software company, an applications-software company and a consumer-software company.

**Hearing you talk like this makes me flash back to the old Apple days, when Apple cast itself in the role of the rebel against the establishment. Except now, instead of IBM, the great evil is Microsoft. And instead of Apple that will save us, it's NeXT. Do you see parallels here, too?**  
Yeah, I do. Forget about me. That's not important. What's important is, I see tremendous parallels between the solidity and dominance that IBM had and the shackles that that was imposing on our industry and what Microsoft is doing today.... I think we came closer than we think to losing some of our computer industry in the late '70s and early '80s, and I think the gradual dissolution of IBM has been the healthiest thing that's happened in this industry in the last 10 years.

**What's your personal relationship with Bill Gates like?**  
I think Bill Gates is a good guy. We're not best friends, but we talk maybe once a month.

**A lot has been made of the rivalry between you two. The two golden boys of the computer revolution —**  
I think Bill and I have very different value systems. I like Bill very much, and I certainly admire his accomplishments, but the companies we built were very different from each other.

**A lot of people believe that given the stranglehold Microsoft has on the software business, in the long run, the best NeXT can hope for is that it will be a niche product.**  
Apple's a niche product, the Mac was a niche product And yet look at what it did. Apple's, what, a $9 billion company. It was $2 billion when I left They're doing OK. Would I be happy if we had a 10 percent market share of the system-software business? I'd be happy now. I'd be very happy. Then I'd go work like crazy to get 20.

**You mentioned the Apple earlier. When you look at the company you founded now, what do you think?**  
I don't want to talk about Apple.

* * *

**What about the PowerPC?**  
It works fine. It's a Pentium. The PowerPC and the Pentium are equivalent, plus or minus 10 or 20 percent, depending on which day you measure them. They're the same thing. So Apple has a Pentium. That's good. Is it three or four or five times better? No. Will it ever be? No. But it beats being behind. Which was where the Motorola 68000 architecture was unfortunately being relegated. It keeps them at least equal, but it's not a compelling advantage.

**You can't open the paper these days without reading about the Internet and the information superhighway. Where is this all going?**  
The Internet is nothing new. It has been happening for 10 years. Finally, now, the wave is cresting on the general computer user. And I love it. I think the den is far more interesting than the living room. Putting the Internet into people's houses is going to be really what the information superhighway is all about, not digital convergence in the set-top box. All that's going to do is put the video rental stores out of business and save me a trip to rent my movie. I'm not very excited about that. I'm not excited about home shopping. I'm very excited about having the Internet in my den.

**Phone companies, cable companies and Hollywood are jumping all over each other trying to get a piece of the action. Who do you think will be the winners and losers, say, five years down the road?**  
I've talked to some of these guys in the phone and cable business, and believe me, they have no idea what they're doing here. And the people who are talking the loudest know the least

**Who are you referring to –John Malone?**  
I don't want to name names. Let me just say that, in general, they have no idea how difficult this is going to be and how long it is going to take. None of these guys understands computer science. They don't understand that that's a little computer that they're going to have in the set-top box, and in order to run that computer, they're going to have to come up with some very sophisticated software.

**Let's talk more about the Internet. Every month, it's growing by leaps and bounds. How is this new communications web going to affect the way we live in the future?**  
I don't think it's too good to talk about these kinds of things. You can open up any book and hear all about this kind of garbage.

**I'm interested in bearing your ideas.**  
I don't think of the world that way. I'm a tool builder. That's how I think of myself. I want to build really good tools that I know in my gut and my heart will be valuable. And then whatever happens is... you can't really predict exactly what will happen, but you can feel the direction that we're going. And that's about as close as you can get. Then you just stand back and get out of the way, and these things take on a life of their own.

**Nevertheless, you've often talked about how technology can empower people, how it can change their lives. Do you still have as much faith in technology today as you did when you started out 20 years ago?**  
Oh, sure. It's not a faith in technology. It's faith in people.

**Explain that.**  
Technology is nothing. What's important is that you have a faith in people, that they're basically good and smart, and if you give them tools, they'll do wonderful things with them. It's not the tools that you have faith in — tools are just tools. They work, or they don't work. It's people you have faith in or not. Yeah, sure, I'm still optimistic I mean, I get pessimistic sometimes but not for long.

**It's been 10 years since the PC revolution started. Rational people can debate about whether technology has made the world a better place –**  
The world's clearly a better place. Individuals can now do things that only large groups of people with lots of money could do before. What that means is, we have much more opportunity for people to get to the marketplace — not just the marketplace of commerce but the marketplace of ideas. The marketplace of publications, the marketplace of public policy. You name it. We've given individuals and small groups equally powerful tools to what the largest, most heavily funded organizations in the world have. And that trend is going to continue. You can buy for under $10,000 today a computer that is just as powerful, basically, as one anyone in the world can get their hands on.

The second thing that we've done is the communications side of it. By creating this electronic web, we have flattened out again the difference between the lone voice and the very large organized voice. We have allowed people who are not part of an organization to communicate and pool their interests and thoughts and energies together and start to act as if they were a virtual organization.

So I think this technology has been extremely rewarding. And I don't think it's anywhere near over.

**When you were talking about Bill Gates, you said that the goal is not to be the richest guy in the cemetery. What is the goal?**  
I don't know how to answer you. In the broadest context, the goal is to seek enlightenment — however you define it. But these are private things. I don't want to talk about this kind of stuff.

**Why?**  
I think, especially when one is somewhat in the public eye, it's very important to keep a private life.

**Are you uncomfortable with your status as a celebrity in Silicon Valley?**  
I think of it as my well-known twin brother. It's not me. Because otherwise, you go crazy. You read some negative article some idiot writes about you — you just can't take it too personally. But then that teaches you not to take the really great ones too personally either. People like symbols, and they write about symbols.

**I talked to some of the original Mac designers the other day, and they mentioned the 10-year-annniversary celebration of the Mac a few months ago. You didn't want to participate in that. Has it been a burden, the pressure to repeat the phenomenal success of the Mac? Some people have compared you to Orson Welles, who at 25 did his best work, and it's all downhill from there.**  
I'm very flattered by that, actually. I wonder what game show I'm going to be on. Guess I'm going to have to start eating a lot of pie. [Laughs.] I don't know. The Macintosh was sort of like this wonderful romance in your life that you once had — and that produced about 10 million children. In a way it will never be over in your life. You'll still smell that romance every morning when you get up. And when you open the window, the cool air will hit your face, and you'll smell that romance in the air. And you'll see your children around, and you feel good about it. And nothing will ever make you feel bad about it.

But now, your life has moved on. You get up every morning, and you might remember that romance, but then the whole day is in front of you to do something wonderful with.

But I also think that what we're now may turn out in the end to be more profound. Because the Macintosh was the agent of change to bring computers to the rest of us with its graphical-user interface. That was very important. But now the industry is up against a really big closed door. Objects are going to unlock that door. On the other side is a world so rich from this well of software that will spring up that the true promise of many of the things we started, even with the Apple II, will finally start to be realized.

After that ... who knows? Maybe there's another locked door behind this door, too; I don't know. But someone else is going to have to figure out how to unlock that one.