> * 原文地址：[A Look into Navigation in Web Design](https://cmd-t.webydo.com/from-simple-to-unusual-a-look-at-navigation-in-web-design-1057d0baef7b#.163gvilh8)
* 原文作者：[Webydo](https://cmd-t.webydo.com/@webydo?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：
* 校对者：

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/2000/1*0FpGfLWYz660FrNzIzM5ig.jpeg">

# A Look into Navigation in Web Design #

## A retrospective on navigation patterns and an examination of where we’re heading in 2017. ##

In web design, navigation is second only to content. You need good content to sell your ideas, but that content won’t mean much if your users can’t find what they’re looking for.

Of course, that was all lost on me when I was just getting started. I was self-taught, which is going to explain a lot about the painful things you’ll read in the next few paragraphs.

Navigation, as I knew it, meant that you needed a “Home” button, an “About Us” button and a “Contact Button.” There might be more buttons depending on the site, or there might not be. Most important of all, of course, was that those buttons had to look *good*.

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*GIW8iiIbA9DkQoNzIld4Og.jpeg">

I started learning web design in the First Era of Photoshop. Those were the good old days when, as I understood it, all you needed to learn web design were a few tutorials and a working knowledge of slicing up PSDs. There was a lot of badly-generated HTML, a few iframes and the liberal use of Flash. Oh yes, Flash. To hell with SEO.

DreamWeaver and Frontpage wouldn’t display my Photoshop-made layouts correctly and their HTML and JavaScript menus made all the tables go wonky. If I wanted my hover effects to work in all browsers, I had to build my menus just the menus, mind, in Flash. I carried that bad habit for a while, even as I learned CSS, because I thought *:hover* didn’t quite work everywhere at the time. I’m only marginally comforted by the fact that the pros weren’t doing that much better.

Remember that Photoshop jockeys often used the image-based buttons, even if they weren’t using Flash. Then there were the companies that absolutely had to have their nav links orbiting their logo. I’m not even going to start listing the abominations created in the days of the Flash-based site.

#### Navigation was a jungle. ####

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*qyZqUsxinp0l8yhIOinyiQ.jpeg">

Oh, remember the lists? I mean those long, long lists of links that people used for navigation on very large sites. They were usually placed on the left side of the page and linked to every single shred of marketing material that the marketing department could think of. The very idea of a “web strategy” was practically nonexistent, so companies just threw everything they could onto a site to see what would stick.

That resulted in very, very long lists of links. When things got really bad, they’d resort to tree-style lists. This pattern was at least familiar to some, as it was basically lifted from some of the file managers of the time, but it was still unwieldy to say the least.

And then there were sitemaps. Before the days of search, before the days of contextual navigation and taxonomy-based navigation, there were sitemaps. For the youngsters, these were entire pages dedicated to listing and, if you were lucky, categorizing *every**single* internal link on the site. Some sites still have them, though now they are typically used to make it easier for search engines to crawl your content.

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*FAfChSYM926n6bZrt0xSNA.jpeg">

Navigation has come a long way and yet, it is still a problem to be solved. In fact, it’s a problem that must be solved anew for each and every website created and the considerations have only gotten more complex.

### Things change. ###

Evolution is the only true constant in the tech world. To understand where we came from and where we’re going, we have to look at *why* navigation has evolved. The standard implementations of navigation have changed for three major reasons:

#### 1. Sites have gotten smaller. And bigger. It’s complicated. ####

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*DV5pcj7VWYU0h_B6LnNhgw.gif">
](https://www.anthropologie.com/)

Ok, so on the one hand, your average brochure site (a very large portion of the web and many agencies’ bread and butter) is getting smaller. Many businesses don’t need more than a one-page site (which may or may not have any classic form of navigation at all) to get their point across, so that’s what they have. But, even if they keep the old five-page standard, people aren’t writing essays on the About Us page anymore. Customers don’t have time for that, clients don’t have time for that and designers sure as heck don’t have time for that.

The amount of text on these sorts of pages is straight up declining. Thank God. I mean, all we need to know is what you sell, where you sell it and maybe give us a price range. Just don’t forget the contact info and social media links. That’s it. That way, users find what they want faster.

On the other hand, the rise of the (mostly) user-friendly CMSs has given end users the ability to build massive sites on their own. Huge blogs are made with just WordPress and a theme. Wikis for every intellectual property imaginable are a thing.

At the enterprise level, we have Facebook and other massive web apps. The navigation for these things is basically spread all throughout the page, as there’s no single menu that could ever take you everywhere you need to go.

#### 2. Devices have changed. ####

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*VznR_0FRGiJSlmRk2iZk5Q.jpeg">

Small screens are everywhere. They come in just about every conceivable size. Navigation systems, just like every other page element, have had to adapt to this new state of affairs. It’s just a bit harder for navigation, though, as “just stacking it vertically” won’t always work.

The result has been the creation of a wide variety of new navigation patterns designed specifically for mobile and others designed to be adapt to all screen sizes. They have met varying degrees of success.

#### 3. Our users and our understanding of users, have changed. ####

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*O5h3W9hSVVqiXOPIplVCAg.jpeg">

Computers are no longer the sole domain of the enthusiast and the person who needs a computer for their job.

Just about everyone in developed countries has some sort of computer access, whether it’s a console, an aging desktop in a library, or their mobile phone. Smartphones in particular have spread all over the world and are almost the only means of connecting the Internet in some places.


Consequently, our users range from people who still have trouble using a mouse, to people who were born into technology (and have still, for some reason, never really used a mouse). As we have come to understand our users better, we’ve developed more intuitive ways of getting around a website. Our goal is not to show them everything on the site at once, but to show them the information they want, when they want it.

As a guy who loves his PCs, I am loath to admit this but… Apple helped with that. And in a big way. This idea, this goal of being able to get around the OS in three clicks at most, inspired a lot of web designers. We may not be there yet in all cases, but hey, some websites and apps are almost as complex as your average operating system.

### Where we are now: ###

Okay, this is the part with the pretty pictures. Let’s have a look at some of the navigation patterns we’re using today. Some are holdovers from the old days that still work great, others are brand new and then others are just slight variations of established patterns, adjusted to fit their context.

#### 1. Plain Navigation ####

This is your classic navigation pattern. It’s a list of links, placed near the top of the page and organized horizontally or vertically. It never stopped working, the lists just got shorter. This category also includes menu-style navigation bars.

It’s been relegated to the domain of smaller sites, usually brochure sites and eCommerce sites with a smallish inventory, because that’s where it usually works best.

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*SoZnl7HsrkXxx184aAyeEg.gif">

**Other examples:**

- [Toy Fight](http://toyfight.co/)
- [The Cool Club](https://thecoolclub.co/)
- [Ode Goods](https://www.odegoods.com/)
- [Peter Tait](https://petertait.com/)
- [Monofonts](http://www.monofonts.com/)
- [Nasty Gal](http://www.nastygal.com/)
- [Wake](https://wake.com/)

#### 2. Hidden Navigation ####

This is an artifact of our mobile-first approach to almost everything these days. It often makes sense to hide your navigation behind a button. This pattern has bled over onto the desktop, with some designers going so far as to make full-screen menus for five or six links.

It sounds kind of unnecessary, but I think that once you go so far as to hide your navigation, making the menu really big isn’t going to hurt usability in any way.

In the case of Awwwards, hiding the navigation makes sense, because they have a complex drill-down(ish) menu that needs a fair bit of space to work.

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*EG28dZE1TXtv7g8qOeeiog.gif">
](http://www.awwwards.com/)

[Awwwards](http://www.awwwards.com/)

**Other examples:**

- [Mindsparkle Mag](http://mindsparklemag.com/)
- [Kinfolk](https://kinfolk.com/)
- [Norgram](http://norgram.co/)
- [Story Trail](http://www.storytrail.co/)
- [Gooqx](http://www.gooqx.com/)
- [Pell Mell](http://www.pellmell.fr/))
- [Phil Casabon](https://philcasabon.com/)

#### 3. Hybrid Navigation ####

On larger sites, and certainly in web apps, it’s often necessary to use more than one form of navigation. The simple example of this is how It’s Nice That has some primary navigation links in the upper left corner, and hides a much more comprehensive list of links behind a hamburger button.

Sites in this category often also make heavy use of footer-based navigation. Sometimes, it’s just a repeat of menu items at the top of the page, and is used for convenience. Other times, the footer is home to secondary navigation, full of links that are useful for a smaller number of users.

People who want to change the site’s language, apply for a job, or read through privacy policies for fun (*Do people actually do that*?) might want to start there.

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*b1KELkwxiiV5h1GDmt3zrQ.gif">
](http://www.itsnicethat.com/)

[It’s Nice That](http://www.itsnicethat.com/)

**Other examples:**

- [Webydo](http://www.webydo.com/)
- [Big Youth](https://www.bigyouth.fr/en)
- [Hannah Purmort](http://hannahpurmort.com/)
- [Forth and Wonder](http://www.forthandwonder.com.au/destinations)
- [10x16](http://10x16.com/)
- [Legwork](http://www.legworkstudio.com/)
- [Aurelien Vigne](http://www.aurelienvigne.com/)

#### 4. Taxonomy-Based Navigation ####

Go look at any blog. Or news site. Or Pinterest. That’s where you’ll find this kind of navigation.

This is all about taking your users through categorized posts and other collections of information. Whether it’s categorized by topic, date, tags, or what-have-you, it’s all about helping you find more of the same kind of content.

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*rfiOS-9zXUSRR-o18PseuA.gif">
](https://24ways.org/)

[24 Ways](https://24ways.org/)

Other examples:

- [Smashing Magazine](https://www.smashingmagazine.com/) 
- [Fubiz](http://www.fubiz.net/)
- [New York Times](https://www.nytimes.com/) 
- [From Up North](http://www.fromupnorth.com/) 
- [Digg](http://digg.com/)
- [Designer News](https://www.designernews.co/)
- [The Reformation](https://www.thereformation.com)

#### 5. Experimental Navigation ####

This isn’t any one particular design pattern, but a collection of them. I like to call it Portfolio Navigation, because this sort of navigation is used most often on portfolio sites, where designers feel free to be extra creative. It’s often marked by the absence of any traditional menu, or by scattering the menu items all around the page. The corners are rather popular.

It’s also often used with a JavaScript-heavy, highly presentation-flavored approach to layout, with lots of animation. This approach to navigation often ends up hurting usability to some extent, but there’s no denying that the effect is often creative and new.

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*QhHgiWKZHwT2psPyXsn2zQ.gif">
](http://onesharedhouse.com/)

[One Shared House](http://onesharedhouse.com/)([Anton & Irene](http://antonandirene.com/) )

**Other examples:**

- [Veinti Dos Gradoes](http://www.veintidosgrados.com/work) 
- [Zero Landfill](http://www.subaru.com/csr/environment.html#!/2016/05/25)
- [Uber Ride](https://ride.uber.com/en_US/)
- [Residente](http://residente.com/en/)
- [North2](http://www.north2.net/)
- [Because](http://www.because-recollection.com/)
- [Aftershock](http://aftershock.cc/)

### Navigation in the future: ###

#### The immediate future: ####

What sort of navigation do you want to see made? Go make it! Other than that, I think people will continue to work on responsive, device-agnostic forms of navigation, because they have to. The idea of standardized screen sizes died a long time ago, after all.

I think people will begin to realize that navigation solutions for the Desktop and Mobile sizes of any design may need to be quite different, especially on large websites. So, for example, a drop-down menu may be turned into a drill-down menu later on, or something else that fits better on a small screen.

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*q3fnHV_okOBXA1oAs7y1Gw.gif">
](https://dribbble.com/shots/2724399-Virtual-reality-interfaces-GUI-Canvas)

[Alex Deruette for Kickpush](https://dribbble.com/shots/2724399-Virtual-reality-interfaces-GUI-Canvas)

I think that people’s belief in virtual reality will change some of our design patterns, too. Mind you, I don’t think VR will do much on its own. It’s a system that makes you more or less blind to the outside world and isn’t exactly mobile. For VR to take off, it needs to take off with the masses, and most of them are *not* nerds that live out of their offices, or have their offices at home.

But, for a while at least, the people who really want VR to be the next big thing will influence the way we design sites and that’s not necessarily a bad thing.

#### The more-or-less foreseeable future: ####

Slightly more palatable (and usable) to most people is Augmented Reality. It got off to a *very* rocky start with Google Glass’ terrible reception. In its more public-friendly forms like Pokemon Go, however, it took off like crazy. (Though even then, we saw some PGo-related hysteria here and there.) Given time for people to adapt, we may begin to see AR-dedicated devices that don’t get people thrown out of restaurants.

[<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*O1o8-isNluuQA89GCVplnQ.jpeg">
](http://dilussion.com/portfolio/sk-telecom-t-um-mobile/) 

[Dilusion](http://dilussion.com/portfolio/sk-telecom-t-um-mobile/) 

Another thing that’s getting bigger all the time is automation. Automated homes, self-driving cars and increasingly, our devices don’t require us to touch them to interact with them.

This will affect website navigation in a huge way, as right now, it’s mostly still very dependent on people clicking with a mouse, or tapping with a finger. That will change, with time.

As virtual assistants like Siri and Cortana become ever more intelligent and capable, people will find fewer reasons to physically interact with their devices to access information and communicate with others. We already have rudimentary voice command systems for lots of things now, and I think they’re only going to get more sophisticated.

Now, this won’t be the way *everyone* interacts with their devices, but I strongly suspect that in the future, website navigation will need to be at least as machine-friendly as human-friendly. Now there’s a challenge that should be fun.

#### What do you think the future holds? Will we see a consolidation of existing navigation frameworks or an explosion of new patterns in web design in 2017? ####

#### Author ####

[Ezequiel Bruni](https://medium.com/@ezequielbruni) ​is a UX designer​,​ writer and aspiring photographer living in Mexico. When he’s not up to his ​finely-​chiseled ears in wire-frames ​or front-end code, h​e ​makes mouth-watering ​tacos. Give him a shout out on [Twitter](https://twitter.com/ezequielbruni).
