>* 原文链接 : [RICE: SIMPLE PRIORITIZATION FOR PRODUCT MANAGERS](https://blog.intercom.io/rice-simple-prioritization-for-product-managers/)
>* 原文作者 : [Sean McBride](https://blog.intercom.io/author/smcbride/)
>* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
>* 译者 : [ZhaofengWu](https://github.com/ZhaofengWu)
>* 校对者: [lynulzy](https://github.com/lynulzy), [dongpeiguo](https://github.com/dongpeiguo)


# 给产品经理的简易优先级法则

在确立产品路线图时，优先级永远都是一个难题。你该如何决定从何处着手呢？

如果你已经花了足够的功夫来构思新的想法、寻找改善的机会、并收集反馈，你会有一个蕴含着不错想法的[可靠的路线图](httop://blog.intercom.io/where-do-product-roadmaps-come-from/)。不过，着手这些想法的顺序同样值得充分思考。你需要花一些时间来合理地确立优先级。



## 优先级是个难题


为什么确立产品路线图的顺序这么难？我们来列一下：

*   相比涉及面广的项目，实现自己个人的小想法会更令人满足。
*   相比直接影响你的目标的项目，专注于聪明的点子更有诱惑力。
*   相比已经成竹在胸的项目，跃入新的想法更令人激动。
*   你很容易忽略，某些项目可能会需要比其他项目付出更多的精力。

就算你能够完美克服这些难题，在所有项目的想法中，你还会一直需要将这些因素结合与比较。不过好在，你不需要在你的脑海中做这些事。



## 一个简单的优先级工具


这时，一个打分系统就有用了。一个好的打分系统能够清晰、系统地帮助你考虑到一个项目的想法中上述每一个因素，并将这些因素严密及统一地结合起来。


利用这样一个打分系统来确立优先级并不新鲜。现在就有很多系统用来平衡收支。不过，我在 Intercom 的团队并没有找到一个完善的系统能够让我们统一地比较诸多想法。


所以，去年八月，从最基础的原理开始，我们开始着手开发我们自己的优先级打分系统。很多次测试与迭代之后，我们确立了四个因素，以及一个将它们结合的方法。



## RICE: 四个评估优先级的因素

RICE 是我们用来评判项目想法的四个因素的首字母缩写：范围 (reach)、影响力度 (impact)、信心 (confidence)、和付出 (effort)。



### 范围


![](https://blog.intercomassets.com/wp-content/uploads/2016/03/15031653/Reach.png)


为了避免个人因素产生的偏见，你应该先估计在一段时间内每个项目影响的范围。比如对于我们团队，要估计的就是我们项目在一个季度会影响多少用户。

范围衡量的是每个时间段中的人数或事件数。它可以是"每季度的顾客量"或者"每月的交易量"。尽量使用产品现实的数据而不是随便想一些数。

#### 示例

> _项目1：每月有 500 顾客到达了这个注册过程，其中 30% 选择了这个选项。那么范围就是 500 × 30% × 3 = 450 名顾客每季度。_
>
> _项目2：每个季度所有使用这个特性的顾客都会注意到这个改变。那么范围就是 2,000 名顾客每季度。_
>
> _项目3：这个改变只会对目前的 800 名顾客产生一次性的影响，且不会持久。那么范围就是 800 名顾客每季度。_



### 影响力度


![](https://blog.intercomassets.com/wp-content/uploads/2016/03/15030742/impact.png)

为了让项目精准地实现你的目标，你需要顾及项目对于个体的影响。我们团队要问的问题就是，当顾客使用我们的项目，会使转化率提高多少。当然，你们的团队要将之改为你们的目标，比如提高使用率或使心情最佳。

影响力度很难准确衡量。所以，我采用了一个量表的形式：3 代表"巨大影响"，2 代表"高"，1 是"中等"，0.5 是"低"，而 0.25 就是"几乎没有"。在计算最终的分数时，这些数字会和系数相乘，来放大或缩小。

如此为影响力度选择一个数字似乎有些不科学，但否则如果只用直觉的话，结果会一团糟。

#### 示例

> _项目1：对于每个顾客都会有巨大的影响。影响分数为 3 。_
>
> _项目2：对于每个顾客都会有较小的影响。影响分数为 1 。_
>
> _项目3：影响力度大约在二者之间。影响分数为 2 。_

### 

### 信心

![](https://blog.intercomassets.com/wp-content/uploads/2016/03/15030748/confidence.png)

为了控制对于那些令人激动但却不明确的想法的热情，你应该考虑到你对于一些预估的信心。如果你觉得一个项目会有巨大的影响力，但是并没有任何支持的数据，该信心因素就能让你控制你的冲动。

信心是一个百分数，而我同样也用了一个量表的形式来避免选择困难症。100％ 是“高度信心”，80% 代表"中等"，50% 则是“低”。比这再低？那简直就是无稽之谈来。不过你要对自己诚实：你的预估背后究竟有多少支撑？

#### 示例

> _项目1：我们有对范围的定量计算，对影响力度的用户调研，以及对于付出精力的工程评估。这个项目就可以有 100% 的信心分数。_
>
> _项目2：我拥有支撑范围和精力的数据，但是我不太确定影响力度。这个项目就有 80% 的信心分数。_
>
> _项目3：范围和影响力度可能比预估低一点，但是精力可能会高一点。这个项目就只能有 50% 的信心分数。 _

### 

### 精力

![](https://blog.intercomassets.com/wp-content/uploads/2016/03/15030800/effort.png)

为了用最少的精力和最快的节奏产生影响，你需要估计一个项目所需的时间。你需要从每个团队成员的角度去预估：产品人员、设计师、和工程师。

精力是用"人月"这个数字来估计的——一个团队成员在一个月中可以做的工作量。这里会有很多未知的因素，所以我粗略地用整数来估计这个量（或者对于远小于一个月的工作量，就用0.5）。不像其它正面的因素，更多的精力是一个坏事。所以，我们需要用总影响力来除以这个数字。



#### 示例

> _项目1：这个项目要一周左右的计划，一两周的设计，和两到四周的工程时间。我觉得 2 人月的分数比较合适。_
>
> _项目2：这个项目要花几周时间来规划，一段较长的时间来设计，以及每个工程师至少两个月的时间。这个项目大约就是 4 人月的精力分数。_
>
> _项目3：这个项目只需要一周的规划，不用任何新设计，以及仅仅几周的工程时间。那么它就只是 1 人月的分数。_



## 合并因素，得到RICE分数

总结一下我们的四个因素：

**范围：**它会影响多少人？（在某一固定时间范围内）

**影响力度：**它会在多大程度上影响一个人？（很大 = 3x，大 = 2x，中 = 1x，低 = 0.5x，很低 = 0.25x）

**信心：**你对你的预估有多大信心？（高 = 100%，中 = 80%，低 = 50%）

**精力：**它会占用多少 "人月" ？（用整数，或者在很小的情况下，用0.5——也不用太精确）

一旦你估计好了这些因素，将它们合并成一个分数，这样你就可以一次性比较多个项目了。公式如下：

![](https://blog.intercomassets.com/wp-content/uploads/2016/03/15030740/formula.png)

得出的分数衡量了"每单位工作时间带来的影响"——这正就是我们想要最大化的。我做了一份[电子表格](https://docs.google.com/spreadsheets/d/12BY8jlCPOVav1KFocIx-wruLjO-TVE2tpLO-oFM3SDA/edit#gid=0)来随着我的估计自动计算这个分数。

[  
![](https://blog.intercomassets.com/wp-content/uploads/2016/03/15032115/spreadsheet-screenshot.png)](https://docs.google.com/spreadsheets/d/12BY8jlCPOVav1KFocIx-wruLjO-TVE2tpLO-oFM3SDA/edit#gid=0)

_你可以复制一份该表格作为自用。你也可以[下载一个 .xls 的版本](https://blog.intercomassets.com/wp-content/uploads/2016/03/15033140/RICE-scoring-example-spreadsheet-1.xlsx)_

一旦第一步计算完了分数，你就可以排序你的列表，并重新评估。有没有得分过高或过低的项目？如果有，重新考虑你的预估，并且要不然进行改动，要不然接受你的直觉可能不准。

我在过去六个月用了该 RICE 分数评估了超过 100 个项目的想法。它巨大地帮了我决定难以比较的想法。它强迫你去想为什么一个项目的想法会拥有影响力，也让你真实地面对需要付出的精力。



## 有效地使用RICE分数

当然，RICE 分数不应该被奉为金科玉律。一些得分低的项目可能也有充足的理由需要首先做。比如，一个项目可能依赖于另一个，所以后者需要先去做。或者，某个特性可能对于目标顾客是个卖点。

我们的团队有时会不按 RICE 分数的顺序来进行，这是完全没有问题的。这个打分系统只是让我们更清晰地看到取舍而已。

RICE 这样的打分系统会帮你做出基于更多信息的优先决定，也帮你向别人解释你这样做的道理。在你自己的优先级评定的过程中，试试 RICE ，并告诉我们用得怎么样！
