> * 原文地址：[Reducing Cognitive Overload For A Better User Experience](https://www.smashingmagazine.com/2016/09/reducing-cognitive-overload-for-a-better-user-experience/)
* 原文作者：[Danny Halarewich](https://www.smashingmagazine.com/author/dannyhalarewich/)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Ruixi](https://github.com/Ruixi)
* 校对者：[Zheaoli](https://github.com/Zheaoli),[Graning](https://github.com/Graning)

# 减少认知过载可以为用户带来更佳体验

最棒的用户体验是不会让用户察觉到的。它使得界面流畅易用，但成百上千的重要设计决策都是出于引导（用户），引起（用户）兴趣以及规避风险的目的。

如果用户体验设计完成了它的本职工作，（那么）用户根本不会察觉到它们究竟做了些什么。用户在界面和设计上想得越少，那他们就越能集中精力在你的网站上完成他们的目标。 你作为设计师的任务是通过预先清除障碍来为他们达成目标**铺设一条捷径**。

> “急功冒进往往会使结果欠佳。这种方式需要花费很多努力来对如此迅猛的进程作出调整。去他们所在的位置，而不是强迫人们从他们的主要任务上转移注意力。”
> 
> – Luke Wroblewski, Product Director at Google

别忘了，考虑一下其他的可能性。复杂混乱的界面迫使用户去寻找解决方案，而这原本不该是要最先做的事。面对选项，界面以及导航等等一头雾水的用户很容易在他们的思维过程中茫然无助。即便是短暂的停顿，也足以让用户回到他们正坐在电脑前的现实中去了。

这种过度的思考被称作**认知超载**, 我们在这里会讲一下怎样避开它。首先，我们需要了解一下到底是脑袋里的什么存在过载的风险。 

[![Brain](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image20.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image20-large-opt.jpg)[](#1)  

(图片： [Dierk Schaefer](https://www.flickr.com/photos/dierkschaefer/2961565820/)[](#2)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image20-large-opt.jpg)[](#3))



### 认知超载的科学根源

认知负荷是指你的工作记忆（或短期记忆）所能处理的信息总量。当你的工作记忆所接收到的信息量超过了你所能顺利处理的信息量时，认知超载就会发生，同时会导致无效的决策。

但是这究竟意味着什么？工作记忆到底是什么？这和设计又有什么联系？首先得了解一下认知负荷理论的起源。

#### John Sweller 和认知负荷理论

尽管对认知的研究可以追溯到几个世纪之前，但直到二十世纪 80 年代才被澳大利亚教育心理学家 [John Sweller](https://education.arts.unsw.edu.au/about-us/people/john-sweller/)[](#4) 应用到教学设计的研究中。Sweller 尝试了解对于任意类型的学习者存储所习得信息的最佳环境。换句话说，如何策划好一堂课？

Sweller 的工作最终结集为 1988 年出版的“[认知负荷理论，学习的难度，及教学设计（ Cognitive Load Theor,Learning Difficulty, and Instructional Design](http://www.realtechsupport.org/UB/I2C/Sweller_CognitiveLoadTheory_1994.pdf)[](#128)[](#5)” (PDF)，在 1994 年又重新出版。他的成果包括数据组织结构，被称作 [schema](https://en.wikipedia.org/wiki/Schema_(psychology))[](#6)，还大致描述了有效以及无效的教学方法，而他关于工作记忆局限性的研究结果却对设计师们很有帮助。

在许多方面，Sweller 的工作扩展了 [George Miller](http://www.psychologicalscience.org/index.php/publications/observer/2012/october-12/remembering-george-a-miller.html)[](#8)（一位二十世纪 50 年代的认知心理学家和语言学家，曾检测过短期记忆的极限）的[信息加工理论](http://www.instructionaldesign.org/theories/information-processing.html)[](#7)。Miller 的研究已经深深植根于数字化设计之中，特别是关于[组块](https://www.nngroup.com/articles/chunking/)[](#63)[](#9)的技术，本文将在稍后讨论。Miller 还创作了论文“[The Magical Number Seven, Plus or Minus Two](http://www.psych.utoronto.ca/users/peterson/psy430s2001/Miller%20GA%20Magical%20Seven%20Psych%20Review%201955.pdf)[](#10)” (PDF)，此文促使众多设计师将菜单项限定在 5 到 9 之间，尽管这个手法在数字设计中一直[被贬低](http://uxmyths.com/post/931925744/myth-23-choices-should-always-be-limited-to-seven)[](#11)。

虽然这些策略最初都是被应用于教育领域，但它们也同样适用于用户体验（UX）设计。正如我们接下来要说的：相同的增强学习和记忆的手段同样能够减少用户的烦恼。 

#### 工作记忆

要是在你每次想要打开冰箱门的时候必须得先回答一个斯芬克斯式的谜语，比如：“什么动物早上有四条腿，下午有两条腿，晚上有三条腿？”

它一会就过时了，不是吗？但根据认知负荷理论，这是一种差劲的用户体验。

[![upset 534103 960 720](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image3.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image3-large-opt.jpg)[](#12)

(Image: [Erika Wittlieb) (](https://pixabay.com/en/upset-sad-confused-figurine-534103/)[View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image3-large-opt.jpg)[](#13))



在了解认知负荷理论之前，你需要理解[工作记忆](http://www.simplypsychology.org/working%20memory.html)[](#14)，即用于在短时间内完成一项任务的大脑活动。工作记忆必须整理外部刺激和短期记忆，如果必要的话也会从长期记忆中提取（信息）。你也可以把工作记忆想象成计算机内存，把长期记忆想象成硬盘。

工作记忆和短期记忆常常互换使用，但它们之间还是有点不一样的地方。工作记忆处理对信息的加工，而短期记忆更像是一个[便笺本](http://www.human-memory.net/types_short.html)[](#15)，用于记录一些比较重要，但是又没有重要到需要调用长期记忆的信息。

我们来看一下这篇文章，解释一下这些差异。在你阅读的时候，可能会在蓝色的文本处遇到一个陌生的概念。你的工作记忆需要理解蓝色文本的概念在文中是什么意思，以便更好的理解文章的涵义。你的长期记忆知道知道蓝色文本代表链接，所以你的工作记忆知道应该去点击这里来获取更多信息。与此同时，你的短期记忆记住你在文章中读到了哪个位置，这样你就不会在从外部页面回到这个页面的时候忘了自己读到哪了；但在第二天的早上，你一准忘了那个位置在哪里。

[![photo 1456406644174 8ddd4cd52a06](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image21.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image21-large-opt.jpg)[](#16)

(Image: [Tim Gouw](https://unsplash.com/photos/1K9T5YiZ2WU)[](#17)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image21-large-opt.jpg)[](#18))



#### 在设计中的应用

很有影响力的作家 Steve Krug 就是认知负荷理论应用于网页设计的推广者之一。他的著作 [_Don’t Make Me Think_](https://www.amazon.com/Dont-Make-Think-Revisited-Usability/dp/0321965515)[](#129)[](#19) 就被许多设计师认为是一部开创性的作品。

在这本书中有很多有价值的课程，以下是我们的最爱：

*   每个页面都应该能够阐述自身，因为并不能保证用户会对你的网站进行深入了解。 
*   用户倾向于“最低要求”——即利用最简单直接的方式解决他们的问题，而非是最好的。此外，作为习惯性生物，用户总会反反复复利用同一解决方案，而不会考虑更佳的选择。
*   如果一个具有一般经验或者能力的人可以利用这套系统来实现他们的目的的话，那么易用性这方面就差不多了。
*   很多网站是被用来节省时间的。所以，用户常常会有带着类似鲨鱼“不进行下一个动作就去死吧”的心态。
*   返回按钮是 Web 浏览器中最常用的功能。
*   就算从来没用过，屏幕上的一个 Home 按钮在视觉上也会给用户一种安慰。

除了 Krug，还有很多人也阐释了认知负荷理论对涉及的作用，[包括 Nielsen Norman 集团的可用性专家](https://www.nngroup.com/articles/minimize-cognitive-load/)[](#20)。

总结一下，在浏览网站的时候用户每次不得不停下来去思考的时候——即便只是一瞬间，也会拖累他们的工作记忆。类似“这玩意儿能点吗？”“Home 按钮在哪儿呐？”“我怎么保存啊？”的问题会彻底摧毁用户体验。

### 认知超载的最常见原因

许多设计的变数都会加重用户大脑的负担，而在用户的日常生活和环境中还有更多你无法掌控的变数。一个用户可能会为第二天的工作演示或者窗外的巨大建筑噪声而忧心忡忡——不管你的网站设计得多么简单易用，这些都会榨干他们的工作记忆。

别忘了，每个用户的工作记忆的容量是不同的。心态平和的用户总是比那些吹毛求疵的人更加能够专注于你的网站。不定期上网的用户则需要比资深网民思考得更多。 

尽管我们没办法对认知超载进行量化，但我们可以通过隔离那些引起设计失误的最常见原因。下面，我们已经把网页设计中的最常见错误类型以及避免的方法整理好了。

### 1\. 不必要的动作

用户所进行的每个步骤都会增加他们的认知负荷。太多不必要的动作会搅乱用户的思路，或者让用户觉得烦躁。因为用户的工作记忆是专注于完成特定目标的，不必要的动作则迫使他们投入更多的努力，而这又会加重工作记忆的任务，有害无益。最起码，这些毫无意义的步骤会考验用户的耐心。

速度和工作节奏是最大限度减少认知负荷的基本因素。用户想要快速、精准地完成任务，所以，预先去掉（步骤间可能的）时间间隔。

[![Touch of Modern](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image17.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image17-large-opt.png)[](#21)

(Image: [Touch of Modern](https://www.touchofmodern.com/)[](#22)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image17-large-opt.png)[](#23))



用户在提交自己的电子邮箱地址之前往往喜欢弄清楚自己在登录或者注册什么东西，可是要进入 Touch of Modern 的话非得先注册不可……不管要干嘛！这个强制还非必要的第一步会吓跑一大波潜在用户的。

#### 解决方法

这有个特别棒的小练习，就是找出不必要的动作：**列出用户完成任务需要做的每一步**。比如，发一封电子邮件大概需要这样：

1.  点击 email 图标。
2.  点击“发送到”输入字段。
3.  输入 email 地址。
4.  点击“主题” 输入字段。
5.  别的杂七杂八。

现在**再看看这个清单有没有什么多余的地方**。有什么想法吗？

你可以默认光标锁定“发送到”输入框，这样彻底干掉步骤 2。这样或多或少都能让用户避免一点麻烦。你消除的每个步骤都是一场胜利。

[![Google](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image2.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image2-large-opt.png)[](#24)

(Image: [Google](https://www.google.com/)[](#25)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image2-large-opt.png)[](#26))



来我们再看看 [Google 的首页](https://www.google.com/)[](#27)。光标默认在搜索框中闪现，这样所有用户需要做的就是开始输入。这些微小的细节提升了整个体验，所以别忽视它们。

### 2\. 过度刺激

凌乱，无序还有其它的分散注意力的界面都会扰乱用户眼前进行的任务。就像在多个人同时和你说话的时候你很难集中精力一样，网页上过多的图片、动画、图标、广告、文本还有亮色调之类都在抢夺着你的注意力。

记着，一个人的工作记忆在达成目标的过程中必须通过外界刺激来进行排序。每个干扰，特别是在视觉上显得气势汹汹的那种，都需要用户调用注意力。

[![](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image1.gif)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image1.gif)[](#28)

(Image: [LINGsCARS](http://www.lingscars.com/)[](#29)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image1-large-opt.gif)[](#30))



LINGsCARS 可能是一个极端的例子，但你应该能理解这些掐架的元素有多快，比如鲜艳的颜色和运动，冲击着感官。两处设计不统一的动画效果很可能会对用户产生刺激。

#### 解决方案

新手们记住，**摆脱一切非必要之物**。只留下必要的东西一般来说还是很实用的，这样可以减少加载时间并使体验更加流畅。尤为重要的是，一项关于[美学如何影响一个网站的第一印象](http://static.googleusercontent.com/external_content/untrusted_dlcp/research.google.com/en/us/pubs/archive/38315.pdf)[](#31) (PDF)的研究发现，用户喜欢那些看上去很复杂实际上却很简单好用的网站。 

你也可以通过**改变内容**来达到某种平衡。同一类型太多（比方说文本或者图像）会让人觉得压抑。[得平衡一下视觉内容才好](http://www.itwconsulting.com/blog/the-rise-of-visual-content-and-what-it-means-for-your-web-presence/)[](#32)——图片、视频、图表，等等。让页面更加和谐，也让用户更容易理解。

影视网站 [IMDb](http://www.imdb.com/)[](#35)[](#33) 可以很容易的（单纯）依靠视觉上的内容，但它选择用几乎同等数量的文本来达到平衡。

[![IMDb](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image13.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image13-large-opt.png)[](#34)

(Image: [IMDb](http://www.imdb.com/)[](#35)[](#33)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image13-large-opt.png)[](#36))



当你整理好一个页面中的必要内容后，要用可以让用户马上理解的方式来组织这些元素。**对称或有意义的不对称布局**是在以一种可以让人更快理解的方式展示信息，就是让大脑少费点力气。对称或有意义的不对称布局不但养眼，它们的结构也让界面更容易产生互动。 

看看 [Groupon](https://www.groupon.com/)[](#39)[](#37) 是怎么利用一个特色冻酸奶交易的文字描述（右中）来抵消其菜单中的文本类别（左中）的吧？利用照片和色块来创建一个结构化的、令人满意的沙漏形状，被文本压在中间。

[![Groupon](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image27.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image27-large-opt.png)[](#38)

(Image: [Groupon](https://www.groupon.com/)[](#39)[](#37)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image27-large-opt.png)[](#40))



对称不仅仅是把相同的布局放在屏幕的两侧。它关乎[视觉重量和视觉方向的平衡](https://www.smashingmagazine.com/2015/06/design-principles-compositional-balance-symmetry-asymmetry/)[](#41)。照这种方法，非对称的屏幕布局依然是有组织的，就像 [OTHR](https://www.othr.com/)[](#44)[](#42) 在下面展示的那样。

[![OTHR](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image22.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image22-large-opt.png)[](#43)

(Image: [OTHR](https://www.othr.com/)[](#44)[](#42)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image22-large-opt.png)[](#45))



简化你的页面，只留简单的、非竞争性质的元素只是反对过度刺激的斗争的一半。不要忽视在一个简单的布局中呈现这些元素。

### 3\. 太多的选择 (希克斯定律)

这有点矛盾：用户想要很多的选择，但太多的选择会让他们不知所措。

希克斯定律（或决策无能）描述的现象：用户可选择的项越多，他们需要用来作决定的时间就越多。而 William Hick 和 Ray Hyman 首次验证他们的理论是在上世纪 50 年代，在最近的十年中，他们的研究结果已经[被数字设计重新定义](https://www.smashingmagazine.com/2012/02/redefining-hicks-law/)[](#46)。不仅有[行为研究](https://faculty.washington.edu/jdb/345/345%20Articles/Iyengar%20%26%20Lepper%20(2000).pdf)[](#47) (PDF) 证实了希克斯定律，而且最近这种现象对大脑的影响也已经[在一个 2015 年磁共振成像研究中被记录下来](https://www.researchgate.net/publication/303676802_HICK%27S_LAW_IS_MIRRORED_IN_THE_BRAIN_AN_FMRI_STUDY_OF_THE_CHOICE_REACTION_TIME)[](#48)。

以设计师的身份理解希克斯定律，把每个选项都想象成一道明亮的闪光。太多的明亮的闪光会带给用户过多的刺激，就像上文中提到的那样。

[![Rakuten](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image6.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image6-large-opt.png)[](#49)

(Image: [Rakuten](http://www.rakuten.com/)[](#50)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image6-large-opt.png)[](#51))



即使是人气网站的制作者，如乐天，也会犯这种错误。因为他们不懂原理。这就是给用户他们想要的东西，和给用户认为他们自己想要的东西之间的区别。

#### 解决方案

假设你已经摆脱了不必要的和多余的选项，你可以**将多个选项编组**。你经常在那些有广泛品类选择的电商网站上看到它们。

这不一定是很多选择，这只是一次选择很多。如果你可以隐藏一些隐藏的菜单选择，抽屉和折页，你得到的世界将完全不同。这些[大菜单](https://www.nngroup.com/articles/mega-menus-work-well/)[](#52)还是给了用户很多选项，但依然是可接受的范围，不会把他们吞没。

[![Amazon](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image15.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image15-large-opt.png)[](#53)

(Image: [Amazon](http://www.amazon.com/)[](#54)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image15-large-opt.png)[](#55))



无论如何，[对隐藏导航菜单的展示进行限制，](http://www.awwwards.com/be-careful-about-these-6-web-design-trends-in-2016.html)[](#56) 因此，电子商务和新闻等行业的设计师必须得小心。你可以通过补充页面与其他产品的方式链接到隐藏的菜单来弥补它的缺陷（如亚马逊的“相关购买”的 banner）。或者你可以简单地通过概括隐藏菜单的标题类别，直到它们在一个导航菜单中契合（苹果和 CNN 是这么干的）。

[![CNN](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image11.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image11-large-opt.png)[](#57)

(Image: [CNN](http://edition.cnn.com/)[](#58)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image11-large-opt.png)[](#59))



你也要多多留意如何将网站的导航组织为一个整体。很多希克斯定律相关的问题可以通过管理信息架构（IA）的方式来处理，我们接下来会谈到“很难找到的网页和功能”部分。

### 4\. 内容太多

就像刺激过度和太多的选择带来的问题，提供太多的内容会将用户的工作记忆拉扯到四面八方。

你当然只想显示必要内容，但对于一些综合性的网站，一切都是必不可少的。如果你的内容很多，那么你必须学会如何组织它，不给用户带来压力。

[![Arngren](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image24.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image24-large-opt.png)[](#60)

(Image: [Arngren](http://www.arngren.net/)[](#61)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image24-large-opt.png)[](#62))



Arngren 的问题不在于它提供的产品太多，而在于它同时提供的产品太多。多一点的结构和组织会为网站的外观创造奇迹。

#### 解决方法

如上所述，George Miller 的策略[组块](https://www.nngroup.com/articles/chunking/)[](#63)[](#9)是以可控的方式呈现大量的内容。分组数据的技巧使它很好记。一个电话号码被分解为国家代码，区域代码，一组三个数字和一组四个数字——一串 11 个或更多位数太难记了。

你想把很多的产品图像作为你的网上商店的主页的特征吗？别把它们全部列在单独的行和列中，**根据他们的类型进行编组展示**。[Etsy](https://www.etsy.com/)[](#66)[](#64) 通过根据卖方分组，他们能够在其主页上显示更多的产品。

[![Etsy](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image18.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image18-large-opt.png)[](#65)

(Image: [Etsy](https://www.etsy.com/)[](#66)[](#64)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image18-large-opt.png)[](#67))



[文本块](https://en.wikipedia.org/wiki/Chunking_(writing))[](#68) 包括短段落，充分利用了标题和副标题，以及充足的空间。

如果表单很长而且所有数据是必须的话，试试[步骤拆分](http://webdesign.tutsplus.com/articles/build-a-multi-step-form-interface--webdesign-11715)[](#69)。冗长的表单可能会很带有威胁性，有时甚至会导致（用户）放弃网站。**将表单的信息拆分到独立的页面**，或者至少分成独立的部分，  让它看起来没那么吓人。不过一定要包括一个进度记录，让用户知道还有多少页。

[![Virgin Atlantic](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image19.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image19-large-opt.png)[](#70)

(Image: [Virgin Atlantic](https://www.virgin-atlantic.com)[](#73)[](#71)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image19-large-opt.png)[](#72))



买机票需要填写一大堆资料，其中没有一个是可有可无的。[Virgin Atlantic](https://www.virgin-atlantic.com)[](#73)[](#71) 通过将它分解成独立页面中的不同步骤来提升原本漫长无聊的体验：选择航班，填写乘客信息，进入付款详情，等等。把所有步骤都放在一个长页中的话会压垮一些用户，还会增加放弃的可能。

### 5\. 含糊的界面

在认知过载上的罪魁祸首就是混乱的用户界面。用户不应该花很长时间去思考如何完成他们想要的动作，也不该浪费脑力去解读一个图标。

[![SpeedCrunch](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image10.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image10-large-opt.png)[](#74)

(Image: [SpeedCrunch](http://speedcrunch.org/)[](#75)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image10-large-opt.png)[](#76))



并不是所有的用户都对技术熟悉到能够理解 SpeedCrunch 含糊的图标。就算他们对电脑了解得够多，认识 Windows 和 Mac OS X 顶部的符号，这两个右下角的图标在甚至能让 Alan Turing 花点时间。

#### 解决方法

不要重复造轮子：使用来自其他网站的**用户已知的可视化提示**。用户依靠共同的[隐喻和符号](https://www.smashingmagazine.com/2014/06/affordance-most-underrated-word-in-web-design/)[](#77)来了解控制，即使在他们之前从未去过的网站上也是如此。

要是觉得这太过压抑，你可以给这个**熟悉的模型一个带有鲜明特色的、截然不同的特征**。[Home Depot](http://www.homedepot.com/)[](#80)[](#78) 采用了常见的图标，但采用了他们品牌标志性的橙色。

[![](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image5.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image5-large-opt.png)[](#79)  

(Image: [Home Depot](http://www.homedepot.com/)[](#80)[](#78)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image5-large-opt.png)[](#81))



这同样适用于微观细节。按钮和**标准标签**比如“联系”和“提交”就比非常规的标签如“地址”或者“前往”更容易识别。一般来说，已知的标签使用户的浏览体验更加流畅，而不常见的则让用户停下来思考这个按钮是做什么的。

如果你有一个以前从未见过的功能怎么办？那样的话，**利用现实生活中的表现，让它不解自明**。拟物化，正如其名，[联结](https://www.quora.com/Why-do-we-use-the-envelope-as-an-icon-for-email-and-why-do-we-use-the-floppy-disc-icon-for-the-save-function)[](#82)[现实](https://www.quora.com/Why-do-we-use-the-envelope-as-an-icon-for-email-and-why-do-we-use-the-floppy-disc-icon-for-the-save-function)[](#83)和[数字效果](https://www.quora.com/Why-do-we-use-the-envelope-as-an-icon-for-email-and-why-do-we-use-the-floppy-disc-icon-for-the-save-function)[](#84)。举个例子，早期的互联网先驱们选择了一个信封来代表电子邮件，因为信封是一个明显的标志的邮件系统。

此外，**避免含糊的符号**，特别是他们可能被误认成别的或是带来其它的困惑。下面，有些 [Issuu](https://issuu.com/)[](#87)[](#85) 的图标很容易识别，但其它的不行。如果用户必须点击一个图标才能发现它的功能，那么它们会被淘汰掉。

[![Issuu](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image14.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image14-large-opt.png)[](#86)

(Image: [Issuu](https://issuu.com/)[](#87)[](#85)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image14-large-opt.png)[](#88))



用一种**全新的眼光**来做设计，确保你没有遗漏任何明显的东西。

看一下 Denis Kortunov 的 [10个常见的图标错误](http://turbomilk.com/blog/cookbook/icon_design/10_mistakes_in_icon_design/)[](#89)的列表，一些不要做的细节——例如，图标太相似，或各自都过于复杂。

任何不够直观的界面应包括[**新手教程**](https://www.useronboard.com/)[](#90) 来告诉用户界面怎么用。简单的网站可以弄一个单独的窗口，特别是如果有一个使人印象深刻的图形来解释功能的话。然而，新的和特殊的界面需要一个更实际的教程。比如，[Slack](https://slack.com/is)[](#93)[](#91) 提供了一个完整的视频介绍，解释发生了什么。

[![Slack](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image8.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image8-large-opt.png)[](#92)

(Image: [Slack](https://slack.com/is)[](#93)[](#91)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image8-large-opt.png)[](#94))



### 6\. 很难找到网页和功能

即使用户已经拥有了想要的一切，他们还是很可能找不到。这种状况比功能残缺好不了多少。而底线则是用户需要花些力气来思考需要做什么。

作为用户体验不可替代的一部分，导航应该是简单而无压力的。网站的导航应该是直观的，让用户有一种自在漫游而不必担心迷失的自信。这不仅需要 IA 的额外工作，还需要谨慎地运用。以便让它看上去比实际上的还要简单。

[![Mojo Yoghurt](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image4.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image4-large-opt.png)[](#95)

(Image: [Mojo Yogurt](http://mojoyogurt.com/#/home)[](#99)[](#96)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image4-large-opt.png)[](#97))



如果你觉得汉堡图标很差劲的话，Mojo Yogurt 则需要你悬停在左上角的 LOGO 那里来显示导航菜单。

[![Mojo Joghurt](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image25.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image25-large-opt.png)[](#98)

(Image: [Mojo Yogurt](http://mojoyogurt.com/#/home)[](#99)[](#96)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image25-large-opt.png)[](#100))



值得肯定的是一个沿 logo 描边的加载导航的小动画。但在屏幕上有如此之多的色彩和动效的前提下，这么一点含混的提示是不够的。

#### 解决方法

**根据你的用户的喜好来整合你的信息。**你的目标用户可能并不会按照你的方式来，所以还是和他们学着点怎么组织一个网站吧。 [卡片分拣](https://www.smashingmagazine.com/2014/10/improving-information-architecture-card-sorting-beginners-guide/)[](#101)会展示出你的用户将如何对一些页面和主体进行分类。[树测试](http://www.measuringu.com/blog/tree-testing-ia.php)[](#102)可以评估用户对你现在的或者准备采用的模式理解如何。

[![3344341528 9c6ca35c88 o](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image9.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image9-large-opt.jpg)[](#103)

(Image: [Rosenfeld Media](https://www.flickr.com/photos/rosenfeldmedia/3344341528/)[](#104)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image9-large-opt.jpg)[](#105))



要想速成 IA，还是读一下 Dan Brown 的 《[信息架构的八个原则](https://www.asis.org/Bulletin/Aug-10/AugSep10_Brown.pdf)[](#106)》 (PDF)。在短短的五页内，他就解释了八个十分明确、每个设计师都应该知道的关于 IA 的原则。比如多重分类的原则（即，使用不同的分类方法来适应用户的不同思维方式）和披露原则 (即，透露刚好能让用户知道接下来会发生什么的信息)。

你应该也想**通过合并页面或菜单项来去除冗余**。例如，你不需要为每个团队成员都执行不同的页面——他们可以在同一页面。[Waaark](http://waaark.com/studio/)[](#109)[](#107) 设计工作室通过合并其团队成员介绍，BIOS 和联系信息为同一页面中的三屏来简化了导航。

[![Waaark](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image16.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image16-large-opt.png)[](#108)

(Image: [Waaark](http://waaark.com/studio/)[](#109)[](#107)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image16-large-opt.png)[](#110))



如果某些功能或特性比其他的部分更重要，那就**使用视觉技巧来吸引他们的注意力**。放大，添加动画，还有使用一种招摇或对比鲜明的颜色都可以吸引用户的眼睛。用一种[新颖的方式](http://conversionxl.com/how-to-grab-and-hold-attention/)[](#111)来展示信息，特别是带一个相关的图像，还有很重要的一点，保证它能被看懂。

[![PayPal](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image12.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image12-large-opt.png)[](#112)

(Image: [PayPal](https://www.paypal.com/)[](#113)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image12-large-opt.png)[](#114))



PayPal 希望拥有比新用户更多的老用户，而且特意把登录按钮放在抓人眼球的空白背景上来满足老用户的需要。

### 7\. 内部矛盾

再来说说一个网站的主页使用标准的蓝色和下划线的文本来表示一个链接，但另一个页面只使用蓝色却没有下划线的情况。即使用户并没触发第一个链接，他们也可能会在第二个页面那里停下来想：“这里没下划线啊，是链接吗？” 他们可能并不在意这个环节，但这个前后不一致造成影响的瞬间就破坏了整体的体验。

拼写和语法错误带来的影响也是一样的。记住：最好的用户体验是看不见的，但错误总会被察觉。

一个元素是否与网站的其他部分，与其他网站（不太对的时候，比如界面样式）或与用户的语言和语法知识不一致都没关系。在这些情况下，用户必须花时间来思考和处理，而这又耗费了工作记忆。

[![SIPhawaii](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image26.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image26-large-opt.png)[](#115)

(Image: [SIPhawaii](https://siphawaii.com/)[](#116)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image26-large-opt.png)[](#117))



SIPhawaii 是大写、字体大小和价格数字的集中地。你甚至都不想知道在点了汉堡按钮之后会发生什么事情——我只能说，它肯定和其它网站的汉堡按钮长得不一样！

#### 解决方案

整个网站保持格式一致。这事做起来可没有说的那么简单，因为这种错误往往是在无意中犯下的。

一份保持一致性的**风格指南会发挥奇效**。它收集了全球所有的设计决策，当设计师需要的时候可以很方便的快速访问。如背景颜色的代码值，图像的尺寸或字体的标题这类细节很容易被遗忘，所以使他们随时可用会很有帮助。

[![Lonely Planet](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image23.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image23-large-opt.png)[](#118)

(Image: [Lonely Planet](https://rizzo.lonelyplanet.com/styleguide/design-elements/colours)[](#119)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image23-large-opt.png)[](#120))



关于建立风格指南的更多信息，请阅读我们在创建中的[深入概述](https://www.smashingmagazine.com/2015/04/an-in-depth-overview-of-living-style-guide-tools/)[](#121)和[实例分析](https://www.smashingmagazine.com/2016/05/creating-a-living-style-guide-case-study/)[](#122)。

至于拼写错误和语法错误，**不要只依赖拼写检查**。永远在发布之前再过一遍你的内容。免费应用 [Grammarly](https://app.grammarly.com/)[](#123) 可以帮你指出那些很难看出的错误。

视觉和功能一致这方面一个很好的例子是 [Pinterest](https://www.pinterest.com/)[](#126)[](#124)。不管在你的推送中的图片是什么风格，样式都是一致的。

[![Pinterest](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image7.png)](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image7-large-opt.png)[](#125)

(Image: [Pinterest](https://www.pinterest.com/)[](#126)[](#124)) ([View large version](https://www.smashingmagazine.com/wp-content/uploads/2016/08/cognitive-overload-image7-large-opt.png)[](#127))



标题，描述，作者，网站，Pins 和活动在同一位置的每一张卡片上都显示同样的文本大小和排版。这给 Pinterest 带来了交错的视觉吸引力，也没有让用户感到困惑。只要你明白了一张卡片，那你就弄明白了所有东西。

### 再说两句

Steve Krug 那句著名的口号“别让我思考” 或多或少也是用户在体验上的呐喊。好的用户体验设计是流畅的。任何碰撞的方式-如认知过载-将拖累整个航程。设计师要抓住任何机会满足他们的用户，所以不要让用户思考任何非必需的事情。

这一下子说的有点多了吧？这里再来几句总结好了，别让你认知过载：

*   认知负荷即工作记忆所消耗的信息。认知过载即过多的信息影响到了决策和一般经验。 
*   通过一系列的内容类型和结构化的页面组合来避免视觉上的混乱。
*   隐藏菜单可以帮助用户管理同时可选择的项的数量，但有发现成本。
*   如组块化和步骤拆分的小技巧可以防止认知过载。
*   可辨认的UI元素和复用元素调用的是户现有的知识，所以他们不用怎么思考。新的和独特的功能，可以通过新手指南来讲解。
*   在你的用户实际上如何思考的基础之上建立你的信息架构。像卡片分拣和树测试这种可用性测试手段可以为你的目标群体提供最直观的指导方案。
*   在视觉效果和功能上的不一致，以及拼写错误和语法错误，都是会分散用户注意力的罪魁祸首。
*   尽可能消除冗余。还有，在怎么减少用户需要做的步骤以及减轻他们所需要花费的努力上也要多多留意。

(顺便，斯芬克斯谜语的谜底是 “人”: 婴儿的时候爬着走，成年之后直立行走，老年的时候拄个拐杖。)

### 扩展阅读

*   “[Cognitive Load Theory, Learning Difficulty, and Instructional Design](http://www.realtechsupport.org/UB/I2C/Sweller_CognitiveLoadTheory_1994.pdf)[](#128)[](#5)” (PDF), John Sweller  
    这是 Sweller 的教学设计发展研究的论文原文。有点偏学术，但很好地解释了人类思维和记忆的内部过程。  

*   [_Don’t Make Me Think_](https://www.amazon.com/Dont-Make-Think-Revisited-Usability/dp/0321965515)[](#129)[](#19), Steve Krug  
    这是最先开始讲述如何将认知负荷的科学原理应用到网页设计中的那本书。  

*   “[The Magical Number Seven, Plus or Minus Two: Some Limits on Our Capacity for Processing Information](http://www.psych.utoronto.ca/users/peterson/psy430s2001/Miller%20GA%20Magical%20Seven%20Psych%20Review%201955.pdf)[](#130)” (PDF) George A. Miller  
    只要你不去纠结于字面(理论已被揭穿的[网页设计](http://uxmyths.com/post/931925744/myth-23-choices-should-always-be-limited-to-seven)[](#131)), 这篇论文对人们如何思考和人类记忆的局限性都提供了有益的见解。this scientific paper offers beneficial insight into how people think and the limits of human memory.  

*   [_100 Things Every Designer Needs to Know About People_](https://www.amazon.com/Things-Designer-People-Voices-Matter/dp/0321767535/)[](#132), Susan Weinschenk  
    如果你想弄清楚你的用户都在想什么的话，这个前行为心理学家对人类的思维模式提出了一些见解，设计师们可以直接应用。
