> * 原文地址：[Push for a point of view](https://theindex.generalassemb.ly/product-design-tips-google-dropbox-slack-airbnb-510eb52fb623#.1dsp91amn)
* 原文作者：[John Saito](https://theindex.generalassemb.ly/@jsaito)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者： 
* 校对者：

---

# Push for a point of view.

## What I learned from designers at Google, Airbnb, Slack, and more.

![](https://cdn-images-1.medium.com/max/2000/1*vLlJ6dMA7MQP2tFMENfgYw.jpeg)

One thing I’ve learned about design is that you can’t please everyone. You can try, but you’ll end up with a watered-down design that won’t please anyone.

When you try to make everyone happy, you’ll lose focus. You’ll build pointless features that people don’t need. You’ll write fluffy words that people won’t read.

Good design is all about having a clear purpose. It’s about having a strong point of view—even if you might ruffle some feathers along the way.

Over the past month, I’ve been chatting with people who have a strong point of view in their design — people from Google, Airbnb, Slack, Dropbox, and more. I wanted to peek inside their noggins to see what drives their decisions and informs their designs. Below are a few things I learned.

### 1. Start with questions, not answers.

Ever sign up for a new service and then forget your password the next day? It’s happened to me countless times. If I asked you for help, what would you suggest I do?

Some people might tell me to just write down the password. Easy-peasy, problem solved. But security experts [don’t recommend writing down the password](https://www.us-cert.gov/ncas/tips/ST04-002). It just isn’t very secure.

> Good designers don’t jump to solutions. They take the time to understand the problem.

So what would a designer do? Good designers don’t jump to solutions. They take the time to understand the problem. They ask questions to figure out the causes, the context, and the constraints: How do you usually keep track of passwords? Do you always carry your phone with you? How many passwords do you have?

The more you understand the problem, the easier it is to develop a point of view about how to solve the problem. Understanding is what gives you confidence. Understanding is what turns an idea into a point of view.

I asked Adriana Olmos, a product designer on [Google Assistant](https://assistant.google.com/), about her approach to solving problems. When her stakeholders ask for things, they often position their idea in terms of the solution, instead of the problem. “I spend time trying to understand the rationale behind what they’re trying to solve for,” she says. “From there, I work with them to change or iterate on the initial request to map it to the ‘why’ of the user. Understand the why, and the how will follow.”

By understanding the ins and outs of the problem, you can develop a stronger point of view about how to solve that problem. 🙋

![](https://cdn-images-1.medium.com/max/1600/1*fm4nOlvjvXLCmn-vm0HwlA.png)

### 2. Design for this, not that.

When kicking off a project, it’s pretty common for designers to list out their design goals: This is the problem we’re trying to solve. This is what success looks like.

But it’s a good idea to also list out your *non-goals*: This is a problem we’re *not* trying to solve. This is what our product *isn’t* meant to do.

By defining non-goals, you can focus on your main problems without getting bogged down by that murky monster known as “scope creep.” That’s when extra features start creeping into your project, diluting your original design.

Erica Morse, a lead designer at [Change.org](https://www.change.org/), tells me about a non-goal that helps her stay focused. Change.org is a community-driven platform. You might think supporters of Change.org would want to connect with other supporters, right? Well, according to her research, most paying supporters didn’t want to use the site to connect with one another.

“Whenever this idea of creating community among members comes up, I reference the research we did to explain why we’re not focusing on it,” Erica explains.

Defining non-goals helps you stay focused on your main goals, and that makes your design stronger. 💪

![](https://cdn-images-1.medium.com/max/1600/1*mHJWZBeSxjCcyN8pJNtdkQ.png)

### 3. Fight for your users.

As a product designer, you have to juggle the needs of your business and the needs of your users. But sometimes, those needs are in direct conflict with each other, and you have to choose a side.

I’ve learned that the strongest designs are the ones that focus on users. I know we all gotta get paid, but let someone else at your company fight for the needs of the business. A designer’s job is to fight for your users.

On the web, autoplaying videos have been around for years. Businesses tend to love them, because they lead to more exposure. Users tend to hate them, because they’re annoying.

> The strongest designs are the ones that focus on users. I know we all gotta get paid, but let someone else at your company fight for the needs of the business.

Years ago, [TED.com](http://ted.com) had autoplaying videos on their site. But TED’s UX architect, Michael McWatters, and other members of his team were determined to get rid of autoplay. Michael even wrote a [manifesto against autoplay](https://medium.com/@mmcwatters/autoplay-blues-9f41564fe030#.6sv8rpvkj), pointing out problems like bandwidth consumption and accessibility issues. After a lot of healthy debate, they decided to do what’s right for users and got rid of autoplay. Praise be!

Michael explains, “Although autoplay guarantees videos start playing with each visit — good for business— it’s also a really bad user experience. While the decision to kill autoplay may not seem bold to people outside the org, when your business depends on video views, removing it was actually a fairly fraught, risky proposition.”

Thanks for fighting for your users, Michael. ✊

![](https://cdn-images-1.medium.com/max/2000/1*TphrQus4tjhWuouhHdXrjA.png)

### 4. Be bold, be brave.

If you work on software, you might be familiar with the phrase “release early, release often.” The general idea is that it’s better to release updates as quickly as possible, and then improve on them over time.

The problem with this approach is that it can lead to half-baked ideas instead of big leaps forward. If you’re not careful, you could end up making hundreds of insignificant improvements, instead of working on things that really matter. Constant tweaks can lead to a weak design and an indecisive point of view.

Over at [Airbnb](http://www.airbnb.com), Michael Austin Sui works on the company’s big, bold [Design Language System](http://airbnb.design/the-way-we-build/) — a unified design system for all of Airbnb. “We like bold moves!” Michael says. “As a recovering, risk-averse perfectionist, I’ve grown to embrace the adventure that comes with an innovative company, inspired by the daring ideas of my colleagues.”

[![](https://cdn-images-1.medium.com/max/1200/1*y68cFzxUNENOjoRNDjty2g.png)
](https://generalassemb.ly/hello/medium?utm_medium=social&amp;utm_source=blog&amp;utm_campaign=saitoPOV)

He tells me about what it took to launch [Airbnb Trips](https://www.airbnb.com/new). Instead of just focusing on accommodations, Trips focuses on the whole trip experience, bringing together where you stay, what you do, and the people you meet—all in one place.

“It was a significant shift for Airbnb’s product, guests, and hosts. After developing Airbnb Trips for about a year, when the time came to launch, we knew we had to shift hard together to give this new idea the best chance of succeeding. That was one major learning from that launch: When you make a bold shift, shift hard.”

Their big shift seems to be paying off. Industry experts are saying that [Airbnb just recently turned a profit](https://www.cnet.com/news/airbnb-first-profit-home-rental-travel-startups/) and is expected to stay profitable throughout 2017.

Think of some of your favorite designs. Do they play it safe, or do they take big risks? Chances are, your favorite designs are the ones that have big ideas and a strong point of view—the ones that take big risks. 🎲

![](https://cdn-images-1.medium.com/max/1600/1*1rM7k8-IKq83FaHtyzxdIw.png)

### 5. Don’t just build what people ask for.

There’s a famous quote from Steve Jobs where he said, “A lot of times, people don’t know what they want until you show it to them.”

When I first heard that, I always thought it sounded cocky. After all, I know myself better than anyone else. Of course I know what I want, silly!

It took me a while, but I now get what he was saying. A lot of times, we’re constrained by what we know, and we forget there might be better ideas we never even thought of.

I recently had a few Polaroid photos that I wanted to transfer to my laptop. If you had asked me what I wanted, I would’ve asked for a flatbed scanner, so I could scan them to my laptop. But then Google came along and created the[ PhotoScan](https://www.google.com/photos/scan/) app, which lets you scan photos right from your phone. The app turned out to be a much faster, easier solution—even though I never asked for it.

[Gusto](https://gusto.com/) is a product that helps business owners take care of payroll, benefits, and other HR tasks. The company’s design team makes big bets on creating features that people aren’t asking for, but will make their lives better.

They recently released [employee happiness surveys](https://gusto.com/blog/the-pursuit-of-employee-happiness/) in which they ask employees a simple question: How happy are you at work? “The results are surprisingly insightful,” says Val Klump, a writer on Gusto’s design team. “The businesses who’ve tried it love it, but no one asked us to build it.”

They predicted what people wanted before people even realized it. 🔮

![](https://cdn-images-1.medium.com/max/1600/1*VnEMUZTnmIdIas6M_J8SXw.png)

### 6. Know when to shine.

To have a strong point of view in design, you need to know who you are as a brand. What’s your personality? Are you more Beyoncé or Bublé? Coldplay or Kanye?

But when it comes to product design, knowing your personality isn’t enough. You also need to know *when* to show your personality, because too much personality gets in the way of usability.

Let’s say you have a button that says “Start tour.” If your brand is all hip and happenin’, you could rewrite this as “Let’s get crackin’!” This sounds a lot more fun, but it’s also confusing. It’s not clear if clicking that button will start a tour, ask you to sign up, or show you a clip from *The Nutcracker*.

> Showing your personality helps you earn brownie points with your users, but you’ve got to know when to dial it up and when to play it cool.

A lot of people love [Slack](https://slack.com/) for the playful copy in its product. The team at Slack understands that words are an integral part of the product’s design, so they have a group of product writers on their design team. Sara Culver, who leads the product writing group, explains the challenge of having to juggle clarity with personality. “We want to preserve personality in the product — but we have to find the best places to do it, where a user is least likely to become frustrated, confused, or annoyed.”

Sara goes on to give me an example: “We recently had a fun session where we all wrote different versions of the same error message — a pretty obscure one that only power users of Slack will ever see, so we wanted it to be playful. We ended up not being able to choose a winner, and are going to try to implement them all in a rotating way, so a user could see a different one each time.”

Showing your personality helps you earn brownie points with your users, but you’ve got to know when to dial it up and when to play it cool. 😎

![](https://cdn-images-1.medium.com/max/1600/1*g6hIzKdQ-9MT3NawbaC5cA.png)

### 7. Believe it, build it.

Part of a designer’s job is to explore multiple ideas to solve a problem. Then, you weigh the pros and cons until you find a direction that works.

But chances are none of your ideas are perfect, and that’s when you start to make compromises. You add an extra button here. You add extra text there. You optimize for edge cases. Suddenly, your design becomes a hot mess.

So what should you do instead? Sometimes you just need to pick a direction you believe in and build it.

David Kjelkerud, a design director at [Dropbox](https://www.dropbox.com/), tells me about an experiment his team ran on the Dropbox homepage a while ago. Instead of showing everyone an A–Z list of files and folders, a small percentage of people saw a list of recently viewed files with inline previews. The assumption was that people would quickly scan the previews and pick up where they left off.

Ultimately, this direction didn’t work because recent files weren’t always the most relevant files. So instead, they pursued a different direction. “But we learned a lot that we wouldn’t have unless we built and released it,” David says. “It’s important to follow your conviction even if the chance of failure is big. Even if you don’t reap the big reward, there’s always learning to be had. I encourage teams to take risks, build, ship, and learn. As long as you’re learning, you’re getting closer.”

Even to this day, their learnings from that experiment are helping to shape new projects. More than a year later, people at Dropbox are still looking back at that experiment for ideas and inspiration. ⚡️

![](https://cdn-images-1.medium.com/max/1600/1*y5ZlhgVy9Sh-93kdm39P6g.png)

### 8. Push for what’s right.

All my life, I’ve lived in shadows. I never caused trouble. I never picked fights. I was that quiet Asian kid in the back — the one who never made a fuss. I just wanted to make sure everyone was happy.

It took me years to realize this, but I now know you can’t make everyone happy, no matter how hard you try. You can’t design for every possible use case, and you can’t please everyone in the room.

Now, more than ever, I’m learning that you need to have a point of view if you want to make progress. You need to ask questions, you need to understand “why,” and you need to fight for what you believe in.

These are crazy times we live in. When we see problems, we need to push for a point of view and push for what’s right. It’s the only way to make things that matter. It’s the only way to design.