>* 原文链接 : [E-Commerce UX: What Information to Display in Product Listings (46% Get it Wrong)](http://baymard.com/blog/product-listing-information)
* 原文作者 : [Jamie](http://baymard.com/blog)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [godofchina](https://github.com/godofchina)
* 校对者:[joddiy](https://github.com/joddiy), [Ruixi](https://github.com/Ruixi)

# 电商列表信息展示，你真的懂吗？

![](http://assets.baymard.com/research/media_files/attachments/17301/original/research-media-file-f6c7249aa471651b567e784d21ca6238.jpg)</div>

_“我想有一种可以比较的方式，因此我可以不用点这个，再点返回，点那个，再点返回，点点点..”_ 一个顾客解释道，他想给自己的笔记本电脑找个包, _“除了价格和商品名称我在这找不到一点有用的信息。”_ 注意 Zappos 的多半电脑包描述里根本没有或只有模糊的有效尺寸描述，像 “大”。

用户基于产品列表里关于这些产品的**有效信息**来选择是否购买这些商品。因此在我们经过大规模的[产品列表和筛选](http://baymard.com/research/ecommerce-product-lists)可用性学习后毫不奇怪地发现贫乏的列表项信息是关于产品列表导航的最严重的可用性问题。

通过测试，我们发现信息过少或信息相关性过低的列表项很有问题，因为用户在缺少这些商品的基本信息的情况下是**无法进行适当评估的**。这会导致受测对象完完全全地误解了相关产品，并导致他们在产品页和列表页之间不必要的来回跳转 – 他们不得不返回继续一遍刚才的操作, 打开列表页的每个产品只是为了了解它的基本属性和核心特征; 这个令人不快的实践经常导致受测对象放弃访问站点，因为简单地定位相关产品的矛盾太突出了。 显而易见，在每个列表页展示正确的数量和正确的类型信息对提升用户的产品查找体验是至关重要的。

另外，在产品列表页确认展示哪种类型的信息以及展示数量是个大问题 , 就像我们全美 Top 50 的电商网站的[产品清单列表](http://baymard.com/ecommerce-product-lists/benchmark/site-reviews)  所显示的，这些网站中的 46% 都有展示内容过少或展示信息选择不当的毛病。(一小部分网站则截然相反，他们在列表项上展示了过多的信息!)

![](http://assets.baymard.com/research/media_files/attachments/17287/original/research-media-file-0f8ef662d7a97428d80c08682f3f36ca.jpg)</div>

测试期间发现，[Gilt](http://baymard.com/ecommerce-product-lists/benchmark/site-reviews/228-gilt) 没有展示了列表信息的关键部分:  可选商品的种类！这导致了多个测试受试者拒绝购买商品，因为他们认为该商品只有显示颜色的有货，实际上它有多种颜色可选择。

![](http://assets.baymard.com/research/media_files/attachments/17288/original/research-media-file-61b54f07f843f261b3958b95261848b5.jpg)</div>

除了所有常见的“通用”属性， [Crutchfield](http://baymard.com/ecommerce-product-lists/benchmark/site-reviews/254-crutchfield) 在特定分类的属性也存在严重的问题 – 那就是和产品类型相关的唯一信息。举个例子，the ‘X-watts-RMS’ 和 ‘filter pass’ 属性只和汽车扩音器相关，也因此仅仅在这些栏目中被展示。同时，这个站点的其他种类的所有产品也仅仅只展示了垂直向的唯一相关性。

在列表项中获得一个好的**信噪比**对提升用户找到他们想要找到商品的能力至关重要。然而很明显这并不容易。它需要仔细斟酌要展示产品属性的提炼。这篇文章里我们会为大家呈现从我们的[产品列表和筛选](http://baymard.com/research/ecommerce-product-lists)学习针对如何准确地评估产品列表里信息的展示量和种类得到的测试发现。

_(注意以下的发现同样适用于种类列表和搜索结果。)_

## 列表项信息: 平衡操作

无论如何展示在产品列表里的信息是用户评估和判断产品适用性的基础。因此产品列表不应该被浪费。列表里的每个元素都应该被**精斟细酌**，呈现给用户最适合他们挑选的条件。一个成功的产品列表设计应满足以下两点要求:

*   展现给用户**足够的产品信息**以适当地评估产品的适用性（针对他们的独特需求）,
*   让用户把**产品列表**当成一个整体对待(i.e. the options available to them)，并可以把有兴趣的产品和另一个产品拿来对比。

前者是每个产品要展示充分的产品信息然而后者产品要在用户的屏幕上展示足够的产品数量。于是就造成了一个**进退维谷**的情况，如果每个产品的信息展示过多，会导致每页展示的产品数量下降。然而产品数量太多又会造成单个产品展示足够的信息变的相对困难，导致过多的来回跳转。

![](http://assets.baymard.com/research/media_files/attachments/17289/original/research-media-file-6debb0c41567623c2fbccb372f972d1c.jpg)</div>

从我们的大规模眼部追踪学习中明显得知, 当用户在浏览视觉导向的产品时极度倾向于关注产品缩略图。(这里我们可以看下 [REI](http://baymard.com/ecommerce-product-lists/benchmark/site-reviews/247-rei) 32个主题的热力图，点击量，总观察时间)

因此产品列表设计不是一个“少即是好”的事情而是一个“刚好合适才是好”的事。找出哪些属性应该被展示在列表项里哪些不应该被才是应该做的事，但是没有硬规则。一个好的列表项应该通过提供充足的信息来帮助用户准确评估列表中哪些是与用户相关的， – 同样重要的是 – 哪些应该被略去。列表信息应该更好地帮助用户对比相关产品。它本质上是一个实践：不要用过于膨大的产品列表来最大化信息的精髓和产品的对比性。

现在我们通过研究发现，有**两组**属性应该被包含在列表项中：通用属性和特定种类属性。纵观整个站点的所有产品通用属性都包含价格和产品标题（或类型）。特定种类属性对每个产品种类来说是惟一的并且产品和产品之间是不同的。下面的例子中我们会讲到每个细节。

## 通用属性

有一些通用属性应该被展示在几乎**所有地方**，无论是在售产品的列表项或站点内容中。举个例子，产品价格是基本属性，所以应该被放在所有环境下（只有极少数情况不需要）.

除了相对明显的价格属性，其他的主要通用属性有: 产品标题或类型，缩略图，用户排名，可选类型。 对搜索结果列表, [contextual search snippets](http://baymard.com/blog/search-snippets) 在这方面也沦陷了。下面的文章会总结通用属性中最重要的几方面。

![](http://assets.baymard.com/research/media_files/attachments/17290/original/research-media-file-beb2f73890ac1b9795830c9a1ce304d8.jpg)</div>

一个客户对IKEA的沙发按价格进行排序（从低到高）– 不幸的是出现了沙发装饰品，沙发垫和沙发套而不是从便宜到贵的沙发。更困惑的是，沙发套被展示在沙发上，一眼扫过去人更加难判断卖的是沙发还是沙发套。
对用户来说每个产品的**价格**很明显是至关重要的，不管是估算产品本身或者和其他产品对比。这就是价格要对用户永久可见的原因。我们的 [产品列表和筛选基准](http://baymard.com/ecommerce-product-lists/benchmark/site-reviews) 显示所有站点都做到了这一点。

测试期间发现一些和产品价格相关的常见问题。举个例子，一些案例中价格中包括什么不是太明确（通常发生在几个产品被展示在产品缩略图中的时候，像[产品适用性](http://baymard.com/blog/ecommerce-compatibility-databases)或捆绑销售）。让顾客明确知道价格里包含什么是明智的。同样，展示“每单元的价格”有助于客户了解性价比 – 98%的站点在这方面做的不太好。(参考我们的测试结果 [Price Per Unit](http://baymard.com/blog/price-per-unit)).

![](http://assets.baymard.com/research/media_files/attachments/17291/original/research-media-file-b9db9eecf9fc4873a76746a11d479ed3.jpg)</div>

_“我看到那儿有东西，但是没有图片，所以我不想点它”_ 一位客户解释道（在Best Buy），看着列表中的第三条。事实证明那确实是她想要的东西，但是由于没有缩略图，她选择像其他人一样直接跳过了那个产品。

**产品缩略图**被证明是最重要的属性，受测对象愿意花大量的注意力在产品缩略图上。没有缩略图的列表项经常被忽略，大多数客户认为这些产品是“不完整的”。好的缩略图在用户搜索和选择产品的过程中扮演关键角色。因此给用户提供产品的视觉信息是至关重要的。

事实上这意味着为所有列表项提供缩略图并确保缩略图的尺寸能反应用户对产品视觉信息的要求。（Product Lists report owners: 参考规则 #25, #28, #29, #34 and #39）。 更加明智的做法是提供 [secondary hover image](http://baymard.com/blog/secondary-hover-information) （提供更多的产品视觉信息） 并同时考虑 [“use context” and “cut out” thumbnails](http://baymard.com/blog/ux-product-image-categories) （允许提供更加全面的产品视图）。

![](http://assets.baymard.com/research/media_files/attachments/17292/original/research-media-file-c77036a8531f2c8700f545ec63d6f399.jpg)</div>

IKEA提供了产品标题（系列）和类型，单独一个产品名称对用户说就显得没那么有价值。类似“Söderhamn”和“Poäng”的标题对用户来说只是提供了产品系列的唯一标识。同时鼠标移动上去后，相关的信息会展现出来，这个特别棒，如果默认状态下提示会列出相关信息就更好了。

**产品标题或类型**也被证明是较为重要的，在客户浏览产品列表（尤其是搜索结果）而且产品缩略图很难一眼识别出产品类型的情况下。和产品标题一样形象生动的产品名称也可以代表自己，有些行业产品类型对用户来说比产品标题更容易理解 – 尤其在产品标题不明了的情况下。在这些情况下，产品类型会替代标题或和产品标题合并展示。

当存在一个数量巨大或者鱼龙混杂的产品目录的情况下，人工确定每个产品的标题的描述性可能会太消耗资源，这种情况下推荐两者都展示。还有一个较为高级的办法就是动态的浏览每个商品标题来确定是否包含产品类型关键词，基于此，对于扫描到的标题中不包含产品类型关键词的商品，展现一下产品类型信息。对于体量或者排列较好的产品目录（像 IKEA 这样的制造业电商），你可以通过整个产品目录（基于整个公司的产品命名规则的）来决定产品标题的描述性。。

![](http://assets.baymard.com/research/media_files/attachments/17293/original/research-media-file-0206f416589dd88e1ef3d8b03263694f.jpg)</div>

在没有任何关于这些锅的尺寸的提示下，用户必须去浏览每个产品页来得到这些信息。虽然用户可以通过已存在的价格区间推测产品的别的参数, 如果搜索结果上百后就显得笨拙了。 更重要的是，盘子的价格区间不能告诉用户盘子的参数有哪些 – 盘子是靠颜色，尺寸还是材质区分？

![](http://assets.baymard.com/research/media_files/attachments/17294/original/research-media-file-c0d845fab21bb7d9f179f057c087c4cb.jpg)</div>

作为比较，我们看下用户在 [American Eagle Outfitters](http://baymard.com/homepage-and-category-usability/benchmark/site-reviews/145-american-eagle-outfitters) 是如何做到扫一眼就能确定衬衫的多个参数（颜色样式等），这些只在列表项缩略图中的特殊样式里才会显示。

**产品参数** 像不同的颜色，尺寸，材质，外观等，是需要直接在列表项里展示的属性。没有这些东西，客户经常会pass掉实际上是他们想要的东西，仅仅是因为他们看不见这些参数，只能通过展示的默认属性来判断是否是他们想要的东西，而不是通过查看产品详情页来确认与产品相关的属性。

然而并不是所有产品都会被展示。举个例子，桌子是否可用得通过列表项里展示的桌子的多个尺寸参数来决定，然而鞋子就不一样了，用户可以根据鞋子的天然属性来推测产品的存在的参数。

![](http://assets.baymard.com/research/media_files/attachments/17295/original/research-media-file-a5a883ffb835cedef8d909f995655728.jpg)</div>

这有一个测试对象 - 不太明白不同产品规格的含义 - 于是决定通过排序来决定应该购买哪个相机。用户排名经常被犹豫不决或者对产品了解不深的人当做指导。

**用户排名**经常被多数行业和网站当做普遍属性放在列表项里。经测试发现，无论何时对特性领域产品了解不深的用户都会依赖用户排名来评估搜索到的相关结果 - 并视那些高排名的项为被其他用户审查过“安全选择”。

有些用户在他们没法自己做出判断的时候就把评分作为“好质量/划算”的代表。因此，如果用户依赖的数据不是在售商品方面的专家，评分就应该被直接包含在产品列表中。
当我们把用户评分放进产品列表时，注意实际上应该包括平均用户评分和平均评分数量。我们回过头来看，发现用户意识到平均评分在没有评分人数是没用的（参见[Users’ Perception of Product Ratings](http://baymard.com/blog/user-perception-of-product-ratings) 和 [Don’t Base ‘Customer Ratings’ Sorting on Averages Only](http://baymard.com/blog/sort-by-customer-ratings)）。

## 特有属性

有些产品的少数属性对那产品来说特别重要，那么我们就应该把它们放进产品列表项的概览中，方便用户选择哪些产品该打开哪些产品该跳过时做出“富含信息量的决定”

这些属性在分类之间变化幅度很大，而且必须是针对每个种类**唯一可选**。后面的是几个例子是不同的特有属性被当做灵感来源在决定是否选择此商品时，对一个给定的分类来说产品属性会变得十分重要（这里的质量就被当做一个特性种类的属性）。

![](http://assets.baymard.com/research/media_files/attachments/17296/original/research-media-file-88602817b6d0a836c6ee58b1e7f79984.jpg)</div>

只有 [Newegg](http://baymard.com/ecommerce-product-lists/benchmark/site-reviews/244-newegg) 中的一些电源适配器包含适配信息。对一些客户来说，他们更愿意买一个便宜的电源适配器而不是一个包含适配信息的价值 $116 的适配器，这些信息会无休止地烦着他们。

在特定种类的高科技产品中产品的相关性几乎完全被产品和其他产品**适配性**来决定。因此“适配信息”应该被放在列表项里，用户可以不用打开列表中的每个产品来确定与产品是否与他们相关。进一步说，如果用户的购物车有适配性相关的产品，产品列表项应该智能的显示此产品是否和购物车里的产品适配。（参见 [6 Use Cases for Compatibility Databases on E-Commerce Sites](http://baymard.com/blog/ecommerce-compatibility-databases)和 [Highlight Items Already in the User’s Cart](http://baymard.com/blog/highlight-products-if-in-users-cart)）。

![](http://assets.baymard.com/research/media_files/attachments/17297/original/research-media-file-d408ce075d520f2eaae6b50eb46d843d.jpg)</div>

因为列表项里没有相机套的尺寸，受测对象必须打开 Tesco 的每个产品页，搜索产品页的说明来确定相机套是否适合他们的相机。一张“使用情景”图也对判断尺寸是否合适有帮助（例如展示包含部分相机的相机套），但是明显没有在列表项里展示实际尺寸来得精准些。

另一种适配信息是**尺寸**。举个例子，任意一种包都需要容纳，携带，存放另一种别的产品，所以我们需要列出它的内部尺寸来让用户确定是否和他们的物品适用。也就是说，比起高科技产品的适配性它还是不太严格的，因此用户可能会买一个“容器”来获得足够多的空间来容纳要存放的东西。

![](http://assets.baymard.com/research/media_files/attachments/17298/original/research-media-file-1fa562b7dfeb88a0ee73f22e5825165b.jpg)</div>

有个受测对象依靠产品缩略图和推荐年龄范围来查找适合她外甥女的产品。Entertainer 明白他们用户中的大多数都不是最终用户，所以他们明智地给他们的玩具加上了一个推荐年龄范围来帮助用户来选择合适年龄段的产品。

**推荐使用年龄段**的属性适用性，场景或受众，在客户不是最终使用者的产业十分重要。事实上，这些属性起到了综合使用手册的作用，引导用户到适合最终受众或场景的产品，像为母亲节买的花的种类。

![](http://assets.baymard.com/research/media_files/attachments/17299/original/research-media-file-dc720599f835747ad6f7f995f879dad8.jpg)</div>

Go Outdoors 在他们的所有睡袋里都没有加入舒适温度排名；只有极少会把舒适温度值印到产品缩略图上。受测对象沮丧地发现他们必须打开剩下的产品来确定产品是否适合在寒冷天气下使用。

另一个典型的特定种类属性的案例是任何产品都会有**特殊使用情况**，包括安全齿轮，户外装备，水下设备，任何类型的产品都必须在特殊环境下保持运行。

特有属性的例子是数不清的，上述文章仅表明了有一两个和产品种类唯一相关特有属性的产品特性的几个实例。产品列表是说不尽的。你可能还会举相机分辨率，汽车里程数和动力，食物的制造方法等等。

特有属性就是比较重要的通用属性，只是在不同产品类型间不共用 - “适用年龄”和玩具高度相关但是和相机毫无关系，“百万像素解析度”和相机相关但是和玩具毫无关系！因此确定特有属性需要花些功夫，要浏览每个产品种类来确定是否存在1-3个和产品种类唯一相关的属性对用户决定产品的相关性起决定性作用，然后动态地放到列表项中。

## 展示产品列表项信息

通过把所有普通产品属性（价格，缩略图，产品标题或属性，相关参数和用户评分）和所有特有属性放在产品列表项中，用户已经具备了**充足的条件**去评估产品列表项中的每一项并决定选择哪个产品进行更近一步的了解（打开产品页）。

通用属性必须具备因为那是所有产品的基本信息，如果没有这些信息用户无法准确评估产品的相关性。特有属性是较为聪明的方法提供1-3个和产品种类唯一相关的额外属性，提供指定的帮助性信息给用户来确定产品是否和他们相关。

通过列表项的所有通用属性和1-3个特有属性，已经提供了足够的信息来让用户准确评估和比较列表中的产品。既没有信息过少的问题（最普遍），也没有列表项信息过多的问题（不太常见但是等同于设计存在问题），简单来说就是：达到了**理想状态的平衡**，没有信息冗余的情况下提供了每个产品的足够信息。

在列表项信息中得到一个理想平衡可以在产品列表中得到高的信噪比，对用户查找产品的**能力**是至关重要的，好的信噪比使用户容易获得哪些产品可以购买，哪些产品可以跳过。千万不要因为轻视这些建议被愚弄 - 46%的电商网站在其中的一两点上做地很失败，强迫用户做多余地返回操作 - 不停地来回跳转 - 经常在用户寻找产品的过程中制造困难，以用户放弃网站而结束。
