> * 原文地址：[Predicting your app’s monetization future](https://medium.com/googleplaydev/predicting-your-apps-monetization-future-27180e82ae34)
> * 原文作者：[Ignacio Monereo](https://medium.com/@ignacio.monereo?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/predicting-your-apps-monetization-future.md](https://github.com/xitu/gold-miner/blob/master/TODO/predicting-your-apps-monetization-future.md)
> * 译者：[PTHFLY](https://github.com/pthtc)
> * 校对者：[Wangalan30](https://github.com/Wangalan30)、[realYukiko](https://github.com/realYukiko)

# 一文教你预测 app 未来的变现情况

## 预测分析法介绍以及用户生命周期价值计算

我们都想要一个魔幻水晶球，可以揭示我们的 app 在未来的表现：会吸引多少用户以及会产生多少收入。遗憾的是，并不存在这种水晶球。但是好消息是，我们有技术手段可以使你有效的洞察你的APP未来的表现，同时帮助你建立一个合理有效的收入策略。

这是我关于探寻**生命周期价值**( **LTV, lifetime value** )两篇文章中的第一篇。在这篇文章中，我将会介绍预测分析法，指出一个计算 LTV 的简单公式，并阐述如何获得一个可用作计划的数值。

在[下一篇博文](https://medium.com/googleplaydev/predicting-your-apps-future-65b741999e0e)中，我将会探寻这个公式如何应用于五个时下流行的 app 的变现策略中，同时也会提供一些从开发者那得来的关于如何优化这些变现策略的见解。

### 预测分析法

如果你想了解你的 APP 的未来走势，你可以通过观察从用户那里收集来的数据进行预测。应用各种统计学技术，从这些数据中提取信息，是预测分析法的主要内容。

预测模型被应用到了许多商业领域中，它们可以帮忙解答许多关键性的商业管理问题：明年我们将有多少付费用户？明年的期望交易数额是多少？用户什么时候会从我们的服务中流失？

这些模型在线下被广泛研究。感谢数字革命，在改良的收集、整合和归类用户数据的能力的推动下，我们得以见证它们正在变得越来越普及。

在移动应用的世界，游戏开发者是这些技术的高级用户，他们的使用对他们应用的变现有着积极的影响。

#### 从经验主义到数学模型的方法

预测会有多少用户以及在未来他们的付费情况的方法会非常不同。其中最特别的两种是：

* 基于专业经验或者标杆管理的简单模型。例如一个公司雇佣了外部顾问，根据顾问的市场和行业知识，向他咨询和预测下一年销售情况。
* 复杂数学模型，像是 Pareto/NBD 模型（可以看 David C. Schmittlein，Donald G. Morrison，和 Richard Colombo 的 [Counting Your Customers: Who Are They and What Will They Do Next?](http://www.jstor.org/stable/2631608?seq=1#page_scan_tab_contents)）。这些模型将多重变量纳入考虑范围，包括近因（最近购买）以及给定时间内的频次或者订单数量，来计算客户复购的可能性。

对于数学建模方法，有一些网上资源可以帮助计算，例如这个由 Bruce G. S. Hardie 在 [Implementing the BG/NBD Model for Customer Base Analysis in Excel](http://www.brucehardie.com/notes/004/)中描述的方法。

#### 分析所需的数据和工具

预测分析技术发展的主要驱动力之一是分析工具使用量的增加。强大的分析工具可以使我们更加高效地收集、整理和整合数据，同时迅速地将它与关键的利益相关者和决策者分享。

一些最重要的 app 特征数据：Some of the most important app metrics are:

* **用户获得数据**: 安装数量，卸载数量和来量渠道。
* **留存数据**: 用户留存（下载后第1、7、28、90、180和365天）。
* **变现数据**: 付费用户数量，最近购买，交易频次，购买总量，流失率以及新的重复购买用户。

这些变量的重要性依托于其计算权重和以下这些因素：

* **应用环境**: 不同种类的 app 的激活和使用情况会有巨大的不同。
* **商业模式**: 根据不同的商业模式选择，某个关键数据会有巨大的影响。比如订阅商业模式通常十分关心订阅者的续期时刻。
* **使用手段**: 一些方法将会要求某些数据来建立未来预测。例如使用 BG/NBD 要求频次和最近购买数据。

需重点强调的是，一个强大的分析工具，如用于应用内分析的 [Google Analytics for Firebase](https://firebase.google.com/features/analytics) 或是用于变现的 [Google Play Console](https://play.google.com/apps/publish/) ，不仅需要能够准确及时地收集这些信息，同时也要能够快速处理和分享这些信息。这是在如数字生态系统这样的动态环境中迅速做出反应的关键。

#### 背景

预测分析法严重依赖于用户和购买者的历史数据。虽然这是一个好的起点，但是不要忽视可能影响未来预测的外部信息。这可能包括公司发展阶段，科技趋势和宏观经济环境。

尤其是当分析 app 的生命周期价值的时候，根据环境因素，如交易环境和合同责任调整某些关键点，调整一些关键点是很有用的。例如，一个零售 app 可能需要在激活一个月内的购买者和一年内的购买者之间做选择。

有一些不同的框架可以帮助识别这些背景因素。在这之中，我发现 Peter S. Fader and Bruce G. S. Hardie 的文章 [Probability Models for Customer-Base Analysis](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.180.2024&rep=rep1&type=pdf) 中指出的一个框架很有用。

Fader 和 Hardie 的模型根据用户是否与公司缔结合同以及交易是连续还是离散的来将用户行为做了区分。来看一个关于这个模型的例子：

![](https://cdn-images-1.medium.com/max/800/1*-tQUKX6mG08lKHaJFscAVQ.png)

左上角的是没有与用户缔结契约关系来形成持续交易流的公司。一个实际的例子是电商应用，消费者反复交易但是又可以随时离开和流失。

在右下方是个刚好相反的例子：公司与用户缔结合约，交易只在特定时间发生。一个实际例子是消费者往往在某个特定的时间点（比如他们找到第一份工作的时候）购买人寿保险单，这份保险单将在保险费的持续时间内保持有效。

### 生命周期价值

最后欢迎的预测分析法标志之一是用户生命周期价值（ LTV ），是最受欢迎的预测分析指标之一，它是用户在一生中对其商业领域经济价值的估算。这个指标在线下十分知名，被广泛应用到了 app 和游戏产业中。

因为提供了每个用户带来的潜在收益估计，LTV 十分有用，因为它可以提供对每个客户潜在收益的解读。相应的，这也可以帮助决定用户获取费用，分析哪个渠道、平台、用户分布是最划算的。

然而，在讨论计算问题之前，有一些常见的 LTV 陷阱需要规避。因此，请不要：

* 将 LTV 作为目标使用并且花费资源来优化和放大它。仅仅把 LTV 当做一个工具，它会随着其他指标（如契约、留存和变现）的增长而提高。
* 创造过于乐观的 LTV。例如，一个初创公司可能过高地估计了每个用户的收入，结果导致 LTV 膨胀，从而可能要在获取用户上花费更高的成本。
* 允许用户获取成本（CAC，the Cost of acquiring a customer）超过 LTV。尽管要考虑的因素（公司的阶段：初创或是成熟；关系类型：是否缔结合约）很多，但一个工业领域的经验法则告诉我们：用户获取成本不能够超过应用的净 LTV。然而许多公司规定 LTV 与 CAC 的比为3：1（CAC 将永远不会超过净 LTV 的33%）。
* 将高 LTV 看作是一个竞争优势。在快速变化的行业，比如科技行业，很容易找到一个变现能力很强，LTV 很高但是快速失去市场份额的例子，因为技术被淘汰，用户转移到更新、更有吸引力的应用上去了。

#### 计算 LTV

有几种方法可以计算应用和游戏的 LTV。这些方法根据商业模式的复杂度，可用数据以及精确度要求的不同而不同。

在一开始，让我们使用下面简单的公式：

> LTV (给定阶段的) = 生命周期 x ARPU（每个用户平均收益）

现在，让我们仔细检查下个变量：

**a. LTV 时间长度**

大多数开发者以 180 天，一年，二年或者五年计算 LTV。决定 LTV 时间长度的因素可能包括平均用户生命周期或者基于商业模式的选择。

例如，想象一个使用内购模式的开发者，平均一个用户使用周期是15个月。在这种情况下，两年的 LTV 会比一年的更高。然而，一年的 LTV 是更保守的选择因为平均生命周期（15个月）比选择的周期更长（12个月）。

选择 LTV 时间长度需要考虑：

* **商业环境**， 例如，对于某些变现模型（尤其是订阅类）来说，收益可能会更高，而且，如果对变现的激励得当，将在很长的一段时间内持续增长，这一点可以为长期 LTV 正名。举例来讲，电信公司一直遵循传统，在用户获取方面大量投资，甚至会对硬件方面进行补贴，以期待较长的生命周期。
* **商业模式**， 例如，对于某些变现模式（尤其是订阅）收益可能会更高并且会长期增长如果变现激励很恰当（流失为负），使用长期 LTV 是有道理的。比如电信公司在用户获取上传统地会投资巨大，甚至会补贴硬件，需要超长生命周期。
* **公司阶段**， 比如早期对比成熟期。因为依靠技术进步或者没有历史数据，早期公司会经常选择更长更乐观的时期来计算 LTV。另一方面，一个技术落伍的成熟公司可能想选择更短的 LTV 计算时间。

**b. 生命周期**

生命周期与激活和留存直接相关。相应的，这两个概念会帮助增加用户留存，增加他们促进变现的可能性。应用开发者通常根据应用留存计算生命周期。

我们可以用一个简单的方法来估算用户滞留，我们把用户在过去的一个月内没有打开过应用的情况称为一个用户在应用内的“流失”时刻。这样，从用户停止使用 APP 起至少一个月的平均流失时长就可以计算出来了。

一个更精准计算生命周期的方法是使用生存曲线模型：一个根据历史使用数据（每个用户或用户群一条曲线）的下降方程。每个部分的整体或者平均留存就可以被计算了，某个时期的方程也可以被解出。

看下面的例子，在计算所有用户的集合之后，一个用户在180天后保持活跃的概率仅仅是 23%。因此，每180用户平均生命周期会是 180 x 23%，将近 41 天。

![](https://cdn-images-1.medium.com/max/800/1*F6OH2IvQnhHXpX5AMVRo7w.png)

这里有个重点需要提示，生命周期总是和 LTV 时间段使用同一单位。例如 180 天的 LTV 会基于 41 天的期望生命周期，而不是月或是年。

**c. ARPU 或者 每个用户的平均收益**

计算 ARPU 的难度会根据商业模式的不同而不同。一个 SaaS 模式会更简单而一个混合模式会更复杂（混合不同的商业模式，比如订阅和广告）。

一个计算 ARPU 的方法将会是将一段时间内的总体收益根据那段时间活跃用户进行分割。例如，平均每日收益 10000 美金被 25000 日活用户分割，ARPU 会是 0.4 美金/天。

我现在可以为这个应用计算 LTV 了。180天内的生命周期为 41 天（ 23% ）并且 ARPU 0.4 美金/天。因此：

**180 天的 LTV = 41 天 x 0.4 美金/天 = 16.4 美金/每用户**

#### 优化 LTV 计算

有几种技术可以与这个简单的 LTV 方程结合，以提升可用性，它们包括：

* **Discount Revenue cash flows**。当生命周期超过一年，通过将通货膨胀速率（r）或者资金成本（比如计算平均资本成本率 —— 衡量平均资本成本）纳入考虑范围来考虑给未来信息流打折。例如，假设生命周期是 n 年，折扣公式表现为下面方式：

> LTV = Revs Year 1 + Revs Year 2 x 1/ (1+ r) + … + Revs Year n x 1 / (1+ r )^(n-1)

* **计算净 LTV**_._ 通过计算每个用户的平均可变利润(VC)并在公式中替换 ARPU，净利润能够被计算出来。为了估计 VC，需要从总收入中扣除总可变成本。可变成本在每个新用户加入 app 时产生（例如分配到每个用户头上的市场费用）。新的公式会像下面这样：

> 净 LTV = 生命周期 x VC

据此:

> VC = 一段时间内的(总收入 — 总可变成本) / 一段时间内的平均用户

还有一件重要的事情是：精明的开发者会通常根据 VC 水平区分用户，并且为不同用户群计算 LTV。 在许多商业活动中通常就是这样，应用开发者会观察到一小群用户会带来最多的收入和利润。

因为可变成本倾向于降低占收入的比例，在用户生命周期中 VC 会经常变化。举个例子，拿一个最近订购了一个软件服务并在使用期间需要更多客服的新用户与一个有经验、不再需要支持客户作比较。

### 结论

预测分析法提供了一个可操作的方法来预测你的应用未来表现：它的用户和收入。在这些预测分析的方法中，生命周期价值（ LTV ）可能是最近在 APP 开发者中大受欢迎的一个指标了。它非常简单并且提供了一个可以应用于获客规划的有用方法。

现在你对 LTV 已经有了一些了解，在[第二篇博文中](https://medium.com/googleplaydev/predicting-your-apps-future-65b741999e0e)我将会检验 LTV 公式如何使用于五个流行应用的变现策略。同时，我也会提供一些从开发者那得来的，关于如何优化这些变现策略的见解。

* * *

#### 你怎么想?

你有关于在优化用户决定方面的问题或者想法吗？在下面评论区继续讨论或者通过井号标签 #AskPlayDev 通知我们，我们会在 [@GooglePlayDev](http://twitter.com/googleplaydev) （我们会定期分享在上面就如何在Google Play成功的话题分享新闻和小贴士）上回复。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
