> * 原文地址：[Get started with motion design in 9 steps: Start breathing life into your creations](https://uxdesign.cc/motion-in-ux-design-9-points-to-get-started-e891974dc7ee?ref=uxdesignweekly)
> * 原文作者：[Arpit Agarwal](https://uxdesign.cc/@agarwalarpit?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/motion-in-ux-design-9-points-to-get-started.md](https://github.com/xitu/gold-miner/blob/master/TODO/motion-in-ux-design-9-points-to-get-started.md)
> * 译者：[reid3290](https://github.com/reid3290)
> * 校对者：[Starriers](https://github.com/Starriers)，[Xekin-FE](https://github.com/Xekin-FE)

# 开始设计动画的九个步骤

## 为作品赋予生命力

![](https://cdn-images-1.medium.com/max/600/1*18NR2HSMnRsf5WBA-zJ23w.gif)

动画创造生命

**动画意味着充沛的活力与激情**，它给静止的事物以生命。在软件应用中，动画不仅是为了取悦人们，而更是为了解决问题。

作为人类，我们习惯于世界围绕着我们运转；如果软件的每一部分也都能有着连贯的动画，那就会让人感到自然而又充满活力。

科技行业领导者不断推动其产品朝着更为自然的方向发展，诸如动画设计、动画用户体验、用户体验编排等复杂的概念日趋流行。

> 请记住：动画就像布局、间距、排印和颜色一样，能在潜意识中构建你应用软件的**个性**。

不知你是否留意过，当在 iPhone 中将某个东西滑动到最顶端或最底端时，它就会出现一种回弹效果。这些细节看似微不足道，却在构建苹果产品的个性上发挥了举足轻重的作用。

### 酷，让我们开始使用动画吧

![](https://cdn-images-1.medium.com/max/800/1*WVO2fUsifiXktIOaradZGQ.gif)

### **1. 开始观察**

学会关注动画：如果你不能够觉察到事物的移动，也就无法创造出动画。在使用你最喜爱的应用程序时，观察屏幕上的东西是如何移动的；反复观察，注意细节，找出它令你喜欢的原因。留意所有发生变化的元素——形状、尺寸、位置、颜色等等。无论变化是小是大，努力找出动画在整个构图中所起到的作用。

### **2. 动画不仅是一层颜色**

动画揭示了一种更深层的意义：作为一名创造者，你必须从一开始就有意识地将动画考虑在内。在设计阶段，为原型添加动画使其具有时间上的维度；在开发阶段，将代码模块化从而更简便地实现 UI 中的动画。[有关模块化参见](https://medium.com/@acyoo/architecting-ios-development-at-zomato-cf894a7fa5e3)

> 提示：谨慎思考产品的动画特点，这将为产品赋予一种角色，并且能够帮助你从更深的层面上理解你所想要构建的东西。

![](https://cdn-images-1.medium.com/max/800/1*t3dqGWRLsL_QGSkaUSic0w.gif)

### **3**. 在何处引入动画？

![](https://cdn-images-1.medium.com/max/600/1*Pmk25Ep7BAtivcKkVcmbCA.gif)

但是要在哪里引入动画呢？

简单的例子有，当**屏幕正在变化时**、当**用户正在与界面元素交互时**或者当**用户不得不等待时**。

### **4**. 动画分类

你可以将产品中的动画分为三类：**切换**（内容变化/页面切换）、**微观互动**（例如推特的点赞按钮）、**图形动画**（例如 Zomato 的购物 App 的启动界面上跳跃的小摩托车）。

![](https://cdn-images-1.medium.com/max/800/1*aP_ns6KdA_kvb3csJEZTEg.gif)

动画分类

### **5**. 用动画提供**空间信息**

![](https://cdn-images-1.medium.com/max/600/1*z9j3rcz8ER5DQF_3mUd4HA.gif)

动画能够传达空间信息

如果某个 UI 元素从屏幕的右侧进入，用户心理上会将那个元素的放在右边。例如，如果一个汉堡菜单按钮处于屏幕的左上角，那么该菜单的入场动画就一定要从屏幕左侧开始。将动画展示给他人观看并听取他们的意见，从而确定动画所传达的空间信息是否准确。这是避免困惑的最简单方法。

### **6. 开始理解像持续时间、时间曲线、动画路径、初值和终值等概念的含义**

这些参数从技术层面上构成了动画。使用这些参数并熟练掌控它们，一旦你能够控制这些参数，你就能够创造出杰出的动画作品。在 UI 方面，[谷歌提供了一些很好的指导资料](https://material.io/guidelines/motion/material-motion.html)。

![](https://cdn-images-1.medium.com/max/800/1*gyD2I6o6-OPu3_rbtaEQkQ.gif)

学习动画参数——这两个箱子的动画除了时间曲线之外其它参数全部一样，请探究其中奥妙

### 7. 绝不能让用户在某个流程的中间等待

![](https://cdn-images-1.medium.com/max/600/1*QHIpIqZwA_lq_bOV9Z2kjQ.gif)

绝不能为了等待动画完成而在某个流程中间故意放慢速度。如果必须要用户等待，那就用一些有意义的动画来达到娱乐的效果。请记住，在任何何时动画都是用来解决问题的。加载动画的存在是有其合理性的。此外，不要在软件中滥用动画，软件不是电影！

> 专家提示：**保持动画的微妙性并使之与产品故事线相吻合能带来愉悦的用户体验**。

### 8. **相关工具**

Lottie，Adobe Animate CC，After Effects，Sketch2AE，Framer，Origami，Animatic App，UIDynamics(iOS) 等工具都可以用来做动画设计，不妨一试。

我会建议使用**纸和笔**来完成构思，之后再使用其他数字化软件。比如在这篇文章中的动画中，我就是先用 [Animatic App](https://animatic.io/) 画的草图。一份完好的草稿会使后续的工作显得简单而明确。

![](https://cdn-images-1.medium.com/max/800/1*DbUs1gsNLdXaqgn4v8kqEw.gif)

从笔和纸开始

### 9. 捕捉并保存你觉得有趣的动画

![](https://cdn-images-1.medium.com/max/600/1*FUBjAjXYGcD-Jy3MpxLxkw.gif)

保存你觉得有趣的动画。放慢速度，反复观察，理解元素的运动机制。通过模仿来进行学习。我的 Mac 里存满了我觉得有趣的 GIF。你也可以在 [dribbble](https://dribbble.com/shots?list=animated) 上保存 GIF。另外，[Giphy Capture](https://giphy.com/apps/giphycapture) 是在 Mac 屏幕上捕捉和记录动画的优秀工具。

![](https://cdn-images-1.medium.com/max/800/1*CSqaOB0Tel9HiyzPsttAAA.gif)

无所畏惧

### 💥 额外福利——对恐惧说再见

还畏惧开始吗？坐下，放松，吃些甜点，放首音乐。关上手机，将纸笔放在身旁。或许可以小憩一会，尽量让自己感到舒适自在。取白纸一张，拿起笔来，随意涂写。再取一张白纸，继续涂写着，线条、形状、故事。放空自己，感受笔尖的移动。开始，一切只需要开始，看它带你去向何方。

> 比画画更难的是开始动笔。一旦你开始在白纸上动笔，无论你画出了什么，你便具有了创造力。

* * *

**感谢阅读！**

请欣赏一些我的动画作品——

- [**我的动画墙**：我做的一些 GIF 及其相关故事。medium.com](https://medium.com/@agarwalarpit/hand-drawn-animations-74c4c61f9298)


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
